/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.deformationModel;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.DefaultTableModel;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DeformationModelDB_DAO;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;

public class DeformationModelTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{"Section Name", "Slip Rate", "Aseismic Slip Factor"};
    private int deformationModelId;
    private ArrayList<Integer> faultSectionsInModel;
    private HashMap<Integer, String> faultSectionsSummaryMap = new HashMap();
    private FaultSectionVer2_DB_DAO faultSectionDB_DAO;
    private DeformationModelDB_DAO deformationModelDAO;
    private ArrayList<FaultSectionSummary> faultSectionSummries;

    public DeformationModelTableModel(DB_AccessAPI dbConnection) {
        this.faultSectionDB_DAO = new FaultSectionVer2_DB_DAO(dbConnection);
        this.deformationModelDAO = new DeformationModelDB_DAO(dbConnection);
        this.faultSectionSummries = this.faultSectionDB_DAO.getAllFaultSectionsSummary();
        for (int i = 0; i < this.faultSectionSummries.size(); ++i) {
            FaultSectionSummary faultSectionSummary = this.faultSectionSummries.get(i);
            this.faultSectionsSummaryMap.put(faultSectionSummary.getSectionId(), faultSectionSummary.getSectionName());
        }
    }

    public void setDeformationModel(int deformationModelId, ArrayList faultSectionIdList) {
        this.deformationModelId = deformationModelId;
        this.faultSectionsInModel = new ArrayList();
        for (int i = 0; i < this.faultSectionSummries.size(); ++i) {
            FaultSectionSummary faultSectionSummary = this.faultSectionSummries.get(i);
            if (!faultSectionIdList.contains(faultSectionSummary.getSectionId())) continue;
            this.faultSectionsInModel.add(faultSectionSummary.getSectionId());
        }
    }

    public int getdeformationModelId() {
        return this.deformationModelId;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return String.class;
        }
        return EstimateInstances.class;
    }

    @Override
    public int getRowCount() {
        int numRows = 0;
        if (this.faultSectionsInModel != null) {
            numRows = this.faultSectionsInModel.size();
        }
        return numRows;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public int getFaultSectionId(int row) {
        return this.faultSectionsInModel.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        int faultSectionId = this.faultSectionsInModel.get(row);
        return this.faultSectionsSummaryMap.get(faultSectionId);
    }

    public Object getValueForSlipAndAseismicFactor(int row, int col) {
        int faultSectionId = this.faultSectionsInModel.get(row);
        if (col == 2) {
            return this.deformationModelDAO.getAseismicSlipEstimate(this.deformationModelId, faultSectionId);
        }
        if (col == 1) {
            return this.deformationModelDAO.getSlipRateEstimate(this.deformationModelId, faultSectionId);
        }
        return this.faultSectionsInModel.get(row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

