/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.EstimateConstraint;
import org.opensha.commons.param.editor.impl.ConstrainedEstimateParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.editor.impl.StringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.EstimateParameter;
import org.opensha.commons.param.impl.StringListParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.PaleoEventDB_DAO;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.data.TimeAPI;
import org.opensha.refFaultParamDb.gui.TimeGuiBean;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddNewReference;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.MeasuredCompPanel;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.SenseOfMotionPanel;
import org.opensha.refFaultParamDb.gui.event.DbAdditionFrame;
import org.opensha.refFaultParamDb.gui.event.DbAdditionListener;
import org.opensha.refFaultParamDb.gui.event.DbAdditionSuccessEvent;
import org.opensha.refFaultParamDb.gui.infotools.ConnectToEmailServlet;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;
import org.opensha.refFaultParamDb.gui.view.ViewAllReferences;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.PaleoEvent;
import org.opensha.refFaultParamDb.vo.Reference;

public class AddEditIndividualEvent
extends DbAdditionFrame
implements ParameterChangeListener,
ActionListener,
DbAdditionListener {
    private JPanel topPanel = new JPanel();
    private JSplitPane estimatesSplitPane = new JSplitPane();
    private JSplitPane mainSplitPane = new JSplitPane();
    private JSplitPane detailedEventInfoSplitPane = new JSplitPane();
    private JButton okButton = new JButton("Submit and Add Another Event");
    private JButton doneButton = new JButton("Done");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel eventSummaryPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private static final String EVENT_NAME_PARAM_NAME = "Event Name";
    private static final String EVENT_NAME_PARAM_DEFAULT = "Enter Event Name";
    private static final String COMMENTS_PARAM_NAME = "Comments";
    private static final String REFERENCES_PARAM_NAME = "Choose References";
    private static final String DATE_ESTIMATE_PARAM_NAME = "Event Time Estimate";
    private static final String SLIP_ESTIMATE_PARAM_NAME = "Event Slip Estimate";
    private static final String SLIP_TITLE = "Event Slip";
    private static final String SLIP = "Slip";
    private static final String DISPLACEMENT_SHARED_PARAM_NAME = "Slip Shared With Other Events";
    private static final String SHARED_EVENT_PARAM_NAME = "Names of Events Sharing Slip";
    private static final String COMMENTS_REFERENCES_TITLE = "Comments & References";
    private static final double TIME_ESTIMATE_MIN = 0.0;
    private static final double TIME_ESTIMATE_MAX = Double.POSITIVE_INFINITY;
    private static final String TIME_ESTIMATE_UNITS = "years";
    private JButton addNewReferenceButton = new JButton("Add Reference");
    private JButton viewAllRefsButton = new JButton("View All References");
    private static final String addNewReferenceToolTipText = "Add Reference not currently in database";
    private static final String MSG_EVENT_NAME_MISSING = "Please enter event name";
    private static final String MSG_REFERENCE_MISSING = "Choose atleast 1 reference";
    private static final String MSG_SHARED_EVENTS_MISSING = "Choose atleast 1 event to share the displacement";
    private static final String MSG_EVENTS_DO_NOT_SHARE_DISPLACEMENT = "The selected event set for shared displacement is invalid.\nThese events do not share same displacement";
    private static final String MSG_PALEO_EVENT_ADD_SUCCESS = "Paleo Event added successfully to the database";
    private static final String MSG_NEED_TO_SAVE_CURR_EVENT = "Do you want to save current event to database?";
    private static final String MSG_CURR_EVENT_NOT_SAVED = "Current Event will not be saved in database";
    private static final String MSG_CONTACT_TO_DELETE = "events were added to database in this session. Contact perry@gps.caltech.edu to remove them";
    private static final String SLIP_UNITS = "meters";
    private static final double SLIP_MIN = 0.0;
    private static final double SLIP_MAX = Double.POSITIVE_INFINITY;
    private static final String DISPLACEMENT_TITLE = "Shared Slip";
    private static final String TITLE = "Add Data, Individual Event(s)";
    private StringParameter eventNameParam;
    private StringParameter commentsParam;
    private TimeGuiBean eventTimeEst = new TimeGuiBean("Event Time Estimate", false);
    private EstimateParameter slipEstParam;
    private BooleanParameter displacementSharedParam;
    private StringListParameter sharedEventParam;
    private StringParameter referencesParam;
    private StringParameterEditor eventNameParamEditor;
    private CommentsParameterEditor commentsParamEditor;
    private ConstrainedEstimateParameterEditor slipEstParamEditor;
    private ParameterListEditor displacementParamListEditor;
    private ConstrainedStringParameterEditor referencesParamEditor;
    private static final int WIDTH = 700;
    private static final int HEIGHT = 700;
    private ReferenceDB_DAO referenceDAO;
    private PaleoEventDB_DAO paleoEventDAO;
    private ArrayList paleoEvents;
    private int siteId;
    private String siteEntryDate;
    private AddNewReference addNewReference;
    private LabeledBoxPanel commentsReferencesPanel;
    private ArrayList referenceSummaryList;
    private ArrayList referenceList;
    private SenseOfMotionPanel senseOfMotionPanel;
    private MeasuredCompPanel measuredCompPanel;
    private static int eventToDatabaseCounter = 0;
    private DB_AccessAPI dbConnection;

    public AddEditIndividualEvent(DB_AccessAPI dbConnection, int siteId, String siteEntryDate) {
        this.dbConnection = dbConnection;
        this.referenceDAO = new ReferenceDB_DAO(dbConnection);
        this.paleoEventDAO = new PaleoEventDB_DAO(dbConnection);
        try {
            this.senseOfMotionPanel = new SenseOfMotionPanel();
            this.measuredCompPanel = new MeasuredCompPanel();
            this.siteId = siteId;
            this.siteEntryDate = siteEntryDate;
            this.jbInit();
            this.initParamsAndEditors();
            this.addActionListeners();
            this.setTitle(TITLE);
            this.setSharedEventVisible((Boolean)this.displacementSharedParam.getValue());
            this.setSize(700, 700);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initParamsAndEditors() throws Exception {
        this.eventNameParam = new StringParameter(EVENT_NAME_PARAM_NAME, EVENT_NAME_PARAM_DEFAULT);
        this.eventNameParamEditor = new StringParameterEditor((Parameter)this.eventNameParam);
        this.commentsParam = new StringParameter(COMMENTS_PARAM_NAME);
        this.commentsParamEditor = new CommentsParameterEditor(this.commentsParam);
        ArrayList dateAllowedEstList = EstimateConstraint.createConstraintForDateEstimates();
        ArrayList allowedEstimates = EstimateConstraint.createConstraintForPositiveDoubleValues();
        this.slipEstParam = new EstimateParameter(SLIP_ESTIMATE_PARAM_NAME, SLIP_UNITS, 0.0, Double.POSITIVE_INFINITY, allowedEstimates);
        this.slipEstParamEditor = new ConstrainedEstimateParameterEditor(this.slipEstParam, true);
        this.displacementSharedParam = new BooleanParameter(DISPLACEMENT_SHARED_PARAM_NAME, false);
        this.displacementSharedParam.addParameterChangeListener(this);
        ParameterList paramList = new ParameterList();
        paramList.addParameter(this.displacementSharedParam);
        ArrayList eventNamesList = this.getEventNamesList();
        if (eventNamesList != null && eventNamesList.size() > 0) {
            this.sharedEventParam = new StringListParameter(SHARED_EVENT_PARAM_NAME, eventNamesList);
            paramList.addParameter(this.sharedEventParam);
        }
        this.displacementParamListEditor = new ParameterListEditor(paramList);
        this.displacementParamListEditor.setTitle(DISPLACEMENT_TITLE);
        this.addEditorstoGUI();
        this.makeReferencesParamAndEditor();
    }

    private void makeReferencesParamAndEditor() throws ConstraintException {
        if (this.referencesParamEditor != null) {
            this.commentsReferencesPanel.remove(this.referencesParamEditor);
        }
        ArrayList referenceList = this.getAvailableReferences();
        this.referencesParam = new StringParameter(REFERENCES_PARAM_NAME, referenceList, (String)referenceList.get(0));
        this.referencesParamEditor = new ConstrainedStringParameterEditor(this.referencesParam);
        this.commentsReferencesPanel.add((Component)this.referencesParamEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    private ArrayList getAvailableReferences() {
        this.referenceList = this.referenceDAO.getAllReferencesSummary();
        this.referenceSummaryList = new ArrayList();
        for (int i = 0; this.referenceList != null && i < this.referenceList.size(); ++i) {
            this.referenceSummaryList.add(((Reference)this.referenceList.get(i)).getSummary());
        }
        return this.referenceSummaryList;
    }

    private ArrayList getEventNamesList() {
        this.paleoEvents = this.paleoEventDAO.getAllEvents(this.siteId);
        ArrayList<String> eventNames = new ArrayList<String>();
        for (int i = 0; i < this.paleoEvents.size(); ++i) {
            eventNames.add(((PaleoEvent)this.paleoEvents.get(i)).getEventName());
        }
        return eventNames;
    }

    private void addEditorstoGUI() {
        this.estimatesSplitPane.add((Component)this.eventTimeEst, "left");
        LabeledBoxPanel slipPanel = new LabeledBoxPanel(this.gridBagLayout1);
        slipPanel.setTitle(SLIP_TITLE);
        slipPanel.add((Component)this.displacementParamListEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        slipPanel.add((Component)this.measuredCompPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        slipPanel.add((Component)this.slipEstParamEditor, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        slipPanel.add((Component)this.senseOfMotionPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.estimatesSplitPane.add((Component)slipPanel, "right");
        this.commentsReferencesPanel = new LabeledBoxPanel(this.gridBagLayout1);
        this.commentsReferencesPanel.setTitle(COMMENTS_REFERENCES_TITLE);
        this.detailedEventInfoSplitPane.add((Component)this.commentsReferencesPanel, "right");
        this.commentsReferencesPanel.add((Component)this.commentsParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.commentsReferencesPanel.add((Component)this.addNewReferenceButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.commentsReferencesPanel.add((Component)this.viewAllRefsButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.eventSummaryPanel.add((Component)this.eventNameParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameterName().equalsIgnoreCase(DISPLACEMENT_SHARED_PARAM_NAME)) {
            this.setSharedEventVisible((Boolean)event.getNewValue());
        }
    }

    private void setSharedEventVisible(boolean isVisible) {
        if (this.paleoEvents != null && this.paleoEvents.size() > 0) {
            this.displacementParamListEditor.setParameterVisible(SHARED_EVENT_PARAM_NAME, isVisible);
            this.slipEstParamEditor.setVisible(!isVisible);
            this.senseOfMotionPanel.setVisible(!isVisible);
            this.measuredCompPanel.setVisible(!isVisible);
        } else {
            this.displacementParamListEditor.setVisible(false);
            this.slipEstParamEditor.setVisible(true);
            this.senseOfMotionPanel.setVisible(true);
            this.measuredCompPanel.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.addNewReferenceButton) {
            this.addNewReference = new AddNewReference(this.dbConnection);
            this.addNewReference.addDbAdditionSuccessListener(this);
        } else if (source == this.okButton) {
            try {
                this.addEventToDatabase();
                ++eventToDatabaseCounter;
            }
            catch (InsertException e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
            }
        } else if (source == this.doneButton) {
            int option = JOptionPane.showConfirmDialog(this, MSG_NEED_TO_SAVE_CURR_EVENT);
            if (option == 0) {
                try {
                    this.addEventToDatabase();
                    eventToDatabaseCounter = 0;
                    this.dispose();
                }
                catch (InsertException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage());
                }
            } else if (option == 1) {
                this.dispose();
            }
        } else if (source == this.cancelButton) {
            Object msg = MSG_CURR_EVENT_NOT_SAVED;
            if (eventToDatabaseCounter > 0) {
                msg = (String)msg + "\n" + eventToDatabaseCounter + " " + MSG_CONTACT_TO_DELETE;
            }
            JOptionPane.showMessageDialog(this, msg);
            eventToDatabaseCounter = 0;
            this.dispose();
        } else if (source == this.viewAllRefsButton) {
            new ViewAllReferences(this.dbConnection);
        }
    }

    private void addEventToDatabase() {
        String eventName;
        PaleoEvent paleoEvent;
        block14: {
            block13: {
                paleoEvent = new PaleoEvent();
                eventName = (String)this.eventNameParam.getValue();
                if (eventName.trim().equalsIgnoreCase("")) break block13;
                if (!eventName.trim().equalsIgnoreCase(EVENT_NAME_PARAM_DEFAULT)) break block14;
            }
            throw new InsertException(MSG_EVENT_NAME_MISSING);
        }
        paleoEvent.setEventName(eventName);
        String reference = (String)this.referencesParam.getValue();
        if (reference == null) {
            throw new InsertException(MSG_REFERENCE_MISSING);
        }
        int index = this.referenceSummaryList.indexOf(reference);
        ArrayList<Reference> referenceList = new ArrayList<Reference>();
        referenceList.add((Reference)this.referenceList.get(index));
        paleoEvent.setReferenceList(referenceList);
        boolean isDispShared = (Boolean)this.displacementSharedParam.getValue();
        ArrayList sharedEventNames = null;
        paleoEvent.setDisplacementShared(isDispShared);
        if (isDispShared) {
            sharedEventNames = (ArrayList)this.sharedEventParam.getValue();
            if (sharedEventNames == null || sharedEventNames.size() == 0) {
                throw new InsertException(MSG_SHARED_EVENTS_MISSING);
            }
            int dispEstId = this.paleoEventDAO.checkSameDisplacement(sharedEventNames);
            if (dispEstId <= 0) {
                throw new InsertException(MSG_EVENTS_DO_NOT_SHARE_DISPLACEMENT);
            }
            paleoEvent.setDisplacementEstId(dispEstId);
        } else {
            try {
                this.slipEstParamEditor.setEstimateInParameter();
            }
            catch (RuntimeException e) {
                throw new InsertException(e.getMessage());
            }
            paleoEvent.setDisplacementEst(new EstimateInstances((Estimate)this.slipEstParam.getValue(), SLIP_UNITS));
        }
        paleoEvent.setComments((String)this.commentsParam.getValue());
        paleoEvent.setSiteId(this.siteId);
        paleoEvent.setSiteEntryDate(this.siteEntryDate);
        TimeAPI eventTime = null;
        try {
            eventTime = this.eventTimeEst.getSelectedTime();
        }
        catch (RuntimeException e) {
            throw new InsertException(e.getMessage());
        }
        eventTime.setDatingComments(paleoEvent.getComments());
        eventTime.setReferencesList(paleoEvent.getReferenceList());
        paleoEvent.setEventTime(eventTime);
        paleoEvent.setMeasuredComponentQual(this.measuredCompPanel.getMeasuredComp());
        paleoEvent.setSenseOfMotionQual(this.senseOfMotionPanel.getSenseOfMotionQual());
        paleoEvent.setSenseOfMotionRake(this.senseOfMotionPanel.getSenseOfMotionRake());
        ConnectToEmailServlet.sendEmail(SessionInfo.getUserName() + " trying to add new event to database\n" + paleoEvent.toString());
        this.paleoEventDAO.addPaleoevent(paleoEvent);
        JOptionPane.showMessageDialog(this, MSG_PALEO_EVENT_ADD_SUCCESS);
        ConnectToEmailServlet.sendEmail("New Event " + eventName + " added successfully for siteId=" + this.siteId + " by " + SessionInfo.getUserName());
        this.sendEventToListeners(paleoEvent);
    }

    private void addActionListeners() {
        this.okButton.addActionListener(this);
        this.doneButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addNewReferenceButton.setToolTipText(addNewReferenceToolTipText);
        this.addNewReferenceButton.addActionListener(this);
        this.viewAllRefsButton.addActionListener(this);
    }

    private void jbInit() throws Exception {
        this.mainSplitPane.setOrientation(0);
        this.topPanel.setLayout(this.gridBagLayout2);
        this.getContentPane().setLayout(this.borderLayout1);
        this.eventSummaryPanel.setLayout(this.gridBagLayout1);
        this.cancelButton.setText("Cancel");
        this.getContentPane().add((Component)this.topPanel, "Center");
        this.topPanel.add((Component)this.mainSplitPane, new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 3, 0, 2), 305, 423));
        this.topPanel.add((Component)this.okButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(7, 19, 19, 0), 42, 1));
        this.topPanel.add((Component)this.doneButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(7, 7, 22, 0), 21, 1));
        this.topPanel.add((Component)this.cancelButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 7, 0, 0), 0, 0));
        this.mainSplitPane.add((Component)this.detailedEventInfoSplitPane, "bottom");
        this.detailedEventInfoSplitPane.add((Component)this.estimatesSplitPane, "left");
        this.mainSplitPane.add((Component)this.eventSummaryPanel, "top");
        this.estimatesSplitPane.setDividerLocation(233);
        this.mainSplitPane.setDividerLocation(50);
        this.detailedEventInfoSplitPane.setDividerLocation(466);
    }

    @Override
    public void dbAdditionSuccessful(DbAdditionSuccessEvent event) {
        Object source = event.getSource();
        if (source == this.addNewReference) {
            this.makeReferencesParamAndEditor();
            this.commentsReferencesPanel.updateUI();
        }
    }

    static {
        String osName = System.getProperty("os.name");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

