/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ConstrainedStringListParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.editor.impl.StringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringListParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.PaleoEventDB_DAO;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;
import org.opensha.refFaultParamDb.vo.EventSequence;
import org.opensha.refFaultParamDb.vo.PaleoEvent;

public class AddEditSequence
extends LabeledBoxPanel
implements ActionListener,
ParameterChangeListener {
    private JButton addAnotherSequenceButton = new JButton("Add Another Sequence");
    private JButton sequenceWeightsButton = new JButton("Assign Weights to Sequences");
    private static final String TITLE = "Add Sequence";
    private static final String SEQUENCE_NAME_PARAM_NAME = "Sequence Name";
    private static final String COMMENTS_PARAM_NAME = "Comments";
    private static final String MISSED_EVENTS_PROB_PARAM_NAME = "Probability of missed events";
    private static final String EVENTS_PARAM_NAME = "Events in Sequence";
    private static final String SEQUENCE_PROB_PARAM_NAME = "Prob of occurence of Seq ";
    private static final String SEQUENCE_PROB_TITLE = "Sequence Probabilities";
    private static final String SEQUENCE_NAME_PARAM_DEFAULT = "Enter Sequence Name";
    private static final String COMMENTS_PARAM_DEFAULT = "Enter Comments";
    private static final String MSG_MISSING_SEQUENCE_NAME = "Please enter sequence name";
    private static final String MSG_MISSING_EVENT_NAMES = "Please select atleast 1 event in this sequence";
    private static final String MSG_NEED_TO_SAVE_CURRRENT_SEQ = "Do you want to save current sequence?";
    private static final String MSG_NO_EVENT = "First add events for this site and then add sequences";
    private static final String MSG_EVENT_PROBS_NOT_ONE = "Missed Event Probabilites do not sum up to 1";
    private static final String BEFORE = "Before";
    private static final String BETWEEN = "Between";
    private static final String AFTER = "After";
    private static final double MISSED_EVENT_PROB_MIN = 0.0;
    private static final double MISSED_EVENT_PROB_MAX = 1.0;
    private static final double SEQUENCE_PROB_MIN = 0.0;
    private static final double SEQUENCE_PROB_MAX = 1.0;
    private static final double tolerance = 1.0E-6;
    private StringParameter sequenceNameParam;
    private StringParameter commentsParam;
    private StringListParameter eventsParam;
    private ParameterList missedEventsProbParamList;
    private ParameterList sequenceProbParamList;
    private StringParameterEditor sequenceNameParamEditor;
    private CommentsParameterEditor commentsParamEditor;
    private ConstrainedStringListParameterEditor eventsParamEditor;
    private ParameterListEditor missedEventsProbParamEditor;
    private ParameterListEditor sequenceProbEditor;
    private ArrayList sequenceList = new ArrayList();
    private PaleoEventDB_DAO paleoEventDAO;
    private int siteId;
    private String siteEntryDate;
    ArrayList eventsInfoList;
    ArrayList eventNamesList;

    public AddEditSequence(DB_AccessAPI dbConnection, int siteId, String siteEntryDate) {
        this.paleoEventDAO = new PaleoEventDB_DAO(dbConnection);
        this.siteId = siteId;
        this.siteEntryDate = siteEntryDate;
        this.setLayout(GUI_Utils.gridBagLayout);
        this.initParamsAndEditors();
        this.addActionListeners();
        this.setTitle(TITLE);
    }

    private void initParamsAndEditors() {
        try {
            this.sequenceNameParam = new StringParameter(SEQUENCE_NAME_PARAM_NAME, SEQUENCE_NAME_PARAM_DEFAULT);
            this.sequenceNameParamEditor = new StringParameterEditor((Parameter)this.sequenceNameParam);
            this.commentsParam = new StringParameter(COMMENTS_PARAM_NAME, COMMENTS_PARAM_DEFAULT);
            this.commentsParamEditor = new CommentsParameterEditor(this.commentsParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList eventList = this.getAvailableEvents();
        if (eventList == null || eventList.size() == 0) {
            throw new RuntimeException(MSG_NO_EVENT);
        }
        this.eventsParam = new StringListParameter(EVENTS_PARAM_NAME, eventList);
        this.eventsParam.addParameterChangeListener(this);
        this.eventsParamEditor = new ConstrainedStringListParameterEditor(this.eventsParam);
        this.constructMissedEventsProbEditor();
        this.addEditorstoGUI();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameterName().equalsIgnoreCase(EVENTS_PARAM_NAME)) {
            this.constructMissedEventsProbEditor();
        }
    }

    private void constructMissedEventsProbEditor() {
        if (this.missedEventsProbParamEditor != null) {
            this.remove(this.missedEventsProbParamEditor);
        }
        ArrayList selectedEvents = (ArrayList)this.eventsParam.getValue();
        this.missedEventsProbParamList = new ParameterList();
        int numEvents = 0;
        ArrayList paramNames = null;
        if (selectedEvents != null) {
            numEvents = selectedEvents.size();
            paramNames = AddEditSequence.getNamesForMissedEventProbs(selectedEvents);
            double eachProb = 1.0 / (double)(numEvents + 1);
            for (int i = 0; i <= numEvents; ++i) {
                DoubleParameter probParameter = new DoubleParameter((String)paramNames.get(i), 0.0, 1.0, (Double)eachProb);
                this.missedEventsProbParamList.addParameter(probParameter);
            }
        }
        this.missedEventsProbParamEditor = new ParameterListEditor(this.missedEventsProbParamList);
        this.missedEventsProbParamEditor.setTitle(MISSED_EVENTS_PROB_PARAM_NAME);
        this.add((Component)this.missedEventsProbParamEditor, new GridBagConstraints(0, 4, 1, 3, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.validate();
        this.repaint();
    }

    public static ArrayList getNamesForMissedEventProbs(ArrayList selectedEvents) {
        int i;
        int numEvents = selectedEvents.size();
        ArrayList<CallSite> names = new ArrayList<CallSite>();
        for (i = 0; i < numEvents; ++i) {
            if (i == 0) {
                names.add((CallSite)((Object)("Before " + String.valueOf(selectedEvents.get(i)))));
                continue;
            }
            names.add((CallSite)((Object)("Between " + String.valueOf(selectedEvents.get(i - 1)) + " & " + String.valueOf(selectedEvents.get(i)))));
        }
        if (numEvents > 0) {
            i = numEvents - 1;
            names.add((CallSite)((Object)("After " + String.valueOf(selectedEvents.get(i)))));
        }
        return names;
    }

    private void addEditorstoGUI() {
        int yPos = 0;
        this.add((Component)this.sequenceNameParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.commentsParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.eventsParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.addAnotherSequenceButton, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.sequenceWeightsButton, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void addActionListeners() {
        this.addAnotherSequenceButton.addActionListener(this);
        this.sequenceWeightsButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        try {
            if (source == this.addAnotherSequenceButton) {
                this.saveCurrentSequence();
                this.removeAll();
                this.initParamsAndEditors();
            } else if (source == this.sequenceWeightsButton) {
                int option = JOptionPane.showConfirmDialog(this, MSG_NEED_TO_SAVE_CURRRENT_SEQ, TITLE, 2);
                if (option == 0) {
                    this.saveCurrentSequence();
                }
                this.removeAll();
                this.addProbParams();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    private void addProbParams() {
        this.sequenceProbParamList = new ParameterList();
        int numSequences = this.sequenceList.size();
        Double seqProbDefault = 1.0 / (double)numSequences;
        for (int i = 0; i < numSequences; ++i) {
            DoubleParameter sequenceProbParam = new DoubleParameter(SEQUENCE_PROB_PARAM_NAME + i, 0.0, 1.0, seqProbDefault);
            this.sequenceProbParamList.addParameter(sequenceProbParam);
        }
        this.sequenceProbEditor = new ParameterListEditor(this.sequenceProbParamList);
        this.sequenceProbEditor.setTitle(SEQUENCE_PROB_TITLE);
        this.add((Component)this.sequenceProbEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        JTextArea sequenceInfo = new JTextArea();
        for (int i = 0; i < numSequences; ++i) {
            EventSequence sequence = (EventSequence)this.sequenceList.get(i);
            sequenceInfo.append("Events in Sequence " + i + ":\n");
            ArrayList<PaleoEvent> events = sequence.getEventsParam();
            for (int j = 0; j < events.size(); ++j) {
                sequenceInfo.append(events.get(j).getEventName() + ",");
            }
            sequenceInfo.append("\n\n");
        }
        sequenceInfo.setEnabled(false);
        this.add((Component)new JScrollPane(sequenceInfo), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.validate();
        this.repaint();
    }

    private void saveCurrentSequence() {
        String sequenceName;
        EventSequence sequence;
        block8: {
            block7: {
                sequence = new EventSequence();
                sequenceName = ((String)this.sequenceNameParam.getValue()).trim();
                if (sequenceName.equalsIgnoreCase("")) break block7;
                if (!sequenceName.equalsIgnoreCase(SEQUENCE_NAME_PARAM_DEFAULT)) break block8;
            }
            throw new RuntimeException(MSG_MISSING_SEQUENCE_NAME);
        }
        ArrayList selectedEvents = (ArrayList)this.eventsParam.getValue();
        if (selectedEvents == null || selectedEvents.size() == 0) {
            throw new RuntimeException(MSG_MISSING_EVENT_NAMES);
        }
        ListIterator<Parameter<?>> paramsIterator = this.missedEventsProbParamList.getParametersIterator();
        ArrayList missingProbs = new ArrayList();
        double[] missedProbs = new double[selectedEvents.size() + 1];
        int i = 0;
        double sumProb = 0.0;
        while (paramsIterator.hasNext()) {
            missedProbs[i] = (Double)((Parameter)paramsIterator.next()).getValue();
            sumProb += missedProbs[i++];
        }
        if (Math.abs(sumProb - 1.0) > 1.0E-6) {
            throw new RuntimeException(MSG_EVENT_PROBS_NOT_ONE);
        }
        sequence.setComments((String)this.commentsParam.getValue());
        ArrayList<PaleoEvent> selectedEventsInfoList = new ArrayList<PaleoEvent>();
        for (i = 0; i < selectedEvents.size(); ++i) {
            String eventName = (String)selectedEvents.get(i);
            int index = selectedEvents.indexOf(eventName);
            selectedEventsInfoList.add((PaleoEvent)this.eventsInfoList.get(index));
        }
        sequence.setEventsParam(selectedEventsInfoList);
        sequence.setSequenceName(sequenceName);
        sequence.setMissedEventsProbList(missedProbs);
        this.sequenceList.add(sequence);
    }

    private ArrayList getAvailableEvents() {
        this.eventsInfoList = this.paleoEventDAO.getAllEvents(this.siteId);
        this.eventNamesList = new ArrayList();
        for (int i = 0; i < this.eventsInfoList.size(); ++i) {
            this.eventNamesList.add(((PaleoEvent)this.eventsInfoList.get(i)).getEventName());
        }
        return this.eventNamesList;
    }

    public ArrayList getAllSequences() {
        ListIterator<Parameter<?>> it = this.sequenceProbParamList.getParametersIterator();
        int i = 0;
        while (it.hasNext()) {
            DoubleParameter param = (DoubleParameter)it.next();
            ((EventSequence)this.sequenceList.get(i)).setSequenceProb((Double)param.getValue());
            ++i;
        }
        return this.sequenceList;
    }

    static {
        String osName = System.getProperty("os.name");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

