/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.data.TimeAPI;
import org.opensha.refFaultParamDb.gui.TimeGuiBean;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;

public class AddEditTimeSpan
extends JPanel {
    private static final String START_TIME_PARAM_NAME = "Start Time";
    private static final String END_TIME_PARAM_NAME = "End Time";
    private static final String TIMESPAN_COMMENTS_PARAM_NAME = "Dating Methodology";
    private static final String TIMESPAN_COMMENTS_DEFAULT = "Summary of dating techniques and dated features";
    private static final String TITLE = "Add Time Span";
    private StringParameter timeSpanCommentsParam;
    private CommentsParameterEditor timeSpanCommentsParamEditor;
    private TimeGuiBean startTimeBean;
    private TimeGuiBean endTimeBean;
    private JSplitPane timSpanSplitPane = new JSplitPane();
    private JPanel commentsPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public AddEditTimeSpan() {
        try {
            this.jbInit();
            this.addTimeEstimateParametersAndEditors();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setVisible(true);
    }

    public AddEditTimeSpan(TimeAPI startTime, TimeAPI endTime, String comments) {
        this();
        this.setValuesInParameters(startTime, endTime, comments);
    }

    private void setValuesInParameters(TimeAPI startTime, TimeAPI endTime, String comments) {
        this.startTimeBean.setTime(startTime);
        this.endTimeBean.setTime(endTime);
        this.timeSpanCommentsParam.setValue(comments);
        this.timeSpanCommentsParamEditor.refreshParamEditor();
    }

    public void setNowYearVal(int nowYearVal) {
        this.endTimeBean.setNowYearVal(nowYearVal);
    }

    private void addTimeEstimateParametersAndEditors() throws Exception {
        this.startTimeBean = new TimeGuiBean(START_TIME_PARAM_NAME, false);
        this.endTimeBean = new TimeGuiBean(END_TIME_PARAM_NAME, true);
        this.timSpanSplitPane.add((Component)this.startTimeBean, "left");
        this.timSpanSplitPane.add((Component)this.endTimeBean, "right");
        this.timSpanSplitPane.setDividerLocation(325);
        this.timeSpanCommentsParam = new StringParameter(TIMESPAN_COMMENTS_PARAM_NAME);
        this.timeSpanCommentsParamEditor = new CommentsParameterEditor(this.timeSpanCommentsParam);
        this.commentsPanel.add((Component)this.timeSpanCommentsParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setMinimumSize(new Dimension(0, 0));
        this.add((Component)this.timSpanSplitPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 0, 4), 374, 432));
        this.add((Component)this.commentsPanel, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 0), 256, 90));
        this.timSpanSplitPane.setOrientation(1);
        this.commentsPanel.setLayout(this.gridBagLayout1);
    }

    public TimeAPI getStartTime() {
        TimeAPI startTime = this.startTimeBean.getSelectedTime();
        this.setDatingComments(startTime);
        return startTime;
    }

    private void setDatingComments(TimeAPI timeAPI) throws RuntimeException {
        timeAPI.setDatingComments((String)this.timeSpanCommentsParam.getValue());
    }

    public TimeAPI getEndTime() {
        TimeAPI endTime = this.endTimeBean.getSelectedTime();
        this.setDatingComments(endTime);
        return endTime;
    }

    public String getTimeSpanComments() {
        return (String)this.timeSpanCommentsParam.getValue();
    }
}

