/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SiteRepresentationDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SiteTypeDB_DAO;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddNewReference;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddSiteInfo;
import org.opensha.refFaultParamDb.gui.event.DbAdditionListener;
import org.opensha.refFaultParamDb.gui.event.DbAdditionSuccessEvent;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.view.ViewAllReferences;
import org.opensha.refFaultParamDb.vo.Reference;
import org.opensha.refFaultParamDb.vo.SiteRepresentation;
import org.opensha.refFaultParamDb.vo.SiteType;

public class ChooseReference
extends JFrame
implements ActionListener,
DbAdditionListener {
    private static final String TIMESPAN_REFERENCES_PARAM_NAME = "Choose Reference";
    private static final String addNewReferenceToolTipText = "Add Reference not currently in database";
    private JButton addNewReferenceButton = new JButton("Add Reference");
    private JButton viewAllRefButtons = new JButton("View All References");
    private AddNewReference addNewReference;
    private ConstrainedStringParameterEditor referencesParamEditor;
    private StringParameter referencesParam;
    private JButton okButton = new JButton("OK");
    private JButton closeButton = new JButton("Close");
    private AddSiteInfo addSiteInfo;
    private static ArrayList referenceSummaryList;
    private static ArrayList referenceList;
    private static final String SITE_TYPE_PARAM_NAME = "Site Type";
    private static final String SITE_REPRESENTATION_PARAM_NAME = "How Representative is this Site";
    private StringParameter siteTypeParam;
    private StringParameter siteRepresentationParam;
    private ConstrainedStringParameterEditor siteTypeParamEditor;
    private ConstrainedStringParameterEditor siteRepresentationParamEditor;
    private SiteTypeDB_DAO siteTypeDAO;
    private SiteRepresentationDB_DAO siteRepresentationDAO;
    private static final String TITLE = "Choose Reference";
    private ReferenceDB_DAO referenceDAO;
    private DB_AccessAPI dbConnection;

    public ChooseReference(DB_AccessAPI dbConnection, AddSiteInfo addSiteInfo) {
        this.dbConnection = dbConnection;
        this.siteTypeDAO = new SiteTypeDB_DAO(dbConnection);
        this.siteRepresentationDAO = new SiteRepresentationDB_DAO(dbConnection);
        this.referenceDAO = new ReferenceDB_DAO(dbConnection);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addSiteInfo = addSiteInfo;
        this.addActionListeners();
        this.setTitle("Choose Reference");
        this.addNewReferenceButton.setToolTipText(addNewReferenceToolTipText);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
    }

    public void setParameters(String siteType, String representativeStrandIndex, Reference reference) {
        this.siteTypeParam.setValue(siteType);
        this.siteTypeParamEditor.refreshParamEditor();
        this.siteRepresentationParam.setValue(representativeStrandIndex);
        this.siteRepresentationParamEditor.refreshParamEditor();
        this.referencesParam.setValue(reference.getSummary());
        this.referencesParamEditor.refreshParamEditor();
    }

    private void addActionListeners() {
        this.addNewReferenceButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.viewAllRefButtons.addActionListener(this);
        this.closeButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.addNewReferenceButton) {
            this.addNewReference = new AddNewReference(this.dbConnection);
            this.addNewReference.addDbAdditionSuccessListener(this);
        } else if (source == this.okButton) {
            int index = referenceSummaryList.indexOf((String)this.referencesParam.getValue());
            this.addSiteInfo.setReference((Reference)referenceList.get(index));
            this.addSiteInfo.setSiteType((String)this.siteTypeParam.getValue());
            this.addSiteInfo.setSiteRepresentativeStrandIndex((String)this.siteRepresentationParam.getValue());
            this.okButton.setEnabled(false);
        } else if (source == this.closeButton) {
            this.dispose();
        } else if (source == this.viewAllRefButtons) {
            ViewAllReferences viewAllReferences = new ViewAllReferences(this.dbConnection);
        }
    }

    private void jbInit() throws Exception {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(GUI_Utils.gridBagLayout);
        this.makeReferencesParamAndEditor();
        this.makeSiteTypeParamAndEditor();
        this.makeSiteRepresentationParamAndEditor();
        int yPos = 3;
        contentPane.add((Component)this.viewAllRefButtons, new GridBagConstraints(0, yPos, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        contentPane.add((Component)this.addNewReferenceButton, new GridBagConstraints(1, yPos++, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        contentPane.add((Component)this.okButton, new GridBagConstraints(0, yPos, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        contentPane.add((Component)this.closeButton, new GridBagConstraints(1, yPos++, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void makeReferencesParamAndEditor() throws ConstraintException {
        if (this.referencesParamEditor != null) {
            this.remove(this.referencesParamEditor);
        }
        ArrayList availableReferences = this.getAvailableReferences();
        this.referencesParam = new StringParameter("Choose Reference", availableReferences, (String)availableReferences.get(0));
        this.referencesParamEditor = new ConstrainedStringParameterEditor(this.referencesParam);
        this.getContentPane().add((Component)this.referencesParamEditor, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private ArrayList getAvailableReferences() {
        referenceList = this.referenceDAO.getAllReferencesSummary();
        referenceSummaryList = new ArrayList();
        for (int i = 0; referenceList != null && i < referenceList.size(); ++i) {
            referenceSummaryList.add(((Reference)referenceList.get(i)).getSummary());
        }
        return referenceSummaryList;
    }

    private void makeSiteTypeParamAndEditor() {
        ArrayList siteTypes = this.getSiteTypes();
        this.siteTypeParam = new StringParameter(SITE_TYPE_PARAM_NAME, siteTypes, (String)siteTypes.get(0));
        this.siteTypeParamEditor = new ConstrainedStringParameterEditor(this.siteTypeParam);
        this.getContentPane().add((Component)this.siteTypeParamEditor, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private ArrayList getSiteTypes() {
        ArrayList<SiteType> siteTypeVOs = this.siteTypeDAO.getAllSiteTypes();
        ArrayList<String> siteTypesList = new ArrayList<String>();
        for (int i = 0; i < siteTypeVOs.size(); ++i) {
            siteTypesList.add(siteTypeVOs.get(i).getSiteType());
        }
        return siteTypesList;
    }

    private void makeSiteRepresentationParamAndEditor() {
        ArrayList siteRepresentations = this.getSiteRepresentations();
        this.siteRepresentationParam = new StringParameter(SITE_REPRESENTATION_PARAM_NAME, siteRepresentations, (String)siteRepresentations.get(0));
        this.siteRepresentationParamEditor = new ConstrainedStringParameterEditor(this.siteRepresentationParam);
        this.getContentPane().add((Component)this.siteRepresentationParamEditor, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private ArrayList getSiteRepresentations() {
        ArrayList<SiteRepresentation> siteRepresentationVOs = this.siteRepresentationDAO.getAllSiteRepresentations();
        ArrayList<String> siteRepresentations = new ArrayList<String>();
        for (int i = 0; i < siteRepresentationVOs.size(); ++i) {
            siteRepresentations.add(siteRepresentationVOs.get(i).getSiteRepresentationName());
        }
        return siteRepresentations;
    }

    @Override
    public void dbAdditionSuccessful(DbAdditionSuccessEvent event) {
        Object source = event.getSource();
        if (source == this.addNewReference) {
            this.makeReferencesParamAndEditor();
        }
        this.validate();
        this.repaint();
    }
}

