/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.login;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.opensha.refFaultParamDb.dao.db.ContributorDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.exception.DBConnectException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;

public class ChangePassword
extends JFrame
implements ActionListener {
    private JPanel mainPanel = new JPanel();
    private JLabel changePasswordLabel = new JLabel();
    private JLabel userNameLabel = new JLabel();
    private JTextField userNameText = new JTextField();
    private JLabel oldPwdLabel = new JLabel();
    private JLabel newPwdLabel = new JLabel();
    private JLabel confirmNewPwdLabel = new JLabel();
    private JPasswordField oldPwdText = new JPasswordField();
    private JPasswordField newPwdText = new JPasswordField();
    private JPasswordField confirmNewPwdText = new JPasswordField();
    private JButton changePasswordButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private static final String MSG_USERNAME_MISSING = "Username is missing";
    private static final String MSG_CURRENT_PWD_MISSING = "Current Password is missing";
    private static final String MSG_NEW_PWD_MISSING = "New Password is missing";
    private static final String MSG_NEW_PWDS_DIFFERENT = "New Passwords are different";
    private static final String MSG_PWD_CHANGE_SUCCESS = "Password changed successful";
    private static final String MSG_PWD_CHANGE_FAILED = "Password change failed\nCheck username and current password";
    private ContributorDB_DAO contributorDAO;

    public ChangePassword(DB_AccessAPI dbConnection) {
        this.contributorDAO = new ContributorDB_DAO(dbConnection);
        try {
            this.jbInit();
            this.changePasswordButton.addActionListener(this);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.changePasswordLabel.setFont(new Font("Dialog", 1, 16));
        this.changePasswordLabel.setForeground(new Color(80, 80, 133));
        this.changePasswordLabel.setHorizontalAlignment(0);
        this.changePasswordLabel.setText("Change Password");
        this.userNameLabel.setFont(new Font("Dialog", 1, 12));
        this.userNameLabel.setForeground(new Color(80, 80, 133));
        this.userNameLabel.setRequestFocusEnabled(true);
        this.userNameLabel.setText("Username:");
        this.userNameText.setForeground(new Color(80, 80, 133));
        this.userNameText.setText("");
        this.oldPwdLabel.setFont(new Font("Dialog", 1, 12));
        this.oldPwdLabel.setForeground(new Color(80, 80, 133));
        this.oldPwdLabel.setText("Old Password:");
        this.newPwdLabel.setFont(new Font("Dialog", 1, 12));
        this.newPwdLabel.setForeground(new Color(80, 80, 133));
        this.newPwdLabel.setText("New Password:");
        this.confirmNewPwdLabel.setFont(new Font("Dialog", 1, 12));
        this.confirmNewPwdLabel.setForeground(new Color(80, 80, 133));
        this.confirmNewPwdLabel.setRequestFocusEnabled(true);
        this.confirmNewPwdLabel.setText("Confirm New Password:");
        this.oldPwdText.setFont(new Font("Dialog", 1, 12));
        this.oldPwdText.setForeground(new Color(80, 80, 133));
        this.oldPwdText.setText("");
        this.newPwdText.setText("");
        this.newPwdText.setFont(new Font("Dialog", 1, 12));
        this.newPwdText.setForeground(new Color(80, 80, 133));
        this.confirmNewPwdText.setText("");
        this.confirmNewPwdText.setFont(new Font("Dialog", 1, 12));
        this.confirmNewPwdText.setForeground(new Color(80, 80, 133));
        this.changePasswordButton.setForeground(new Color(80, 80, 133));
        this.changePasswordButton.setText("Change Password");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.userNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(26, 18, 0, 65), 27, 13));
        this.mainPanel.add((Component)this.oldPwdLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(18, 18, 0, 53), 20, 13));
        this.mainPanel.add((Component)this.newPwdLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(19, 18, 0, 49), 18, 13));
        this.mainPanel.add((Component)this.confirmNewPwdLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(18, 18, 0, 0), 20, 13));
        this.mainPanel.add((Component)this.userNameText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(28, 16, 0, 23), 163, 3));
        this.mainPanel.add((Component)this.oldPwdText, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 16, 0, 23), 164, 4));
        this.mainPanel.add((Component)this.confirmNewPwdText, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 16, 0, 23), 164, 4));
        this.mainPanel.add((Component)this.newPwdText, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(21, 16, 0, 23), 164, 4));
        this.mainPanel.add((Component)this.changePasswordButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(11, 37, 20, 23), 21, 4));
        this.mainPanel.add((Component)this.changePasswordLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 39, 0, 55), 148, 13));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String userName = this.userNameText.getText().trim();
        String oldPwd = new String(this.oldPwdText.getPassword()).trim();
        String newPwd = new String(this.newPwdText.getPassword()).trim();
        String confirmNewPwdText = new String(this.confirmNewPwdText.getPassword()).trim();
        if (userName.equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, MSG_USERNAME_MISSING);
            return;
        }
        if (oldPwd.equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, MSG_CURRENT_PWD_MISSING);
            return;
        }
        if (newPwd.equalsIgnoreCase("") || confirmNewPwdText.equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, MSG_NEW_PWD_MISSING);
            return;
        }
        if (!newPwd.equalsIgnoreCase(confirmNewPwdText)) {
            JOptionPane.showMessageDialog(this, MSG_NEW_PWDS_DIFFERENT);
            return;
        }
        SessionInfo.setUserName(userName);
        SessionInfo.setPassword(oldPwd);
        SessionInfo.setContributorInfo();
        try {
            SessionInfo.setContributorInfo();
            if (SessionInfo.getContributor() == null) {
                JOptionPane.showMessageDialog(this, "Invalid username/password");
                return;
            }
        }
        catch (DBConnectException connectException) {
            JOptionPane.showMessageDialog(this, "Invalid username/password");
            return;
        }
        boolean success = this.contributorDAO.updatePassword(userName, oldPwd, newPwd);
        if (success) {
            JOptionPane.showMessageDialog(this, MSG_PWD_CHANGE_SUCCESS);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, MSG_PWD_CHANGE_FAILED);
        }
    }
}

