/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.opensha.refFaultParamDb.dao.db.ContributorDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.servlets.UserAccountInfoServlet;
import org.opensha.refFaultParamDb.vo.Contributor;

public class GetAccountInfo
extends JFrame
implements ActionListener {
    private JPanel jPanel1 = new JPanel();
    private JTextField emailText = new JTextField();
    private JLabel emailLabel = new JLabel();
    private JButton emailAccountInfoButton = new JButton();
    private JLabel forgotLabel = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private static final String MSG_EMAIL_MISSING = "Email address is missing";
    private static final String MSG_INVALID_EMAIL = "Invalid email address";
    private static final String MSG_SUCCESS = "Account Info emailed successfully";
    private ContributorDB_DAO contributorDAO;

    public GetAccountInfo(DB_AccessAPI dbConnection) {
        this.contributorDAO = new ContributorDB_DAO(dbConnection);
        try {
            this.jbInit();
            this.emailAccountInfoButton.addActionListener(this);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout2);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.emailText.setText("");
        this.emailText.setForeground(new Color(80, 80, 133));
        this.emailLabel.setFont(new Font("Dialog", 1, 12));
        this.emailLabel.setForeground(new Color(80, 80, 133));
        this.emailLabel.setText("Email:");
        this.emailAccountInfoButton.setForeground(new Color(80, 80, 133));
        this.emailAccountInfoButton.setText("Email Account Info");
        this.forgotLabel.setFont(new Font("Dialog", 1, 16));
        this.forgotLabel.setForeground(new Color(80, 80, 133));
        this.forgotLabel.setHorizontalAlignment(0);
        this.forgotLabel.setText("Forgot username/password");
        this.getContentPane().add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 13, 24), -4, 4));
        this.jPanel1.add((Component)this.forgotLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 7), 78, 13));
        this.jPanel1.add((Component)this.emailAccountInfoButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 22, 33), 20, 7));
        this.jPanel1.add((Component)this.emailLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(14, 17, 0, 0), 73, 13));
        this.jPanel1.add((Component)this.emailText, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(15, 75, 0, 31), 184, 3));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String email = this.emailText.getText().trim();
        if (email.equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, MSG_EMAIL_MISSING);
            return;
        }
        Contributor contributor = this.contributorDAO.getContributorByEmail(email);
        if (contributor == null) {
            JOptionPane.showMessageDialog(this, MSG_INVALID_EMAIL);
            return;
        }
        this.contributorDAO.resetPasswordByEmail(email);
        JOptionPane.showMessageDialog(this, MSG_SUCCESS);
        this.dispose();
    }

    public static void sendEmail(String message, String emailTo) {
        try {
            URL emailServlet = new URL(UserAccountInfoServlet.SERVLET_ADDRESS);
            URLConnection servletConnection = emailServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream toServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            toServlet.writeObject(emailTo);
            toServlet.writeObject(message);
            toServlet.flush();
            toServlet.close();
            ObjectInputStream fromServlet = new ObjectInputStream(servletConnection.getInputStream());
            String outputFromServlet = (String)fromServlet.readObject();
            fromServlet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

