/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DeformationModelPrefDataDB_DAO;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.gui.infoTools.CalcProgressBar;

public class DeformationModelFileWriter
implements Runnable {
    private DeformationModelPrefDataDB_DAO deformationModelPrefDAO;
    private CalcProgressBar progressBar;
    private int totSections;
    private int currSection;
    private HSSFWorkbook wb;
    private HSSFSheet excelSheet;
    private int rowNum;
    private boolean createExcelSheet;

    public DeformationModelFileWriter(DB_AccessAPI dbConnection) {
        this.deformationModelPrefDAO = new DeformationModelPrefDataDB_DAO(dbConnection);
    }

    public void writeForDeformationModel(int deformationModelId, File file, boolean createExcelSheet) {
        try {
            this.createExcelSheet = createExcelSheet;
            if (createExcelSheet) {
                this.wb = new HSSFWorkbook();
                this.excelSheet = this.wb.createSheet();
            }
            this.currSection = 0;
            ArrayList<Integer> faultSectionIds = this.deformationModelPrefDAO.getFaultSectionIdsForDeformationModel(deformationModelId);
            this.totSections = faultSectionIds.size();
            this.progressBar = new CalcProgressBar("Writing to file", "Writing Fault sections");
            this.progressBar.displayProgressBar();
            Thread t = new Thread(this);
            t.start();
            FileWriter fw = new FileWriter(file);
            fw.write(this.getFormatStringForDeformationModel());
            this.currSection = 0;
            while (this.currSection < this.totSections) {
                this.writeForDeformationModel(deformationModelId, faultSectionIds.get(this.currSection), fw);
                ++this.currSection;
            }
            fw.close();
            if (createExcelSheet) {
                FileOutputStream fileOut = new FileOutputStream(file.getAbsolutePath().replaceFirst(".txt", ".xls"));
                this.wb.write((OutputStream)fileOut);
                fileOut.close();
            }
            this.progressBar.showProgress(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            while (this.currSection < this.totSections) {
                this.progressBar.updateProgress(this.currSection, this.totSections);
                Thread.currentThread();
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeForDeformationModel(int deformationModelId, int faultSectionId, FileWriter fw) {
        try {
            FaultSectionPrefData faultSectionPrefData = this.deformationModelPrefDAO.getFaultSectionPrefData(deformationModelId, faultSectionId);
            this.writeForDeformationModel(faultSectionPrefData, fw);
            if (this.createExcelSheet) {
                this.writeToExcelSheet(faultSectionPrefData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeToExcelSheet(FaultSectionPrefData faultSectionPrefData) {
        HSSFRow row = this.excelSheet.createRow(this.rowNum);
        int colIndex = 0;
        if (this.rowNum == 0) {
            row.createCell((int)((short)colIndex)).setCellValue("Section Name");
            row.createCell((int)((short)(++colIndex))).setCellValue("Ave Strike -  LocationVector from the first to the last point on fault trace");
            row.createCell((int)((short)(++colIndex))).setCellValue("Dip (degrees)");
            row.createCell((int)((short)(++colIndex))).setCellValue("Slip Rate (mm/yr)");
            row.createCell((int)((short)(++colIndex))).setCellValue("Aseismic Slip Factor");
            row.createCell((int)((short)(++colIndex))).setCellValue("Rake");
            row.createCell((int)((short)(++colIndex))).setCellValue("Upper Seis Depth (km)");
            row.createCell((int)((short)(++colIndex))).setCellValue("Lower Seis Depth (km)");
            row.createCell((int)((short)(++colIndex))).setCellValue("Length (km)");
            row.createCell((int)((short)(++colIndex))).setCellValue("Down Dip Width (km)");
            row.createCell((int)((short)(++colIndex))).setCellValue("Area (sq. km)");
            row.createCell((int)((short)(++colIndex))).setCellValue("Num Fault Trace Locations");
            ++colIndex;
            ++this.rowNum;
            row = this.excelSheet.createRow(this.rowNum);
        }
        FaultTrace faultTrace = faultSectionPrefData.getFaultTrace();
        int numLocations = faultTrace.getNumLocations();
        colIndex = 0;
        row.createCell((int)((short)colIndex)).setCellValue(faultSectionPrefData.getSectionName());
        double strike = LocationUtils.vector((Location)faultTrace.get(0), (Location)faultTrace.get(numLocations - 1)).getAzimuth();
        row.createCell((int)((short)(++colIndex))).setCellValue(strike);
        row.createCell((int)((short)(++colIndex))).setCellValue(this.getValue(faultSectionPrefData.getAveDip()));
        row.createCell((int)((short)(++colIndex))).setCellValue(this.getValue(faultSectionPrefData.getOrigAveSlipRate()));
        row.createCell((int)((short)(++colIndex))).setCellValue(this.getValue(faultSectionPrefData.getAseismicSlipFactor()));
        row.createCell((int)((short)(++colIndex))).setCellValue(this.getValue(faultSectionPrefData.getAveRake()));
        row.createCell((int)((short)(++colIndex))).setCellValue(this.getValue(faultSectionPrefData.getOrigAveUpperDepth()));
        row.createCell((int)((short)(++colIndex))).setCellValue(this.getValue(faultSectionPrefData.getAveLowerDepth()));
        row.createCell((int)((short)(++colIndex))).setCellValue(faultSectionPrefData.getTraceLength());
        row.createCell((int)((short)(++colIndex))).setCellValue(faultSectionPrefData.getOrigDownDipWidth());
        row.createCell((int)((short)(++colIndex))).setCellValue(faultSectionPrefData.getTraceLength() * faultSectionPrefData.getOrigDownDipWidth());
        row.createCell((int)((short)(++colIndex))).setCellValue((double)numLocations);
        for (int i = 0; i < numLocations; ++i) {
            Location loc = (Location)faultTrace.get(i);
            row.createCell((int)((short)(++colIndex))).setCellValue(loc.getLatitude());
            row.createCell((int)((short)(++colIndex))).setCellValue(loc.getLongitude());
        }
        ++colIndex;
        ++this.rowNum;
    }

    public void writeForDeformationModel(FaultSectionPrefData faultSectionPrefData, FileWriter fw) {
        try {
            fw.write(this.getStringForDeformationModel(faultSectionPrefData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getStringForDeformationModel(FaultSectionPrefData faultSectionPrefData) {
        FaultTrace faultTrace = faultSectionPrefData.getFaultTrace();
        String str = "#" + faultSectionPrefData.getSectionName() + "\n" + this.getValue(faultSectionPrefData.getShortName()) + "\n" + this.getValue(faultSectionPrefData.getOrigAveUpperDepth()) + "\n" + this.getValue(faultSectionPrefData.getAveLowerDepth()) + "\n" + this.getValue(faultSectionPrefData.getAveDip()) + "\n" + this.getValue(faultSectionPrefData.getDipDirection()) + "\n" + this.getValue(faultSectionPrefData.getOrigAveSlipRate()) + "\n" + this.getValue(faultSectionPrefData.getAseismicSlipFactor()) + "\n" + this.getValue(faultSectionPrefData.getAveRake()) + "\n" + this.getValue(faultTrace.getTraceLength()) + "\n" + faultTrace.getNumLocations() + "\n";
        for (int i = 0; i < faultTrace.getNumLocations(); ++i) {
            str = str + (float)((Location)faultTrace.get(i)).getLatitude() + "\t" + (float)((Location)faultTrace.get(i)).getLongitude() + "\n";
        }
        return str;
    }

    private String getValue(double val) {
        if (Double.isNaN(val)) {
            return "Not Available";
        }
        return GUI_Utils.decimalFormat.format(val);
    }

    private String getValue(String val) {
        if (val == null || val.equalsIgnoreCase("")) {
            return "Not Available";
        }
        return val;
    }

    public String getFormatStringForDeformationModel() {
        return "********************************\n#Section Name\n#Short Name\n#Ave Upper Seis Depth (km)\n#Ave Lower Seis Depth (km)\n#Ave Dip (degrees)\n#Ave Dip Direction\n#Ave Long Term Slip Rate\n#Ave Aseismic Slip Factor\n#Ave Rake\n#Trace Length (derivative value) (km)\n#Num Trace Points\n#lat1 lon1\n#lat2 lon2\n********************************\n";
    }
}

