/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.gui.view.AbstractSectionInfoFileWriter;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultTrace;

public class SectionInfoTextFileWriter
extends AbstractSectionInfoFileWriter {
    public SectionInfoTextFileWriter(DB_AccessAPI dbConnection) {
        super(dbConnection);
    }

    @Override
    public String getFaultAsString(FaultSectionPrefData faultSectionPrefData) {
        FaultTrace faultTrace = faultSectionPrefData.getFaultTrace();
        String str = "#" + faultSectionPrefData.getSectionName() + "\n" + this.getValue(faultSectionPrefData.getShortName()) + "\n" + this.getValue(faultSectionPrefData.getOrigAveUpperDepth()) + "\n" + this.getValue(faultSectionPrefData.getAveLowerDepth()) + "\n" + this.getValue(faultSectionPrefData.getAveDip()) + "\n" + this.getValue(faultSectionPrefData.getDipDirection()) + "\n" + this.getValue(faultSectionPrefData.getAveRake()) + "\n" + this.getValue(faultTrace.getTraceLength()) + "\n" + faultTrace.getNumLocations() + "\n";
        for (int i = 0; i < faultTrace.getNumLocations(); ++i) {
            str = str + (float)((Location)faultTrace.get(i)).getLatitude() + "\t" + (float)((Location)faultTrace.get(i)).getLongitude() + "\n";
        }
        return str;
    }

    @Override
    public String getFileHeader() {
        return "********************************\n#Section Name\n#Short Name\n#Ave Upper Seis Depth (km)\n#Ave Lower Seis Depth (km)\n#Ave Dip (degrees)\n#Ave Dip Direction\n#Ave Rake\n#Trace Length (derivative value) (km)\n#Num Trace Points\n#lat1 lon1\n#lat2 lon2\n********************************\n";
    }
}

