/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JPanel;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.InfoLabel;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;
import org.opensha.refFaultParamDb.vo.CombinedDisplacementInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class ViewCumDisplacement
extends LabeledBoxPanel {
    private static final String DISPLACEMENT_TITLE = "Displacement";
    private static final String DISPLACEMENT_PANEL_TITLE = "Displacement Estimate(m)";
    private final String ASEISMIC_SLIP_PANEL_TITLE = "Aseismic Slip Factor(0-1, 1=all aseismic)";
    private static final String MEASURED_COMP_SLIP_TITLE = "Measured Component of Slip";
    private static final String SENSE_OF_MOTION_TITLE = "Sense of Motion";
    private static final String DISPLACEMENT = "Displacement";
    private static final String ASEISMIC_SLIP_FACTOR = "Aseismic Slip Factor";
    private static final String PROB = "Prob this is correct value";
    private static final String RAKE = "Rake";
    private static final String QUALITATIVE = "Qualitative";
    private InfoLabel displacementEstimateLabel = new InfoLabel();
    private InfoLabel aSesimicSlipFactorLabel = new InfoLabel();
    private InfoLabel senseOfMotionRakeLabel = new InfoLabel();
    private InfoLabel senseOfMotionQualLabel = new InfoLabel();
    private InfoLabel measuredCompQualLabel = new InfoLabel();
    private StringParameter commentsParam = new StringParameter("Displacement Comments");
    private CommentsParameterEditor commentsParameterEditor;

    public ViewCumDisplacement() {
        super(GUI_Utils.gridBagLayout);
        try {
            this.viewDisplacementForTimePeriod();
            this.setTitle("Displacement");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInfo(CombinedDisplacementInfo combinedDisplacementInfo) {
        if (combinedDisplacementInfo == null) {
            this.setInfo(null, null, null, null, null, null);
        } else {
            EstimateInstances aseismicSlipEstInstance = combinedDisplacementInfo.getASeismicSlipFactorEstimateForDisp();
            Estimate aseismicSlipEst = null;
            if (aseismicSlipEstInstance != null) {
                aseismicSlipEst = aseismicSlipEstInstance.getEstimate();
            }
            this.setInfo(combinedDisplacementInfo.getDisplacementEstimate().getEstimate(), aseismicSlipEst, combinedDisplacementInfo.getDisplacementComments(), combinedDisplacementInfo.getSenseOfMotionRake(), combinedDisplacementInfo.getSenseOfMotionQual(), combinedDisplacementInfo.getMeasuredComponentQual());
        }
    }

    private void setInfo(Estimate displacementEstimate, Estimate aSeismicSlipFactorEstimate, String comments, EstimateInstances rakeForSenseOfMotion, String senseOfMotionQual, String measuredSlipQual) {
        this.displacementEstimateLabel.setTextAsHTML(displacementEstimate, "Displacement", PROB);
        this.aSesimicSlipFactorLabel.setTextAsHTML(aSeismicSlipFactorEstimate, ASEISMIC_SLIP_FACTOR, PROB);
        this.commentsParam.setValue(comments);
        this.commentsParameterEditor.refreshParamEditor();
        this.measuredCompQualLabel.setTextAsHTML(QUALITATIVE, measuredSlipQual);
        Estimate rakeEst = null;
        if (rakeForSenseOfMotion != null) {
            rakeEst = rakeForSenseOfMotion.getEstimate();
        }
        this.senseOfMotionRakeLabel.setTextAsHTML(rakeEst, RAKE, PROB);
        this.senseOfMotionQualLabel.setTextAsHTML(QUALITATIVE, senseOfMotionQual);
    }

    private void viewDisplacementForTimePeriod() throws Exception {
        JPanel displacementEstimatePanel = GUI_Utils.getPanel(this.displacementEstimateLabel, DISPLACEMENT_PANEL_TITLE);
        JPanel aseismicPanel = GUI_Utils.getPanel(this.aSesimicSlipFactorLabel, "Aseismic Slip Factor(0-1, 1=all aseismic)");
        JPanel senseOfMotionPanel = GUI_Utils.getPanel(SENSE_OF_MOTION_TITLE);
        JPanel measuredSlipCompPanel = GUI_Utils.getPanel(MEASURED_COMP_SLIP_TITLE);
        senseOfMotionPanel.add((Component)this.senseOfMotionRakeLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        senseOfMotionPanel.add((Component)this.senseOfMotionQualLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        measuredSlipCompPanel.add((Component)this.measuredCompQualLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.commentsParameterEditor = new CommentsParameterEditor(this.commentsParam);
        this.commentsParameterEditor.setEnabled(false);
        int yPos = 0;
        this.add((Component)displacementEstimatePanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)measuredSlipCompPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)senseOfMotionPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)aseismicPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.commentsParameterEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

