/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddEditSequence;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.InfoLabel;
import org.opensha.refFaultParamDb.vo.EventSequence;
import org.opensha.refFaultParamDb.vo.PaleoEvent;

public class ViewSequences
extends LabeledBoxPanel
implements ParameterChangeListener {
    private static final String SEQUENCE_NAME_PARAM_NAME = "Sequence Name";
    private static final String SEQUENCE_PROB_PARAM_NAME = "Prob this is correct sequence";
    private static final String COMMENTS_PARAM_NAME = "Comments";
    private static final String MISSED_EVENTS_PROB_PARAM_NAME = "Probability of missed events";
    private static final String EVENTS_PARAM_NAME = "Events in Sequence";
    private static final String TITLE = "Sequences";
    private InfoLabel sequenceProbLabel = new InfoLabel();
    private InfoLabel eventsLabel = new InfoLabel();
    private InfoLabel missedProbLabel = new InfoLabel();
    private InfoLabel commentsLabel = new InfoLabel();
    private StringParameter sequenceNameParam;
    private ConstrainedStringParameterEditor sequenceNamesEditor;
    private ArrayList sequenceNamesList;
    private ArrayList sequencesList;

    public ViewSequences() {
        try {
            this.setLayout(GUI_Utils.gridBagLayout);
            this.createSequencesListParameterEditor();
            this.addEditorstoGUI();
            this.setTitle(TITLE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createSequencesListParameterEditor() {
        if (this.sequenceNamesEditor != null) {
            this.remove(this.sequenceNamesEditor);
        }
        ArrayList sequenceNamesList = this.getSequenceNamesList();
        this.sequenceNameParam = new StringParameter(SEQUENCE_NAME_PARAM_NAME, sequenceNamesList, (String)sequenceNamesList.get(0));
        this.sequenceNameParam.addParameterChangeListener(this);
        this.sequenceNamesEditor = new ConstrainedStringParameterEditor(this.sequenceNameParam);
        this.add((Component)this.sequenceNamesEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.sequenceNamesEditor.refreshParamEditor();
        this.updateUI();
        this.setSequenceInfo((String)this.sequenceNameParam.getValue());
    }

    private ArrayList getSequenceNamesList() {
        this.sequenceNamesList = new ArrayList();
        if (this.sequencesList == null || this.sequencesList.size() == 0) {
            this.sequenceNamesList.add("NA");
        } else {
            for (int i = 0; i < this.sequencesList.size(); ++i) {
                this.sequenceNamesList.add(((EventSequence)this.sequencesList.get(i)).getSequenceName());
            }
        }
        return this.sequenceNamesList;
    }

    private void addEditorstoGUI() {
        int yPos = 1;
        this.add((Component)GUI_Utils.getPanel(this.sequenceProbLabel, SEQUENCE_PROB_PARAM_NAME), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.eventsLabel, EVENTS_PARAM_NAME), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.missedProbLabel, MISSED_EVENTS_PROB_PARAM_NAME), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.commentsLabel, COMMENTS_PARAM_NAME), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.setSequenceInfo((String)this.sequenceNameParam.getValue());
    }

    public void setSequenceList(ArrayList sequenceList) {
        this.sequencesList = sequenceList;
        this.createSequencesListParameterEditor();
    }

    private void setSequenceInfo(String sequenceName) {
        if (this.sequencesList != null && this.sequencesList.size() != 0) {
            int index = this.sequenceNamesList.indexOf(sequenceName);
            EventSequence eventSequence = (EventSequence)this.sequencesList.get(index);
            ArrayList<PaleoEvent> paleoEventsList = eventSequence.getEventsParam();
            ArrayList<String> eventNames = new ArrayList<String>();
            for (int i = 0; i < paleoEventsList.size(); ++i) {
                PaleoEvent paleoEvent = paleoEventsList.get(i);
                eventNames.add(paleoEvent.getEventName());
            }
            this.updateLabels(eventSequence.getSequenceProb(), eventNames, eventSequence.getMissedEventsProbs(), eventSequence.getComments());
        } else {
            this.updateLabels(Double.NaN, null, null, null);
        }
    }

    private void updateLabels(double sequenceProb, ArrayList eventsInthisSequence, double[] missedEventProbs, String comments) {
        if (Double.isNaN(sequenceProb)) {
            this.sequenceProbLabel.setTextAsHTML((String)null);
        } else {
            this.sequenceProbLabel.setTextAsHTML(GUI_Utils.decimalFormat.format(sequenceProb));
        }
        ArrayList<CallSite> missedProbInfoList = null;
        if (eventsInthisSequence != null) {
            missedProbInfoList = new ArrayList<CallSite>();
            ArrayList names = AddEditSequence.getNamesForMissedEventProbs(eventsInthisSequence);
            for (int i = 0; i < names.size(); ++i) {
                missedProbInfoList.add((CallSite)((Object)(String.valueOf(names.get(i)) + ": " + GUI_Utils.decimalFormat.format(missedEventProbs[i]))));
            }
        }
        this.missedProbLabel.setTextAsHTML(missedProbInfoList);
        this.commentsLabel.setTextAsHTML(comments);
        this.eventsLabel.setTextAsHTML(eventsInthisSequence);
    }
}

