/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.vo;

import com.google.common.base.Preconditions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;

public class FaultSectionConnection {
    private int id1;
    private int id2;
    private Location loc1;
    private Location loc2;

    public FaultSectionConnection(int id1, int id2, Location loc1, Location loc2) {
        Preconditions.checkArgument((id1 != id2 ? 1 : 0) != 0, (Object)"IDs cannot be equal.");
        this.id1 = id1;
        this.id2 = id2;
        Preconditions.checkNotNull((Object)loc1, (Object)"Connection locations cannot be null");
        Preconditions.checkNotNull((Object)loc2, (Object)"Connection locations cannot be null");
        this.loc1 = loc1;
        this.loc2 = loc2;
    }

    public int getId1() {
        return this.id1;
    }

    public int getId2() {
        return this.id2;
    }

    public Location getLoc1() {
        return this.loc1;
    }

    public Location getLoc2() {
        return this.loc2;
    }

    public boolean involvesSection(int id) {
        return this.id1 == id || this.id2 == id;
    }

    public boolean involvesSectionAtLocation(int id, Location loc) {
        if (!this.involvesSection(id)) {
            return false;
        }
        Location locForID = this.getLocationForID(id);
        loc = new Location(loc.getLatitude(), loc.getLongitude(), locForID.getDepth());
        return loc.equals(locForID);
    }

    public Location getLocationForID(int id) {
        if (id == this.id1) {
            return this.loc1;
        }
        if (id == this.id2) {
            return this.loc2;
        }
        throw new IllegalArgumentException("The specified id (" + id + ") isn't part of this connection.");
    }

    public double calcDistance() {
        return LocationUtils.horzDistanceFast(this.loc1, this.loc2);
    }

    public String toString() {
        return "FaultSectionConnection [id1=" + this.id1 + ", id2=" + this.id2 + ", loc1=" + String.valueOf(this.loc1) + ", loc2=" + String.valueOf(this.loc2) + "]";
    }
}

