/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.data.ShortNamed;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.QuadSurface;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;

public class FaultSectionPrefData
implements FaultSection,
Serializable,
Cloneable,
ShortNamed {
    private static final long serialVersionUID = 1L;
    public static final String XML_METADATA_NAME = "FaultSectionPrefData";
    private int sectionId = -1;
    private String sectionName;
    private String shortName;
    private double aveLongTermSlipRate;
    private double slipRateStdDev;
    private double aveDip;
    private double aveRake;
    private double aveUpperDepth;
    private double aveLowerDepth;
    private boolean connector;
    private Region zonePolygon;
    private double aseismicSlipFactor = 0.0;
    private double couplingCoeff = 1.0;
    private FaultTrace faultTrace;
    private float dipDirection = Float.NaN;
    private String parentSectionName;
    private int parentSectionId = -1;
    private long dateOfLastEventMillis = Long.MIN_VALUE;
    private double slipInLastEvent = Double.NaN;
    private FaultSection.StirlingSurfaceCache stirlingCache;
    private FaultSection.QuadSurfaceCache quadCache;
    private boolean proxyFault = false;

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public void setFaultSectionPrefData(FaultSection faultSection) {
        this.sectionId = faultSection.getSectionId();
        this.sectionName = faultSection.getSectionName();
        this.parentSectionId = faultSection.getParentSectionId();
        this.parentSectionName = faultSection.getParentSectionName();
        this.shortName = faultSection instanceof ShortNamed ? ((ShortNamed)((Object)faultSection)).getShortName() : faultSection.getName();
        this.aveLongTermSlipRate = faultSection.getOrigAveSlipRate();
        this.slipRateStdDev = faultSection.getOrigSlipRateStdDev();
        this.aveDip = faultSection.getAveDip();
        this.aveRake = faultSection.getAveRake();
        this.aveUpperDepth = faultSection.getOrigAveUpperDepth();
        this.aveLowerDepth = faultSection.getAveLowerDepth();
        this.aseismicSlipFactor = faultSection.getAseismicSlipFactor();
        this.couplingCoeff = faultSection.getCouplingCoeff();
        this.faultTrace = faultSection.getFaultTrace();
        this.dipDirection = faultSection.getDipDirection();
        this.dateOfLastEventMillis = faultSection.getDateOfLastEvent();
        this.slipInLastEvent = faultSection.getSlipInLastEvent();
        this.connector = faultSection.isConnector();
        this.zonePolygon = faultSection.getZonePolygon();
        this.proxyFault = faultSection.isProxyFault();
    }

    public String toString() {
        Object str = new String();
        str = (String)str + "sectionId = " + this.getSectionId() + "\n";
        str = (String)str + "sectionName = " + this.getSectionName() + "\n";
        str = (String)str + "shortName = " + this.getShortName() + "\n";
        str = (String)str + "aveLongTermSlipRate = " + this.getOrigAveSlipRate() + "\n";
        str = (String)str + "slipRateStdDev = " + this.getOrigSlipRateStdDev() + "\n";
        str = (String)str + "aveDip = " + this.getAveDip() + "\n";
        str = (String)str + "aveRake = " + this.getAveRake() + "\n";
        str = (String)str + "aveUpperDepth = " + this.getOrigAveUpperDepth() + "\n";
        str = (String)str + "aveLowerDepth = " + this.getAveLowerDepth() + "\n";
        str = (String)str + "aseismicSlipFactor = " + this.getAseismicSlipFactor() + "\n";
        str = (String)str + "couplingCoeff = " + this.getCouplingCoeff() + "\n";
        str = (String)str + "dipDirection = " + this.getDipDirection() + "\n";
        str = (String)str + "dateOfLastEventMillis = " + this.getDateOfLastEvent() + "\n";
        str = (String)str + "slipInLastEvent = " + this.getSlipInLastEvent() + "\n";
        str = (String)str + "faultTrace:\n";
        for (int i = 0; i < this.getFaultTrace().size(); ++i) {
            Location loc = (Location)this.getFaultTrace().get(i);
            str = (String)str + "\t" + loc.getLatitude() + ", " + loc.getLongitude() + ", " + loc.getDepth() + "\n";
        }
        return str;
    }

    @Override
    public void setDateOfLastEvent(long dateOfLastEventMillis) {
        this.dateOfLastEventMillis = dateOfLastEventMillis;
    }

    @Override
    public long getDateOfLastEvent() {
        return this.dateOfLastEventMillis;
    }

    @Override
    public void setSlipInLastEvent(double slipInLastEvent) {
        this.slipInLastEvent = slipInLastEvent;
    }

    @Override
    public double getSlipInLastEvent() {
        return this.slipInLastEvent;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String getName() {
        return this.getSectionName();
    }

    @Override
    public double getAseismicSlipFactor() {
        return this.aseismicSlipFactor;
    }

    @Override
    public void setAseismicSlipFactor(double aseismicSlipFactor) {
        this.aseismicSlipFactor = aseismicSlipFactor;
    }

    @Override
    public void setCouplingCoeff(double couplingCoeff) {
        this.couplingCoeff = couplingCoeff;
    }

    @Override
    public double getCouplingCoeff() {
        return this.couplingCoeff;
    }

    @Override
    public double getAveDip() {
        return this.aveDip;
    }

    public void setAveDip(double aveDip) {
        this.aveDip = aveDip;
    }

    @Override
    public double getOrigAveSlipRate() {
        return this.aveLongTermSlipRate;
    }

    @Override
    public void setAveSlipRate(double aveLongTermSlipRate) {
        this.aveLongTermSlipRate = aveLongTermSlipRate;
    }

    @Override
    public double getAveLowerDepth() {
        return this.aveLowerDepth;
    }

    public void setAveLowerDepth(double aveLowerDepth) {
        this.aveLowerDepth = aveLowerDepth;
    }

    @Override
    public double getAveRake() {
        return this.aveRake;
    }

    @Override
    public void setAveRake(double aveRake) {
        this.aveRake = aveRake;
    }

    @Override
    public double getOrigAveUpperDepth() {
        return this.aveUpperDepth;
    }

    public void setAveUpperDepth(double aveUpperDepth) {
        this.aveUpperDepth = aveUpperDepth;
    }

    @Override
    public float getDipDirection() {
        return this.dipDirection;
    }

    public void setDipDirection(float dipDirection) {
        this.dipDirection = dipDirection;
    }

    @Override
    public FaultTrace getFaultTrace() {
        return this.faultTrace;
    }

    public void setFaultTrace(FaultTrace faultTrace) {
        this.faultTrace = faultTrace;
    }

    @Override
    public int getSectionId() {
        return this.sectionId;
    }

    @Override
    public void setSectionId(int sectionId) {
        this.sectionId = sectionId;
    }

    @Override
    public int getParentSectionId() {
        return this.parentSectionId;
    }

    @Override
    public void setParentSectionId(int parentSectionId) {
        this.parentSectionId = parentSectionId;
    }

    @Override
    public String getSectionName() {
        return this.sectionName;
    }

    @Override
    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    @Override
    public String getParentSectionName() {
        return this.parentSectionName;
    }

    @Override
    public void setParentSectionName(String parentSectionName) {
        this.parentSectionName = parentSectionName;
    }

    public ArrayList<FaultSectionPrefData> getSubSectionsList(double maxSubSectionLen) {
        return this.getSubSectionsList(maxSubSectionLen, 1000 * this.sectionId);
    }

    public ArrayList<FaultSectionPrefData> getSubSectionsList(double maxSubSectionLen, int startId) {
        return this.getSubSectionsList(maxSubSectionLen, startId, 1);
    }

    public ArrayList<FaultSectionPrefData> getSubSectionsList(double maxSubSectionLen, int startId, int minSubSections) {
        ArrayList<FaultTrace> equalLengthSubsTrace = FaultUtils.getEqualLengthSubsectionTraces(this.faultTrace, maxSubSectionLen, minSubSections);
        ArrayList<FaultSectionPrefData> subSectionList = new ArrayList<FaultSectionPrefData>();
        for (int i = 0; i < equalLengthSubsTrace.size(); ++i) {
            FaultSectionPrefData subSection = new FaultSectionPrefData();
            subSection.setFaultSectionPrefData(this);
            subSection.setFaultTrace(equalLengthSubsTrace.get(i));
            subSection.setSectionId(startId + i);
            subSection.setSectionName(this.sectionName + ", Subsection " + i);
            subSection.setParentSectionId(this.sectionId);
            subSection.setParentSectionName(this.sectionName);
            subSectionList.add(subSection);
        }
        return subSectionList;
    }

    @Override
    public double getOrigSlipRateStdDev() {
        return this.slipRateStdDev;
    }

    @Override
    public double getReducedSlipRateStdDev() {
        return this.slipRateStdDev * this.couplingCoeff;
    }

    @Override
    public void setSlipRateStdDev(double slipRateStdDev) {
        this.slipRateStdDev = slipRateStdDev;
    }

    @Override
    public boolean isConnector() {
        return this.connector;
    }

    public void setConnector(boolean connector) {
        this.connector = connector;
    }

    @Override
    public Region getZonePolygon() {
        return this.zonePolygon;
    }

    @Override
    public void setZonePolygon(Region zonePolygon) {
        this.zonePolygon = zonePolygon;
    }

    public SimpleFaultData getSimpleFaultDataOld(boolean aseisReducesArea) {
        if (!aseisReducesArea) {
            SimpleFaultData simpleFaultData = new SimpleFaultData(this.getAveDip(), this.getAveLowerDepth(), this.getOrigAveUpperDepth(), this.getFaultTrace(), this.getDipDirection());
            return simpleFaultData;
        }
        double depthToReduce = this.aseismicSlipFactor * (this.getAveLowerDepth() - this.getOrigAveUpperDepth());
        double lowerDepth = this.getAveLowerDepth() - depthToReduce / 2.0;
        double upperDepth = this.getOrigAveUpperDepth() + depthToReduce / 2.0;
        SimpleFaultData simpleFaultData = new SimpleFaultData(this.getAveDip(), lowerDepth, upperDepth, this.getFaultTrace());
        return simpleFaultData;
    }

    @Override
    public StirlingGriddedSurface getFaultSurface(double gridSpacing) {
        return this.getStirlingGriddedSurface(gridSpacing, true, true);
    }

    @Override
    public StirlingGriddedSurface getFaultSurface(double gridSpacing, boolean preserveGridSpacingExactly, boolean aseisReducesArea) {
        return this.getStirlingGriddedSurface(gridSpacing, preserveGridSpacingExactly, aseisReducesArea);
    }

    public synchronized StirlingGriddedSurface getStirlingGriddedSurface(double gridSpacing, boolean preserveGridSpacingExactly, boolean aseisReducesArea) {
        if (this.stirlingCache == null) {
            this.stirlingCache = new FaultSection.StirlingSurfaceCache(this);
        }
        return this.stirlingCache.getStirlingGriddedSurface(gridSpacing, preserveGridSpacingExactly, aseisReducesArea);
    }

    public StirlingGriddedSurface getStirlingGriddedSurface(double gridSpacing) {
        return this.getStirlingGriddedSurface(gridSpacing, true, true);
    }

    public QuadSurface getQuadSurface(boolean aseisReducesArea) {
        return this.getQuadSurface(aseisReducesArea, 1.0);
    }

    public synchronized QuadSurface getQuadSurface(boolean aseisReducesArea, double spacingForGridOperations) {
        if (this.quadCache == null) {
            this.quadCache = new FaultSection.QuadSurfaceCache(this);
        }
        return this.quadCache.getQuadSurface(aseisReducesArea, spacingForGridOperations);
    }

    @Override
    public Element toXMLMetadata(Element root) {
        return this.toXMLMetadata(root, XML_METADATA_NAME);
    }

    @Override
    public Element toXMLMetadata(Element root, String name) {
        Element el = root.addElement(name);
        el.addAttribute("sectionId", "" + this.getSectionId());
        el.addAttribute("sectionName", this.getSectionName());
        el.addAttribute("shortName", this.getShortName());
        el.addAttribute("aveLongTermSlipRate", "" + this.getOrigAveSlipRate());
        el.addAttribute("slipRateStdDev", "" + this.getOrigSlipRateStdDev());
        el.addAttribute("aveDip", "" + this.getAveDip());
        el.addAttribute("aveRake", "" + this.getAveRake());
        el.addAttribute("aveUpperDepth", "" + this.getOrigAveUpperDepth());
        el.addAttribute("aveLowerDepth", "" + this.getAveLowerDepth());
        el.addAttribute("aseismicSlipFactor", "" + this.getAseismicSlipFactor());
        el.addAttribute("couplingCoeff", "" + this.getCouplingCoeff());
        el.addAttribute("dipDirection", "" + this.getDipDirection());
        String parentSectionName = this.getParentSectionName();
        if (parentSectionName != null) {
            el.addAttribute("parentSectionName", parentSectionName);
        }
        el.addAttribute("parentSectionId", "" + this.getParentSectionId());
        el.addAttribute("connector", "" + this.isConnector());
        if (this.getZonePolygon() != null) {
            this.zonePolygon.toXMLMetadata(el, "ZonePolygon");
        }
        if (this.getDateOfLastEvent() > Long.MIN_VALUE) {
            el.addAttribute("dateOfLastEventMillis", "" + this.getDateOfLastEvent());
        }
        if (!Double.isNaN(this.getSlipInLastEvent())) {
            el.addAttribute("slipInLastEvent", "" + this.getSlipInLastEvent());
        }
        FaultTrace trace = this.getFaultTrace();
        Element traceEl = el.addElement("FaultTrace");
        traceEl.addAttribute("name", trace.getName());
        for (int j = 0; j < trace.getNumLocations(); ++j) {
            Location loc = (Location)trace.get(j);
            traceEl = loc.toXMLMetadata(traceEl);
        }
        el.addAttribute("class", FaultSectionPrefData.class.getCanonicalName());
        return root;
    }

    public static FaultSectionPrefData fromXMLMetadata(Element el) {
        Attribute lastSlipAtt;
        double slipRateStdDev;
        int sectionId = Integer.parseInt(el.attributeValue("sectionId"));
        String sectionName = el.attributeValue("sectionName");
        String shortName = el.attributeValue("shortName");
        double aveLongTermSlipRate = Double.parseDouble(el.attributeValue("aveLongTermSlipRate"));
        try {
            slipRateStdDev = Double.parseDouble(el.attributeValue("slipRateStdDev"));
        }
        catch (NullPointerException err) {
            slipRateStdDev = Double.NaN;
        }
        double aveDip = Double.parseDouble(el.attributeValue("aveDip"));
        double aveRake = Double.parseDouble(el.attributeValue("aveRake"));
        double aveUpperDepth = Double.parseDouble(el.attributeValue("aveUpperDepth"));
        double aveLowerDepth = Double.parseDouble(el.attributeValue("aveLowerDepth"));
        double aseismicSlipFactor = Double.parseDouble(el.attributeValue("aseismicSlipFactor"));
        float dipDirection = Float.parseFloat(el.attributeValue("dipDirection"));
        Attribute parentSectNameAtt = el.attribute("parentSectionName");
        String parentSectionName = parentSectNameAtt != null ? parentSectNameAtt.getStringValue() : null;
        Attribute parentSectIDAtt = el.attribute("parentSectionId");
        int parentSectionId = parentSectIDAtt != null ? Integer.parseInt(parentSectIDAtt.getStringValue()) : -1;
        Element traceEl = el.element("FaultTrace");
        String traceName = traceEl.attributeValue("name");
        FaultTrace trace = new FaultTrace(traceName);
        Iterator traceIt = traceEl.elementIterator();
        while (traceIt.hasNext()) {
            Element locEl = (Element)traceIt.next();
            trace.add(Location.fromXMLMetadata(locEl));
        }
        boolean connector = false;
        Attribute connectorAtt = el.attribute("connector");
        if (connectorAtt != null) {
            connector = Boolean.parseBoolean(connectorAtt.getStringValue());
        }
        Region zonePolygon = null;
        Element zonePolygonEl = el.element("ZonePolygon");
        if (zonePolygonEl != null) {
            zonePolygon = Region.fromXMLMetadata(zonePolygonEl);
        }
        FaultSectionPrefData data = new FaultSectionPrefData();
        data.setSectionId(sectionId);
        data.setSectionName(sectionName);
        data.setShortName(shortName);
        data.setAveSlipRate(aveLongTermSlipRate);
        data.setSlipRateStdDev(slipRateStdDev);
        data.setAveDip(aveDip);
        data.setAveRake(aveRake);
        data.setAveUpperDepth(aveUpperDepth);
        data.setAveLowerDepth(aveLowerDepth);
        data.setAseismicSlipFactor(aseismicSlipFactor);
        Attribute couplingAtt = el.attribute("couplingCoeff");
        if (couplingAtt != null) {
            data.setCouplingCoeff(Double.parseDouble(couplingAtt.getStringValue()));
        }
        data.setDipDirection(dipDirection);
        data.setFaultTrace(trace);
        data.setParentSectionName(parentSectionName);
        data.setParentSectionId(parentSectionId);
        data.setConnector(connector);
        data.setZonePolygon(zonePolygon);
        Attribute lastEventAtt = el.attribute("dateOfLastEventMillis");
        if (lastEventAtt != null) {
            data.setDateOfLastEvent(Long.parseLong(lastEventAtt.getStringValue()));
        }
        if ((lastSlipAtt = el.attribute("slipInLastEvent")) != null) {
            data.setSlipInLastEvent(Double.parseDouble(lastSlipAtt.getStringValue()));
        }
        return data;
    }

    @Override
    public FaultSectionPrefData clone() {
        FaultSectionPrefData section = new FaultSectionPrefData();
        section.setFaultSectionPrefData(this);
        return section;
    }

    public int hashCode() {
        return FaultSection.hashCode(this);
    }

    public boolean equals(Object obj) {
        return FaultSection.equals(this, obj);
    }

    @Override
    public boolean isProxyFault() {
        return this.proxyFault;
    }
}

