/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet;

import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensha.commons.data.Site;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.IM_EventSet.IMEventSetCalcAPI;
import org.opensha.sha.util.SiteTranslator;

public abstract class AbstractIMEventSetCalc
implements IMEventSetCalcAPI {
    public static Logger logger = Logger.getLogger("IMEventSetLog");
    public static final float MIN_SOURCE_DIST = 200.0f;
    private static final SiteTranslator siteTrans = new SiteTranslator();
    private ArrayList<Site> sites = null;
    private ArrayList<ParameterList> sitesData = null;

    public static void initLogger(Level level) {
        for (Logger parent = logger; parent != null; parent = parent.getParent()) {
            for (Handler handler : parent.getHandlers()) {
                handler.setLevel(level);
            }
            parent.setLevel(level);
        }
        assert (logger != null);
        logger.setLevel(level);
    }

    @Override
    public final ArrayList<Site> getSites() {
        if (this.sites == null) {
            logger.log(Level.FINE, "Generating site list");
            this.sites = new ArrayList();
            for (int i = 0; i < this.getNumSites(); ++i) {
                Site site = new Site(this.getSiteLocation(i));
                this.sites.add(site);
            }
        }
        return this.sites;
    }

    public static ArrayList<ParameterList> getSitesData(IMEventSetCalcAPI calc) {
        ArrayList<ParameterList> sitesData = new ArrayList<ParameterList>();
        ArrayList<Site> sites = calc.getSites();
        for (int i = 0; i < sites.size(); ++i) {
            ParameterList userSiteData = calc.getUserSiteData(i);
            if (userSiteData == null) {
                logger.log(Level.FINE, "No user site data for site " + i);
                continue;
            }
            sitesData.add(userSiteData);
        }
        return sitesData;
    }

    @Override
    public final ArrayList<ParameterList> getSitesData() {
        if (this.sitesData == null) {
            logger.log(Level.FINE, "Generating site data lists");
            this.sitesData = AbstractIMEventSetCalc.getSitesData(this);
        }
        return this.sitesData;
    }
}

