/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.opensha.commons.data.siteData.impl.WillsMap2000;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.calc.IM_EventSet.AbstractIMEventSetCalc;
import org.opensha.sha.calc.IM_EventSet.IMEventSetERFUtils;
import org.opensha.sha.calc.IM_EventSet.IM_EventSetOutputWriter;
import org.opensha.sha.calc.IM_EventSet.outputImpl.HAZ01Writer;
import org.opensha.sha.calc.IM_EventSet.outputImpl.OriginalModWriter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ERF_Ref;
import org.opensha.sha.earthquake.param.BackgroundRupParam;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.IncludeBackgroundParam;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF1.WGCEP_UCERF1_EqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;
import scratch.UCERF3.erf.mean.MeanUCERF3;

public class IMEventSetCalculatorCLT
extends AbstractIMEventSetCalc
implements ParameterChangeWarningListener {
    protected LocationList locList;
    protected ERF forecast;
    protected ArrayList<ScalarIMR> chosenAttenuationsList;
    protected ArrayList<String> supportedIMTs;
    protected String dirName = "MeanSigma";
    private File outputDir;
    private ArrayList<ParameterList> userDataVals;
    private static final Set<ERF_Ref> erfRefs = IMEventSetERFUtils.getSupportedERFs();
    private static final Map<String, ERF_Ref> erfNameMap = new HashMap<String, ERF_Ref>();
    private static final ArrayList<String> erfShortNames = new ArrayList();
    private static final ArrayList<String> erfLongNames = new ArrayList();
    private static final ArrayList<String> attenRelClasses = new ArrayList();
    private static final ArrayList<String> imNames = new ArrayList();

    public IMEventSetCalculatorCLT(String inpFile, String outDir) {
        String inputFileName = "MeanSigmaCalc_InputFile.txt";
        if (inpFile != null && !inpFile.isEmpty()) {
            inputFileName = inpFile;
        }
        if (outDir != null && !outDir.isEmpty()) {
            this.dirName = outDir;
            this.outputDir = new File(this.dirName);
        }
        try {
            this.parseLegacyInputFile(inputFileName);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Error parsing input file!", ex);
            System.exit(1);
        }
    }

    public IMEventSetCalculatorCLT(String erfName, String bgSeismicity, double rupOffset, ArrayList<String> attenRelNames, ArrayList<String> imtNames, String siteFile, String outDir) {
        this.getERF(erfName);
        this.toApplyBackGroud(bgSeismicity);
        this.setRupOffset(rupOffset);
        for (String attenRel : attenRelNames) {
            this.setIMR(attenRel);
        }
        for (String imt : imtNames) {
            this.setIMT(imt);
        }
        if (siteFile == null || siteFile.isEmpty()) {
            this.setSite("34.1 -118.1 760");
        } else {
            try {
                this.parseSitesInputCSV(siteFile);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Error parsing input file!", ex);
                System.exit(1);
            }
        }
        if (outDir != null && !outDir.isEmpty()) {
            this.dirName = outDir;
            this.outputDir = new File(this.dirName);
        }
    }

    private void parseSitesInputCSV(String siteFile) throws IOException {
        logger.log(Level.INFO, "Parsing sites input file: " + siteFile);
        ArrayList<String> fileLines = FileUtils.loadFile(siteFile);
        if (fileLines.isEmpty()) {
            throw new RuntimeException("Input file empty or doesn't exist! " + siteFile);
        }
        for (String fileLine : fileLines) {
            String line = fileLine.trim();
            if (line.startsWith("#") || line.isEmpty()) continue;
            this.setSite(line, ",");
        }
    }

    private void parseLegacyInputFile(String inputFileName) throws IOException {
        logger.log(Level.INFO, "Parsing input file: " + inputFileName);
        ArrayList<String> fileLines = FileUtils.loadFile(inputFileName);
        if (fileLines.isEmpty()) {
            throw new RuntimeException("Input file empty or doesn't exist! " + inputFileName);
        }
        int j = 0;
        int numIMRdone = 0;
        int numIMRs = 0;
        int numIMTdone = 0;
        int numIMTs = 0;
        int numSitesDone = 0;
        int numSites = 0;
        for (String fileLine : fileLines) {
            String line = fileLine.trim();
            if (line.startsWith("#") || line.isEmpty()) continue;
            if (j == 0) {
                this.getERF(line);
            }
            if (j == 1) {
                this.toApplyBackGroud(line.trim());
            }
            if (j == 2) {
                double rupOffset = Double.parseDouble(line.trim());
                this.setRupOffset(rupOffset);
            }
            if (j == 3) {
                numIMRs = Integer.parseInt(line.trim());
            }
            if (j == 4) {
                this.setIMR(line.trim());
                if (++numIMRdone != numIMRs) continue;
                ++j;
                continue;
            }
            if (j == 5) {
                numIMTs = Integer.parseInt(line.trim());
            }
            if (j == 6) {
                this.setIMT(line.trim());
                if (++numIMTdone != numIMTs) continue;
                ++j;
                continue;
            }
            if (j == 7) {
                numSites = Integer.parseInt(line.trim());
            }
            if (j == 8) {
                this.setSite(line.trim());
                if (++numSitesDone != numSites) continue;
                ++j;
                continue;
            }
            ++j;
        }
    }

    private void setSite(String line) {
        this.setSite(line, "\\s+");
    }

    private void setSite(String line, String delim) {
        String[] tokens;
        int tokenCount;
        if (this.locList == null) {
            this.locList = new LocationList();
        }
        if (this.userDataVals == null) {
            this.userDataVals = new ArrayList();
        }
        if ((tokenCount = (tokens = line.trim().split(delim)).length) > 3 || tokenCount < 2) {
            throw new RuntimeException("Must Enter valid Lat Lon in each line in the file");
        }
        double lat = Double.parseDouble(tokens[0].trim());
        double lon = Double.parseDouble(tokens[1].trim());
        Location loc = new Location(lat, lon);
        this.locList.add(loc);
        ParameterList dataVals = new ParameterList();
        String dataVal = null;
        if (tokenCount == 3) {
            dataVal = tokens[2].trim();
        }
        if (WillsMap2000.wills_vs30_map.containsKey(dataVal)) {
            dataVals.addParameter(new StringParameter("Wills Site Class", dataVal));
        } else if (dataVal != null) {
            try {
                Vs30_Param vs30 = new Vs30_Param();
                vs30.setValue(Double.parseDouble(dataVal));
                dataVals.addParameter(vs30);
                Vs30_TypeParam vs30Type = new Vs30_TypeParam();
                vs30Type.setValue("Measured");
                dataVals.addParameter(vs30Type);
            }
            catch (NumberFormatException e) {
                System.err.println("*** WARNING: Site Wills/Vs30 value unknown: " + dataVal);
            }
        }
        this.userDataVals.add(dataVals);
    }

    private void setIMT(String line) {
        if (this.supportedIMTs == null) {
            this.supportedIMTs = new ArrayList();
        }
        this.supportedIMTs.add(line.trim());
    }

    private void setIMR(String str) {
        if (this.chosenAttenuationsList == null) {
            this.chosenAttenuationsList = new ArrayList();
        }
        String imrName = str.trim();
        int index = imNames.indexOf(imrName);
        this.createIMRClassInstance(attenRelClasses.get(index));
    }

    protected void createIMRClassInstance(String AttenRelClassName) {
        try {
            Class<ParameterChangeWarningListener> listenerClass = ParameterChangeWarningListener.class;
            Object[] paramObjects = new Object[]{this};
            Class[] params = new Class[]{listenerClass};
            Class<?> imrClass = Class.forName(AttenRelClassName);
            Constructor<?> con = imrClass.getConstructor(params);
            AttenuationRelationship attenRel = (AttenuationRelationship)con.newInstance(paramObjects);
            if (attenRel.getName().equals("USGS Combined (2004)")) {
                throw new RuntimeException("Cannot use USGS Combined (2004) in calculation of Mean and Sigma");
            }
            attenRel.setParamDefaults();
            this.chosenAttenuationsList.add(attenRel);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    private void getERF(String line) {
        String erfName = line.trim();
        logger.log(Level.CONFIG, "Attempting to identify ERF from name: " + erfName);
        ERF_Ref erfRef = erfNameMap.get(erfName);
        if (erfName.equals(Frankel02_AdjustableEqkRupForecast.NAME) || erfName.equals(Frankel02_AdjustableEqkRupForecast.class.getSimpleName())) {
            this.createFrankel02Forecast();
        } else if (erfName.equals(WGCEP_UCERF1_EqkRupForecast.NAME) || erfName.equals(WGCEP_UCERF1_EqkRupForecast.class.getSimpleName())) {
            this.createUCERF1_Forecast();
        } else if (erfName.equals(MeanUCERF2.NAME) || erfName.equals(MeanUCERF2.class.getSimpleName())) {
            this.createMeanUCERF2_Forecast();
        } else if (erfName.startsWith("Mean UCERF3") || erfName.startsWith("UCERF3")) {
            this.createMeanUCERF3_Forecast(erfName);
        } else if (erfRef != null) {
            logger.log(Level.CONFIG, "Creating ERF dynamically with default parameters.");
            this.forecast = (ERF)erfRef.instance();
        } else {
            throw new RuntimeException("Unsupported ERF");
        }
        if (!(this.forecast instanceof MeanUCERF3)) {
            try {
                this.forecast.getTimeSpan().setDuration(1.0);
                logger.log(Level.FINE, "Set duration to 1.0 for ERF: " + erfName);
            }
            catch (ConstraintException e) {
                logger.log(Level.WARNING, "ERF " + erfName + " does not allow duration=1.0, using default duration: " + this.forecast.getTimeSpan().getDuration());
            }
        }
    }

    private void createFrankel02Forecast() {
        logger.log(Level.CONFIG, "Creating Frankel02 ERF");
        this.forecast = new Frankel02_AdjustableEqkRupForecast();
    }

    private void createUCERF1_Forecast() {
        logger.log(Level.CONFIG, "Creating UCERF1 ERF");
        this.forecast = new WGCEP_UCERF1_EqkRupForecast();
        this.forecast.getAdjustableParameterList().getParameter("Time Dependent").setValue(false);
    }

    private void createMeanUCERF2_Forecast() {
        logger.log(Level.CONFIG, "Creating UCERF2 ERF");
        this.forecast = new MeanUCERF2();
        this.forecast.getAdjustableParameterList().getParameter("Probability Model").setValue("Poisson");
    }

    private void createMeanUCERF3_Forecast(String name) {
        String args;
        MeanUCERF3.Presets preset;
        name = name.trim();
        logger.log(Level.CONFIG, "Creating MeanUCERF3 ERF");
        MeanUCERF3.show_progress = false;
        MeanUCERF3 forecast = new MeanUCERF3();
        if (name.startsWith("Mean UCERF3 FM3.1")) {
            preset = MeanUCERF3.Presets.FM3_1_BRANCH_AVG;
            args = name.substring("Mean UCERF3 FM3.1".length());
        } else if (name.startsWith("Mean UCERF3 FM3.2")) {
            preset = MeanUCERF3.Presets.FM3_2_BRANCH_AVG;
            args = name.substring("Mean UCERF3 FM3.2".length());
        } else {
            preset = MeanUCERF3.Presets.BOTH_FM_BRANCH_AVG;
            Preconditions.checkState((name.length() == "Mean UCERF3".length() ? 1 : 0) != 0, (Object)"Can't specify UCERF3-TD params for full model, must use individual Fault Model");
            args = "";
        }
        logger.log(Level.CONFIG, "MeanUCERF3 Preset: " + preset.name());
        forecast.setPreset(preset);
        if (!args.isEmpty()) {
            logger.log(Level.CONFIG, "Time dependent args: " + args);
            args = args.trim().replaceAll("\t", " ");
            while (args.contains("  ")) {
                args = args.replaceAll("  ", " ");
            }
            String[] split = args.split(" ");
            Preconditions.checkState((split.length == 1 || split.length == 2 ? 1 : 0) != 0, (Object)"UCERF3-TD arguments: <start-year> [<duration>]");
            int startYear = Integer.parseInt(split[0]);
            double duration = 1.0;
            if (split.length == 2) {
                duration = Double.parseDouble(split[1]);
            }
            logger.log(Level.CONFIG, "Start Year: " + startYear);
            logger.log(Level.CONFIG, "Duration: " + duration);
            forecast.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_PREF_BLEND);
            forecast.setParameter("Aleatory Mag-Area StdDev", 0.0);
            forecast.setParameter("Historic Open Interval", (double)startYear - 1875.0);
            forecast.getTimeSpan().setStartTime(startYear);
            forecast.getTimeSpan().setDuration(duration);
        } else {
            forecast.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
            forecast.getTimeSpan().setDuration(1.0);
        }
        this.forecast = forecast;
    }

    private void toApplyBackGroud(String toApply) {
        Parameter param;
        try {
            param = this.forecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_NAME);
            logger.log(Level.FINE, "Setting ERF background seismicity value: " + toApply);
            if (param instanceof StringParameter) {
                param.setValue(toApply);
            } else if (param instanceof IncludeBackgroundParam) {
                IncludeBackgroundOption val = IncludeBackgroundOption.valueOf(toApply.trim().toUpperCase());
                param.setValue(val);
            }
        }
        catch (ParameterException e) {
            logger.log(Level.WARNING, "ERF doesn't contain param '" + Frankel02_AdjustableEqkRupForecast.BACK_SEIS_NAME + "', ignoring setting.");
        }
        if (!(this.forecast instanceof MeanUCERF2) && this.forecast.getAdjustableParameterList().containsParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_NAME)) {
            param = this.forecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_NAME);
            if (param instanceof StringParameter) {
                param.setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_FINITE);
            } else if (param instanceof BackgroundRupParam) {
                param.setValue(BackgroundRupType.FINITE);
            }
        }
    }

    private void setRupOffset(double rupOffset) {
        if (this.forecast.getAdjustableParameterList().containsParameter("Rupture Offset")) {
            logger.log(Level.FINE, "Setting ERF rupture offset: " + rupOffset);
            this.forecast.getAdjustableParameterList().getParameter("Rupture Offset").setValue(rupOffset);
        } else {
            logger.log(Level.WARNING, "ERF doesn't contain param 'Rupture Offset', ignoring setting.");
        }
        this.forecast.updateForecast();
    }

    public void getMeanSigma() throws IOException {
        this.getMeanSigma(false);
    }

    public void getMeanSigma(boolean haz01) throws IOException {
        int numIMRs = this.chosenAttenuationsList.size();
        File file = new File(this.dirName);
        file.mkdirs();
        IM_EventSetOutputWriter writer = null;
        writer = haz01 ? new HAZ01Writer(this) : new OriginalModWriter(this);
        writer.writeFiles(this.forecast, this.chosenAttenuationsList, this.supportedIMTs);
    }

    @Override
    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        String S = " : parameterChangeWarning(): ";
        WarningParameter param = e.getWarningParameter();
        param.setValueIgnoreWarning(e.getNewValue());
    }

    private static void listERFs() {
        System.out.println("Available Earthquake Rupture Forecasts (ERFs):");
        System.out.println("==============================================");
        System.out.println();
        int maxShortNameLength = 0;
        for (String shortName : erfShortNames) {
            if (shortName.length() <= maxShortNameLength) continue;
            maxShortNameLength = shortName.length();
        }
        maxShortNameLength = Math.max(maxShortNameLength, 10);
        for (int i = 0; i < erfShortNames.size(); ++i) {
            String shortName;
            shortName = erfShortNames.get(i);
            String longName = erfLongNames.get(i);
            System.out.printf("%-" + maxShortNameLength + "s \u2013 %s%n", shortName, longName);
        }
        System.out.println();
        System.out.println("Usage: imcalc -e \"FULL_NAME\" ... or imcalc -e ShortName ...");
        System.out.println("Example: imcalc -e \"STEP Alaskan Pipeline ERF\" ...");
        System.out.println("Example: imcalc -e STEP_AlaskanPipeForecast ...");
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(null);
        String header = "\nIM Event Set Calculator - Compute Mean and Sigma for Attenuation Relationships and IMTs\n\n";
        String footer = "\nExample:\n  imcalc -e \"WGCEP (2007) UCERF2 - Single Branch\" \\\n         -b Exclude \\\n         -a \"Boore & Atkinson (2008)\",\"Chiou & Youngs (2008)\" \\\n         -m \"PGA,SA200,SA 1.0\" \\\n         -r 5 \\\n         -s sites.csv \\\n         -o results/\n\nLegacy-mode usage:\n  imcalc --legacy <legacy-input.txt> <output-dir>\n\nNote: Site data value (Vs30 or Wills Class) is optional in CSV file.\n      Use IMEventSetCalculatorGUI for more refined control of Site Parameters.\n      Legacy input file format is deprecated. Consider migrating to new-style options.\n";
        formatter.printHelp("imcalc [OPTIONS] [--] [<legacy-file> <output-dir>]", header, options, footer, true);
    }

    private static void printLegacyUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(null);
        String header = "\nIM Event Set Calculator - Legacy Mode\n\nUses fixed-format input file. See example input file for format details.\n\n";
        String footer = "\nLegacy-mode usage:\n  imcalc --legacy <legacy-input.txt> <output-dir>\n\nExample:\n  imcalc --legacy ExampleLegacyInputFileCLT.txt output/\n  imcalc --legacy --haz01 ExampleLegacyInputFileCLT.txt output/\n  imcalc --legacy -d ExampleLegacyInputFileCLT.txt output/\n\nNote: Legacy input file format is deprecated.\n      Consider migrating to new command-line options for better flexibility.\n      Use 'imcalc --help' (without --legacy) to see new-style options.\n";
        formatter.printHelp("imcalc --legacy [OPTIONS] <legacy-input.txt> <output-dir>", header, options, footer, true);
    }

    private static Level getLogLevel(CommandLine cmd) {
        if (cmd.hasOption("ddd")) {
            return Level.ALL;
        }
        if (cmd.hasOption("dd")) {
            return Level.FINE;
        }
        if (cmd.hasOption("d")) {
            return Level.CONFIG;
        }
        if (cmd.hasOption("q")) {
            return Level.OFF;
        }
        return Level.WARNING;
    }

    private static Options createFullOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt("help").desc("Show this help and exit. Use `--legacy --help` for legacy-style help").build());
        options.addOption(Option.builder().longOpt("list-erfs").desc("List available ERF short names and long names").build());
        options.addOption(Option.builder().longOpt("haz01").desc("Use HAZ01 output file format instead of default").build());
        options.addOption(Option.builder((String)"d").desc("Set logging level to CONFIG (verbose)").build());
        options.addOption(Option.builder((String)"dd").desc("Set logging level to FINE (very verbose)").build());
        options.addOption(Option.builder((String)"ddd").desc("Set logging level to ALL (debug)").build());
        options.addOption(Option.builder((String)"q").longOpt("quiet").desc("Set logging level to OFF (quiet)").build());
        options.addOption(Option.builder((String)"e").longOpt("erf").hasArg().argName("name").desc("Earthquake Rupture Forecast (ERF) - short code or full name in quotes").build());
        options.addOption(Option.builder((String)"b").longOpt("background-seismicity").hasArg().argName("type").desc("Include | Exclude | Only-Background").build());
        options.addOption(Option.builder((String)"r").longOpt("rupture-offset").hasArg().argName("km").desc("Rupture offset for floating ruptures (1-100 km; 5 km is generally best). Not applicable to UCERF3, but a value is still required.").build());
        OptionGroup attenRelGroup = new OptionGroup();
        attenRelGroup.addOption(Option.builder((String)"a").longOpt("atten-rels").hasArg().argName("IMR1,IMR2,...").desc("Comma-separated in quotation attenuation relations").build());
        attenRelGroup.addOption(Option.builder((String)"f").longOpt("atten-rels-file").hasArg().argName("file").desc("Newlines-separated IMR list (mutually exclusive with --atten-rels)").build());
        options.addOptionGroup(attenRelGroup);
        options.addOption(Option.builder((String)"m").longOpt("imts").hasArg().argName("IMT1,IMT2,...").desc("Comma-separated intensity-measure types").build());
        options.addOption(Option.builder((String)"s").longOpt("sites").hasArg().argName("csv-file").desc("CSV of Lat, Lon, [Vs30/Wills] (column optional)").build());
        options.addOption(Option.builder((String)"o").longOpt("output-dir").hasArg().argName("dir").desc("Where to write results (defaults to current dir)").build());
        options.addOption(Option.builder().longOpt("legacy").desc("Switch to legacy-file mode").build());
        return options;
    }

    private static Options createLegacyOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt("help").desc("Show legacy help and exit. Don't pass `--legacy` for new-style help.").build());
        options.addOption(Option.builder().longOpt("haz01").desc("Use HAZ01 output file format instead of default").build());
        options.addOption(Option.builder((String)"d").desc("Set logging level to CONFIG (verbose)").build());
        options.addOption(Option.builder((String)"dd").desc("Set logging level to FINE (very verbose)").build());
        options.addOption(Option.builder((String)"ddd").desc("Set logging level to ALL (debug)").build());
        options.addOption(Option.builder((String)"q").longOpt("quiet").desc("Set logging level to OFF (quiet)").build());
        return options;
    }

    private static IMEventSetCalculatorCLT processLegacyInput(CommandLine cmd, String[] remainingArgs) {
        String[] invalidOptions;
        Options options = IMEventSetCalculatorCLT.createLegacyOptions();
        if (cmd.hasOption("help")) {
            IMEventSetCalculatorCLT.printLegacyUsage(options);
            System.exit(0);
        }
        logger.log(Level.WARNING, "Using deprecated legacy input file format. Consider migrating to new command-line options.");
        logger.log(Level.WARNING, "See 'imcalc --help' for new-style usage.");
        for (String option : invalidOptions = new String[]{"erf", "background-seismicity", "atten-rels", "atten-rels-file", "imts", "sites", "output-dir"}) {
            if (!cmd.hasOption(option)) continue;
            System.err.println("Error: Option --" + option + " is not supported in legacy mode");
            System.err.println("Use a legacy input file or switch to new-style mode");
            System.exit(2);
        }
        if (remainingArgs.length != 2) {
            System.err.println("Error: Input file and output directory are required");
            System.err.println("Expected 2 positional arguments, found: " + remainingArgs.length);
            System.exit(2);
        }
        String inputFileName = remainingArgs[0];
        String outputDirName = remainingArgs[1];
        return new IMEventSetCalculatorCLT(inputFileName, outputDirName);
    }

    private static IMEventSetCalculatorCLT processNewStyleInput(CommandLine cmd) {
        ArrayList<String> attenRels;
        String[] requiredOptions;
        Options options = IMEventSetCalculatorCLT.createFullOptions();
        if (cmd.hasOption("help")) {
            IMEventSetCalculatorCLT.printUsage(options);
            System.exit(0);
        }
        if (cmd.hasOption("list-erfs")) {
            IMEventSetCalculatorCLT.listERFs();
            System.exit(0);
        }
        boolean hasAttenRels = cmd.hasOption("atten-rels");
        boolean hasAttenRelsFile = cmd.hasOption("atten-rels-file");
        if (!hasAttenRels && !hasAttenRelsFile) {
            System.err.println("Error: At least one of --atten-rels or --atten-rels-file must be specified");
            IMEventSetCalculatorCLT.printUsage(options);
            System.exit(2);
        }
        for (String option : requiredOptions = new String[]{"erf", "background-seismicity", "rupture-offset", "imts", "output-dir"}) {
            if (cmd.hasOption(option)) continue;
            System.err.println("Error: Required option --" + option + " is missing");
            IMEventSetCalculatorCLT.printUsage(options);
            System.exit(2);
        }
        String erfName = cmd.getOptionValue("erf");
        String bgSeis = cmd.getOptionValue("background-seismicity");
        double rupOffset = Double.parseDouble(cmd.getOptionValue("rupture-offset"));
        if (hasAttenRels) {
            attenRels = IMEventSetCalculatorCLT.parseQuotedString(cmd.getOptionValue("atten-rels"));
            System.out.println(attenRels);
        } else {
            try {
                attenRels = FileUtils.loadFile(cmd.getOptionValue("atten-rels-file"));
                attenRels.removeIf(s -> s.startsWith("#"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<String> imts = new ArrayList<String>(List.of(cmd.getOptionValue("imts").split(",")));
        String sites = null;
        if (cmd.hasOption("sites")) {
            sites = cmd.getOptionValue("sites");
        }
        String outputDirName = cmd.getOptionValue("output-dir");
        return new IMEventSetCalculatorCLT(erfName, bgSeis, rupOffset, attenRels, imts, sites, outputDirName);
    }

    private static ArrayList<String> parseQuotedString(String csvString) {
        String[] parts;
        ArrayList<String> values = new ArrayList<String>();
        if (csvString == null || csvString.trim().isEmpty()) {
            return values;
        }
        for (String part : parts = csvString.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")) {
            if ((part = part.trim()).startsWith("\"") && part.endsWith("\"")) {
                values.add(part.substring(1, part.length() - 1));
                continue;
            }
            values.add(part);
        }
        return values;
    }

    public static void main(String[] args) {
        Options options = IMEventSetCalculatorCLT.createFullOptions();
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args, true);
        }
        catch (ParseException e) {
            System.err.println("Error parsing command line: " + e.getMessage());
            IMEventSetCalculatorCLT.printUsage(options);
            System.exit(2);
        }
        boolean legacyMode = cmd.hasOption("legacy");
        String[] remainingArgs = cmd.getArgs();
        Level level = IMEventSetCalculatorCLT.getLogLevel(cmd);
        IMEventSetCalculatorCLT.initLogger(level);
        if (!legacyMode && remainingArgs.length > 0 && remainingArgs[0].toLowerCase().endsWith(".txt")) {
            legacyMode = true;
        }
        boolean haz01 = cmd.hasOption("haz01");
        IMEventSetCalculatorCLT calc = null;
        calc = legacyMode ? IMEventSetCalculatorCLT.processLegacyInput(cmd, remainingArgs) : IMEventSetCalculatorCLT.processNewStyleInput(cmd);
        try {
            calc.getMeanSigma(haz01);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    @Override
    public int getNumSites() {
        return this.locList.size();
    }

    @Override
    public File getOutputDir() {
        return this.outputDir;
    }

    @Override
    public Location getSiteLocation(int i) {
        return (Location)this.locList.get(i);
    }

    @Override
    public ParameterList getUserSiteData(int i) {
        return this.userDataVals.get(i);
    }

    static {
        for (ERF_Ref eRF_Ref : erfRefs) {
            String erfName = eRF_Ref.toString();
            String erfShortName = eRF_Ref.getERFClass().getSimpleName();
            erfNameMap.put(erfName, eRF_Ref);
            erfNameMap.put(erfShortName, eRF_Ref);
            erfShortNames.add(erfShortName);
            erfLongNames.add(erfName);
        }
        for (AttenRelRef attenRelRef : AttenRelRef.get(ServerPrefUtils.SERVER_PREFS)) {
            try {
                String name = attenRelRef.getName();
                String className = attenRelRef.getAttenRelClass().getName();
                imNames.add(name);
                attenRelClasses.add(className);
            }
            catch (Exception exception) {}
        }
    }
}

