/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.ListModel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.calc.IM_EventSet.IM_EventSetOutputWriter;
import org.opensha.sha.calc.IM_EventSet.gui.NamesListPanel;
import org.opensha.sha.gui.beans.IMT_NewGuiBean;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;

public class IMT_ChooserPanel
extends NamesListPanel
implements ParameterChangeListener {
    private final IMT_NewGuiBean imtGuiBean;
    private final ArrayList<Parameter<?>> imts;
    private boolean masterDisable = false;

    public IMT_ChooserPanel() {
        super("Selected IMT(s):");
        List<AttenuationRelationship> imrs = AttenRelRef.instanceList(null, true, ServerPrefUtils.SERVER_PREFS);
        for (ScalarIMR scalarIMR : imrs) {
            scalarIMR.setParamDefaults();
        }
        this.imtGuiBean = new IMT_NewGuiBean(imrs, true);
        this.imts = new ArrayList();
        this.setLowerPanel(this.imtGuiBean);
    }

    public void setForceDisableAddButton(boolean disable) {
        this.masterDisable = disable;
        this.addButton.setEnabled(this.shouldEnableAddButton());
    }

    protected void rebuildList() {
        String[] names = new String[this.imts.size()];
        for (int i = 0; i < this.imts.size(); ++i) {
            Parameter<?> imt = this.imts.get(i);
            names[i] = IM_EventSetOutputWriter.getRegularIMTString(imt) + " (HAZ01 code: " + IM_EventSetOutputWriter.getHAZ01IMTString(imt) + ")";
        }
        this.namesList.setListData(names);
    }

    @Override
    public void addButton_actionPerformed() {
        Parameter<Double> newIMT = this.imtGuiBean.getSelectedIM();
        Parameter clone = (Parameter)newIMT.clone();
        for (Parameter<?> param : newIMT.getIndependentParameterList()) {
            if (clone.containsIndependentParameter(param.getName())) continue;
            Parameter independentParamClone = (Parameter)param.clone();
            independentParamClone.addParameterChangeListener(this);
            clone.addIndependentParameter(independentParamClone);
        }
        clone.addParameterChangeListener(this);
        this.imts.add(clone);
        this.rebuildList();
    }

    @Override
    public void removeButton_actionPerformed() {
        ListModel model = this.namesList.getModel();
        String[] names = new String[model.getSize() - 1];
        int selected = this.namesList.getSelectedIndex();
        int cnt = 0;
        for (int i = 0; i < model.getSize(); ++i) {
            if (selected == i) {
                this.imts.remove(i);
                continue;
            }
            names[cnt] = (String)model.getElementAt(i);
            ++cnt;
        }
        this.namesList.setListData(names);
    }

    @Override
    public boolean shouldEnableAddButton() {
        if (this.masterDisable || !this.imtGuiBean.areIMTsAvailable()) {
            return false;
        }
        Parameter<Double> imt = this.imtGuiBean.getSelectedIM();
        for (Parameter<?> oldIMT : this.imts) {
            if (!imt.getName().equals(oldIMT.getName())) continue;
            if (imt.getName().equals("SA")) {
                double oldPeriod = (Double)oldIMT.getIndependentParameter("SA Period").getValue();
                double newPeriod = (Double)imt.getIndependentParameter("SA Period").getValue();
                if (newPeriod != oldPeriod) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public List<String> getIMTsRemoveFor(List<ScalarIMR> imrs) {
        ArrayList<String> toRemove = new ArrayList<String>();
        block0: for (int i = this.imts.size() - 1; i >= 0; --i) {
            Parameter<?> imt = this.imts.get(i);
            for (ScalarIMR imr : imrs) {
                if (imr.isIntensityMeasureSupported(imt)) continue;
                Object name = imt.getName();
                if (((String)name).equals("SA")) {
                    name = (String)name + "(" + String.valueOf(imt.getIndependentParameter("SA Period").getValue()) + ")";
                }
                toRemove.add((String)name);
                continue block0;
            }
        }
        Collections.reverse(toRemove);
        return toRemove;
    }

    public void setIMRs(ArrayList<ScalarIMR> imrs) {
        this.imtGuiBean.setIMRs(imrs);
        if (imrs == null || imrs.isEmpty()) {
            this.setForceDisableAddButton(true);
            return;
        }
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        block0: for (int i = this.imts.size() - 1; i >= 0; --i) {
            Parameter<?> imt = this.imts.get(i);
            for (ScalarIMR imr : imrs) {
                if (imr.isIntensityMeasureSupported(imt)) continue;
                toRemove.add(i);
                continue block0;
            }
        }
        if (!toRemove.isEmpty()) {
            Iterator iterator = toRemove.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.imts.remove(index);
            }
            this.rebuildList();
        }
        this.setForceDisableAddButton(imrs.isEmpty());
        this.imtGuiBean.getParameterList().getParameter("IMT").addParameterChangeListener(this);
        this.imtGuiBean.refreshParamEditor();
        this.imtGuiBean.invalidate();
        this.imtGuiBean.validate();
        this.validate();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 600);
        IMT_ChooserPanel choose = new IMT_ChooserPanel();
        frame.setContentPane(choose);
        frame.setVisible(true);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getNewValue().equals("SA")) {
            Parameter periodParam = this.imtGuiBean.getParameterList().getParameter("SA Period");
            periodParam.addParameterChangeListener(this);
        }
        this.addButton.setEnabled(this.shouldEnableAddButton());
    }

    public ArrayList<String> getIMTStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        for (Parameter<?> param : this.imts) {
            strings.add(IM_EventSetOutputWriter.getRegularIMTString(param));
        }
        return strings;
    }

    public void setIMTs(ArrayList<String> imts) {
        for (String imt : imts) {
            StringTokenizer tok = new StringTokenizer(imt.trim());
            String imtName = tok.nextToken();
            this.imtGuiBean.getParameterList();
            this.imtGuiBean.getParameterList().getParameter("IMT");
            this.imtGuiBean.getParameterList().getParameter("IMT").setValue(imtName);
            if (tok.hasMoreTokens()) {
                Double period = Double.parseDouble(tok.nextToken());
                this.imtGuiBean.getParameterList().getParameter("SA Period").setValue(period);
            }
            this.addButton_actionPerformed();
        }
    }
}

