/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.gui.beans.OrderedSiteDataGUIBean;
import org.opensha.commons.data.siteData.impl.WillsMap2000;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.IM_EventSet.gui.AddSitePanel;
import org.opensha.sha.imr.IntensityMeasureRelationship;
import org.opensha.sha.imr.ScalarIMR;

public class SitesPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    protected JList sitesList;
    protected JList siteDataList;
    protected JButton addSiteButton = new JButton("Add Site");
    protected JButton removeSiteButton = new JButton("Remove Site(s)");
    protected JButton editSiteButton = new JButton("Edit Site");
    private ArrayList<Location> locs;
    private ArrayList<ParameterList> siteDataParams;
    private ParameterList defaultSiteDataParams;
    private final OrderedSiteDataGUIBean siteDataGUIBean;

    public SitesPanel(OrderedSiteDataGUIBean siteDataGUIBean) {
        this.setLayout(new BoxLayout(this, 1));
        this.siteDataGUIBean = siteDataGUIBean;
        this.locs = new ArrayList();
        this.siteDataParams = new ArrayList();
        this.defaultSiteDataParams = new ParameterList();
        this.sitesList = new JList();
        this.sitesList.setSelectionMode(2);
        this.sitesList.setSelectedIndex(0);
        this.sitesList.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.sitesList);
        listScroller.setPreferredSize(new Dimension(250, 650));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)new JLabel("Sites"), "North");
        northPanel.add((Component)listScroller, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout(new BoxLayout(leftButtonPanel, 0));
        leftButtonPanel.add(this.addSiteButton);
        leftButtonPanel.add(this.removeSiteButton);
        buttonPanel.add((Component)leftButtonPanel, "West");
        buttonPanel.add((Component)this.editSiteButton, "East");
        this.removeSiteButton.setEnabled(false);
        this.addSiteButton.addActionListener(this);
        this.removeSiteButton.addActionListener(this);
        this.editSiteButton.addActionListener(this);
        northPanel.add((Component)buttonPanel, "South");
        this.siteDataList = new JList();
        this.siteDataList.setSelectionMode(2);
        this.siteDataList.setSelectedIndex(0);
        this.siteDataList.addListSelectionListener(this);
        JScrollPane dataListScroller = new JScrollPane(this.siteDataList);
        dataListScroller.setPreferredSize(new Dimension(250, 150));
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)new JLabel("Site Data Values"), "North");
        southPanel.add((Component)dataListScroller, "Center");
        JPanel dataButtonPanel = new JPanel();
        dataButtonPanel.setLayout(new BoxLayout(dataButtonPanel, 0));
        southPanel.add((Component)dataButtonPanel, "South");
        this.rebuildSiteList();
        this.add(northPanel);
        this.add(southPanel);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.sitesList)) {
            this.rebuildSiteDataList();
        }
    }

    private void checkEnableRemoveSite() {
        this.removeSiteButton.setEnabled(!this.sitesList.isSelectionEmpty());
    }

    private void checkEnableEditSite() {
        this.editSiteButton.setEnabled(!this.sitesList.isSelectionEmpty());
    }

    private void replaceSite(int index, Location loc, ParameterList params) {
        this.locs.set(index, loc);
        this.siteDataParams.set(index, params);
        this.rebuildSiteList();
    }

    protected void addSite(Location loc, ParameterList params) {
        this.locs.add(loc);
        this.siteDataParams.add(params);
        this.rebuildSiteList();
    }

    public void clear() {
        this.locs.clear();
        this.siteDataParams.clear();
        this.rebuildSiteList();
    }

    private void removeSite(int i) {
        this.locs.remove(i);
        this.siteDataParams.remove(i);
        this.rebuildSiteList();
    }

    private void removeSite(int[] indices) {
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            this.locs.remove(i);
            this.siteDataParams.remove(i);
        }
        this.rebuildSiteList();
    }

    private void rebuildSiteList() {
        String[] data = new String[this.locs.size()];
        for (int i = 0; i < this.locs.size(); ++i) {
            Location loc = this.locs.get(i);
            data[i] = i + 1 + ". " + loc.getLatitude() + ", " + loc.getLongitude();
        }
        this.sitesList.setListData(data);
        this.checkEnableRemoveSite();
        this.checkEnableEditSite();
        this.rebuildSiteDataList();
        this.validate();
    }

    private int getSingleSelectedIndex() {
        int[] selection = this.sitesList.getSelectedIndices();
        if (selection.length > 1) {
            return -1;
        }
        return selection[0];
    }

    public void rebuildSiteDataList() {
        if (this.sitesList.isSelectionEmpty()) {
            String[] data = new String[]{"(no site(s) selected)"};
            this.siteDataList.setListData(data);
            return;
        }
        int index = this.getSingleSelectedIndex();
        if (index < 0) {
            String[] data = new String[]{"(multiple selected)"};
            this.siteDataList.setListData(data);
            return;
        }
        ParameterList params = this.siteDataParams.get(index);
        String[] data = new String[params.size()];
        int i = 0;
        for (Parameter<?> param : params) {
            data[i] = SitesPanel.getDataListString(i++, param);
        }
        this.siteDataList.setListData(data);
        this.checkEnableRemoveSite();
        this.checkEnableEditSite();
    }

    public static String getDataListString(int index, Parameter<?> param) {
        return index + 1 + ". " + param.getName() + ": " + String.valueOf(param.getValue());
    }

    private int promptNewSite(AddSitePanel siteAdd, Location exception) {
        int selection = JOptionPane.showConfirmDialog(this, siteAdd, "Add Site", 2);
        if (selection == 0) {
            boolean allowDuplicateSite;
            Location loc = siteAdd.getSiteLocation();
            boolean bl = allowDuplicateSite = exception != null && exception.getLongitude() == loc.getLongitude() && exception.getLatitude() == loc.getLatitude();
            if (!allowDuplicateSite && this.locs.contains(loc)) {
                JOptionPane.showMessageDialog(this, "Site with coordinates (" + loc.getLatitude() + ", " + loc.getLongitude() + ") already exists", "Cannot add site", 0);
                return this.promptNewSite(siteAdd, exception);
            }
        }
        return selection;
    }

    private int promptNewSite(AddSitePanel siteAdd) {
        return this.promptNewSite(siteAdd, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int siteIndex;
        ParameterList params;
        AddSitePanel siteAdd;
        int selection;
        OrderedSiteDataProviderList providers = this.siteDataGUIBean.getProviderList();
        if (e.getSource().equals(this.addSiteButton)) {
            if (this.defaultSiteDataParams.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Must have at least 1 IMR selected to add sites", "Cannot add site", 0);
                return;
            }
            ParameterList params2 = (ParameterList)this.defaultSiteDataParams.clone();
            AddSitePanel siteAdd2 = new AddSitePanel(params2, providers);
            int selection2 = this.promptNewSite(siteAdd2);
            if (selection2 == 0) {
                Location loc = siteAdd2.getSiteLocation();
                System.out.println("Adding site: " + String.valueOf(loc) + " (" + params2.size() + " vals)");
                this.addSite(loc, params2);
                this.rebuildSiteDataList();
            }
        } else if (e.getSource().equals(this.removeSiteButton)) {
            int[] indices = this.sitesList.getSelectedIndices();
            this.removeSite(indices);
        } else if (e.getSource().equals(this.editSiteButton) && (selection = this.promptNewSite(siteAdd = new AddSitePanel(params = this.siteDataParams.get(siteIndex = this.sitesList.getSelectedIndex()), providers, this.locs.get(siteIndex)), this.locs.get(siteIndex))) == 0) {
            Location loc = siteAdd.getSiteLocation();
            System.out.println("Editing site: " + String.valueOf(loc) + " (" + params.size() + " vals)");
            this.replaceSite(siteIndex, loc, params);
            this.rebuildSiteDataList();
        }
    }

    private ParameterList updateSiteDataParams(List<ScalarIMR> imrs, ParameterList params) {
        ParameterList oldParams = (ParameterList)params.clone();
        ParameterList newParams = ParameterList.union((ParameterList[])imrs.stream().map(IntensityMeasureRelationship::getSiteParams).toArray(ParameterList[]::new));
        for (Parameter<?> oldParam : oldParams) {
            if (!newParams.containsParameter(oldParam)) continue;
            newParams.setValue(oldParam.getName(), oldParam.getValue());
        }
        return newParams;
    }

    private List<String> getSiteDataTypes() {
        ArrayList<String> supportedTypes = new ArrayList<String>();
        for (Parameter<?> param : this.defaultSiteDataParams) {
            supportedTypes.add(param.getName());
        }
        return supportedTypes;
    }

    public void updateSiteDataParams(List<ScalarIMR> imrs) {
        List<String> invalidatedSiteDataTypes = this.getSiteDataTypes();
        System.out.println(invalidatedSiteDataTypes);
        this.defaultSiteDataParams = this.updateSiteDataParams(imrs, this.defaultSiteDataParams);
        List<String> newSiteDataTypes = this.getSiteDataTypes();
        invalidatedSiteDataTypes.removeAll(newSiteDataTypes);
        ArrayList<ParameterList> newSiteDataParams = new ArrayList<ParameterList>();
        for (ParameterList params : this.siteDataParams) {
            newSiteDataParams.add(this.updateSiteDataParams(imrs, params));
        }
        this.siteDataParams = newSiteDataParams;
        if (!invalidatedSiteDataTypes.isEmpty()) {
            JOptionPane.showMessageDialog(this, "The following site data parameters were previously set and have been removed across all sites added so far.\nRemoved Site Data Types: " + String.join((CharSequence)",", invalidatedSiteDataTypes) + "\nSite data parameters are generated from the selected IMRs. To avoid this in the future, select all desired IMRs before adding sites.", "Site Data Parameter Removal", 1);
        }
        this.rebuildSiteDataList();
    }

    public ArrayList<Location> getLocs() {
        return this.locs;
    }

    public ArrayList<ParameterList> getSiteDataParams() {
        return this.siteDataParams;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 600);
        ArrayList params = new ArrayList();
        params.add(new WillsMap2000());
        OrderedSiteDataProviderList providers = new OrderedSiteDataProviderList(params);
        SitesPanel sites = new SitesPanel(new OrderedSiteDataGUIBean(providers));
        sites.addSite(new Location(34.0, -118.0), null);
        frame.setContentPane(sites);
        frame.setVisible(true);
    }
}

