/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.outputImpl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.calc.IM_EventSet.IMEventSetCalcAPI;
import org.opensha.sha.calc.IM_EventSet.IM_EventSetOutputWriter;
import org.opensha.sha.calc.IM_EventSet.outputImpl.HAZ01ASegment;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;

public class HAZ01Writer
extends IM_EventSetOutputWriter {
    public static final String NAME = "HAZ01 Format Writer";
    public static final String HAZ01A_FILE_NAME = "haz01a.txt";
    public static final String HAZ01B_FILE_NAME = "haz01b.txt";

    public HAZ01Writer(IMEventSetCalcAPI calc) {
        super(calc);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeFiles(ArrayList<ERF> erfs, ArrayList<ScalarIMR> attenRels, ArrayList<String> imts) throws IOException {
        void var15_25;
        void var14_17;
        logger.log(Level.INFO, "Writing HAZ01 files");
        String fileA = this.calc.getOutputDir().getAbsolutePath() + File.separator + HAZ01A_FILE_NAME;
        String fileB = this.calc.getOutputDir().getAbsolutePath() + File.separator + HAZ01B_FILE_NAME;
        logger.log(Level.FINE, "Opening HAZ01A file for writing: " + fileA);
        FileWriter fwA = new FileWriter(fileA);
        logger.log(Level.FINE, "Opening HAZ01B file for writing: " + fileB);
        FileWriter fwB = new FileWriter(fileB);
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz");
        logger.log(Level.FINEST, "Writing headers");
        fwA.write("ID,ERF,Source,Rupture,GMPE,Site,VS30,Dist,IMT,Median,LSDT,LSDE\n");
        fwB.write("ID,ERF,Source,Rupture,Rate,Mag,SourceName\n");
        int lineIDA = 0;
        int lineIDB = 0;
        Object imtstr = null;
        for (String string : imts) {
            imtstr = imtstr == null ? "" : (String)imtstr + ",";
            imtstr = (String)imtstr + string;
        }
        Object erfstr = null;
        for (ERF eRF : erfs) {
            erfstr = erfstr == null ? "" : (String)erfstr + ",";
            erfstr = (String)erfstr + eRF.getName();
        }
        Object var14_16 = null;
        for (ScalarIMR attenRel : attenRels) {
            void var14_20;
            if (var14_17 == null) {
                String string = "";
            } else {
                String string = (String)var14_17 + ",";
            }
            String string = (String)var14_20 + attenRel.getShortName();
        }
        logger.log(Level.FINE, "ERF(S): " + (String)erfstr);
        logger.log(Level.FINE, "IMR(S): " + (String)var14_17);
        logger.log(Level.FINE, "IMT(S): " + String.valueOf(imts));
        boolean bl = false;
        while (var15_25 < erfs.size()) {
            String erfName = "erf" + (int)(var15_25 + true);
            ERF erf = erfs.get((int)var15_25);
            logger.log(Level.INFO, "Updating forecast for ERF: " + erf.getName());
            erf.updateForecast();
            for (ScalarIMR attenRel : attenRels) {
                for (String imt : imts) {
                    fwA.flush();
                    lineIDA = this.writeHAZ01A_Part(fwA, lineIDA, imt, erfName, erf, attenRel);
                }
            }
            fwB.flush();
            lineIDB = this.writeHAZ01B_Part(fwB, lineIDB, erfName, erfs.get((int)var15_25));
            ++var15_25;
        }
        fwA.close();
        fwB.close();
        logger.log(Level.INFO, "Done writing HAZ01 files.");
    }

    private int writeHAZ01A_Part(FileWriter fw, int lineID, String imt, String erfName, ERF erf, ScalarIMR attenRel) throws IOException {
        logger.log(Level.INFO, "Writing HAZ01A portion for ERF: " + erf.getName() + ", IMR: " + attenRel.getShortName() + ", IMT: " + imt);
        HAZ01Writer.setIMTFromString(imt, attenRel);
        ArrayList<Parameter> defaultSiteParams = this.getDefaultSiteParams(attenRel);
        ArrayList<Site> sites = this.getInitializedSites(attenRel);
        StdDevTypeParam stdDevParam = null;
        boolean hasInterIntra = false;
        try {
            stdDevParam = (StdDevTypeParam)attenRel.getParameter("Std Dev Type");
            hasInterIntra = stdDevParam.isAllowed("Inter-Event") && stdDevParam.isAllowed("Intra-Event");
        }
        catch (ParameterException e) {
            logger.log(Level.INFO, "IMR " + attenRel.getShortName() + " missing Std Dev Type parameter.");
        }
        if (!hasInterIntra) {
            logger.log(Level.WARNING, "Selected IMR, " + attenRel.getShortName() + ", doesn't allow inter event Std Dev...all values will be set to -1");
        }
        int numSources = erf.getNumSources();
        String gmpe = attenRel.getShortName();
        for (int siteID = 0; siteID < sites.size(); ++siteID) {
            logger.log(Level.FINEST, "Writing portion for site: " + siteID);
            Site site = sites.get(siteID);
            attenRel.setSite(site);
            HAZ01ASegment haz01a = new HAZ01ASegment(erfName, siteID, gmpe, HAZ01Writer.getHAZ01IMTString(attenRel.getIntensityMeasure()));
            float vs30 = -1.0f;
            try {
                attenRel.getParameter("Vs30");
                vs30 = (float)((Double)site.getParameter("Vs30").getValue()).doubleValue();
            }
            catch (ParameterException e) {
                logger.log(Level.WARNING, "Selected IMR, " + attenRel.getShortName() + ", doesn't have Vs30...all values will be set to -1");
            }
            for (int sourceID = 0; sourceID < numSources; ++sourceID) {
                logger.log(Level.FINEST, "Writing portion for Source: " + sourceID);
                ProbEqkSource source = erf.getSource(sourceID);
                if (!this.shouldIncludeSource(source)) continue;
                for (int rupID = 0; rupID < source.getNumRuptures(); ++rupID) {
                    ++lineID;
                    ProbEqkRupture rup = source.getRupture(rupID);
                    attenRel.setEqkRupture(rup);
                    double rupDist = rup.getRuptureSurface().getDistanceRup(site.getLocation());
                    double mean = attenRel.getMean();
                    if (stdDevParam != null) {
                        if (stdDevParam.isAllowed("Total")) {
                            stdDevParam.setValue("Total");
                        } else if (stdDevParam.isAllowed("Total (Mag Dependent)")) {
                            stdDevParam.setValue("Total (Mag Dependent)");
                        }
                    }
                    double total = attenRel.getStdDev();
                    double inter = -1.0;
                    if (hasInterIntra) {
                        stdDevParam.setValue("Inter-Event");
                        inter = attenRel.getStdDev();
                    }
                    String line = haz01a.getLine(lineID, sourceID, rupID, vs30, rupDist, mean, total, inter);
                    fw.write(line + "\n");
                }
            }
        }
        logger.log(Level.INFO, "Done with portion");
        this.setSiteParams(attenRel, defaultSiteParams);
        return lineID;
    }

    private int writeHAZ01B_Part(FileWriter fw, int lineID, String erfName, ERF erf) throws IOException {
        logger.log(Level.INFO, "Writing HAZ01B for ERF: " + erf.getName());
        ArrayList<Site> sites = this.calc.getSites();
        erf.updateForecast();
        int numSources = erf.getNumSources();
        double duration = erf.getTimeSpan().getDuration();
        for (int sourceID = 0; sourceID < numSources; ++sourceID) {
            ProbEqkSource source = erf.getSource(sourceID);
            logger.log(Level.FINEST, "Writing portion for Source: " + sourceID);
            String sourceName = source.getName();
            sourceName = sourceName.replaceAll(",", "");
            if (!this.shouldIncludeSource(source)) continue;
            for (int rupID = 0; rupID < source.getNumRuptures(); ++rupID) {
                ProbEqkRupture rup = source.getRupture(rupID);
                double rate = rup.getMeanAnnualRate(duration);
                String line = ++lineID + "," + erfName + "," + sourceID + "," + rupID + "," + rateFormat.format(rate) + "," + (float)rup.getMag() + "," + sourceName;
                fw.write(line + "\n");
            }
        }
        return lineID;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

