/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.outputImpl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.opensha.commons.data.CSVWriter;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.calc.IM_EventSet.IMEventSetCalcAPI;
import org.opensha.sha.calc.IM_EventSet.IM_EventSetOutputWriter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;

public class OriginalModWriter
extends IM_EventSetOutputWriter {
    public static final String NAME = "OpenSHA Format Writer";
    File outputDir;

    public OriginalModWriter(IMEventSetCalcAPI calc) {
        super(calc);
    }

    @Override
    public void writeFiles(ArrayList<ERF> erfs, ArrayList<ScalarIMR> attenRels, ArrayList<String> imts) throws IOException {
        logger.log(Level.INFO, "Writing CSV format files");
        this.outputDir = null;
        boolean multipleERFs = erfs.size() != 1;
        for (int erfID = 0; erfID < erfs.size(); ++erfID) {
            ERF erf = erfs.get(erfID);
            this.outputDir = multipleERFs ? new File(this.calc.getOutputDir().getAbsolutePath() + File.separator + "erf" + erfID) : this.calc.getOutputDir();
            logger.log(Level.INFO, "Writing files to: " + this.outputDir.getAbsolutePath());
            this.writeOriginalSrcRupMetaFile(erf);
            this.writeOriginalRupDistFile(erf);
            for (ScalarIMR attenRel : attenRels) {
                for (String imt : imts) {
                    this.writeOriginalMeanSigmaFiles(erf, attenRel, imt);
                }
            }
        }
        logger.log(Level.INFO, "Done writing files.");
    }

    private void writeOriginalMeanSigmaFiles(ERF erf, ScalarIMR attenRel, String imt) throws IOException {
        OriginalModWriter.setIMTFromString(imt, attenRel);
        logger.log(Level.INFO, "Writing Mean/Sigma CSV file for " + attenRel.getShortName() + ", " + imt);
        ArrayList<Parameter> defaultSiteParams = this.getDefaultSiteParams(attenRel);
        ArrayList<Site> sites = this.getInitializedSites(attenRel);
        StdDevTypeParam stdDevParam = null;
        boolean hasInterIntra = false;
        try {
            stdDevParam = (StdDevTypeParam)attenRel.getParameter("Std Dev Type");
            hasInterIntra = stdDevParam.isAllowed("Inter-Event") && stdDevParam.isAllowed("Intra-Event");
        }
        catch (ParameterException e) {
            logger.log(Level.INFO, "IMR " + attenRel.getShortName() + " missing Std Dev Type parameter.");
        }
        Parameter im = attenRel.getIntensityMeasure();
        StringBuilder fname = new StringBuilder(attenRel.getShortName());
        StringTokenizer imtTok = new StringTokenizer(imt);
        if (imtTok.countTokens() > 1) {
            while (imtTok.hasMoreTokens()) {
                fname.append("_").append(imtTok.nextToken());
            }
            fname.append(".csv");
        } else {
            fname.append("_").append(imt).append(".csv");
        }
        File file = new File(this.outputDir.getAbsolutePath() + File.separator + String.valueOf(fname));
        try (CSVWriter csvWriter = new CSVWriter(new FileOutputStream(file), true);){
            ArrayList<String> header = new ArrayList<String>();
            header.add("SourceId");
            header.add("RuptureId");
            for (int i = 0; i < sites.size(); ++i) {
                int siteIndex = i + 1;
                header.add("Mean(" + siteIndex + ")");
                header.add("Total-Std-Dev.(" + siteIndex + ")");
                header.add("Inter-Event-Std-Dev.(" + siteIndex + ")");
            }
            csvWriter.write(header);
            erf.updateForecast();
            int numSources = erf.getNumSources();
            for (int sourceID = 0; sourceID < numSources; ++sourceID) {
                ProbEqkSource source = erf.getSource(sourceID);
                if (!this.shouldIncludeSource(source)) continue;
                for (int rupID = 0; rupID < source.getNumRuptures(); ++rupID) {
                    ProbEqkRupture rup = source.getRupture(rupID);
                    attenRel.setEqkRupture(rup);
                    ArrayList<String> row = new ArrayList<String>();
                    row.add(Integer.toString(sourceID));
                    row.add(Integer.toString(rupID));
                    for (Site site : sites) {
                        attenRel.setSite(site);
                        double mean = attenRel.getMean();
                        if (stdDevParam != null) {
                            stdDevParam.setValue("Total");
                        }
                        double total = attenRel.getStdDev();
                        double inter = -1.0;
                        if (hasInterIntra) {
                            stdDevParam.setValue("Inter-Event");
                            inter = attenRel.getStdDev();
                        }
                        row.add(meanSigmaFormat.format(mean));
                        row.add(meanSigmaFormat.format(total));
                        row.add(meanSigmaFormat.format(inter));
                    }
                    csvWriter.write(row);
                }
            }
        }
        logger.log(Level.INFO, "Done writing " + String.valueOf(fname));
        this.setSiteParams(attenRel, defaultSiteParams);
    }

    private void writeOriginalRupDistFile(ERF erf) throws IOException {
        logger.log(Level.INFO, "Writing rupture distance files");
        String fname = "rup_dist_info.csv";
        String fname_jb = "rup_dist_jb_info.csv";
        File file = new File(this.outputDir.getAbsolutePath() + File.separator + fname);
        File file_jb = new File(this.outputDir.getAbsolutePath() + File.separator + fname_jb);
        try (CSVWriter csvWriter = new CSVWriter(new FileOutputStream(file), true);
             CSVWriter csvWriterJB = new CSVWriter(new FileOutputStream(file_jb), true);){
            ArrayList<Site> sites = this.calc.getSites();
            ArrayList<String> header = new ArrayList<String>();
            header.add("SourceId");
            header.add("RuptureId");
            for (int i = 0; i < sites.size(); ++i) {
                int siteIndex = i + 1;
                header.add("RupDist(" + siteIndex + ")");
            }
            csvWriter.write(header);
            csvWriterJB.write(header);
            erf.updateForecast();
            int numSources = erf.getNumSources();
            for (int sourceID = 0; sourceID < numSources; ++sourceID) {
                ProbEqkSource source = erf.getSource(sourceID);
                if (!this.shouldIncludeSource(source)) continue;
                for (int rupID = 0; rupID < source.getNumRuptures(); ++rupID) {
                    ProbEqkRupture rup = source.getRupture(rupID);
                    ArrayList<String> row = new ArrayList<String>();
                    ArrayList<String> rowJB = new ArrayList<String>();
                    row.add(Integer.toString(sourceID));
                    row.add(Integer.toString(rupID));
                    rowJB.add(Integer.toString(sourceID));
                    rowJB.add(Integer.toString(rupID));
                    for (Site site : sites) {
                        double rupDist = rup.getRuptureSurface().getDistanceRup(site.getLocation());
                        double distJB = rup.getRuptureSurface().getDistanceJB(site.getLocation());
                        row.add(distFormat.format(rupDist));
                        rowJB.add(distFormat.format(distJB));
                    }
                    csvWriter.write(row);
                    csvWriterJB.write(rowJB);
                }
            }
        }
        logger.log(Level.INFO, "Done writing " + fname);
        logger.log(Level.INFO, "Done writing " + fname_jb);
    }

    private void writeOriginalSrcRupMetaFile(ERF erf) throws IOException {
        logger.log(Level.INFO, "Writing source/rupture metadata file");
        String fname = "src_rup_metadata.csv";
        File file = new File(this.outputDir.getAbsolutePath() + File.separator + fname);
        try (CSVWriter csvWriter = new CSVWriter(new FileOutputStream(file), true);){
            List<String> header = Arrays.asList("SourceId", "RuptureId", "annualizedRate", "Mag", "Src-Name");
            csvWriter.write(header);
            erf.updateForecast();
            int numSources = erf.getNumSources();
            double duration = erf.getTimeSpan().getDuration();
            for (int sourceID = 0; sourceID < numSources; ++sourceID) {
                ProbEqkSource source = erf.getSource(sourceID);
                if (!this.shouldIncludeSource(source)) continue;
                for (int rupID = 0; rupID < source.getNumRuptures(); ++rupID) {
                    ProbEqkRupture rup = source.getRupture(rupID);
                    double rate = rup.getMeanAnnualRate(duration);
                    List<String> row = Arrays.asList(Integer.toString(sourceID), Integer.toString(rupID), rateFormat.format(rate), Float.toString((float)rup.getMag()), source.getName());
                    csvWriter.write(row);
                }
            }
        }
        logger.log(Level.INFO, "Done writing " + fname);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

