/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.disaggregation;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.sha.earthquake.ProbEqkSource;

public class DisaggregationSourceRuptureInfo {
    private String name;
    private double rate;
    private int id;
    private ProbEqkSource source;
    private DiscretizedFunc exceedProbs;

    public DisaggregationSourceRuptureInfo(String name, double rate, int id, ProbEqkSource source) {
        this(name, rate, id, source, null);
    }

    public DisaggregationSourceRuptureInfo(String name, double rate, int id, ProbEqkSource source, DiscretizedFunc exceedProbs) {
        this.name = name;
        this.rate = rate;
        this.id = id;
        this.source = source;
        this.exceedProbs = exceedProbs;
    }

    public int getId() {
        return this.id;
    }

    public double getRate() {
        return this.rate;
    }

    public String getName() {
        return this.name;
    }

    public ProbEqkSource getSource() {
        return this.source;
    }

    public DiscretizedFunc getExceedProbs() {
        return this.exceedProbs;
    }

    public DisaggregationSourceRuptureInfo getScaled(double scalar, double duration) {
        DiscretizedFunc exceedProbs = this.exceedProbs;
        if (exceedProbs != null) {
            exceedProbs = exceedProbs.deepClone();
            for (int i = 0; i < exceedProbs.size(); ++i) {
                double origProb = exceedProbs.getY(i);
                double origRate = -Math.log(1.0 - origProb) / duration;
                double modRate = origRate * scalar;
                double modProb = 1.0 - Math.exp(-modRate * duration);
                exceedProbs.set(i, modProb);
            }
        }
        return new DisaggregationSourceRuptureInfo(this.name, this.rate * scalar, this.id, this.source, exceedProbs);
    }

    public static DisaggregationSourceRuptureInfo consolidate(Collection<DisaggregationSourceRuptureInfo> contribs, int consolidatedIndex, String consolidatedName) {
        int i;
        XY_DataSet nonExceeds = null;
        double rate = 0.0;
        for (DisaggregationSourceRuptureInfo contrib : contribs) {
            DiscretizedFunc exceeds = contrib.getExceedProbs();
            if (exceeds != null) {
                if (nonExceeds == null) {
                    Preconditions.checkState((rate == 0.0 ? 1 : 0) != 0, (Object)"Some but not all source/rup infos have exceedance probs");
                    double[] xVals = new double[exceeds.size()];
                    double[] yVals = new double[exceeds.size()];
                    for (int i2 = 0; i2 < xVals.length; ++i2) {
                        xVals[i2] = exceeds.getX(i2);
                        yVals[i2] = 1.0;
                    }
                    nonExceeds = new LightFixedXFunc(xVals, yVals);
                } else {
                    Preconditions.checkState((nonExceeds.size() == exceeds.size() ? 1 : 0) != 0, (Object)"Some source/rup infos have different exceedenace function sizes");
                }
                for (i = 0; i < exceeds.size(); ++i) {
                    Preconditions.checkState(((float)exceeds.getX(i) == (float)nonExceeds.getX(i) ? 1 : 0) != 0, (Object)"Some source/rup infos have different x-values");
                    nonExceeds.set(i, nonExceeds.getY(i) * (1.0 - exceeds.getY(i)));
                }
            }
            rate += contrib.getRate();
        }
        LightFixedXFunc exceedProps = null;
        if (nonExceeds != null) {
            double[] xVals = new double[nonExceeds.size()];
            double[] yVals = new double[nonExceeds.size()];
            for (i = 0; i < xVals.length; ++i) {
                xVals[i] = nonExceeds.getX(i);
                yVals[i] = 1.0 - nonExceeds.getY(i);
            }
            exceedProps = new LightFixedXFunc(xVals, yVals);
        }
        return new DisaggregationSourceRuptureInfo(consolidatedName, rate, consolidatedIndex, null, exceedProps);
    }
}

