/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.disaggregation.chart3d;

import java.awt.Color;
import org.jfree.chart3d.axis.CategoryAxis3D;
import org.jfree.chart3d.axis.ValueAxis3D;
import org.jfree.chart3d.data.KeyedValues3DItemKey;
import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.data.category.CategoryDataset3D;
import org.jfree.chart3d.graphics3d.Dimension3D;
import org.jfree.chart3d.graphics3d.Face;
import org.jfree.chart3d.graphics3d.Object3D;
import org.jfree.chart3d.graphics3d.Point3D;
import org.jfree.chart3d.graphics3d.World;
import org.jfree.chart3d.graphics3d.internal.TaggedFace;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.plot.CategoryPlot3D;
import org.jfree.chart3d.renderer.category.CategoryColorSource;
import org.jfree.chart3d.renderer.category.StackedBarRenderer3D;

class DisaggBarRenderer3D
extends StackedBarRenderer3D {
    protected void composeItem(double value, double barBase, CategoryDataset3D dataset, int series, int row, int column, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        Comparable seriesKey = dataset.getSeriesKey(series);
        Comparable rowKey = dataset.getRowKey(row);
        Comparable columnKey = dataset.getColumnKey(column);
        double vlow = Math.min(barBase, value);
        double vhigh = Math.max(barBase, value);
        CategoryPlot3D plot = this.getPlot();
        CategoryAxis3D rowAxis = plot.getRowAxis();
        CategoryAxis3D columnAxis = plot.getColumnAxis();
        ValueAxis3D valueAxis = plot.getValueAxis();
        Range range = valueAxis.getRange();
        if (!range.intersects(vlow, vhigh)) {
            return;
        }
        double vbase = range.peggedValue(vlow);
        double vtop = range.peggedValue(vhigh);
        boolean inverted = barBase > value;
        double rowValue = rowAxis.getCategoryValue(rowKey);
        double columnValue = columnAxis.getCategoryValue(columnKey);
        double width = dimensions.getWidth();
        double height = dimensions.getHeight();
        double depth = dimensions.getDepth();
        double xx = columnAxis.translateToWorld(columnValue, width) + xOffset;
        double yy = valueAxis.translateToWorld(vtop, height) + yOffset;
        double zz = rowAxis.translateToWorld(rowValue, depth) + zOffset;
        double xw = this.getBarXWidth() * columnAxis.getCategoryWidth();
        double zw = this.getBarZWidth() * rowAxis.getCategoryWidth();
        double xxw = columnAxis.translateToWorld(xw, width);
        double xzw = rowAxis.translateToWorld(zw, depth);
        double basew = valueAxis.translateToWorld(vbase, height) + yOffset;
        Color color = this.getColorSource().getColor(series, row, column);
        Color baseColor = null;
        CategoryColorSource baseColorSource = this.getBaseColorSource();
        if (baseColorSource != null && !range.contains(this.getBase())) {
            baseColor = baseColorSource.getColor(series, row, column);
        }
        if (baseColor == null) {
            baseColor = color;
        }
        Color topColor = null;
        CategoryColorSource topColorSource = this.getTopColorSource();
        if (topColorSource != null && !range.contains(value)) {
            topColor = topColorSource.getColor(series, row, column);
        }
        if (topColor == null) {
            topColor = color;
        }
        double customZ = (double)column * 100000.0 + (double)row * 10000.0 + (double)series * 1000.0;
        Object3D bar = DisaggBarRenderer3D.createBar(xxw, xzw, xx, yy, zz, basew, color, baseColor, topColor, inverted, customZ);
        KeyedValues3DItemKey itemKey = new KeyedValues3DItemKey(seriesKey, rowKey, columnKey);
        bar.setProperty("key", (Object)itemKey);
        world.add(bar);
        this.drawItemLabels(world, dataset, itemKey, xx, yy, zz, basew, inverted);
    }

    public static Object3D createBar(double xWidth, double zWidth, double x, double y, double z, double zero, Color barColor, Color baseColor, Color topColor, boolean inverted, double customZ) {
        Args.nullNotPermitted((Object)barColor, (String)"barColor");
        Color c0 = baseColor;
        Color c1 = topColor;
        if (inverted) {
            Color cc = c1;
            c1 = c0;
            c0 = cc;
        }
        Object3D bar = new Object3D(barColor);
        if (c0 != null) {
            bar.setProperty("color/c0", (Object)c0);
        }
        if (c1 != null) {
            bar.setProperty("color/c1", (Object)c1);
        }
        double xdelta = xWidth / 2.0;
        double zdelta = zWidth / 2.0;
        bar.addVertex(new Point3D(x - xdelta, zero, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, zero, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, zero, z + zdelta));
        bar.addVertex(new Point3D(x - xdelta, zero, z + zdelta));
        bar.addVertex(new Point3D(x - xdelta, y, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, y, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, y, z + zdelta));
        bar.addVertex(new Point3D(x - xdelta, y, z + zdelta));
        bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{0, 1, 5, 4}, customZ));
        bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{4, 5, 1, 0}, customZ));
        bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{1, 2, 6, 5}, customZ));
        bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{5, 6, 2, 1}, customZ));
        bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{2, 3, 7, 6}, customZ));
        bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{6, 7, 3, 2}, customZ));
        bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{0, 4, 7, 3}, customZ));
        bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{3, 7, 4, 0}, customZ));
        bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{4, 5, 6, 7}, customZ));
        bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{3, 2, 1, 0}, customZ));
        if (c1 != null) {
            bar.addFace((Face)new ZSortOverrideTaggedFace(bar, new int[]{7, 6, 5, 4}, "c1", customZ));
        } else {
            bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{7, 6, 5, 4}, customZ));
        }
        if (c0 != null) {
            bar.addFace((Face)new ZSortOverrideTaggedFace(bar, new int[]{0, 1, 2, 3}, "c0", customZ));
        } else {
            bar.addFace((Face)new ZSortOverrideFace(bar, new int[]{0, 1, 2, 3}, customZ));
        }
        return bar;
    }

    private static class ZSortOverrideFace
    extends Face {
        private double zOverride;
        private int[] vertices;

        public ZSortOverrideFace(Object3D owner, int[] vertices, double zOverride) {
            super(owner, vertices);
            this.vertices = vertices;
            this.zOverride = zOverride;
        }

        public float calculateAverageZValue(Point3D[] points) {
            float total = 0.0f;
            int offset = this.getOffset();
            for (int i = 0; i < this.vertices.length; ++i) {
                total += (float)points[this.vertices[i] + offset].z;
            }
            return (float)this.zOverride + total / (float)this.getVertexCount();
        }
    }

    private static class ZSortOverrideTaggedFace
    extends TaggedFace {
        private int[] vertices;
        private double zOverride;

        public ZSortOverrideTaggedFace(Object3D owner, int[] vertices, String tag, double zOverride) {
            super(owner, vertices, tag);
            this.vertices = vertices;
            this.zOverride = zOverride;
        }

        public float calculateAverageZValue(Point3D[] points) {
            float total = 0.0f;
            int offset = this.getOffset();
            for (int i = 0; i < this.vertices.length; ++i) {
                total += (float)points[this.vertices[i] + offset].z;
            }
            return (float)this.zOverride + total / (float)this.getVertexCount();
        }
    }
}

