/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.dom4j.Document;
import org.opensha.commons.data.Site;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.calc.hazardMap.HazardCurveSetCalculator;
import org.opensha.sha.calc.hazardMap.ThreadedHazardCurveSetCalculator;
import org.opensha.sha.calc.hazardMap.components.CalculationInputsXMLFile;

public class HazardCurveDriver {
    private HazardCurveSetCalculator[] calcs;
    private List<Site> sites;

    public HazardCurveDriver(Document doc, int threads) throws InvocationTargetException, IOException {
        this(CalculationInputsXMLFile.loadXML(doc, threads, true), threads);
    }

    private static CalculationInputsXMLFile[] toArray(CalculationInputsXMLFile inputs) {
        CalculationInputsXMLFile[] array = new CalculationInputsXMLFile[]{inputs};
        return array;
    }

    public HazardCurveDriver(CalculationInputsXMLFile inputs) throws InvocationTargetException, IOException {
        this(HazardCurveDriver.toArray(inputs), 1);
    }

    public HazardCurveDriver(CalculationInputsXMLFile[] inputs, int threads) throws InvocationTargetException, IOException {
        Preconditions.checkArgument((inputs.length == threads ? 1 : 0) != 0, (Object)"incompatible number of threads/inputs");
        this.calcs = new HazardCurveSetCalculator[threads];
        for (int i = 0; i < inputs.length; ++i) {
            this.calcs[i] = new HazardCurveSetCalculator(inputs[i]);
        }
        this.sites = inputs[0].getSites();
    }

    public void startCalculation() throws IOException, InterruptedException {
        if (this.calcs.length > 1) {
            ThreadedHazardCurveSetCalculator calc = new ThreadedHazardCurveSetCalculator(this.calcs);
            calc.calculateCurves(this.sites);
        } else {
            this.calcs[0].calculateCurves(this.sites, null);
        }
        this.calcs[0].close();
    }

    public static void main(String[] args) {
        System.out.println(HazardCurveDriver.class.getName() + ": starting up");
        try {
            String filePath;
            if (args.length != 1 && args.length != 2) {
                System.err.println("USAGE: HazardCurveDriver [--threaded] <XML File>");
                System.exit(2);
            }
            int threads = 1;
            if (args.length == 2) {
                Preconditions.checkArgument((boolean)args[0].equals("--threaded"), (Object)("Unknown argument: " + args[0]));
                threads = Runtime.getRuntime().availableProcessors();
                filePath = args[1];
            } else {
                filePath = args[0];
            }
            File xmlFile = new File(filePath);
            if (!xmlFile.exists()) {
                throw new IOException("XML Input file '" + filePath + "' not found!");
            }
            Document doc = XMLUtils.loadDocument(xmlFile.getAbsolutePath());
            HazardCurveDriver driver = new HazardCurveDriver(doc, threads);
            driver.startCalculation();
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

