/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.calc.hazardMap.components.CalculationInputsXMLFile;
import org.opensha.sha.calc.hazardMap.components.CalculationSettings;
import org.opensha.sha.calc.hazardMap.components.CurveMetadata;
import org.opensha.sha.calc.hazardMap.components.CurveResultsArchiver;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;

public class HazardCurveSetCalculator {
    private static final boolean D = false;
    private ERF erf;
    private List<Map<TectonicRegionType, ScalarIMR>> imrMaps;
    private List<Parameter<Double>> imts;
    private CurveResultsArchiver archiver;
    private CalculationSettings calcSettings;
    private HazardCurveCalculator calc;

    public HazardCurveSetCalculator(ERF erf, List<Map<TectonicRegionType, ScalarIMR>> imrMaps, CurveResultsArchiver archiver, CalculationSettings calcSettings) {
        this(erf, imrMaps, null, archiver, calcSettings);
    }

    public HazardCurveSetCalculator(CalculationInputsXMLFile inputs) {
        this(inputs.getERF(), inputs.getIMRMaps(), inputs.getIMTs(), inputs.getArchiver(), inputs.getCalcSettings());
    }

    public HazardCurveSetCalculator(ERF erf, List<Map<TectonicRegionType, ScalarIMR>> imrMaps, List<Parameter<Double>> imts, CurveResultsArchiver archiver, CalculationSettings calcSettings) {
        this.erf = erf;
        this.imrMaps = imrMaps;
        this.imts = imts;
        this.archiver = archiver;
        this.calcSettings = calcSettings;
        if (imts != null && imts.size() != imrMaps.size()) {
            throw new IllegalArgumentException("If IMTs are specified for each IMR map, there must me exactly one for every IMR map.");
        }
        this.calc = new HazardCurveCalculator();
        this.calc.setMaxSourceDistance(calcSettings.getMaxSourceDistance());
        erf.updateForecast();
    }

    public void calculateCurves(List<Site> sites, List<Integer> siteIndexes) throws IOException {
        if (siteIndexes == null) {
            siteIndexes = Lists.newArrayList();
            for (int i = 0; i < sites.size(); ++i) {
                siteIndexes.add(i);
            }
        }
        Preconditions.checkState((siteIndexes.size() == sites.size() ? 1 : 0) != 0);
        int siteCount = 0;
        for (int i = 0; i < sites.size(); ++i) {
            int index = (Integer)siteIndexes.get(i);
            Site site = sites.get(i);
            if (++siteCount % 10 == 0) {
                System.gc();
            }
            this.calculateCurves(site, index);
        }
    }

    public void calculateCurves(Site site, int index) throws IOException {
        int imrMapCount = 0;
        for (Map<TectonicRegionType, ScalarIMR> imrMap : this.imrMaps) {
            CurveMetadata meta;
            if (this.imts != null) {
                Parameter<Double> newIMT = this.imts.get(imrMapCount);
                for (TectonicRegionType trt : imrMap.keySet()) {
                    ScalarIMR imr = imrMap.get(trt);
                    imr.setIntensityMeasure(newIMT.getName());
                    Parameter imt = imr.getIntensityMeasure();
                    for (Parameter<?> depParam : newIMT.getIndependentParameterList()) {
                        imt.getIndependentParameter(depParam.getName()).setValue(depParam.getValue());
                    }
                }
            }
            ++imrMapCount;
            Parameter imtParam = TRTUtils.getFirstIMR(imrMap).getIntensityMeasure();
            String imt = imtParam.getName();
            Object imtMeta = imtParam.getName();
            if (imtParam instanceof SA_Param) {
                imtMeta = (String)imtMeta + " (Period: " + SA_Param.getPeriodInSA_Param(imtParam) + " sec)";
            }
            if (this.archiver.isCurveCalculated(meta = new CurveMetadata(site, index, imrMap, "imrs" + imrMapCount), this.calcSettings.getXValues(imt))) continue;
            boolean logSpace = this.calcSettings.isCalcInLogSpace();
            DiscretizedFunc calcFunction = logSpace ? HazardCurveSetCalculator.getLogFunction(this.calcSettings.getXValues(imt)) : this.calcSettings.getXValues(imt).deepClone();
            long curveStart = System.currentTimeMillis();
            try {
                this.calc.getHazardCurve(calcFunction, site, imrMap, this.erf);
            }
            catch (Exception e) {
                System.err.println("Error calculating hazard curve. Metadata below.");
                System.err.println("Site: " + String.valueOf(site));
                System.err.println("ERF: " + this.erf.getName());
                for (TectonicRegionType type : imrMap.keySet()) {
                    System.err.println(type.name() + " => IMR: " + imrMap.get(type).getName());
                }
                System.err.println("Function: " + String.valueOf(calcFunction));
                ExceptionUtils.throwAsRuntimeException(e);
            }
            long curveEnd = System.currentTimeMillis();
            float curveSecs = (float)(curveEnd - curveStart) / 1000.0f;
            DiscretizedFunc hazardCurve = logSpace ? HazardCurveSetCalculator.unLogFunction(this.calcSettings.getXValues(imt), calcFunction) : calcFunction;
            this.archiver.archiveCurve(hazardCurve, meta);
        }
    }

    public static ArbitrarilyDiscretizedFunc getLogFunction(DiscretizedFunc arb) {
        ArbitrarilyDiscretizedFunc new_func = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < arb.size(); ++i) {
            new_func.set(Math.log(arb.getX(i)), 1.0);
        }
        return new_func;
    }

    public static ArbitrarilyDiscretizedFunc unLogFunction(DiscretizedFunc oldHazFunc, DiscretizedFunc logHazFunction) {
        int numPoints = oldHazFunc.size();
        ArbitrarilyDiscretizedFunc hazFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < numPoints; ++i) {
            hazFunc.set(oldHazFunc.getX(i), logHazFunction.getY(i));
        }
        return hazFunc;
    }

    public void close() {
        this.archiver.close();
    }
}

