/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.params.filters;

import com.google.common.base.Preconditions;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.Site;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.calc.params.filters.TectonicRegionDistCutoffParam;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.EqkSource;
import org.opensha.sha.util.TectonicRegionType;

public class TectonicRegionDistCutoffFilter
implements SourceFilter,
ParameterChangeListener {
    private TectonicRegionDistCutoffParam param = new TectonicRegionDistCutoffParam();
    private TectonicRegionDistanceCutoffs cutoffs = (TectonicRegionDistanceCutoffs)this.param.getValue();
    private ParameterList params;

    public TectonicRegionDistCutoffFilter() {
        this.param.addParameterChangeListener(this);
        this.params = new ParameterList();
        this.params.addParameter(this.param);
    }

    public TectonicRegionDistanceCutoffs getCutoffs() {
        return this.cutoffs;
    }

    @Override
    public boolean canSkipSource(EqkSource source, Site site, double sourceSiteDistance) {
        TectonicRegionType trt = source.getTectonicRegionType();
        double maxDist = this.cutoffs.getCutoffDist(trt);
        return sourceSiteDistance > maxDist;
    }

    @Override
    public boolean canSkipRupture(EqkRupture rup, Site site) {
        return false;
    }

    @Override
    public ParameterList getAdjustableParams() {
        return this.params;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.cutoffs = (TectonicRegionDistanceCutoffs)this.param.getValue();
    }

    public String toString() {
        return "TRT=[Active:" + (float)this.cutoffs.getCutoffDist(TectonicRegionType.ACTIVE_SHALLOW) + ", Stable:" + (float)this.cutoffs.getCutoffDist(TectonicRegionType.STABLE_SHALLOW) + ", Interface:" + (float)this.cutoffs.getCutoffDist(TectonicRegionType.SUBDUCTION_INTERFACE) + ", Slab:" + (float)this.cutoffs.getCutoffDist(TectonicRegionType.SUBDUCTION_SLAB) + ", Volcanic:" + (float)this.cutoffs.getCutoffDist(TectonicRegionType.VOLCANIC) + "]";
    }

    public static class TectonicRegionDistanceCutoffs {
        private TectonicRegionType[] trts = TectonicRegionType.values();
        private double[] cutoffDists = new double[this.trts.length];

        public TectonicRegionDistanceCutoffs() {
            for (int i = 0; i < this.trts.length; ++i) {
                this.cutoffDists[i] = this.trts[i].defaultCutoffDist();
            }
        }

        public double getCutoffDist(TectonicRegionType trt) {
            Preconditions.checkNotNull((Object)trt, (Object)"Tectonic region type must be non-null");
            return this.cutoffDists[trt.ordinal()];
        }

        public void setCutoffDist(TectonicRegionType trt, double dist) {
            Preconditions.checkNotNull((Object)trt, (Object)"Tectonic region type must be non-null");
            Preconditions.checkState((dist > 0.0 ? 1 : 0) != 0, (String)"Distance must be >0: %s", (Object)dist);
            for (int i = 0; i < this.trts.length; ++i) {
                if (trt != this.trts[i]) continue;
                this.cutoffDists[i] = dist;
                return;
            }
            throw new IllegalStateException("TRT not found? " + String.valueOf(trt));
        }

        public double getLargestCutoffDist() {
            return StatUtils.max((double[])this.cutoffDists);
        }
    }
}

