/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.params.filters;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.editor.impl.NumericTextField;
import org.opensha.sha.calc.params.filters.TectonicRegionDistCutoffFilter;
import org.opensha.sha.calc.params.filters.TectonicRegionDistCutoffParam;
import org.opensha.sha.util.TectonicRegionType;

class TectonicRegionDistCutoffParamEditor
extends AbstractParameterEditor<TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs>
implements FocusListener,
KeyListener {
    private static final boolean D = false;
    private static TectonicRegionType[] trts = TectonicRegionType.values();
    static final DecimalFormat oDF = new DecimalFormat("0.##");
    static final int DIST_COLS = 7;
    private JPanel panel;
    private NumericTextField[] fields;

    public TectonicRegionDistCutoffParamEditor(Parameter<TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs> param) {
        super(param);
    }

    @Override
    public boolean isParameterSupported(Parameter<TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs> param) {
        return param != null && param.getValue() instanceof TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.fields != null) {
            this.panel.setEnabled(enabled);
            for (NumericTextField field : this.fields) {
                field.setEnabled(enabled);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.panel != null && this.panel.isEnabled();
    }

    @Override
    protected JComponent buildWidget() {
        TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs cutoffs = (TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs)this.getParameter().getValue();
        Preconditions.checkNotNull((Object)cutoffs, (Object)"Cutoffs are null in the parameter");
        int rows = trts.length;
        this.fields = new NumericTextField[rows];
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (int i = 0; i < rows; ++i) {
            String text = trts[i].toString();
            double val = cutoffs.getCutoffDist(trts[i]);
            JLabel label = new JLabel(text);
            this.fields[i] = new NumericTextField(text, 7, oDF);
            this.fields[i].setText(oDF.format(val));
            this.fields[i].addFocusListener(this);
            this.fields[i].addKeyListener(this);
            JPanel subPanel = new JPanel();
            subPanel.setLayout(new BorderLayout());
            label.setPreferredSize(new Dimension(100, 18));
            this.fields[i].setPreferredSize(new Dimension(30, 18));
            subPanel.add((Component)label, "Center");
            subPanel.add((Component)this.fields[i], "East");
            panel.add(subPanel);
        }
        panel.setPreferredSize(new Dimension(130, 18 * rows));
        panel.setMinimumSize(new Dimension(130, 18 * rows));
        this.panel = panel;
        return panel;
    }

    @Override
    protected JComponent updateWidget() {
        TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs cutoffs = (TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs)this.getParameter().getValue();
        Preconditions.checkNotNull((Object)cutoffs, (Object)"Cutoffs are null in the parameter");
        Preconditions.checkNotNull((Object)this.panel, (Object)"Can't update, not yet built");
        for (int i = 0; i < this.fields.length; ++i) {
            double val = i < trts.length ? cutoffs.getCutoffDist(trts[i]) : cutoffs.getCutoffDist(null);
            this.fields[i].setText(oDF.format(val));
            this.fields[i].invalidate();
        }
        return this.panel;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (e.getComponent() != this.fields[i]) continue;
            this.updateForIndex(i);
            break;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            for (int i = 0; i < this.fields.length; ++i) {
                if (e.getComponent() != this.fields[i]) continue;
                this.updateForIndex(i);
                break;
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void updateForIndex(int index) {
        double val;
        TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs cutoffs = (TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs)this.getParameter().getValue();
        Preconditions.checkNotNull((Object)cutoffs, (Object)"Cutoffs are null in the parameter");
        NumericTextField field = this.fields[index];
        boolean reset = false;
        try {
            val = field.getDoubleValue();
            if (val <= 0.0) {
                JOptionPane.showMessageDialog(this.panel, "Bad distance: " + val, "Error Parsing Distance", 0);
                reset = true;
            } else {
                cutoffs.setCutoffDist(trts[index], val);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.panel, "Error parsing text: " + e.getMessage(), "Error Parsing Distance", 0);
            reset = true;
        }
        if (reset) {
            val = cutoffs.getCutoffDist(trts[index]);
            field.setValue(val);
            field.invalidate();
        }
    }

    public static void main(String[] args) {
        TectonicRegionDistCutoffParam param = new TectonicRegionDistCutoffParam();
        TectonicRegionDistCutoffParamEditor editor = new TectonicRegionDistCutoffParamEditor(param);
        JFrame frame = new JFrame();
        frame.setContentPane(editor.buildWidget());
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        frame.validate();
    }
}

