/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.Region;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.TimeSpanChangeListener;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EpistemicListERF;
import org.opensha.sha.util.TectonicRegionType;

public abstract class AbstractEpistemicListERF
implements EpistemicListERF,
TimeSpanChangeListener,
ParameterChangeListener,
XMLSaveable {
    private static final long serialVersionUID = 1L;
    public static final String XML_METADATA_NAME = "ERF_Epistemic";
    protected ArrayList<ERF> erf_List = new ArrayList();
    private ArrayList<Double> relativeWeight = new ArrayList();
    protected boolean parameterChangeFlag = true;
    protected ParameterList adjustableParams = new ParameterList();
    protected TimeSpan timeSpan;

    protected void addERF(AbstractERF eqkRupForecast, double relWeight) {
        this.erf_List.add(eqkRupForecast);
        this.relativeWeight.add(relWeight);
    }

    @Override
    public int getNumERFs() {
        return this.erf_List.size();
    }

    @Override
    public ERF getERF(int index) {
        ERF eqkRupForecast = this.erf_List.get(index);
        eqkRupForecast.setTimeSpan(this.timeSpan);
        return eqkRupForecast;
    }

    @Override
    public double getERF_RelativeWeight(int index) {
        return this.relativeWeight.get(index);
    }

    @Override
    public ArrayList<Double> getRelativeWeightsList() {
        return this.relativeWeight;
    }

    public ListIterator<Parameter<?>> getAdjustableParamsIterator() {
        return this.adjustableParams.getParametersIterator();
    }

    @Override
    public String getName() {
        return "List of Earthquake Rupture Forecasts";
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            int num = this.erf_List.size();
            for (int i = 0; i < num; ++i) {
                this.getERF(i).updateForecast();
            }
        }
        this.parameterChangeFlag = false;
    }

    @Override
    public Region getApplicableRegion() {
        return null;
    }

    @Override
    public void setTimeSpan(TimeSpan time) {
        this.timeSpan = time;
    }

    @Override
    public ParameterList getAdjustableParameterList() {
        return this.adjustableParams;
    }

    @Override
    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    @Override
    public void timeSpanChange(EventObject event) {
        this.parameterChangeFlag = true;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    public void setParameterChangeFlag(boolean flag) {
        this.parameterChangeFlag = flag;
    }

    public String updateAndSaveForecast() {
        throw new UnsupportedOperationException("updateAndSaveForecast() not supported");
    }

    public Parameter getParameter(String paramName) {
        return this.adjustableParams.getParameter(paramName);
    }

    @Override
    public void setParameter(String name, Object value) {
        AbstractERF.setParameter(this, name, value);
    }

    @Override
    public ArrayList<TectonicRegionType> getIncludedTectonicRegionTypes() {
        ArrayList<TectonicRegionType> list = new ArrayList<TectonicRegionType>();
        list.add(TectonicRegionType.ACTIVE_SHALLOW);
        return list;
    }

    @Override
    public int compareTo(BaseERF o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    @Override
    public Element toXMLMetadata(Element root) {
        return this.toXMLMetadata(root, -1);
    }

    public Element toXMLMetadata(Element root, int index) {
        Element el = root.addElement(XML_METADATA_NAME);
        AbstractERF.baseERF_ToXML(this, el);
        if (index >= 0) {
            el.addAttribute("index", "" + index);
        }
        return root;
    }

    public static BaseERF fromXMLMetadata(Element el) throws InvocationTargetException {
        BaseERF erf = AbstractERF.baseERF_FromXML(el);
        Attribute indexAtt = el.attribute("index");
        if (indexAtt != null) {
            int index = Integer.parseInt(indexAtt.getValue());
            return ((EpistemicListERF)erf).getERF(index);
        }
        return erf;
    }
}

