/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.sha.calc.disaggregation.DisaggregationSourceRuptureInfo;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.CustomCacheWrappedSurface;
import org.opensha.sha.util.TectonicRegionType;

public class DistCachedERFWrapper
extends AbstractERF {
    private static final long serialVersionUID = 1L;
    private AbstractERF erf;
    private List<ProbEqkSource> sources = null;

    public DistCachedERFWrapper(AbstractERF erf) {
        this.erf = erf;
    }

    @Override
    public int getNumSources() {
        return this.erf.getNumSources();
    }

    public AbstractERF getOriginalERF() {
        return this.erf;
    }

    private void initSources() {
        ArrayList<ProbEqkSource> sources = new ArrayList<ProbEqkSource>();
        HashMap<RuptureSurface, CustomCacheWrappedSurface> wrappedMap = new HashMap<RuptureSurface, CustomCacheWrappedSurface>();
        for (ProbEqkSource source : this.erf) {
            if (source instanceof FaultRuptureSource) {
                RuptureSurface sourceSurf = DistCachedERFWrapper.getWrappedSurface(wrappedMap, source.getSourceSurface());
                ArrayList<ProbEqkRupture> rups = new ArrayList<ProbEqkRupture>();
                for (ProbEqkRupture origRup : source) {
                    RuptureSurface rupSurf = DistCachedERFWrapper.getWrappedSurface(wrappedMap, origRup.getRuptureSurface());
                    rups.add(new DistCacheWrapperRupture(origRup, rupSurf));
                }
                sources.add(new CustomSource(source, sourceSurf, rups));
                continue;
            }
            boolean cacheEnabled = true;
            RuptureSurface sourceSurf = null;
            try {
                sourceSurf = source.getSourceSurface();
                cacheEnabled = sourceSurf == null || sourceSurf instanceof CacheEnabledSurface;
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int rupID = 0; cacheEnabled && rupID < source.getNumRuptures(); ++rupID) {
                cacheEnabled = cacheEnabled && source.getRupture(rupID).getRuptureSurface() instanceof CacheEnabledSurface;
            }
            if (cacheEnabled) {
                ArrayList<ProbEqkRupture> rups = new ArrayList<ProbEqkRupture>();
                for (ProbEqkRupture origRup : source) {
                    RuptureSurface rupSurf = DistCachedERFWrapper.getWrappedSurface(wrappedMap, origRup.getRuptureSurface());
                    rups.add(new DistCacheWrapperRupture(origRup, rupSurf));
                }
                sources.add(new CustomSource(source, sourceSurf, rups));
                continue;
            }
            sources.add(null);
        }
        this.sources = sources;
    }

    public static RuptureSurface getWrappedSurface(Map<RuptureSurface, CustomCacheWrappedSurface> wrappedMap, RuptureSurface origSurf) {
        RuptureSurface wrappedSurf;
        if (wrappedMap.containsKey(origSurf)) {
            return wrappedMap.get(origSurf);
        }
        if (origSurf instanceof CompoundSurface) {
            ArrayList<RuptureSurface> subSurfs = new ArrayList<RuptureSurface>();
            for (RuptureSurface ruptureSurface : ((CompoundSurface)origSurf).getSurfaceList()) {
                if (wrappedMap.containsKey(ruptureSurface)) {
                    subSurfs.add(wrappedMap.get(ruptureSurface));
                    continue;
                }
                if (ruptureSurface instanceof CacheEnabledSurface) {
                    CustomCacheWrappedSurface cachedSubSurf = new CustomCacheWrappedSurface((CacheEnabledSurface)ruptureSurface);
                    subSurfs.add(cachedSubSurf);
                    wrappedMap.put(ruptureSurface, cachedSubSurf);
                    continue;
                }
                subSurfs.add(ruptureSurface);
            }
            wrappedSurf = new CustomCacheWrappedSurface(new CompoundSurface(subSurfs));
            wrappedMap.put(origSurf, (CustomCacheWrappedSurface)wrappedSurf);
        } else if (origSurf instanceof CacheEnabledSurface) {
            wrappedSurf = new CustomCacheWrappedSurface((CacheEnabledSurface)origSurf);
            wrappedMap.put(origSurf, (CustomCacheWrappedSurface)wrappedSurf);
        } else {
            wrappedSurf = origSurf;
        }
        return wrappedSurf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProbEqkSource getSource(int idx) {
        ProbEqkSource source;
        if (this.sources == null) {
            DistCachedERFWrapper distCachedERFWrapper = this;
            synchronized (distCachedERFWrapper) {
                if (this.sources == null) {
                    this.initSources();
                }
            }
        }
        if ((source = this.sources.get(idx)) == null) {
            source = this.erf.getSource(idx);
        }
        return source;
    }

    @Override
    public void updateForecast() {
        this.sources = null;
        this.erf.updateForecast();
    }

    @Override
    public String getName() {
        return this.erf.getName();
    }

    @Override
    public UnaryOperator<List<DisaggregationSourceRuptureInfo>> getDisaggSourceConsolidator() {
        return this.erf.getDisaggSourceConsolidator();
    }

    public static class DistCacheWrapperRupture
    extends ProbEqkRupture {
        private ProbEqkRupture origRup;

        public DistCacheWrapperRupture(ProbEqkRupture origRup, RuptureSurface wrappedSurf) {
            super(origRup.getMag(), origRup.getAveRake(), origRup.getProbability(), wrappedSurf, origRup.getHypocenterLocation());
            this.origRup = origRup;
        }

        public ProbEqkRupture getOriginalRupture() {
            return this.origRup;
        }
    }

    private static class CustomSource
    extends ProbEqkSource {
        private static final long serialVersionUID = 1L;
        private ProbEqkSource origSource;
        private RuptureSurface sourceSurf;
        private List<ProbEqkRupture> rups;

        public CustomSource(ProbEqkSource origSource, RuptureSurface sourceSurf, List<ProbEqkRupture> rups) {
            this.origSource = origSource;
            this.sourceSurf = sourceSurf;
            this.rups = rups;
        }

        @Override
        public LocationList getAllSourceLocs() {
            return this.origSource.getAllSourceLocs();
        }

        @Override
        public RuptureSurface getSourceSurface() {
            return this.sourceSurf;
        }

        @Override
        public double getMinDistance(Site site) {
            Location loc = site.getLocation();
            Preconditions.checkNotNull((Object)loc);
            if (this.sourceSurf == null) {
                return this.origSource.getMinDistance(site);
            }
            return this.sourceSurf.getQuickDistance(loc);
        }

        @Override
        public int getNumRuptures() {
            return this.rups.size();
        }

        @Override
        public ProbEqkRupture getRupture(int nRupture) {
            return this.rups.get(nRupture);
        }

        @Override
        public boolean isSourcePoissonian() {
            return this.origSource.isSourcePoissonian();
        }

        @Override
        public boolean isPoissonianSource() {
            return this.origSource.isPoissonianSource();
        }

        @Override
        public TectonicRegionType getTectonicRegionType() {
            return this.origSource.getTectonicRegionType();
        }

        @Override
        public void setTectonicRegionType(TectonicRegionType tectonicRegionType) {
            this.origSource.setTectonicRegionType(tectonicRegionType);
        }
    }
}

