/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.lang.reflect.Constructor;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.opensha.commons.util.DevStatus;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.ServerPrefs;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.rupForecastImpl.FloatingPoissonFaultERF;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel96.Frankel96_AdjustableEqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel96.Frankel96_EqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.PEER_TestCases.PEER_AreaForecast;
import org.opensha.sha.earthquake.rupForecastImpl.PEER_TestCases.PEER_LogicTreeERF_List;
import org.opensha.sha.earthquake.rupForecastImpl.PEER_TestCases.PEER_MultiSourceForecast;
import org.opensha.sha.earthquake.rupForecastImpl.PEER_TestCases.PEER_NonPlanarFaultForecast;
import org.opensha.sha.earthquake.rupForecastImpl.Point2MultVertSS_Fault.Point2MultVertSS_FaultERF;
import org.opensha.sha.earthquake.rupForecastImpl.Point2MultVertSS_Fault.Point2MultVertSS_FaultERF_List;
import org.opensha.sha.earthquake.rupForecastImpl.PointSourceERF;
import org.opensha.sha.earthquake.rupForecastImpl.PoissonFaultERF;
import org.opensha.sha.earthquake.rupForecastImpl.WG02.WG02_ERF_Epistemic_List;
import org.opensha.sha.earthquake.rupForecastImpl.WG02.WG02_EqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF1.WGCEP_UCERF1_EqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeIndependentEpistemicList;
import org.opensha.sha.earthquake.rupForecastImpl.YuccaMountain.YuccaMountainERF;
import org.opensha.sha.earthquake.rupForecastImpl.YuccaMountain.YuccaMountainERF_List;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.erf.NSHM23_WUS_BranchAveragedERF;
import org.opensha.sha.earthquake.rupForecastImpl.step.STEP_AlaskanPipeForecast;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.erf.UCERF3_CompoundSol_ERF;
import scratch.UCERF3.erf.epistemic.UCERF3EpistemicListERF;
import scratch.UCERF3.erf.mean.MeanUCERF3;
import scratch.UCERF3.utils.ModUCERF2.ModMeanUCERF2_FM2pt1;

public enum ERF_Ref {
    FRANKEL_ADJUSTABLE_96(Frankel96_AdjustableEqkRupForecast.class, Frankel96_AdjustableEqkRupForecast.NAME, DevStatus.PRODUCTION, false),
    FRANKEL_96(Frankel96_EqkRupForecast.class, Frankel96_EqkRupForecast.NAME, DevStatus.PRODUCTION, false),
    FRANKEL_02(Frankel02_AdjustableEqkRupForecast.class, Frankel02_AdjustableEqkRupForecast.NAME, DevStatus.PRODUCTION, false),
    WGCEP_02(WG02_EqkRupForecast.class, "WG02 Eqk Rup Forecast", DevStatus.PRODUCTION, false),
    WGCEP_02_LIST(WG02_ERF_Epistemic_List.class, WG02_ERF_Epistemic_List.NAME, DevStatus.PRODUCTION, true),
    WGCEP_UCERF_1(WGCEP_UCERF1_EqkRupForecast.class, WGCEP_UCERF1_EqkRupForecast.NAME, DevStatus.PRODUCTION, false),
    PEER_AREA(PEER_AreaForecast.class, "PEER Area Forecast", DevStatus.PRODUCTION, false),
    PEER_NON_PLANAR_FAULT(PEER_NonPlanarFaultForecast.class, "PEER Non Planar Fault Forecast", DevStatus.PRODUCTION, false),
    PEER_MULTI_SOURCE(PEER_MultiSourceForecast.class, "PEER Multi Source", DevStatus.PRODUCTION, false),
    PEER_LOGIC_TREE(PEER_LogicTreeERF_List.class, PEER_LogicTreeERF_List.NAME, DevStatus.PRODUCTION, false),
    POISSON_FLOATING_FAULT(FloatingPoissonFaultERF.class, "Floating Poisson Fault ERF", DevStatus.PRODUCTION, false),
    POISSON_FAULT(PoissonFaultERF.class, "Poisson Fault ERF", DevStatus.PRODUCTION, false),
    POINT_SOURCE(PointSourceERF.class, "Point Source ERF", DevStatus.PRODUCTION, false),
    POINT_SOURCE_MULTI_VERT(Point2MultVertSS_FaultERF.class, "Point 2 Mult Vertical SS Fault ERF", DevStatus.PRODUCTION, false),
    POINT_SOURCE_MULTI_VERT_LIST(Point2MultVertSS_FaultERF_List.class, "Point2Mult Vertical SS Fault ERF List", DevStatus.PRODUCTION, true),
    UCERF_2(UCERF2.class, UCERF2.NAME, DevStatus.PRODUCTION, false),
    UCERF_2_TIME_INDEP_LIST(UCERF2_TimeIndependentEpistemicList.class, UCERF2_TimeIndependentEpistemicList.NAME, DevStatus.PRODUCTION, true),
    MEAN_UCERF_2(MeanUCERF2.class, MeanUCERF2.NAME, DevStatus.PRODUCTION, false),
    MEAN_UCERF_2_Mod(ModMeanUCERF2_FM2pt1.class, ModMeanUCERF2_FM2pt1.NAME, DevStatus.PRODUCTION, false),
    INVERSION_SOLUTION_ERF(FaultSystemSolutionERF.class, "Fault System Solution ERF", DevStatus.PRODUCTION, false),
    MEAN_UCERF3(MeanUCERF3.class, "Mean UCERF3", DevStatus.PRODUCTION, false),
    UCERF3_COMPOUND(UCERF3_CompoundSol_ERF.class, "UCERF3 Single Branch ERF", DevStatus.PRODUCTION, false),
    YUCCA_MOUNTAIN(YuccaMountainERF.class, YuccaMountainERF.NAME, DevStatus.PRODUCTION, false),
    YUCCA_MOUNTAIN_LIST(YuccaMountainERF_List.class, YuccaMountainERF_List.NAME, DevStatus.PRODUCTION, true),
    UCERF3_EPISTEMIC(UCERF3EpistemicListERF.class, "UCERF3 Epistemic List ERF", DevStatus.PRODUCTION, true),
    NSHM23_WUS_BRANCH_AVG(NSHM23_WUS_BranchAveragedERF.class, "NSHM23-WUS (crustal only, excl. Cascadia) Branch Avg ERF", DevStatus.PRODUCTION, false),
    STEP_ALASKA(STEP_AlaskanPipeForecast.class, STEP_AlaskanPipeForecast.NAME, DevStatus.DEVELOPMENT, false);

    private Class<? extends BaseERF> clazz;
    private String name;
    private DevStatus status;
    private boolean erfList;

    private ERF_Ref(Class<? extends BaseERF> clazz, String name, DevStatus status, boolean erfList) {
        this.clazz = clazz;
        this.name = name;
        this.status = status;
        this.erfList = erfList;
    }

    public String toString() {
        return this.name;
    }

    public DevStatus status() {
        return this.status;
    }

    public boolean isERFList() {
        return this.erfList;
    }

    public BaseERF instance() {
        try {
            Constructor<? extends BaseERF> con = this.clazz.getConstructor(new Class[0]);
            return con.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    public Class<? extends BaseERF> getERFClass() {
        return this.clazz;
    }

    public static Set<ERF_Ref> get(boolean includeListERFs) {
        return ERF_Ref.get(includeListERFs, DevStatus.PRODUCTION, DevStatus.DEVELOPMENT, DevStatus.EXPERIMENTAL);
    }

    public static Set<ERF_Ref> get(boolean includeListERFs, ServerPrefs prefs) {
        if (prefs == ServerPrefs.DEV_PREFS) {
            return ERF_Ref.get(includeListERFs, DevStatus.PRODUCTION, DevStatus.DEVELOPMENT, DevStatus.EXPERIMENTAL);
        }
        if (prefs == ServerPrefs.PRODUCTION_PREFS) {
            return ERF_Ref.get(includeListERFs, DevStatus.PRODUCTION);
        }
        throw new IllegalArgumentException("Unknown ServerPrefs instance: " + String.valueOf((Object)prefs));
    }

    public static Set<ERF_Ref> get(boolean includeListERFs, DevStatus ... stati) {
        EnumSet<ERF_Ref> erfSet = EnumSet.allOf(ERF_Ref.class);
        for (ERF_Ref erf : erfSet) {
            if (!ArrayUtils.contains((Object[])stati, (Object)erf.status)) {
                erfSet.remove((Object)erf);
            }
            if (!erf.isERFList() || includeListERFs) continue;
            erfSet.remove((Object)erf);
        }
        return erfSet;
    }
}

