/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.io.Serializable;
import java.util.Objects;

public class FocalMechanism
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double strike = Double.NaN;
    private double dip = Double.NaN;
    private double rake = Double.NaN;

    public FocalMechanism() {
    }

    public FocalMechanism(double strike, double dip, double rake) {
        this.strike = strike;
        this.dip = dip;
        this.rake = rake;
    }

    public double getDip() {
        return this.dip;
    }

    public double getRake() {
        return this.rake;
    }

    public double getStrike() {
        return this.strike;
    }

    public void setDip(double dip) {
        this.dip = dip;
    }

    public void setRake(double rake) {
        this.rake = rake;
    }

    public void setStrike(double strike) {
        this.strike = strike;
    }

    public void setAll(double strike, double dip, double rake) {
        this.strike = strike;
        this.dip = dip;
        this.rake = rake;
    }

    public FocalMechanism copy() {
        return new FocalMechanism(this.strike, this.dip, this.rake);
    }

    public Unmodifiable unmodifiable() {
        return new Unmodifiable(this.strike, this.dip, this.rake);
    }

    public int hashCode() {
        return Objects.hash(this.dip, this.rake, this.strike);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FocalMechanism)) {
            return false;
        }
        FocalMechanism other = (FocalMechanism)obj;
        return Double.doubleToLongBits(this.dip) == Double.doubleToLongBits(other.dip) && Double.doubleToLongBits(this.rake) == Double.doubleToLongBits(other.rake) && Double.doubleToLongBits(this.strike) == Double.doubleToLongBits(other.strike);
    }

    public String toString() {
        return "FocalMechanism [strike=" + this.strike + ", dip=" + this.dip + ", rake=" + this.rake + "]";
    }

    public static class Unmodifiable
    extends FocalMechanism {
        public Unmodifiable(FocalMechanism mech) {
            super(mech.strike, mech.dip, mech.rake);
        }

        public Unmodifiable(double strike, double dip, double rake) {
            super(strike, dip, rake);
        }

        @Override
        public void setDip(double dip) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRake(double rake) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setStrike(double strike) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAll(double strike, double dip, double rake) {
            throw new UnsupportedOperationException();
        }
    }
}

