/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.EqkSource;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.util.TectonicRegionType;

public abstract class ProbEqkSource
implements EqkSource,
Named,
Iterable<ProbEqkRupture> {
    private static final long serialVersionUID = 1L;
    protected String name = new String("ProbEqkSource");
    public static final TectonicRegionType TECTONIC_REGION_TYPE_DEFAULT = TectonicRegionType.ACTIVE_SHALLOW;
    private TectonicRegionType tectonicRegionType = TECTONIC_REGION_TYPE_DEFAULT;
    private int sourceIndex;
    protected boolean isPoissonian = true;
    private String info;

    public boolean isSourcePoissonian() {
        return this.isPoissonian;
    }

    @Override
    public Iterator<ProbEqkRupture> getRupturesIterator() {
        return new Iterator<ProbEqkRupture>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ProbEqkSource.this.getNumRuptures();
            }

            @Override
            public ProbEqkRupture next() {
                return ProbEqkSource.this.getRupture(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported by this iterator");
            }
        };
    }

    public boolean isPoissonianSource() {
        return this.isPoissonian;
    }

    public abstract double getMinDistance(Site var1);

    @Override
    public abstract int getNumRuptures();

    @Override
    public abstract ProbEqkRupture getRupture(int var1);

    @Override
    public ProbEqkRupture getRuptureClone(int nRupture) {
        ProbEqkRupture eqkRupture = this.getRupture(nRupture);
        ProbEqkRupture eqkRuptureClone = (ProbEqkRupture)eqkRupture.clone();
        return eqkRuptureClone;
    }

    @Override
    public List<ProbEqkRupture> getRuptureList() {
        ArrayList<ProbEqkRupture> v = new ArrayList<ProbEqkRupture>();
        for (int i = 0; i < this.getNumRuptures(); ++i) {
            v.add(this.getRuptureClone(i));
        }
        return v;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setInfo(String infoString) {
        this.info = new String(infoString);
    }

    public String getInfo() {
        return this.info;
    }

    public String getSourceMetadata() {
        String sourceMetadata = this.sourceIndex + "\t";
        sourceMetadata = sourceMetadata + this.getNumRuptures() + "\t";
        sourceMetadata = sourceMetadata + this.isPoissonian + "\t";
        sourceMetadata = sourceMetadata + (float)this.computeTotalProb() + "\t";
        sourceMetadata = sourceMetadata + "\"" + this.getName() + "\"";
        return sourceMetadata;
    }

    public double computeTotalEquivMeanAnnualRate(double duration) {
        double rate = 0.0;
        for (ProbEqkRupture rup : this) {
            rate += rup.getMeanAnnualRate(duration);
        }
        return rate;
    }

    public double computeTotalProb() {
        return this.computeTotalProbAbove(-10.0);
    }

    public double computeTotalProbAbove(double mag) {
        return this.computeTotalProbAbove(mag, null);
    }

    public double computeApproxTotalProbAbove(double mag, Region region) {
        double totProb = 0.0;
        for (int i = 0; i < this.getNumRuptures(); ++i) {
            ProbEqkRupture tempRup = this.getRupture(i);
            if (tempRup.getMag() < mag) continue;
            totProb += this.getApproxRupProbWithinRegion(tempRup, region);
        }
        if (this.isPoissonian) {
            return 1.0 - Math.exp(totProb);
        }
        return totProb;
    }

    public double computeTotalProbAbove(double mag, Region region) {
        double totProb = 0.0;
        for (int i = 0; i < this.getNumRuptures(); ++i) {
            ProbEqkRupture tempRup = this.getRupture(i);
            if (tempRup.getMag() < mag) continue;
            totProb += this.getRupProbWithinRegion(tempRup, region);
        }
        if (this.isPoissonian) {
            return 1.0 - Math.exp(totProb);
        }
        return totProb;
    }

    private double getRupProbWithinRegion(ProbEqkRupture tempRup, Region region) {
        int numLocsInside = 0;
        int totPoints = 0;
        if (region != null) {
            ListIterator<Location> locIt = tempRup.getRuptureSurface().getLocationsIterator();
            while (locIt.hasNext()) {
                if (region.contains((Location)locIt.next())) {
                    ++numLocsInside;
                }
                ++totPoints;
            }
        } else {
            totPoints = numLocsInside = 1;
        }
        if (this.isPoissonian) {
            return Math.log(1.0 - tempRup.getProbability() * (double)numLocsInside / (double)totPoints);
        }
        return tempRup.getProbability() * (double)numLocsInside / (double)totPoints;
    }

    private double getApproxRupProbWithinRegion(ProbEqkRupture tempRup, Region region) {
        int numLocsInside = 0;
        int totPoints = 0;
        if (region != null) {
            RuptureSurface rupSurface = tempRup.getRuptureSurface();
            Location loc1 = rupSurface.getFirstLocOnUpperEdge();
            Location loc2 = rupSurface.getLastLocOnUpperEdge();
            if (region.contains(loc1) && region.contains(loc2)) {
                totPoints = numLocsInside = 1;
            } else {
                Iterator locIt = rupSurface.getEvenlyDiscritizedUpperEdge().iterator();
                while (locIt.hasNext()) {
                    if (region.contains((Location)locIt.next())) {
                        ++numLocsInside;
                    }
                    ++totPoints;
                }
            }
        } else {
            totPoints = numLocsInside = 1;
        }
        if (this.isPoissonian) {
            return Math.log(1.0 - tempRup.getProbability() * (double)numLocsInside / (double)totPoints);
        }
        return tempRup.getProbability() * (double)numLocsInside / (double)totPoints;
    }

    public ArrayList<ProbEqkRupture> drawRandomEqkRuptures() {
        ArrayList<ProbEqkRupture> rupList = new ArrayList<ProbEqkRupture>();
        if (this.isPoissonian) {
            for (int r = 0; r < this.getNumRuptures(); ++r) {
                int num;
                ProbEqkRupture rup = this.getRupture(r);
                double expected = -Math.log(1.0 - rup.getProbability());
                double rand = Math.random();
                double sum = 0.0;
                double factoral = 1.0;
                int maxNum = (int)Math.round(10.0 * expected) + 2;
                for (num = 0; num < maxNum; ++num) {
                    double prob;
                    if (num != 0) {
                        factoral *= (double)num;
                    }
                    if (rand <= (sum += (prob = Math.pow(expected, num) * Math.exp(-expected) / factoral))) break;
                }
                for (int i = 0; i < num; ++i) {
                    rupList.add((ProbEqkRupture)rup.clone());
                }
            }
        } else {
            throw new RuntimeException("drawRandomEqkRuptures(): Non poissonsources are not yet supported");
        }
        return rupList;
    }

    public ArrayList<Integer> drawRandomEqkRuptureIndices() {
        ArrayList<Integer> rupIndexList = new ArrayList<Integer>();
        if (this.isPoissonian) {
            for (int r = 0; r < this.getNumRuptures(); ++r) {
                int num;
                ProbEqkRupture rup = this.getRupture(r);
                double expected = -Math.log(1.0 - rup.getProbability());
                double rand = Math.random();
                double sum = 0.0;
                double factoral = 1.0;
                int maxNum = (int)Math.round(10.0 * expected) + 2;
                for (num = 0; num < maxNum; ++num) {
                    double prob;
                    if (num != 0) {
                        factoral *= (double)num;
                    }
                    if (rand <= (sum += (prob = Math.pow(expected, num) * Math.exp(-expected) / factoral))) break;
                }
                for (int i = 0; i < num; ++i) {
                    rupIndexList.add(r);
                }
            }
        } else {
            throw new RuntimeException("drawRandomEqkRuptures(): Non poissonsources are not yet supported");
        }
        return rupIndexList;
    }

    public int drawSingleRandomEqkRuptureIndex() {
        int numRup = this.getNumRuptures();
        IntegerPDF_FunctionSampler rupSampler = new IntegerPDF_FunctionSampler(numRup);
        for (int r = 0; r < this.getNumRuptures(); ++r) {
            rupSampler.add((double)r, this.getRupture(r).getProbability());
        }
        return rupSampler.getRandomInt();
    }

    public int drawSingleRandomEqkRuptureIndex(double randDouble) {
        int numRup = this.getNumRuptures();
        IntegerPDF_FunctionSampler rupSampler = new IntegerPDF_FunctionSampler(numRup);
        for (int r = 0; r < this.getNumRuptures(); ++r) {
            rupSampler.add((double)r, this.getRupture(r).getProbability());
        }
        return rupSampler.getRandomInt(randDouble);
    }

    public int drawSingleRandomEqkRuptureIndexFromRelativeRates(double randDouble) {
        int numRup = this.getNumRuptures();
        IntegerPDF_FunctionSampler rupSampler = new IntegerPDF_FunctionSampler(numRup);
        for (int r = 0; r < this.getNumRuptures(); ++r) {
            double rate = -Math.log(1.0 - this.getRupture(r).getProbability());
            if (Double.isInfinite(rate)) {
                throw new RuntimeException("Infinite rate error");
            }
            rupSampler.add((double)r, rate);
        }
        return rupSampler.getRandomInt(randDouble);
    }

    @Override
    public TectonicRegionType getTectonicRegionType() {
        return this.tectonicRegionType;
    }

    public void setTectonicRegionType(TectonicRegionType tectonicRegionType) {
        if (tectonicRegionType == null) {
            throw new RuntimeException("tectonicRegionType cannot be set as null");
        }
        this.tectonicRegionType = tectonicRegionType;
    }

    @Override
    public Iterator<ProbEqkRupture> iterator() {
        return this.getRupturesIterator();
    }

    public double computeEquivTotalMomentRate(double duration) {
        double moRate = 0.0;
        for (ProbEqkRupture rup : this) {
            moRate += MagUtils.magToMoment(rup.getMag()) * rup.getMeanAnnualRate(duration);
        }
        return moRate;
    }
}

