/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc;

import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class ERF2GriddedSeisRatesCalc {
    private double minMagnitude;
    private DecimalFormat magFormat = new DecimalFormat("0.00");
    private ERF eqkRupForecast;
    private GriddedRegion region;

    public ArrayList calcMFD_ForGriddedRegion(double minMag, double maxMag, int numMagBins, ERF eqkRupForecast, GriddedRegion region, double duration) {
        double delta = (maxMag - minMag) / (double)(numMagBins - 1);
        ArrayList cumMFDList = this.calcCumMFD_ForGriddedRegion(minMag - delta, eqkRupForecast, region);
        int numLocs = cumMFDList.size();
        ArrayList<IncrementalMagFreqDist> mfdList = new ArrayList<IncrementalMagFreqDist>();
        for (int i = 0; i < numLocs; ++i) {
            IncrementalMagFreqDist magFreqDist = new IncrementalMagFreqDist(minMag, maxMag, numMagBins);
            mfdList.add(magFreqDist);
            ArbitrarilyDiscretizedFunc cumFunc = (ArbitrarilyDiscretizedFunc)cumMFDList.get(i);
            if (cumFunc == null) continue;
            for (int j = 0; j < magFreqDist.size(); ++j) {
                double mag = magFreqDist.getX(j);
                double cumRate1 = this.getRateForMag(cumFunc, mag - delta / 2.0);
                double cumRate2 = this.getRateForMag(cumFunc, mag + delta / 2.0);
                magFreqDist.set(mag, (cumRate1 - cumRate2) * duration);
            }
        }
        return mfdList;
    }

    private double getRateForMag(ArbitrarilyDiscretizedFunc func, double mag) {
        if (mag < func.getMinX()) {
            return func.getY(0);
        }
        if (mag > func.getMaxX()) {
            return 0.0;
        }
        return func.getInterpolatedY_inLogXLogYDomain(mag);
    }

    public ArrayList calcCumMFD_ForGriddedRegion(double minMag, ERF eqkRupForecast, GriddedRegion region) {
        this.minMagnitude = minMag;
        this.eqkRupForecast = eqkRupForecast;
        this.region = region;
        ArbDiscrEmpiricalDistFunc[] funcs = this.calcSeisRatesForGriddedRegion();
        ArrayList<ArbitrarilyDiscretizedFunc> magRateDist = new ArrayList<ArbitrarilyDiscretizedFunc>();
        int size = funcs.length;
        for (int i = 0; i < size; ++i) {
            int numEmpDistElemnents = funcs[i].size();
            if (numEmpDistElemnents == 0) {
                magRateDist.add(null);
                continue;
            }
            DiscretizedFunc cumDist = funcs[i].getCumDist();
            int numMags = cumDist.size();
            ArbitrarilyDiscretizedFunc magRateFunction = new ArbitrarilyDiscretizedFunc();
            magRateFunction.set(cumDist.getX(0), cumDist.getY(numMags - 1));
            for (int magIndex = 1; magIndex < numMags; ++magIndex) {
                double rates = cumDist.getY(numMags - 1) - cumDist.getY(magIndex - 1);
                magRateFunction.set(cumDist.getX(magIndex), rates);
            }
            magRateDist.add(magRateFunction);
        }
        return magRateDist;
    }

    public double[] getTotalSeisRateAtEachLocationInRegion(double minMag, ERF eqkRupForecast, GriddedRegion region) {
        this.minMagnitude = minMag;
        this.eqkRupForecast = eqkRupForecast;
        this.region = region;
        double[] rates = this.calcTotalSeisRatesForGriddedRegion();
        return rates;
    }

    public double getTotalSeisRateInRegion(double minMag, ERF eqkRupForecast, Region region) {
        int numSources = eqkRupForecast.getNumSources();
        double totalRate = 0.0;
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            ProbEqkSource source = eqkRupForecast.getSource(sourceIndex);
            int numRuptures = source.getNumRuptures();
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                double mag = rupture.getMag();
                if (mag < minMag) continue;
                EvenlyGriddedSurface rupSurface = (EvenlyGriddedSurface)rupture.getRuptureSurface();
                long numPts = rupSurface.size();
                double ptRate = this.getRupturePtRate(eqkRupForecast, rupture, numPts);
                ListIterator it = rupSurface.getAllByRowsIterator();
                while (it.hasNext()) {
                    Location ptLoc = (Location)it.next();
                    if (!region.contains(ptLoc)) continue;
                    totalRate += ptRate;
                }
            }
        }
        return totalRate;
    }

    public ArbDiscrEmpiricalDistFunc getMagRateDistForRegion(double minMag, ERF eqkRupForecast, Region region) {
        ArbDiscrEmpiricalDistFunc magRateDist = new ArbDiscrEmpiricalDistFunc();
        int numSources = eqkRupForecast.getNumSources();
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            ProbEqkSource source = eqkRupForecast.getSource(sourceIndex);
            int numRuptures = source.getNumRuptures();
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                double mag = rupture.getMag();
                if (mag < minMag) continue;
                EvenlyGriddedSurface rupSurface = (EvenlyGriddedSurface)rupture.getRuptureSurface();
                long numPts = rupSurface.size();
                double ptRate = this.getRupturePtRate(eqkRupForecast, rupture, numPts);
                ListIterator it = rupSurface.getAllByRowsIterator();
                while (it.hasNext()) {
                    Location ptLoc = (Location)it.next();
                    if (!region.contains(ptLoc)) continue;
                    String ruptureMag = this.magFormat.format(mag);
                    magRateDist.set(Double.parseDouble(ruptureMag), ptRate);
                }
            }
        }
        return magRateDist;
    }

    private double getRupturePtRate(ERF eqkRupForecast, ProbEqkRupture rupture, long numPts) {
        return rupture.getMeanAnnualRate(eqkRupForecast.getTimeSpan().getDuration()) / (double)numPts;
    }

    private double[] calcTotalSeisRatesForGriddedRegion() {
        int numSources = this.eqkRupForecast.getNumSources();
        int numLocations = this.region.getNodeCount();
        double[] rates = new double[numLocations];
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            ProbEqkSource source = this.eqkRupForecast.getSource(sourceIndex);
            int numRuptures = source.getNumRuptures();
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                double mag = rupture.getMag();
                if (mag < this.minMagnitude) continue;
                EvenlyGriddedSurface rupSurface = (EvenlyGriddedSurface)rupture.getRuptureSurface();
                long numPts = rupSurface.size();
                double ptRate = this.getRupturePtRate(this.eqkRupForecast, rupture, numPts);
                ListIterator it = rupSurface.getAllByRowsIterator();
                while (it.hasNext()) {
                    Location ptLoc = (Location)it.next();
                    int locIndex = 0;
                    locIndex = this.region.indexForLocation(ptLoc);
                    if (locIndex < 0) continue;
                    int n = locIndex;
                    rates[n] = rates[n] + ptRate;
                }
            }
        }
        return rates;
    }

    private ArbDiscrEmpiricalDistFunc[] calcSeisRatesForGriddedRegion() {
        int numSources = this.eqkRupForecast.getNumSources();
        int numLocations = this.region.getNodeCount();
        ArbDiscrEmpiricalDistFunc[] funcs = new ArbDiscrEmpiricalDistFunc[numLocations];
        for (int i = 0; i < numLocations; ++i) {
            funcs[i] = new ArbDiscrEmpiricalDistFunc();
        }
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            ProbEqkSource source = this.eqkRupForecast.getSource(sourceIndex);
            int numRuptures = source.getNumRuptures();
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                double mag = rupture.getMag();
                if (mag < this.minMagnitude) continue;
                EvenlyGriddedSurface rupSurface = (EvenlyGriddedSurface)rupture.getRuptureSurface();
                long numPts = rupSurface.size();
                double ptRate = this.getRupturePtRate(this.eqkRupForecast, rupture, numPts);
                ListIterator it = rupSurface.getAllByRowsIterator();
                while (it.hasNext()) {
                    Location ptLoc = (Location)it.next();
                    int locIndex = 0;
                    locIndex = this.region.indexForLocation(ptLoc);
                    if (locIndex < 0) continue;
                    String magString = this.magFormat.format(mag);
                    funcs[locIndex].set(Double.parseDouble(magString), ptRate);
                }
            }
        }
        return funcs;
    }

    public double getTotalProbAbove(ERF eqkRupForecast, double minMag, Region region) {
        int numSources = eqkRupForecast.getNumSources();
        double totalProb = 1.0;
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            ProbEqkSource source = eqkRupForecast.getSource(sourceIndex);
            int numRuptures = source.getNumRuptures();
            boolean isSourcePoission = source.isPoissonianSource();
            double srcProb = isSourcePoission ? 1.0 : 0.0;
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                if (rupture.getMag() < minMag) continue;
                EvenlyGriddedSurface rupSurface = (EvenlyGriddedSurface)rupture.getRuptureSurface();
                double ptProb = rupture.getProbability() / (double)rupSurface.size();
                ListIterator it = rupSurface.getAllByRowsIterator();
                while (it.hasNext()) {
                    Location ptLoc = (Location)it.next();
                    if (!region.contains(ptLoc)) continue;
                    if (isSourcePoission) {
                        srcProb *= 1.0 - ptProb;
                        continue;
                    }
                    srcProb += ptProb;
                }
            }
            if (isSourcePoission) {
                srcProb = 1.0 - srcProb;
            }
            totalProb *= 1.0 - srcProb;
        }
        return 1.0 - totalProb;
    }

    public static void main(String[] args) {
        ERF2GriddedSeisRatesCalc erf2griddedseisratescalc = new ERF2GriddedSeisRatesCalc();
        Frankel02_AdjustableEqkRupForecast frankelForecast = null;
        frankelForecast = new Frankel02_AdjustableEqkRupForecast();
        frankelForecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_EXCLUDE);
        frankelForecast.getAdjustableParameterList().getParameter("Rupture Offset").setValue(10.0);
        frankelForecast.getTimeSpan().setDuration(50.0);
        frankelForecast.updateForecast();
        int numSources = frankelForecast.getNumSources();
        try {
            FileWriter fw = new FileWriter("Source_Rupture.txt");
            fw.write("SrcIndex   RupIndex   Mag  Prob.   SourceName\n");
            for (int i = 0; i < numSources; ++i) {
                ProbEqkSource source = frankelForecast.getSource(i);
                int numRups = source.getNumRuptures();
                for (int j = 0; j < numRups; ++j) {
                    ProbEqkRupture rup = source.getRupture(j);
                    float magnitude = (float)rup.getMag();
                    if (!((double)magnitude >= 7.5)) continue;
                    fw.write(i + "  " + j + "   " + magnitude + "     " + (float)rup.getProbability() + "      " + source.getName() + "\n");
                }
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

