/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc;

import java.util.ListIterator;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;

public class MomentInRegionCalc {
    public static double getMoment(AbstractERF erf, Region region) {
        int numSources = erf.getNumSources();
        double totMoment = 0.0;
        double rupMoment = 0.0;
        for (int srcIndex = 0; srcIndex < numSources; ++srcIndex) {
            int numRups = erf.getNumRuptures(srcIndex);
            for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
                ProbEqkRupture rupture = erf.getRupture(srcIndex, rupIndex);
                rupMoment = MagUtils.magToMoment(rupture.getMag());
                ListIterator<Location> it = rupture.getRuptureSurface().getLocationsIterator();
                int totRupLocs = 0;
                int rupLocsInside = 0;
                while (it.hasNext()) {
                    Location loc = (Location)it.next();
                    ++totRupLocs;
                    if (!region.contains(loc)) continue;
                    ++rupLocsInside;
                }
                totMoment += rupMoment * (double)rupLocsInside / (double)totRupLocs;
            }
        }
        return totMoment;
    }

    public static void main(String[] args) {
        LocationList locList1 = new LocationList();
        locList1.add(new Location(40.5, -127.0));
        locList1.add(new Location(45.0, -122.0));
        locList1.add(new Location(41.75, -119.025));
        locList1.add(new Location(37.25, -124.025));
        Region region1 = new Region(locList1, BorderType.MERCATOR_LINEAR);
        LocationList locList2 = new LocationList();
        locList2.add(new Location(37.25, -124.025));
        locList2.add(new Location(41.75, -119.025));
        locList2.add(new Location(41.0, -118.35));
        locList2.add(new Location(36.5, -123.35));
        Region region2 = new Region(locList2, BorderType.MERCATOR_LINEAR);
        LocationList locList3 = new LocationList();
        locList3.add(new Location(36.5, -123.35));
        locList3.add(new Location(41.0, -118.35));
        locList3.add(new Location(39.5, -117.0));
        locList3.add(new Location(35.0, -122.0));
        Region region3 = new Region(locList3, BorderType.MERCATOR_LINEAR);
        LocationList locList4 = new LocationList();
        locList4.add(new Location(35.0, -122.0));
        locList4.add(new Location(39.5, -117.0));
        locList4.add(new Location(37.5, -115.2));
        locList4.add(new Location(33.0, -120.2));
        Region region4 = new Region(locList4, BorderType.MERCATOR_LINEAR);
        LocationList locList5 = new LocationList();
        locList5.add(new Location(33.0, -120.2));
        locList5.add(new Location(37.5, -115.2));
        locList5.add(new Location(36.75, -114.525));
        locList5.add(new Location(32.25, -119.525));
        Region region5 = new Region(locList5, BorderType.MERCATOR_LINEAR);
        LocationList locList6 = new LocationList();
        locList6.add(new Location(32.25, -119.525));
        locList6.add(new Location(36.75, -114.525));
        locList6.add(new Location(34.0, -112.0));
        locList6.add(new Location(29.5, -117.0));
        Region region6 = new Region(locList6, BorderType.MERCATOR_LINEAR);
        UCERF2 ucerf2 = new UCERF2();
        ucerf2.updateForecast();
        System.out.println(MomentInRegionCalc.getMoment(ucerf2, region1));
        System.out.println(MomentInRegionCalc.getMoment(ucerf2, region2));
        System.out.println(MomentInRegionCalc.getMoment(ucerf2, region3));
        System.out.println(MomentInRegionCalc.getMoment(ucerf2, region4));
        System.out.println(MomentInRegionCalc.getMoment(ucerf2, region5));
        System.out.println(MomentInRegionCalc.getMoment(ucerf2, region6));
    }
}

