/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc.recurInterval;

import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.calc.recurInterval.EqkProbDistCalc;

public final class LognormalDistCalc
extends EqkProbDistCalc
implements ParameterChangeListener {
    public LognormalDistCalc() {
        this.NAME = "Lognormal";
    }

    public double getFractionalUncertaintyForConfBounds(double confBoundsFraction) {
        double fractUncert = 0.0;
        this.getCDF();
        for (double factor = 1.001; factor < 9.999; factor += 0.001) {
            fractUncert = this.cdf.getInterpolatedY(this.mean * factor) - this.cdf.getInterpolatedY(this.mean / factor);
            if (!(fractUncert > confBoundsFraction)) continue;
            fractUncert = factor;
            break;
        }
        return fractUncert;
    }

    @Override
    protected void computeDistributions() {
        this.integratedCDF = null;
        this.integratedOneMinusCDF = null;
        this.pdf = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        this.cdf = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        this.pdf.set(0, 0.0);
        this.cdf.set(0, 0.0);
        double sigma = Math.sqrt(Math.log(this.aperiodicity * this.aperiodicity + 1.0));
        double mu = Math.log(this.mean) - sigma * sigma / 2.0;
        double temp1 = sigma * Math.sqrt(Math.PI * 2);
        double temp2 = 2.0 * sigma * sigma;
        double cd = 0.0;
        for (int i = 1; i < this.pdf.size(); ++i) {
            double t = this.cdf.getX(i);
            double pd = Math.exp(-(Math.log(t) - mu) * (Math.log(t) - mu) / temp2) / (temp1 * t);
            if (Double.isNaN(pd)) {
                pd = 0.0;
                System.out.println("pd=0 for i=" + i);
            }
            this.pdf.set(i, pd);
            this.cdf.set(i, cd += this.deltaX * (pd + this.pdf.getY(i - 1)) / 2.0);
        }
        this.upToDate = true;
    }

    public static void main(String[] args) {
    }
}

