/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.IntStream;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.DocumentException;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.CSVReader;
import org.opensha.commons.data.CSVWriter;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.RegionUtils;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.ModuleArchive;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.commons.util.modules.helpers.LargeCSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.BuildInfoModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceList;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.InfoModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupSetTectonicRegimes;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectAreas;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.earthquake.faultSysSolution.util.SlipAlongRuptureModelBranchNode;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemRupSetFactory;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class FaultSystemRupSet
extends ModuleContainer<OpenSHA_Module>
implements ArchivableModule,
SubModule<ModuleArchive<OpenSHA_Module>> {
    private List<? extends FaultSection> faultSectionData;
    private double[] mags;
    private double[] rakes;
    private double[] rupAreas;
    private double[] rupLengths;
    private List<List<Integer>> sectionForRups;
    ModuleArchive<OpenSHA_Module> archive;
    public static final String NESTING_PREFIX = "ruptures/";
    public static final String SECTS_FILE_NAME = "fault_sections.geojson";
    public static final String RUP_SECTS_FILE_NAME = "indices.csv";
    public static final String RUP_PROPS_FILE_NAME = "properties.csv";
    protected boolean showProgress = false;
    private double[] minMagsCache = null;
    private double[] maxMagsCache = null;
    protected transient RupSurfaceCache surfCache = new RupSurfaceCache();
    private Table<Region, Boolean, double[]> fractRupsInsideRegions = HashBasedTable.create();
    private Table<Region, Boolean, double[]> fractSectsInsideRegions = HashBasedTable.create();
    private int[] sectNumPtsTraceOnly = null;
    private int[] sectNumPtsFull = null;
    private List<List<Integer>> rupturesForSectionCache = null;
    private Map<Integer, List<Integer>> rupturesForParentSectionCache = null;

    protected FaultSystemRupSet() {
    }

    public FaultSystemRupSet(List<? extends FaultSection> faultSectionData, List<List<Integer>> sectionForRups, double[] mags, double[] rakes, double[] rupAreas, @Nullable double[] rupLengths) {
        this.init(faultSectionData, sectionForRups, mags, rakes, rupAreas, rupLengths);
        if (!this.hasModule(BuildInfoModule.class)) {
            try {
                this.addModule(BuildInfoModule.detect());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ModuleArchive<OpenSHA_Module> getArchive() {
        FaultSystemRupSet rupSet;
        if (this.archive == null) {
            this.archive = new ModuleArchive();
        }
        if ((rupSet = this.archive.getModule(FaultSystemRupSet.class)) == null) {
            this.archive.addModule(this);
        } else {
            Preconditions.checkState((rupSet == this ? 1 : 0) != 0);
        }
        return this.archive;
    }

    public void write(File file) throws IOException {
        this.getArchive().write(file);
    }

    @Override
    public void setParent(ModuleArchive<OpenSHA_Module> parent) throws IllegalStateException {
        if (parent != null) {
            FaultSystemRupSet oRupSet = parent.getModule(FaultSystemRupSet.class, false);
            Preconditions.checkState((oRupSet == null || oRupSet == this ? 1 : 0) != 0);
        }
        this.archive = parent;
    }

    @Override
    public ModuleArchive<OpenSHA_Module> getParent() {
        return this.archive;
    }

    @Override
    public SubModule<ModuleArchive<OpenSHA_Module>> copy(ModuleArchive<OpenSHA_Module> newArchive) throws IllegalStateException {
        if (this.archive == null) {
            this.archive = newArchive;
            return this;
        }
        FaultSystemRupSet copy = new FaultSystemRupSet();
        copy.init(this);
        newArchive.addModule(copy);
        return copy;
    }

    public static FaultSystemRupSet load(File file) throws IOException {
        return FaultSystemRupSet.load(ArchiveInput.getDefaultInput(file));
    }

    public static FaultSystemRupSet load(ZipFile zip) throws IOException {
        if (zip.getEntry("rup_sections.bin") != null) {
            System.err.println("WARNING: this is a legacy fault system rupture set, that file format is deprecated. Will attempt to load it using the legacy file loader. See https://opensha.org/File-Formats for more information.");
            try {
                return U3FaultSystemIO.loadRupSetAsApplicable(zip, null);
            }
            catch (DocumentException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        return FaultSystemRupSet.load(new ArchiveInput.ZipFileInput(zip));
    }

    public static FaultSystemRupSet load(ArchiveInput input) throws IOException {
        if (input.hasEntry("rup_sections.bin")) {
            System.err.println("WARNING: this is a legacy fault system rupture set, that file format is deprecated. Will attempt to load it using the legacy file loader. See https://opensha.org/File-Formats for more information.");
            Preconditions.checkState((boolean)(input instanceof ArchiveInput.FileBacked), (Object)"Can only do a deprecated load from zip files (this isn't file-backed)");
            try {
                return U3FaultSystemIO.loadRupSetAsApplicable(((ArchiveInput.FileBacked)input).getInputFile());
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        ModuleArchive<FaultSystemRupSet> archive = new ModuleArchive<FaultSystemRupSet>(input, FaultSystemRupSet.class);
        FaultSystemRupSet rupSet = archive.getModule(FaultSystemRupSet.class);
        if (rupSet == null && !input.hasEntry("modules.json") && input.hasEntry("ruptures/indices.csv")) {
            System.err.println("WARNING: rupture set archive is missing modules.json, trying to load it anyway");
            archive.loadUnlistedModule(FaultSystemRupSet.class, NESTING_PREFIX);
            rupSet = archive.getModule(FaultSystemRupSet.class);
        }
        Preconditions.checkState((rupSet != null ? 1 : 0) != 0, (Object)"Failed to load rupture set module from archive (see above error messages)");
        Preconditions.checkNotNull(rupSet.archive, (Object)"archive should have been set automatically");
        return rupSet;
    }

    @Override
    public String getName() {
        return "Rupture Set";
    }

    @Override
    protected String getNestingPrefix() {
        return NESTING_PREFIX;
    }

    @Override
    public final void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        FaultSystemSolution solution;
        FileBackedModule.initEntry(output, entryPrefix, RUP_SECTS_FILE_NAME);
        CSVWriter csvWriter = new CSVWriter(output.getOutputStream(), false);
        FaultSystemRupSet.buildRupSectsCSV(this, csvWriter);
        csvWriter.flush();
        output.closeEntry();
        FileBackedModule.initEntry(output, entryPrefix, RUP_PROPS_FILE_NAME);
        csvWriter = new CSVWriter(output.getOutputStream(), true);
        new RuptureProperties(this).buildCSV(csvWriter);
        csvWriter.flush();
        output.closeEntry();
        FileBackedModule.initEntry(output, entryPrefix, SECTS_FILE_NAME);
        OutputStreamWriter writer = new OutputStreamWriter(output.getOutputStream());
        GeoJSONFaultReader.writeFaultSections(writer, this.faultSectionData);
        writer.flush();
        output.closeEntry();
        FileBackedModule.initEntry(output, null, "README");
        writer = new OutputStreamWriter(output.getOutputStream());
        BufferedWriter readme = new BufferedWriter(writer);
        FaultSystemSolution faultSystemSolution = solution = this.archive == null ? null : this.archive.getModule(FaultSystemSolution.class);
        if (solution != null) {
            readme.write("This is an OpenSHA Fault System Solution zip file.\n\n");
        } else {
            readme.write("This is an OpenSHA Fault System Rupture Set zip file.\n\n");
        }
        readme.write("The file format is described in detail at https://opensha.org/Modular-Fault-System-Solution\n\n");
        readme.write("Rupture information is stored in the '" + entryPrefix + "' sub-directory. Optional files may exist, but the core (required) files are:\n");
        readme.write(" - " + ArchivableModule.getEntryName(entryPrefix, "fault_sections.geojson: GeoJSON file listing the fault trace and properties of each fault section\n"));
        readme.write(" - " + ArchivableModule.getEntryName(entryPrefix, "indices.csv: CSV file listing the fault section indices that comprise each rupture\n"));
        readme.write(" - " + ArchivableModule.getEntryName(entryPrefix, "properties.csv: CSV file listing the properties of each rupture, including magnitude and rake\n"));
        if (solution != null) {
            readme.write("\n");
            String solPrefix = solution.getNestingPrefix();
            readme.write("Rate information is stored in the '" + solPrefix + "' sub-directory. Optional files may exist, but there is only one required file:\n");
            readme.write(" - " + ArchivableModule.getEntryName(solPrefix, "rates.csv: CSV file giving the annual rate of occurrence for each rupture\n"));
            GridSourceProvider gridProv = solution.getModule(GridSourceProvider.class);
            if (gridProv != null) {
                readme.write("This solution has optional gridded seismicity information. Files related to that are:\n");
                if (gridProv instanceof MFDGridSourceProvider) {
                    readme.write(" - " + ArchivableModule.getEntryName(solPrefix, "grid_region.geojson: GeoJSON file giving the location of each gridded seismicity node\n"));
                    readme.write(" - " + ArchivableModule.getEntryName(solPrefix, "grid_mech_weights.csv: CSV file giving the relative weights of each gridded seismicity focal mechanism at each grid node\n"));
                    readme.write(" - " + ArchivableModule.getEntryName(solPrefix, "grid_sub_seis_mfds.csv: CSV file giving the magnitude-frequency distribution of sub-seismogenic ruptures at each gridded seismicity node that are associated with at least one fault\n"));
                    readme.write(" - " + ArchivableModule.getEntryName(solPrefix, "grid_sub_seis_mfds.csv: CSV file giving the magnitude-frequency distribution of off-fault ruptures at each gridded seismicity node (those that are not associated with at any fault)\n"));
                } else if (gridProv instanceof GridSourceList) {
                    if (gridProv.getGriddedRegion() != null) {
                        readme.write(" - " + ArchivableModule.getEntryName(solPrefix, "grid_region.geojson: Optional GeoJSON defining the region for which this gridded seismicity model applies\n"));
                    }
                    readme.write(" - " + ArchivableModule.getEntryName(solPrefix, "grid_source_locations.csv: CSV file giving the index and location and of each gridded seismicity source\n"));
                    readme.write(" - " + ArchivableModule.getEntryName(solPrefix, "grid_sources.csv: CSV file listing each gridded seismicity rupture. Grid indexes in this file reference the locations listed in " + ArchivableModule.getEntryName(solPrefix, "grid_source_locations.csv") + "\n"));
                }
            }
        }
        readme.flush();
        writer.flush();
        output.closeEntry();
    }

    public static void buildRupSectsCSV(FaultSystemRupSet rupSet, CSVWriter writer) throws IOException {
        int maxNumSects = 0;
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            maxNumSects = Integer.max(maxNumSects, rupSet.getSectionsIndicesForRup(r).size());
        }
        ArrayList<String> header = new ArrayList<String>(List.of("Rupture Index", "Num Sections"));
        for (int s = 0; s < maxNumSects; ++s) {
            header.add("# " + (s + 1));
        }
        writer.write(header);
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            List<Integer> sectIDs = rupSet.getSectionsIndicesForRup(r);
            ArrayList<String> line = new ArrayList<String>(2 + sectIDs.size());
            line.add("" + r);
            line.add("" + sectIDs.size());
            for (int s : sectIDs) {
                line.add("" + s);
            }
            writer.write(line);
        }
        writer.flush();
    }

    public static List<List<Integer>> loadRupSectsCSV(CSVReader rupSectsCSV, int numSections, int numRuptures) {
        ArrayList<List<Integer>> rupSectsList = new ArrayList<List<Integer>>(numRuptures);
        boolean shortSafe = numSections < Short.MAX_VALUE;
        rupSectsCSV.read();
        for (int r = 0; r < numRuptures; ++r) {
            AbstractList rupSects;
            int i;
            Object[] sectIDs;
            int row = r + 1;
            int col = 0;
            CSVReader.Row csvRow = rupSectsCSV.read();
            Preconditions.checkState((csvRow != null ? 1 : 0) != 0, (Object)"Ruptures CSV file has too few rows.");
            Preconditions.checkState((r == csvRow.getInt(col++) ? 1 : 0) != 0, (String)"Ruptures out of order or not 0-based in CSV file, expected id=%s at row %s", (int)r, (int)row);
            int numRupSects = csvRow.getInt(col++);
            Preconditions.checkState((numRupSects > 0 ? 1 : 0) != 0, (String)"Rupture %s has no sections!", (int)r);
            if (shortSafe) {
                sectIDs = new short[numRupSects];
                for (i = 0; i < numRupSects; ++i) {
                    sectIDs[i] = (short)csvRow.getInt(col++);
                }
                rupSects = new ShortListWrapper((short[])sectIDs);
            } else {
                sectIDs = new int[numRupSects];
                for (i = 0; i < numRupSects; ++i) {
                    sectIDs[i] = csvRow.getInt(col++);
                }
                rupSects = new IntListWrapper((int[])sectIDs);
            }
            int rowSize = csvRow.getLine().size();
            while (col < rowSize) {
                String str = csvRow.get(col++);
                Preconditions.checkState((boolean)str.isBlank(), (String)"Rupture has %s sections, but data exists in %s column %s: %s", (Object)RUP_SECTS_FILE_NAME, (Object)col, (Object)str);
            }
            Iterator iterator = rupSects.iterator();
            while (iterator.hasNext()) {
                int sectID = (Integer)iterator.next();
                Preconditions.checkState((sectID >= 0 && sectID < numSections ? 1 : 0) != 0, (String)"Bad sectionID=%s for rupture %s", (int)sectID, (int)r);
            }
            rupSectsList.add(rupSects);
        }
        Preconditions.checkState((rupSectsCSV.read() == null ? 1 : 0) != 0, (Object)"Rupture CSV file has too many rows.");
        try {
            rupSectsCSV.close();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        return rupSectsList;
    }

    @Override
    public final void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        List<List<Integer>> rupSectsList;
        int numRuptures;
        if (this.verbose) {
            System.out.println("\tLoading ruptures CSV...");
        }
        CSVReader rupSectsCSV = LargeCSV_BackedModule.loadFromArchive(input, entryPrefix, RUP_SECTS_FILE_NAME);
        CSVFile<String> rupPropsCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, RUP_PROPS_FILE_NAME);
        List<GeoJSONFaultSection> sections = GeoJSONFaultReader.readFaultSections(new InputStreamReader(FileBackedModule.getInputStream(input, entryPrefix, SECTS_FILE_NAME)));
        for (int s = 0; s < sections.size(); ++s) {
            Preconditions.checkState((sections.get(s).getSectionId() == s ? 1 : 0) != 0, (Object)"Fault sections must be provided in order starting with ID=0");
        }
        if (this.verbose) {
            System.out.println("\tParsing rupture properties CSV");
        }
        RuptureProperties props = new RuptureProperties(rupPropsCSV);
        if (this.verbose) {
            System.out.println("\tParsing rupture sections CSV");
        }
        Preconditions.checkState(((numRuptures = (rupSectsList = FaultSystemRupSet.loadRupSectsCSV(rupSectsCSV, sections.size(), props.mags.length)).size()) > 0 ? 1 : 0) != 0, (Object)"No ruptures found in CSV file");
        Preconditions.checkState((numRuptures + 1 == rupPropsCSV.getNumRows() ? 1 : 0) != 0, (Object)"Rupture sections and properites CSVs have different lengths");
        this.init(sections, rupSectsList, props.mags, props.rakes, props.areas, props.lengths);
        boolean hasManifest = input.hasEntry(entryPrefix + "modules.json");
        if (this.archive != null) {
            boolean doLoad;
            if (input.hasEntry(entryPrefix + "sect_areas.csv") && !this.hasAvailableModule(SectAreas.Precomputed.class)) {
                boolean bl = doLoad = !hasManifest || this.getModule(SectAreas.class) instanceof SectAreas.Default;
                if (doLoad) {
                    try {
                        System.out.println("Trying to load unlisted precomputed SectAreas module");
                        this.archive.loadUnlistedModule(SectAreas.Precomputed.class, entryPrefix, this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (input.hasEntry(entryPrefix + "sect_slip_rates.csv") && !this.hasAvailableModule(SectSlipRates.Precomputed.class)) {
                boolean bl = doLoad = !hasManifest || this.getModule(SectSlipRates.class) instanceof SectSlipRates.Default;
                if (doLoad) {
                    try {
                        System.out.println("Trying to load unlisted SectSlipRates module");
                        this.archive.loadUnlistedModule(SectSlipRates.Precomputed.class, entryPrefix, this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (input.hasEntry(entryPrefix + "average_slips.csv") && !this.hasAvailableModule(AveSlipModule.class)) {
                try {
                    System.out.println("Trying to load unlisted AveSlipModule module");
                    this.archive.loadUnlistedModule(AveSlipModule.Precomputed.class, entryPrefix, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (input.hasEntry(entryPrefix + "tectonic_regimes.csv") && !this.hasAvailableModule(RupSetTectonicRegimes.class)) {
                try {
                    System.out.println("Trying to load unlisted RupSetTectonicRegimes module");
                    this.archive.loadUnlistedModule(RupSetTectonicRegimes.class, entryPrefix, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public final Class<? extends ArchivableModule> getLoadingClass() {
        return FaultSystemRupSet.class;
    }

    protected void init(FaultSystemRupSet rupSet) {
        this.init(rupSet.getFaultSectionDataList(), rupSet.getSectionIndicesForAllRups(), rupSet.getMagForAllRups(), rupSet.getAveRakeForAllRups(), rupSet.getAreaForAllRups(), rupSet.getLengthForAllRups());
        this.copyCacheFrom(rupSet);
        for (OpenSHA_Module module : rupSet.getModules(true)) {
            this.addModule(module);
        }
    }

    protected void init(List<? extends FaultSection> faultSectionData, List<List<Integer>> sectionForRups, double[] mags, double[] rakes, double[] rupAreas, double[] rupLengths) {
        Preconditions.checkNotNull(faultSectionData, (Object)"Fault Section Data cannot be null");
        int numSects = faultSectionData.size();
        for (int s = 0; s < numSects; ++s) {
            FaultSection sect = faultSectionData.get(s);
            Preconditions.checkNotNull((Object)sect, (String)"Section %s is null", (int)s);
            Preconditions.checkState((sect.getSectionId() == s ? 1 : 0) != 0, (String)"Section indexes and IDs must match. Instead, section %s has ID %s with name: %s", (Object)s, (Object)sect.getSectionId(), (Object)sect.getSectionName());
        }
        this.faultSectionData = faultSectionData;
        Preconditions.checkNotNull(faultSectionData, (Object)"Magnitudes cannot be null");
        this.mags = mags;
        int numRups = mags.length;
        Preconditions.checkArgument((rakes.length == numRups ? 1 : 0) != 0, (Object)"array sizes inconsistent!");
        this.rakes = rakes;
        Preconditions.checkArgument((rupAreas == null || rupAreas.length == numRups ? 1 : 0) != 0, (Object)"array sizes inconsistent!");
        this.rupAreas = rupAreas;
        Preconditions.checkArgument((rupLengths == null || rupLengths.length == numRups ? 1 : 0) != 0, (Object)"array sizes inconsistent!");
        if (rupLengths == null) {
            rupLengths = FaultSystemRupSet.rupLengthsDefault(faultSectionData, sectionForRups);
        }
        this.rupLengths = rupLengths;
        Preconditions.checkArgument((sectionForRups.size() == numRups ? 1 : 0) != 0, (Object)"array sizes inconsistent!");
        for (int r = 0; r < numRups; ++r) {
            for (int s : sectionForRups.get(r)) {
                Preconditions.checkState((s >= 0 && s < numSects ? 1 : 0) != 0, (String)"Bad sectIndex=%s in sectionForRups for rupIndex=%s", (int)s, (int)r);
            }
        }
        this.sectionForRups = sectionForRups;
        if (!this.hasAvailableModule(SectAreas.class)) {
            this.addAvailableModule((Callable<OpenSHA_Module>)new Callable<SectAreas>(){

                @Override
                public SectAreas call() throws Exception {
                    return SectAreas.fromFaultSectData(FaultSystemRupSet.this);
                }
            }, SectAreas.Default.class);
        }
        if (!this.hasAvailableModule(SectSlipRates.class)) {
            this.addAvailableModule((Callable<OpenSHA_Module>)new Callable<SectSlipRates>(){

                @Override
                public SectSlipRates call() throws Exception {
                    return SectSlipRates.fromFaultSectData(FaultSystemRupSet.this);
                }
            }, SectSlipRates.Default.class);
        }
        if (!this.hasAvailableModule(SlipAlongRuptureModel.class)) {
            this.addAvailableModule((Callable<OpenSHA_Module>)new Callable<SlipAlongRuptureModel>(){

                @Override
                public SlipAlongRuptureModel call() throws Exception {
                    LogicTreeBranch branch = FaultSystemRupSet.this.getModule(LogicTreeBranch.class);
                    if (branch != null && branch.hasValue(SlipAlongRuptureModelBranchNode.class)) {
                        return branch.getValue(SlipAlongRuptureModelBranchNode.class).getModel();
                    }
                    return new SlipAlongRuptureModel.Default();
                }
            }, SlipAlongRuptureModel.class);
        }
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void clearCache() {
        this.rupturesForSectionCache.clear();
        this.rupturesForParentSectionCache.clear();
        this.fractRupsInsideRegions.clear();
        this.fractSectsInsideRegions.clear();
    }

    public void copyCacheFrom(FaultSystemRupSet rupSet) {
        if (rupSet.getNumRuptures() != this.getNumRuptures() || rupSet.getNumSections() != this.getNumSections()) {
            return;
        }
        this.rupturesForSectionCache = rupSet.rupturesForSectionCache;
        this.rupturesForParentSectionCache = rupSet.rupturesForParentSectionCache;
        this.fractRupsInsideRegions = rupSet.fractRupsInsideRegions;
        this.fractSectsInsideRegions = rupSet.fractSectsInsideRegions;
    }

    public int getNumRuptures() {
        return this.mags.length;
    }

    public int getNumSections() {
        return this.faultSectionData.size();
    }

    public List<List<Integer>> getSectionIndicesForAllRups() {
        return this.sectionForRups;
    }

    public List<Integer> getSectionsIndicesForRup(int rupIndex) {
        return this.sectionForRups.get(rupIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitMagsCaches() {
        if (this.minMagsCache == null) {
            FaultSystemRupSet faultSystemRupSet = this;
            synchronized (faultSystemRupSet) {
                if (this.minMagsCache == null) {
                    double[] mins = new double[this.getNumSections()];
                    for (int s = 0; s < mins.length; ++s) {
                        mins[s] = Double.POSITIVE_INFINITY;
                    }
                    double[] maxs = new double[this.getNumSections()];
                    for (int rupIndex = 0; rupIndex < this.getNumRuptures(); ++rupIndex) {
                        double mag = this.getMagForRup(rupIndex);
                        for (int sectIndex : this.getSectionsIndicesForRup(rupIndex)) {
                            if (mag > maxs[sectIndex]) {
                                maxs[sectIndex] = mag;
                            }
                            if (!(mag < mins[sectIndex])) continue;
                            mins[sectIndex] = mag;
                        }
                    }
                    for (int s = 0; s < mins.length; ++s) {
                        if (!Double.isInfinite(mins[s])) continue;
                        mins[s] = Double.NaN;
                        maxs[s] = Double.NaN;
                    }
                    this.maxMagsCache = maxs;
                    this.minMagsCache = mins;
                }
            }
        }
    }

    public double getMaxMagForSection(int sectIndex) {
        this.checkInitMagsCaches();
        return this.maxMagsCache[sectIndex];
    }

    public double getMinMagForSection(int sectIndex) {
        this.checkInitMagsCaches();
        return this.minMagsCache[sectIndex];
    }

    public double[] getMagForAllRups() {
        return this.mags;
    }

    public double getMagForRup(int rupIndex) {
        return this.mags[rupIndex];
    }

    public double[] getAveRakeForAllRups() {
        return this.rakes;
    }

    public double getAveRakeForRup(int rupIndex) {
        return this.rakes[rupIndex];
    }

    public double[] getAreaForAllRups() {
        return this.rupAreas;
    }

    public double getAreaForRup(int rupIndex) {
        return this.rupAreas[rupIndex];
    }

    private SectAreas getSectAreas() {
        if (!this.hasModule(SectAreas.class)) {
            this.addModule(SectAreas.fromFaultSectData(this));
        }
        return this.requireModule(SectAreas.class);
    }

    public double[] getAreaForAllSections() {
        return this.getSectAreas().getSectAreas();
    }

    public double getAreaForSection(int sectIndex) {
        return this.getSectAreas().getSectArea(sectIndex);
    }

    public List<? extends FaultSection> getFaultSectionDataList() {
        return this.faultSectionData;
    }

    public FaultSection getFaultSectionData(int sectIndex) {
        return this.faultSectionData.get(sectIndex);
    }

    public List<FaultSection> getFaultSectionDataForRupture(int rupIndex) {
        List<Integer> inds = this.getSectionsIndicesForRup(rupIndex);
        ArrayList<FaultSection> datas = new ArrayList<FaultSection>(inds.size());
        for (int ind : inds) {
            datas.add(this.getFaultSectionData(ind));
        }
        return datas;
    }

    public RuptureSurface getSurfaceForRupture(int rupIndex, double gridSpacing) {
        return this.getSurfaceForRupture(rupIndex, gridSpacing, true);
    }

    public RuptureSurface getSurfaceForRupture(int rupIndex, double gridSpacing, boolean aseisReducesArea) {
        return this.surfCache.getSurfaceForRupture(rupIndex, gridSpacing, aseisReducesArea);
    }

    public double[] getLengthForAllRups() {
        return this.rupLengths;
    }

    public double getLengthForRup(int rupIndex) {
        return this.rupLengths[rupIndex];
    }

    public double getAveWidthForRup(int rupIndex) {
        return this.getAreaForRup(rupIndex) / this.getLengthForRup(rupIndex);
    }

    public SectSlipRates getSectSlipRates() {
        if (!this.hasModule(SectSlipRates.class)) {
            this.addModule(SectSlipRates.fromFaultSectData(this));
        }
        return this.requireModule(SectSlipRates.class);
    }

    public double getSlipRateForSection(int sectIndex) {
        return this.getSectSlipRates().getSlipRate(sectIndex);
    }

    public double[] getSlipRateForAllSections() {
        return this.getSectSlipRates().getSlipRates();
    }

    public double getSlipRateStdDevForSection(int sectIndex) {
        return this.getSectSlipRates().getSlipRateStdDev(sectIndex);
    }

    public double[] getSlipRateStdDevForAllSections() {
        return this.getSectSlipRates().getSlipRateStdDevs();
    }

    public String getInfoString() {
        InfoModule info = this.getModule(InfoModule.class);
        if (info != null) {
            return info.getText();
        }
        return null;
    }

    public void setInfoString(String info) {
        if (info == null) {
            this.removeModuleInstances(InfoModule.class);
        } else {
            this.addModule(new InfoModule(info));
        }
    }

    public double[] getFractSectsInsideRegion(Region region, boolean traceOnly) {
        return this.getFractSectsInsideRegion(region, traceOnly, new int[this.getNumSections()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getFractSectsInsideRegion(Region region, boolean traceOnly, int[] numPtsInSection) {
        double[] fractSectsInside;
        Table<Region, Boolean, double[]> table = this.fractSectsInsideRegions;
        synchronized (table) {
            int[] cachedPtsInSection;
            fractSectsInside = (double[])this.fractSectsInsideRegions.get((Object)region, (Object)traceOnly);
            int[] nArray = cachedPtsInSection = traceOnly ? this.sectNumPtsTraceOnly : this.sectNumPtsFull;
            if (cachedPtsInSection == null) {
                fractSectsInside = null;
            } else if (fractSectsInside != null) {
                Preconditions.checkState((numPtsInSection.length == cachedPtsInSection.length ? 1 : 0) != 0);
                System.arraycopy(cachedPtsInSection, 0, numPtsInSection, 0, cachedPtsInSection.length);
            }
        }
        if (fractSectsInside == null) {
            table = this.fractSectsInsideRegions;
            synchronized (table) {
                if (this.fractSectsInsideRegions.size() > 50) {
                    Set cells = this.fractSectsInsideRegions.cellSet();
                    cells.remove(cells.iterator().next());
                }
            }
            fractSectsInside = new double[this.getNumSections()];
            double gridSpacing = 1.0;
            for (int s = 0; s < this.getNumSections(); ++s) {
                RuptureSurface surf = this.getFaultSectionData(s).getFaultSurface(gridSpacing, false, true);
                if (traceOnly) {
                    FaultTrace trace = surf.getEvenlyDiscritizedUpperEdge();
                    numPtsInSection[s] = trace.size();
                    fractSectsInside[s] = RegionUtils.getFractionInside(region, trace);
                    continue;
                }
                LocationList surfLocs = surf.getEvenlyDiscritizedListOfLocsOnSurface();
                numPtsInSection[s] = surfLocs.size();
                fractSectsInside[s] = RegionUtils.getFractionInside(region, surfLocs);
            }
            Table<Region, Boolean, double[]> table2 = this.fractSectsInsideRegions;
            synchronized (table2) {
                this.fractSectsInsideRegions.put((Object)region, (Object)traceOnly, (Object)fractSectsInside);
                if (traceOnly) {
                    this.sectNumPtsTraceOnly = Arrays.copyOf(numPtsInSection, numPtsInSection.length);
                } else {
                    this.sectNumPtsFull = Arrays.copyOf(numPtsInSection, numPtsInSection.length);
                }
            }
        }
        return fractSectsInside;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getFractRupsInsideRegion(Region region, boolean traceOnly) {
        double[] fractRupsInside;
        if (region == null) {
            double[] ret = new double[this.getNumRuptures()];
            for (int r = 0; r < ret.length; ++r) {
                ret[r] = 1.0;
            }
            return ret;
        }
        Table<Region, Boolean, double[]> r = this.fractRupsInsideRegions;
        synchronized (r) {
            fractRupsInside = (double[])this.fractRupsInsideRegions.get((Object)region, (Object)traceOnly);
        }
        if (fractRupsInside == null) {
            r = this.fractRupsInsideRegions;
            synchronized (r) {
                if (this.fractRupsInsideRegions.size() > 10) {
                    Set cells = this.fractRupsInsideRegions.cellSet();
                    cells.remove(cells.iterator().next());
                }
            }
            int[] numPtsInSection = new int[this.getNumSections()];
            double[] fractSectsInside = this.getFractSectsInsideRegion(region, traceOnly, numPtsInSection);
            int numRuptures = this.getNumRuptures();
            fractRupsInside = new double[numRuptures];
            int rup = 0;
            while (rup < numRuptures) {
                List<Integer> sectionsIndicesForRup = this.getSectionsIndicesForRup(rup);
                int totNumPts = 0;
                for (Integer s : sectionsIndicesForRup) {
                    int n = rup;
                    fractRupsInside[n] = fractRupsInside[n] + fractSectsInside[s] * (double)numPtsInSection[s];
                    totNumPts += numPtsInSection[s];
                }
                int n = rup++;
                fractRupsInside[n] = fractRupsInside[n] / (double)totNumPts;
            }
            Table<Region, Boolean, double[]> table = this.fractRupsInsideRegions;
            synchronized (table) {
                this.fractRupsInsideRegions.put((Object)region, (Object)traceOnly, (Object)fractRupsInside);
            }
        }
        return fractRupsInside;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Integer> getRupturesForSection(int secIndex) {
        if (this.rupturesForSectionCache == null) {
            FaultSystemRupSet faultSystemRupSet = this;
            synchronized (faultSystemRupSet) {
                if (this.rupturesForSectionCache != null) {
                    return this.rupturesForSectionCache.get(secIndex);
                }
                CalcProgressBar p = null;
                if (this.showProgress) {
                    p = new CalcProgressBar("Calculating Ruptures for each Section", "Calculating Ruptures for each Section");
                }
                int numSects = this.getNumSections();
                ArrayList<List<Integer>> rupturesForSectionCache = new ArrayList<List<Integer>>(numSects);
                for (int secID = 0; secID < numSects; ++secID) {
                    rupturesForSectionCache.add(new ArrayList());
                }
                int numRups = this.getNumRuptures();
                for (int rupID = 0; rupID < numRups; ++rupID) {
                    if (p != null) {
                        p.updateProgress(rupID, numRups);
                    }
                    for (int secID : this.getSectionsIndicesForRup(rupID)) {
                        rupturesForSectionCache.get(secID).add(rupID);
                    }
                }
                for (int i = 0; i < rupturesForSectionCache.size(); ++i) {
                    rupturesForSectionCache.set(i, Collections.unmodifiableList(rupturesForSectionCache.get(i)));
                }
                this.rupturesForSectionCache = rupturesForSectionCache;
                if (p != null) {
                    p.dispose();
                }
            }
        }
        return this.rupturesForSectionCache.get(secIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Integer> getRupturesForParentSection(int parentSectID) {
        if (this.rupturesForParentSectionCache == null) {
            FaultSystemRupSet faultSystemRupSet = this;
            synchronized (faultSystemRupSet) {
                if (this.rupturesForParentSectionCache != null) {
                    return this.rupturesForParentSectionCache.get(parentSectID);
                }
                CalcProgressBar p = null;
                if (this.showProgress) {
                    p = new CalcProgressBar("Calculating Ruptures for each Parent Section", "Calculating Ruptures for each Parent Section");
                }
                ConcurrentMap rupturesForParentSectionCache = Maps.newConcurrentMap();
                int numRups = this.getNumRuptures();
                for (int rupID = 0; rupID < numRups; ++rupID) {
                    if (p != null) {
                        p.updateProgress(rupID, numRups);
                    }
                    int prevParent = -1;
                    for (int secID : this.getSectionsIndicesForRup(rupID)) {
                        int parent = this.getFaultSectionData(secID).getParentSectionId();
                        if (parent < 0 || parent == prevParent) continue;
                        ArrayList<Integer> rupsForParent = (ArrayList<Integer>)rupturesForParentSectionCache.get(parent);
                        if (rupsForParent == null) {
                            rupsForParent = new ArrayList<Integer>();
                            rupturesForParentSectionCache.put(parent, rupsForParent);
                        }
                        if (rupsForParent.isEmpty() || (Integer)rupsForParent.get(rupsForParent.size() - 1) != rupID) {
                            rupsForParent.add(rupID);
                        }
                        prevParent = parent;
                    }
                }
                for (Integer key : rupturesForParentSectionCache.keySet()) {
                    rupturesForParentSectionCache.put(key, Collections.unmodifiableList((List)rupturesForParentSectionCache.get(key)));
                }
                if (p != null) {
                    p.dispose();
                }
                this.rupturesForParentSectionCache = rupturesForParentSectionCache;
            }
        }
        return this.rupturesForParentSectionCache.get(parentSectID);
    }

    public final List<Integer> getParentSectionsForRup(int rupIndex) {
        ArrayList parents = Lists.newArrayList();
        for (int sectIndex : this.getSectionsIndicesForRup(rupIndex)) {
            int parent = this.getFaultSectionData(sectIndex).getParentSectionId();
            if (parents.contains(parent)) continue;
            parents.add(parent);
        }
        return parents;
    }

    public double getMaxMag() {
        return StatUtils.max((double[])this.getMagForAllRups());
    }

    public double getMinMag() {
        return StatUtils.min((double[])this.getMagForAllRups());
    }

    public boolean isEquivalentTo(FaultSystemRupSet other) {
        if (!this.areSectionsEquivalentTo(other)) {
            return false;
        }
        if (this.getNumRuptures() != other.getNumRuptures()) {
            return false;
        }
        for (int r = 0; r < this.getNumRuptures(); ++r) {
            List<Integer> oSects;
            List<Integer> mySects = this.getSectionsIndicesForRup(r);
            if (mySects.equals(oSects = other.getSectionsIndicesForRup(r))) continue;
            return false;
        }
        return true;
    }

    public boolean areSectionsEquivalentTo(FaultSystemRupSet other) {
        return this.areSectionsEquivalentTo(other.getFaultSectionDataList());
    }

    public boolean areSectionsEquivalentTo(List<? extends FaultSection> sects) {
        if (this.getNumSections() != sects.size()) {
            return false;
        }
        for (int s = 0; s < this.getNumSections(); ++s) {
            FaultSection mySect = this.getFaultSectionData(s);
            FaultSection oSect = sects.get(s);
            if (mySect.getParentSectionId() != oSect.getParentSectionId()) {
                return false;
            }
            if (mySect.getSectionName().equals(oSect.getSectionName())) continue;
            return false;
        }
        return true;
    }

    public FaultSystemRupSet getForSectionSubSet(Collection<Integer> retainedSectIDs) throws IllegalStateException {
        return this.getForSectionSubSet(retainedSectIDs, null);
    }

    public FaultSystemRupSet getForSectionSubSet(Collection<Integer> retainedSectIDs, RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExclusionModel) throws IllegalStateException {
        ArrayList<FaultSection> remappedSects = new ArrayList<FaultSection>();
        int sectIndex = 0;
        HashBiMap sectIDs_newToOld = HashBiMap.create((int)retainedSectIDs.size());
        for (int origID = 0; origID < this.faultSectionData.size(); ++origID) {
            if (!retainedSectIDs.contains(origID)) continue;
            FaultSection remappedSect = this.faultSectionData.get(origID).clone();
            remappedSect.setSectionId(sectIndex);
            remappedSects.add(remappedSect);
            sectIDs_newToOld.put((Object)sectIndex, (Object)origID);
            ++sectIndex;
        }
        System.out.println("Building rupture sub-set, retaining " + sectIDs_newToOld.size() + "/" + this.getNumSections() + " sections");
        int rupIndex = 0;
        HashBiMap rupIDs_newToOld = HashBiMap.create((int)retainedSectIDs.size());
        ClusterRuptures cRups = rupExclusionModel == null ? null : this.requireModule(ClusterRuptures.class);
        for (int origID = 0; origID < this.getNumRuptures(); ++origID) {
            if (rupExclusionModel != null && !rupExclusionModel.isRupAllowed(cRups.get(origID), false)) continue;
            boolean allRetained = true;
            boolean anyRetained = false;
            for (int s : this.sectionForRups.get(origID)) {
                boolean sectRetained = retainedSectIDs.contains(s);
                allRetained = allRetained && sectRetained;
                anyRetained = anyRetained || sectRetained;
            }
            Preconditions.checkState((anyRetained == allRetained ? 1 : 0) != 0, (String)"Rupture %s involves sections that are retained and excluded in the rupture subset, can only build subsets for independent clusters of sections.", (int)origID);
            if (!anyRetained) continue;
            rupIDs_newToOld.put((Object)rupIndex++, (Object)origID);
        }
        System.out.println("Retaining " + rupIDs_newToOld.size() + "/" + this.getNumRuptures() + " ruptures");
        boolean shortSafe = sectIDs_newToOld.size() < Short.MAX_VALUE;
        double[] modMags = new double[rupIndex];
        double[] modRakes = new double[rupIndex];
        double[] modRupAreas = new double[rupIndex];
        double[] modRupLengths = this.rupLengths == null ? null : new double[rupIndex];
        ArrayList<List<Integer>> modSectionForRups = new ArrayList<List<Integer>>();
        BiMap sectIDs_oldToNew = sectIDs_newToOld.inverse();
        for (rupIndex = 0; rupIndex < rupIDs_newToOld.size(); ++rupIndex) {
            int origID = (Integer)rupIDs_newToOld.get((Object)rupIndex);
            modMags[rupIndex] = this.mags[origID];
            modRakes[rupIndex] = this.rakes[origID];
            modRupAreas[rupIndex] = this.rupAreas[origID];
            if (modRupLengths != null) {
                modRupLengths[rupIndex] = this.rupLengths[origID];
            }
            ArrayList<Integer> sectForRup = new ArrayList<Integer>();
            Iterator<Object> iterator = this.sectionForRups.get(origID).iterator();
            while (iterator.hasNext()) {
                int origSectIndex = (Integer)iterator.next();
                Integer newSectID = (Integer)sectIDs_oldToNew.get((Object)origSectIndex);
                Preconditions.checkNotNull((Object)newSectID, (String)"Rupture (newID=%s, oldID=%s) uses origSectID=%s which is not retained", (Object)rupIndex, (Object)origID, (Object)origID);
                sectForRup.add(newSectID);
            }
            if (shortSafe) {
                modSectionForRups.add(new ShortListWrapper(sectForRup));
                continue;
            }
            modSectionForRups.add(new IntListWrapper(sectForRup));
        }
        FaultSystemRupSet modRupSet = new FaultSystemRupSet(remappedSects, modSectionForRups, modMags, modRakes, modRupAreas, modRupLengths);
        RuptureSubSetMappings mappings = new RuptureSubSetMappings((BiMap<Integer, Integer>)sectIDs_newToOld, (BiMap<Integer, Integer>)rupIDs_newToOld, this);
        modRupSet.addModule(mappings);
        for (OpenSHA_Module module : this.getModulesAssignableTo(SplittableRuptureModule.class, true)) {
            Object modModule = ((SplittableRuptureModule)module).getForRuptureSubSet(modRupSet, mappings);
            if (modModule == null) continue;
            modRupSet.addModule(modModule);
        }
        return modRupSet;
    }

    public FaultSystemRupSet getForRuptureSubSet(Collection<Integer> retainedRuptureIDs) throws IllegalStateException {
        Preconditions.checkState((!retainedRuptureIDs.isEmpty() ? 1 : 0) != 0, (Object)"Must retain at least 1 rupture");
        System.out.println("Building rupture sub-set, retaining " + retainedRuptureIDs.size() + "/" + this.getNumRuptures() + " ruptures");
        int rupIndex = 0;
        HashBiMap rupIDs_newToOld = HashBiMap.create((int)retainedRuptureIDs.size());
        for (int origID = 0; origID < this.getNumRuptures(); ++origID) {
            if (!retainedRuptureIDs.contains(origID)) continue;
            rupIDs_newToOld.put((Object)rupIndex++, (Object)origID);
        }
        Preconditions.checkState((rupIDs_newToOld.size() == retainedRuptureIDs.size() ? 1 : 0) != 0, (Object)"Retained IDs mismatch?");
        HashBiMap sectIDs_newToOld = HashBiMap.create((int)this.getNumSections());
        for (int s = 0; s < this.getNumSections(); ++s) {
            sectIDs_newToOld.put((Object)s, (Object)s);
        }
        double[] modMags = new double[rupIndex];
        double[] modRakes = new double[rupIndex];
        double[] modRupAreas = new double[rupIndex];
        double[] modRupLengths = this.rupLengths == null ? null : new double[rupIndex];
        ArrayList<List<Integer>> modSectionForRups = new ArrayList<List<Integer>>();
        for (rupIndex = 0; rupIndex < rupIDs_newToOld.size(); ++rupIndex) {
            int origID = (Integer)rupIDs_newToOld.get((Object)rupIndex);
            modMags[rupIndex] = this.mags[origID];
            modRakes[rupIndex] = this.rakes[origID];
            modRupAreas[rupIndex] = this.rupAreas[origID];
            if (modRupLengths != null) {
                modRupLengths[rupIndex] = this.rupLengths[origID];
            }
            modSectionForRups.add(this.getSectionsIndicesForRup(rupIndex));
        }
        FaultSystemRupSet modRupSet = new FaultSystemRupSet(this.getFaultSectionDataList(), modSectionForRups, modMags, modRakes, modRupAreas, modRupLengths);
        RuptureSubSetMappings mappings = new RuptureSubSetMappings((BiMap<Integer, Integer>)sectIDs_newToOld, (BiMap<Integer, Integer>)rupIDs_newToOld, this);
        modRupSet.addModule(mappings);
        for (OpenSHA_Module module : this.getModulesAssignableTo(SplittableRuptureModule.class, true)) {
            Object modModule = ((SplittableRuptureModule)module).getForRuptureSubSet(modRupSet, mappings);
            if (modModule == null) continue;
            modRupSet.addModule(modModule);
        }
        return modRupSet;
    }

    public static Builder buildFromExisting(FaultSystemRupSet rupSet) {
        return FaultSystemRupSet.buildFromExisting(rupSet, true);
    }

    public static Builder buildFromExisting(FaultSystemRupSet rupSet, boolean copyModules) {
        Builder builder = new Builder(rupSet.faultSectionData, rupSet.sectionForRups, rupSet.mags, rupSet.rakes, rupSet.rupAreas, rupSet.rupLengths);
        if (copyModules) {
            for (OpenSHA_Module module : rupSet.getModules(true)) {
                builder.addModule(module);
            }
        }
        return builder;
    }

    public static Builder builder(List<? extends FaultSection> faultSectionData, List<List<Integer>> sectionForRups) {
        return new Builder(faultSectionData, sectionForRups);
    }

    public static Builder builderForClusterRups(List<? extends FaultSection> faultSectionData, List<ClusterRupture> rups) {
        boolean shortSafe;
        ArrayList<List<Integer>> sectionForRups = new ArrayList<List<Integer>>();
        boolean bl = shortSafe = faultSectionData.get(faultSectionData.size() - 1).getSectionId() < Short.MAX_VALUE;
        if (shortSafe) {
            for (ClusterRupture rup : rups) {
                List<FaultSection> sections = rup.buildOrderedSectionList();
                short[] ids = new short[sections.size()];
                for (int s = 0; s < ids.length; ++s) {
                    ids[s] = (short)sections.get(s).getSectionId();
                }
                sectionForRups.add(new ShortListWrapper(ids));
            }
        } else {
            for (ClusterRupture rup : rups) {
                List<FaultSection> sections = rup.buildOrderedSectionList();
                int[] ids = new int[sections.size()];
                for (int s = 0; s < ids.length; ++s) {
                    ids[s] = sections.get(s).getSectionId();
                }
                sectionForRups.add(new IntListWrapper(ids));
            }
        }
        Builder builder = new Builder(faultSectionData, sectionForRups);
        builder.setClusterRuptures(rups);
        return builder;
    }

    private static <E extends OpenSHA_Module> Callable<E> builderCallable(final FaultSystemRupSet rupSet, final ModuleBuilder builder, Class<E> clazz) {
        return new Callable<E>(){

            @Override
            public E call() throws Exception {
                return builder.build(rupSet);
            }
        };
    }

    private static double[] rupLengthsDefault(List<? extends FaultSection> faultSectionData, List<List<Integer>> sectionForRups) {
        int numRups = sectionForRups.size();
        double[] rupLengths = new double[numRups];
        for (int r = 0; r < numRups; ++r) {
            for (int s : sectionForRups.get(r)) {
                FaultSection sect = faultSectionData.get(s);
                double length = sect.getTraceLength() * 1000.0;
                int n = r;
                rupLengths[n] = rupLengths[n] + length;
            }
        }
        return rupLengths;
    }

    public static void main(String[] args) throws Exception {
        InversionFaultSystemRupSet rupSet = InversionFaultSystemRupSetFactory.forBranch(U3LogicTreeBranch.DEFAULT);
        File destFile = new File("/tmp/new_ivfrs.zip");
        rupSet.getArchive().write(destFile);
        FaultSystemRupSet loaded = FaultSystemRupSet.load(destFile);
        loaded.loadAllAvailableModules();
        System.out.println(loaded.getModule(U3LogicTreeBranch.class));
    }

    private class RupSurfaceCache {
        private double prevGridSpacing = Double.NaN;
        private boolean prevAseisReducesArea = false;
        private Map<Integer, RuptureSurface> rupSurfaceCache;

        private RupSurfaceCache() {
        }

        private synchronized RuptureSurface getSurfaceForRupture(int rupIndex, double gridSpacing, boolean aseisReducesArea) {
            RuptureSurface surf;
            if (this.rupSurfaceCache == null) {
                this.rupSurfaceCache = new HashMap<Integer, RuptureSurface>();
            }
            if (this.prevGridSpacing != gridSpacing || aseisReducesArea != this.prevAseisReducesArea) {
                this.rupSurfaceCache.clear();
                this.prevGridSpacing = gridSpacing;
                this.prevAseisReducesArea = aseisReducesArea;
            }
            if ((surf = this.rupSurfaceCache.get(rupIndex)) != null) {
                return surf;
            }
            List<FaultSection> fltDatas = FaultSystemRupSet.this.getFaultSectionDataForRupture(rupIndex);
            ArrayList<RuptureSurface> rupSurfs = new ArrayList<RuptureSurface>(fltDatas.size());
            for (FaultSection fltData : fltDatas) {
                rupSurfs.add(fltData.getFaultSurface(gridSpacing, false, aseisReducesArea));
            }
            surf = rupSurfs.size() == 1 ? (RuptureSurface)rupSurfs.get(0) : new CompoundSurface(rupSurfs);
            this.rupSurfaceCache.put(rupIndex, surf);
            return surf;
        }
    }

    public static class RuptureProperties {
        public final double[] mags;
        public final double[] rakes;
        public final double[] areas;
        public final double[] lengths;

        public RuptureProperties(CSVFile<String> rupPropsCSV) {
            int numRuptures = rupPropsCSV.getNumRows() - 1;
            double[] mags = new double[numRuptures];
            double[] rakes = new double[numRuptures];
            double[] areas = new double[numRuptures];
            double[] lengths = null;
            for (int r = 0; r < numRuptures; ++r) {
                int row = r + 1;
                int col = 0;
                Preconditions.checkState((r == rupPropsCSV.getInt(row, col++) ? 1 : 0) != 0, (String)"Ruptures out of order or not 0-based in CSV file, expected id=%s at row %s", (int)r, (int)row);
                mags[r] = rupPropsCSV.getDouble(row, col++);
                rakes[r] = rupPropsCSV.getDouble(row, col++);
                areas[r] = rupPropsCSV.getDouble(row, col++);
                String lenStr = rupPropsCSV.get(row, col++);
                if (r == 0 && !lenStr.isBlank()) {
                    lengths = new double[numRuptures];
                    lengths[r] = Double.parseDouble(lenStr);
                    continue;
                }
                if (lengths != null) {
                    lengths[r] = Double.parseDouble(lenStr);
                    continue;
                }
                Preconditions.checkState((boolean)lenStr.isBlank(), (String)"Rupture lenghts must be populated for all ruptures, or omitted for all. We have a length for rupture %s but the first rupture did not have a length.", (int)r);
            }
            this.mags = mags;
            this.rakes = rakes;
            this.areas = areas;
            this.lengths = lengths;
        }

        public RuptureProperties(FaultSystemRupSet rupSet) {
            int numRuptures = rupSet.getNumRuptures();
            this.mags = new double[numRuptures];
            this.rakes = new double[numRuptures];
            this.areas = new double[numRuptures];
            this.lengths = rupSet.getLengthForAllRups();
            for (int r = 0; r < numRuptures; ++r) {
                this.mags[r] = rupSet.getMagForRup(r);
                this.rakes[r] = rupSet.getAveRakeForRup(r);
                this.areas[r] = rupSet.getAreaForRup(r);
            }
        }

        public void buildCSV(CSVWriter writer) throws IOException {
            ArrayList<String> header = new ArrayList<String>(List.of("Rupture Index", "Magnitude", "Average Rake (degrees)", "Area (m^2)", "Length (m)"));
            writer.write(header);
            for (int r = 0; r < this.mags.length; ++r) {
                ArrayList<String> line = new ArrayList<String>(5);
                line.add("" + r);
                line.add("" + this.mags[r]);
                line.add("" + this.rakes[r]);
                line.add("" + this.areas[r]);
                if (this.lengths == null) {
                    line.add("");
                } else {
                    line.add("" + this.lengths[r]);
                }
                writer.write(line);
            }
            writer.flush();
        }
    }

    public static class ShortListWrapper
    extends AbstractList<Integer> {
        private short[] vals;

        public ShortListWrapper(List<Integer> ints) {
            this.vals = new short[ints.size()];
            for (int i = 0; i < this.vals.length; ++i) {
                int val = ints.get(i);
                Preconditions.checkState((val < Short.MAX_VALUE ? 1 : 0) != 0);
                this.vals[i] = (short)val;
            }
        }

        public ShortListWrapper(short[] vals) {
            this.vals = vals;
        }

        @Override
        public Integer get(int index) {
            return this.vals[index];
        }

        @Override
        public int size() {
            this.equals(null);
            return this.vals.length;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            List oList = (List)o;
            if (this.size() != oList.size()) {
                return false;
            }
            if (this.size() == 0) {
                return true;
            }
            if (!Integer.class.isAssignableFrom(oList.get(0).getClass())) {
                return false;
            }
            for (int i = 0; i < this.vals.length; ++i) {
                if (this.vals[i] == (Integer)oList.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    public static class IntListWrapper
    extends AbstractList<Integer> {
        private int[] vals;

        public IntListWrapper(List<Integer> ints) {
            this.vals = new int[ints.size()];
            for (int i = 0; i < this.vals.length; ++i) {
                this.vals[i] = ints.get(i);
            }
        }

        public IntListWrapper(int[] vals) {
            this.vals = vals;
        }

        @Override
        public Integer get(int index) {
            return this.vals[index];
        }

        @Override
        public int size() {
            this.equals(null);
            return this.vals.length;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            List oList = (List)o;
            if (this.size() != oList.size()) {
                return false;
            }
            if (this.size() == 0) {
                return true;
            }
            if (!Integer.class.isAssignableFrom(oList.get(0).getClass())) {
                return false;
            }
            for (int i = 0; i < this.vals.length; ++i) {
                if (this.vals[i] == (Integer)oList.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Builder {
        private List<? extends FaultSection> faultSectionData;
        private double[] mags;
        private double[] rakes;
        private double[] rupAreas;
        private double[] rupLengths;
        private List<List<Integer>> sectionForRups;
        private List<ModuleBuilder> modules;

        private Builder(List<? extends FaultSection> faultSectionData, List<List<Integer>> sectionForRups) {
            Preconditions.checkState((faultSectionData != null && !faultSectionData.isEmpty() ? 1 : 0) != 0, (Object)"Must supply fault sections");
            this.faultSectionData = faultSectionData;
            Preconditions.checkState((sectionForRups != null && !sectionForRups.isEmpty() ? 1 : 0) != 0, (Object)"Must supply ruptures");
            this.sectionForRups = sectionForRups;
            this.modules = new ArrayList<ModuleBuilder>();
        }

        private Builder(List<? extends FaultSection> faultSectionData, List<List<Integer>> sectionForRups, @Nullable double[] mags, @Nullable double[] rakes, @Nullable double[] rupAreas, @Nullable double[] rupLengths) {
            Preconditions.checkState((faultSectionData != null && !faultSectionData.isEmpty() ? 1 : 0) != 0, (Object)"Must supply fault sections");
            this.faultSectionData = faultSectionData;
            this.mags = mags;
            this.rakes = rakes;
            this.rupAreas = rupAreas;
            this.rupLengths = rupLengths;
            Preconditions.checkState((sectionForRups != null && !sectionForRups.isEmpty() ? 1 : 0) != 0, (Object)"Must supply ruptures");
            this.sectionForRups = sectionForRups;
            this.modules = new ArrayList<ModuleBuilder>();
        }

        public Builder info(String info) {
            this.addModule(new InfoModule(info));
            return this;
        }

        public Builder setClusterRuptures(final List<ClusterRupture> rups) {
            this.addModule(new ModuleBuilder(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public OpenSHA_Module build(FaultSystemRupSet rupSet) {
                    return ClusterRuptures.instance(rupSet, rups);
                }

                @Override
                public Class<? extends OpenSHA_Module> getType() {
                    return ClusterRuptures.class;
                }
            });
            return this;
        }

        public Builder replaceFaultSections(List<? extends FaultSection> newSects) {
            Preconditions.checkState((newSects.size() == this.faultSectionData.size() ? 1 : 0) != 0);
            this.faultSectionData = newSects;
            this.rupAreas = null;
            return this;
        }

        private void checkBuildRakesAndAreas() {
            if (this.rakes == null || this.rupAreas == null) {
                int r2;
                double[] rakes = this.rakes;
                double[] rupAreas = this.rupAreas;
                int numRups = this.sectionForRups.size();
                if (rakes == null) {
                    rakes = new double[numRups];
                    for (r2 = 0; r2 < numRups; ++r2) {
                        rakes[r2] = Double.NaN;
                    }
                }
                if (rupAreas == null) {
                    rupAreas = new double[numRups];
                    for (r2 = 0; r2 < numRups; ++r2) {
                        rupAreas[r2] = Double.NaN;
                    }
                }
                double[] finalRakes = rakes;
                double[] finalRupAreas = rupAreas;
                IntStream.range(0, numRups).parallel().forEach(r -> {
                    ArrayList<Double> mySectAreas = new ArrayList<Double>();
                    ArrayList<Double> mySectRakes = new ArrayList<Double>();
                    double totArea = 0.0;
                    for (int s : this.sectionForRups.get(r)) {
                        FaultSection sect = this.faultSectionData.get(s);
                        double area = sect.getArea(true);
                        totArea += area;
                        mySectAreas.add(area);
                        mySectRakes.add(sect.getAveRake());
                    }
                    if (Double.isNaN(finalRupAreas[r])) {
                        finalRupAreas[r] = totArea;
                    }
                    if (Double.isNaN(finalRakes[r])) {
                        finalRakes[r] = FaultUtils.getInRakeRange(FaultUtils.getScaledAngleAverage(mySectAreas, mySectRakes));
                    }
                });
                this.rakes = rakes;
                this.rupAreas = rupAreas;
            }
        }

        private void checkBuildLengths() {
            if (this.rupLengths == null) {
                this.rupLengths(FaultSystemRupSet.rupLengthsDefault(this.faultSectionData, this.sectionForRups));
            }
        }

        public Builder forScalingRelationship(final RupSetScalingRelationship scale) {
            this.mags = new double[this.sectionForRups.size()];
            this.checkBuildRakesAndAreas();
            this.checkBuildLengths();
            for (int r = 0; r < this.mags.length; ++r) {
                double totOrigArea = 0.0;
                for (int s : this.sectionForRups.get(r)) {
                    FaultSection sect = this.faultSectionData.get(s);
                    totOrigArea += sect.getArea(false);
                }
                double origDDW = totOrigArea / this.rupLengths[r];
                this.mags[r] = scale.getMag(this.rupAreas[r], this.rupLengths[r], this.rupAreas[r] / this.rupLengths[r], origDDW, this.rakes[r]);
            }
            this.modules.add(new ModuleBuilder(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public OpenSHA_Module build(FaultSystemRupSet rupSet) {
                    return AveSlipModule.forModel(rupSet, scale);
                }

                @Override
                public Class<? extends OpenSHA_Module> getType() {
                    return AveSlipModule.class;
                }
            });
            return this;
        }

        public Builder tectonicRegime(final TectonicRegionType regime) {
            this.modules.add(new ModuleBuilder(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public OpenSHA_Module build(FaultSystemRupSet rupSet) {
                    return RupSetTectonicRegimes.constant(rupSet, regime);
                }

                @Override
                public Class<? extends OpenSHA_Module> getType() {
                    return RupSetTectonicRegimes.class;
                }
            });
            return this;
        }

        public Builder tectonicRegimes(final TectonicRegionType[] regimes) {
            Preconditions.checkState((this.sectionForRups.size() == regimes.length ? 1 : 0) != 0);
            this.modules.add(new ModuleBuilder(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public OpenSHA_Module build(FaultSystemRupSet rupSet) {
                    return new RupSetTectonicRegimes(rupSet, regimes);
                }

                @Override
                public Class<? extends OpenSHA_Module> getType() {
                    return RupSetTectonicRegimes.class;
                }
            });
            return this;
        }

        public Builder slipAlongRupture(SlipAlongRuptureModelBranchNode slipAlong) {
            return this.slipAlongRupture(SlipAlongRuptureModel.forModel(slipAlong));
        }

        public Builder slipAlongRupture(final SlipAlongRuptureModel slipAlong) {
            this.addModule(new ModuleBuilder(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public OpenSHA_Module build(FaultSystemRupSet rupSet) {
                    return slipAlong;
                }

                @Override
                public Class<? extends OpenSHA_Module> getType() {
                    return SlipAlongRuptureModel.class;
                }
            });
            return this;
        }

        public Builder modSectMinMagsAbove(final double systemWideMinMag, final boolean useMaxForParent) {
            this.addModule(new ModuleBuilder(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public OpenSHA_Module build(FaultSystemRupSet rupSet) {
                    return ModSectMinMags.above(rupSet, systemWideMinMag, useMaxForParent);
                }

                @Override
                public Class<? extends OpenSHA_Module> getType() {
                    return ModSectMinMags.class;
                }
            });
            return this;
        }

        public Builder modSectMinMags(final double[] minMags) {
            Preconditions.checkState((minMags.length == this.faultSectionData.size() ? 1 : 0) != 0, (String)"Have %s sections but given %s min mags", (int)this.faultSectionData.size(), (int)minMags.length);
            this.addModule(new ModuleBuilder(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public OpenSHA_Module build(FaultSystemRupSet rupSet) {
                    return ModSectMinMags.instance(rupSet, minMags);
                }

                @Override
                public Class<? extends OpenSHA_Module> getType() {
                    return ModSectMinMags.class;
                }
            });
            return this;
        }

        public Builder rupMags(double[] mags) {
            Preconditions.checkArgument((mags.length == this.sectionForRups.size() ? 1 : 0) != 0);
            this.mags = mags;
            return this;
        }

        public Builder rupRakes(double[] rakes) {
            Preconditions.checkArgument((rakes.length == this.sectionForRups.size() ? 1 : 0) != 0);
            this.rakes = rakes;
            return this;
        }

        public Builder rupAreas(double[] rupAreas) {
            Preconditions.checkArgument((rupAreas.length == this.sectionForRups.size() ? 1 : 0) != 0);
            this.rupAreas = rupAreas;
            return this;
        }

        public Builder rupLengths(double[] rupLengths) {
            Preconditions.checkArgument((rupLengths == null || rupLengths.length == this.sectionForRups.size() ? 1 : 0) != 0);
            this.rupLengths = rupLengths;
            return this;
        }

        public Builder addModule(ModuleBuilder module) {
            this.modules.add(module);
            return this;
        }

        public Builder addModule(final OpenSHA_Module module) {
            this.modules.add(new ModuleBuilder(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public OpenSHA_Module build(FaultSystemRupSet rupSet) {
                    return module;
                }

                @Override
                public Class<? extends OpenSHA_Module> getType() {
                    return module.getClass();
                }
            });
            return this;
        }

        public FaultSystemRupSet build() {
            return this.build(false);
        }

        public FaultSystemRupSet build(boolean round) {
            Preconditions.checkNotNull((Object)this.mags, (Object)"Must set magnitudes");
            this.checkBuildRakesAndAreas();
            this.checkBuildLengths();
            if (round) {
                this.mags = Builder.roundFixed(this.mags, 3);
                this.rakes = Builder.roundFixed(this.rakes, 1);
                this.rupAreas = DataUtils.roundSigFigs(this.rupAreas, 6);
                this.rupLengths = DataUtils.roundSigFigs(this.rupLengths, 6);
            }
            final FaultSystemRupSet rupSet = new FaultSystemRupSet(this.faultSectionData, this.sectionForRups, this.mags, this.rakes, this.rupAreas, this.rupLengths);
            for (final ModuleBuilder module : this.modules) {
                rupSet.removeModuleInstances(module.getType());
                rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<OpenSHA_Module>(){
                    final /* synthetic */ Builder this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public OpenSHA_Module call() throws Exception {
                        OpenSHA_Module instance = module.build(rupSet);
                        Preconditions.checkState((boolean)module.getType().isAssignableFrom(instance.getClass()), (String)"Instance is of type %s, but was declared as type %s", instance.getClass(), module.getType());
                        return instance;
                    }
                }, module.getType());
            }
            return rupSet;
        }

        private static double[] roundFixed(double[] values, int scale) {
            double[] ret = new double[values.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = DataUtils.roundFixed(values[i], scale);
            }
            return ret;
        }
    }

    public static interface ModuleBuilder {
        public OpenSHA_Module build(FaultSystemRupSet var1);

        public Class<? extends OpenSHA_Module> getType();
    }
}

