/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.erf;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.sha.calc.disaggregation.DisaggregationSourceRuptureInfo;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.aftershocks.MagnitudeDependentAftershockFilter;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.erf.ProxyRupsFaultRuptureSource;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.ProxyFaultSectionInstances;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupSetTectonicRegimes;
import org.opensha.sha.earthquake.faultSysSolution.util.SolutionDisaggConsolidator;
import org.opensha.sha.earthquake.param.AseismicityAreaReductionParam;
import org.opensha.sha.earthquake.param.BackgroundRupParam;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.earthquake.param.FaultGridSpacingParam;
import org.opensha.sha.earthquake.param.GriddedSeismicitySettingsParam;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.IncludeBackgroundParam;
import org.opensha.sha.earthquake.param.UseProxySectionsParam;
import org.opensha.sha.earthquake.param.UseRupMFDsParam;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.earthquake.util.GridCellSupersamplingSettings;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrections;
import org.opensha.sha.util.TectonicRegionType;

public class BaseFaultSystemSolutionERF
extends AbstractNthRupERF {
    private static final long serialVersionUID = 1L;
    protected static final boolean D = false;
    public static final String NAME = "Fault System Solution ERF";
    private String name = "Fault System Solution ERF";
    public static final String FILE_PARAM_NAME = "Solution Input File";
    protected FileParameter fileParam;
    protected boolean includeFileParam = true;
    protected FaultGridSpacingParam faultGridSpacingParam;
    protected IncludeBackgroundParam bgIncludeParam;
    protected BackgroundRupParam bgRupTypeParam;
    protected GriddedSeismicitySettingsParam bgSettingsParam;
    protected AseismicityAreaReductionParam aseisParam;
    protected UseRupMFDsParam useRupMFDsParam;
    protected UseProxySectionsParam useProxyRupturesParam;
    public static final double FAULT_GRID_SPACING_DEFAULT = 1.0;
    public static final IncludeBackgroundOption INCLUDE_BG_DEFAULT = IncludeBackgroundOption.INCLUDE;
    public static final BackgroundRupType BG_RUP_TYPE_DEFAULT = BackgroundRupType.POINT;
    public static final PointSourceDistanceCorrections DIST_CORR_TYPE_DEFAULT = PointSourceDistanceCorrections.NSHM_2013;
    public static final GridCellSupersamplingSettings GRID_SUPERSAMPLE_DEFAULT = null;
    public static final GriddedSeismicitySettings GRID_SETTINGS_DEFAULT = GriddedSeismicitySettings.DEFAULT.forSurfaceType(BG_RUP_TYPE_DEFAULT).forDistanceCorrections(DIST_CORR_TYPE_DEFAULT).forSupersamplingSettings(GRID_SUPERSAMPLE_DEFAULT);
    public static final boolean ASEIS_REDUCES_AREA_DEAFULT = true;
    public static final boolean USE_RUP_MFDS_DEAFULT = true;
    public static final boolean USE_PROXY_RUPS_DEAFULT = true;
    protected double faultGridSpacing = 1.0;
    protected IncludeBackgroundOption bgInclude = INCLUDE_BG_DEFAULT;
    protected GriddedSeismicitySettings bgSettings = GRID_SETTINGS_DEFAULT;
    protected boolean aseisReducesArea = true;
    protected boolean useRupMFDs = true;
    protected boolean useProxyRuptures = true;
    protected boolean fileParamChanged = false;
    protected boolean faultGridSpacingChanged = true;
    protected boolean bgIncludeChanged = true;
    protected boolean bgRupSettingsChanged = true;
    protected boolean quadSurfacesChanged = true;
    protected boolean aseisReducesAreaChanged = true;
    protected boolean useProxyRupturesChanged = true;
    protected boolean useRupMFDsChanged = true;
    protected static final double DURATION_DEFAULT = 30.0;
    protected static final double DURATION_MIN = 1.0E-4;
    public static final double DURATION_MAX = 1000000.0;
    protected boolean timeSpanChangeFlag = true;
    protected FaultSystemSolution faultSysSolution;
    protected Optional<RupMFDsModule> mfdsModuleOptional;
    protected Optional<ProxyFaultSectionInstances> proxySectsModuleOptional;
    protected boolean cacheGridSources = false;
    protected ProbEqkSource[] gridSourceCache = null;
    protected int numNonZeroFaultSystemSources;
    protected int totNumRupsFromFaultSystem;
    protected int numOtherSources = 0;
    protected int[] fltSysRupIndexForSource;
    protected int[] srcIndexForFltSysRup;
    protected int[] fltSysRupIndexForNthRup;
    protected double[] longTermRateOfFltSysRupInERF;
    protected boolean faultSysSolutionChanged = true;
    protected List<ProbEqkSource> faultSourceList;
    private SolutionDisaggConsolidator disaggSourceConsolidator;

    public BaseFaultSystemSolutionERF() {
        this(true);
    }

    protected BaseFaultSystemSolutionERF(boolean doInit) {
        if (doInit) {
            this.initParams();
            this.initTimeSpan();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)name) ? 1 : 0) != 0, (Object)"Name cannot be empty");
        this.name = name;
    }

    protected void initParams() {
        this.fileParam = new FileParameter(FILE_PARAM_NAME);
        this.faultGridSpacingParam = new FaultGridSpacingParam();
        this.bgIncludeParam = new IncludeBackgroundParam();
        this.bgRupTypeParam = new BackgroundRupParam();
        this.bgRupTypeParam.setValue(this.bgSettings.surfaceType);
        this.bgSettingsParam = new GriddedSeismicitySettingsParam(this.bgSettings, this.bgRupTypeParam);
        this.aseisParam = new AseismicityAreaReductionParam();
        this.useRupMFDsParam = new UseRupMFDsParam(this.useRupMFDs);
        this.useProxyRupturesParam = new UseProxySectionsParam(this.useProxyRuptures);
        this.faultGridSpacingParam.setValue(this.faultGridSpacing);
        this.bgIncludeParam.setValue(this.bgInclude);
        this.bgSettingsParam.setValue(this.bgSettings);
        this.aseisParam.setValue(this.aseisReducesArea);
        this.useRupMFDsParam.setValue(this.useRupMFDs);
        this.useProxyRupturesParam.setValue(this.useProxyRuptures);
        this.fileParam.addParameterChangeListener(this);
        this.faultGridSpacingParam.addParameterChangeListener(this);
        this.bgIncludeParam.addParameterChangeListener(this);
        this.bgRupTypeParam.addParameterChangeListener(this);
        this.bgSettingsParam.addParameterChangeListener(this);
        this.aseisParam.addParameterChangeListener(this);
        this.useRupMFDsParam.addParameterChangeListener(this);
        this.useProxyRupturesParam.addParameterChangeListener(this);
        this.createParamList();
    }

    protected void createParamList() {
        if (this.adjustableParams == null) {
            this.adjustableParams = new ParameterList();
        } else {
            this.adjustableParams.clear();
        }
        if (this.includeFileParam) {
            this.adjustableParams.addParameter(this.fileParam);
        }
        this.adjustableParams.addParameter(this.bgIncludeParam);
        if (!((IncludeBackgroundOption)((Object)this.bgIncludeParam.getValue())).equals((Object)IncludeBackgroundOption.EXCLUDE)) {
            this.adjustableParams.addParameter(this.bgRupTypeParam);
            this.adjustableParams.addParameter(this.bgSettingsParam);
        }
        this.adjustableParams.addParameter(this.faultGridSpacingParam);
        this.adjustableParams.addParameter(this.aseisParam);
        if (this.faultSysSolution != null) {
            if (this.faultSysSolution.hasAvailableModule(RupMFDsModule.class)) {
                this.adjustableParams.addParameter(this.useRupMFDsParam);
                this.useRupMFDs = (Boolean)this.useRupMFDsParam.getValue();
            } else {
                this.useRupMFDs = false;
            }
            if (this.faultSysSolution.getRupSet().hasAvailableModule(ProxyFaultSectionInstances.class)) {
                this.adjustableParams.addParameter(this.useProxyRupturesParam);
                this.useProxyRuptures = (Boolean)this.useProxyRupturesParam.getValue();
            } else {
                this.useProxyRuptures = false;
            }
        } else {
            this.useRupMFDs = false;
            this.useProxyRuptures = false;
        }
    }

    protected void initTimeSpan() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.setDuration(30.0);
        this.timeSpan.addParameterChangeListener(this);
    }

    public int getNumFaultSystemSources() {
        return this.numNonZeroFaultSystemSources;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase(this.fileParam.getName())) {
            this.fileParamChanged = true;
            File solFile = (File)this.fileParam.getValue();
            if (solFile == null) {
                this.setSolution(null, false);
            } else {
                this.readFaultSysSolutionFromFile();
            }
            this.fileParamChanged = false;
        } else if (paramName.equalsIgnoreCase(this.faultGridSpacingParam.getName())) {
            this.faultGridSpacing = (Double)this.faultGridSpacingParam.getValue();
            this.faultGridSpacingChanged = true;
        } else if (paramName.equalsIgnoreCase(this.bgIncludeParam.getName())) {
            this.bgInclude = (IncludeBackgroundOption)((Object)this.bgIncludeParam.getValue());
            this.createParamList();
            this.bgIncludeChanged = true;
            if (this.bgInclude != IncludeBackgroundOption.EXCLUDE && this.numOtherSources == 0) {
                this.bgRupSettingsChanged = true;
            }
        } else if (paramName.equalsIgnoreCase(this.bgRupTypeParam.getName())) {
            this.createParamList();
            this.bgRupSettingsChanged = true;
            this.clearCachedGridSources();
        } else if (paramName.equalsIgnoreCase(this.bgSettingsParam.getName())) {
            this.bgSettings = (GriddedSeismicitySettings)this.bgSettingsParam.getValue();
            System.out.println("FSS ERF updated grid seis settings: " + String.valueOf(this.bgSettings));
            this.bgRupSettingsChanged = true;
            this.clearCachedGridSources();
        } else if (paramName.equalsIgnoreCase(this.aseisParam.getName())) {
            this.aseisReducesArea = (Boolean)this.aseisParam.getValue();
            this.aseisReducesAreaChanged = true;
        } else if (paramName.equalsIgnoreCase(this.useRupMFDsParam.getName())) {
            this.useRupMFDs = (Boolean)this.useRupMFDsParam.getValue();
            this.useRupMFDsChanged = true;
        } else if (paramName.equalsIgnoreCase(this.useProxyRupturesParam.getName())) {
            this.useProxyRuptures = (Boolean)this.useProxyRupturesParam.getValue();
            this.useProxyRupturesChanged = true;
        } else {
            throw new RuntimeException("parameter name not recognized");
        }
    }

    protected boolean shouldRebuildFaultSystemSources() {
        return this.faultSysSolutionChanged || this.faultGridSpacingChanged || this.quadSurfacesChanged || this.timeSpanChangeFlag || this.aseisReducesAreaChanged || this.useProxyRupturesChanged || this.useRupMFDsChanged;
    }

    protected void updateHookBeforeOtherBuild() {
    }

    protected void updateHookBeforeFaultSourceBuild() {
    }

    @Override
    public void updateForecast() throws NullPointerException {
        long runTime = System.currentTimeMillis();
        if (this.fileParamChanged) {
            this.readFaultSysSolutionFromFile();
        }
        if (this.faultSysSolution == null) {
            throw new NullPointerException("Failed to update forecast. Fault system solution is unavailable. Ensure the ERF is provided prior to computation.");
        }
        boolean numOtherRupsChanged = false;
        if (this.bgIncludeChanged || this.bgRupSettingsChanged || this.timeSpanChangeFlag) {
            this.updateHookBeforeOtherBuild();
            numOtherRupsChanged = this.initOtherSources();
            this.gridSourceCache = null;
        }
        boolean numFaultRupsChanged = false;
        if (this.faultSysSolutionChanged) {
            this.makeMiscFSS_Arrays();
            numFaultRupsChanged = true;
        }
        if (this.shouldRebuildFaultSystemSources()) {
            this.updateHookBeforeFaultSourceBuild();
            this.makeAllFaultSystemSources();
        }
        if (numOtherRupsChanged || numFaultRupsChanged) {
            this.setAllNthRupRelatedArrays();
        }
        this.fileParamChanged = false;
        this.faultSysSolutionChanged = false;
        this.faultGridSpacingChanged = false;
        this.aseisReducesAreaChanged = false;
        this.useRupMFDsChanged = false;
        this.useProxyRupturesChanged = false;
        this.bgIncludeChanged = false;
        this.bgRupSettingsChanged = false;
        this.quadSurfacesChanged = false;
        this.timeSpanChangeFlag = false;
        runTime = (System.currentTimeMillis() - runTime) / 1000L;
    }

    protected boolean isRuptureIncluded(int fltSystRupIndex) {
        return true;
    }

    private void makeMiscFSS_Arrays() {
        FaultSystemRupSet rupSet = this.faultSysSolution.getRupSet();
        this.longTermRateOfFltSysRupInERF = new double[rupSet.getNumRuptures()];
        this.numNonZeroFaultSystemSources = 0;
        ArrayList<Integer> fltSysRupIndexForSourceList = new ArrayList<Integer>();
        this.srcIndexForFltSysRup = new int[rupSet.getNumRuptures()];
        for (int i = 0; i < this.srcIndexForFltSysRup.length; ++i) {
            this.srcIndexForFltSysRup[i] = -1;
        }
        int srcIndex = 0;
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            if (!(this.faultSysSolution.getRateForRup(r) > 0.0) || !this.isRuptureIncluded(r)) continue;
            ++this.numNonZeroFaultSystemSources;
            fltSysRupIndexForSourceList.add(r);
            this.srcIndexForFltSysRup[r] = srcIndex++;
            this.longTermRateOfFltSysRupInERF[r] = this.faultSysSolution.getRateForRup(r);
        }
        if (fltSysRupIndexForSourceList.size() != this.numNonZeroFaultSystemSources) {
            throw new RuntimeException("Problem");
        }
        this.fltSysRupIndexForSource = new int[this.numNonZeroFaultSystemSources];
        for (int i = 0; i < this.numNonZeroFaultSystemSources; ++i) {
            this.fltSysRupIndexForSource[i] = (Integer)fltSysRupIndexForSourceList.get(i);
        }
    }

    public double[] getLongTermRateOfFltSysRupInERF() {
        return this.longTermRateOfFltSysRupInERF;
    }

    public int getFltSysRupIndexForSource(int iSrc) {
        return this.fltSysRupIndexForSource[iSrc];
    }

    protected void readFaultSysSolutionFromFile() {
        File file = (File)this.fileParam.getValue();
        if (file == null) {
            throw new RuntimeException("No solution file specified");
        }
        long runTime = System.currentTimeMillis();
        try {
            this.setSolution(FaultSystemSolution.load(file), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSolution(FaultSystemSolution sol) {
        this.setSolution(sol, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSolution(FaultSystemSolution sol, boolean clearFileParam) {
        this.faultSysSolution = sol;
        if (clearFileParam) {
            FileParameter fileParameter = this.fileParam;
            synchronized (fileParameter) {
                this.fileParam.removeParameterChangeListener(this);
                this.fileParam.setValue(null);
                this.fileParam.addParameterChangeListener(this);
            }
        }
        this.mfdsModuleOptional = null;
        this.proxySectsModuleOptional = null;
        this.gridSourceCache = null;
        this.faultSysSolutionChanged = true;
        this.bgIncludeChanged = true;
        this.bgRupSettingsChanged = true;
        this.fileParamChanged = false;
        this.createParamList();
    }

    public FaultSystemSolution getSolution() {
        return this.faultSysSolution;
    }

    @Override
    public int getNumSources() {
        if (this.bgInclude.equals((Object)IncludeBackgroundOption.ONLY)) {
            return this.numOtherSources;
        }
        if (this.bgInclude.equals((Object)IncludeBackgroundOption.EXCLUDE)) {
            return this.numNonZeroFaultSystemSources;
        }
        return this.numNonZeroFaultSystemSources + this.numOtherSources;
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        if (this.bgInclude.equals((Object)IncludeBackgroundOption.ONLY)) {
            return this.getOtherSource(iSource);
        }
        if (this.bgInclude.equals((Object)IncludeBackgroundOption.EXCLUDE)) {
            return this.faultSourceList.get(iSource);
        }
        if (iSource < this.numNonZeroFaultSystemSources) {
            return this.faultSourceList.get(iSource);
        }
        return this.getOtherSource(iSource - this.numNonZeroFaultSystemSources);
    }

    protected MagnitudeDependentAftershockFilter getGridSourceAftershockFilter() {
        return null;
    }

    private void makeAllFaultSystemSources() {
        this.faultSourceList = new ArrayList<ProbEqkSource>(this.numNonZeroFaultSystemSources);
        for (int i = 0; i < this.numNonZeroFaultSystemSources; ++i) {
            this.faultSourceList.add(this.makeFaultSystemSource(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiscretizedFunc getFaultSysRupMFD(int fltSystRupIndex) {
        DiscretizedFunc rupMFD;
        if (!this.useRupMFDs) {
            return null;
        }
        if (this.mfdsModuleOptional == null) {
            BaseFaultSystemSolutionERF baseFaultSystemSolutionERF = this;
            synchronized (baseFaultSystemSolutionERF) {
                if (this.mfdsModuleOptional == null) {
                    this.mfdsModuleOptional = this.faultSysSolution.getOptionalModule(RupMFDsModule.class);
                }
            }
        }
        if (this.mfdsModuleOptional.isEmpty()) {
            return null;
        }
        RupMFDsModule rupMFDs = this.mfdsModuleOptional.get();
        if (rupMFDs.getParent() != this.faultSysSolution) {
            rupMFDs.setParent(this.faultSysSolution);
        }
        if ((rupMFD = rupMFDs.getRuptureMFD(fltSystRupIndex)) == null || rupMFD.size() < 2) {
            return null;
        }
        return rupMFD;
    }

    protected double getFaultSysRupRateGain(int fltSystRupIndex) {
        return 1.0;
    }

    protected boolean isFaultSysRupPoisson(int fltSystRupIndex) {
        return true;
    }

    protected String getFaultSysSourceName(int fltSystRupIndex) {
        FaultSystemRupSet rupSet = this.faultSysSolution.getRupSet();
        List<Integer> rupSects = rupSet.getSectionsIndicesForRup(fltSystRupIndex);
        FaultSection firstSect = rupSet.getFaultSectionData(rupSects.get(0));
        FaultSection lastSect = rupSet.getFaultSectionData(rupSects.get(rupSects.size() - 1));
        return "Inversion Src #" + fltSystRupIndex + "; " + rupSects.size() + " SECTIONS BETWEEN " + firstSect.getName() + " AND " + lastSect.getName();
    }

    protected boolean isRateGainValid(double rateGain, int fltSystRupIndex, double duration) {
        return rateGain > 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProbEqkSource makeFaultSystemSource(int iSource) {
        TectonicRegionType regime;
        ProbEqkSource src;
        FaultSystemRupSet rupSet = this.faultSysSolution.getRupSet();
        int fltSystRupIndex = this.fltSysRupIndexForSource[iSource];
        double meanMag = rupSet.getMagForRup(fltSystRupIndex);
        DiscretizedFunc rupMFD = this.getFaultSysRupMFD(fltSystRupIndex);
        double duration = this.timeSpan.getDuration();
        double rateGain = this.getFaultSysRupRateGain(fltSystRupIndex);
        boolean isPoisson = this.isFaultSysRupPoisson(fltSystRupIndex);
        Preconditions.checkState((boolean)this.isRateGainValid(rateGain, fltSystRupIndex, duration), (String)"Bad probGain=%s for rupIndex=%s, duration=%s", (Object)rateGain, (Object)fltSystRupIndex, (Object)duration);
        boolean proxyRups = false;
        ProxyFaultSectionInstances proxySectsModule = null;
        if (this.useProxyRuptures) {
            if (this.proxySectsModuleOptional == null) {
                BaseFaultSystemSolutionERF baseFaultSystemSolutionERF = this;
                synchronized (baseFaultSystemSolutionERF) {
                    if (this.proxySectsModuleOptional == null) {
                        this.proxySectsModuleOptional = this.faultSysSolution.getRupSet().getOptionalModule(ProxyFaultSectionInstances.class);
                    }
                }
            }
            if (this.proxySectsModuleOptional.isPresent()) {
                proxySectsModule = this.proxySectsModuleOptional.get();
                proxyRups = proxySectsModule.rupHasProxies(fltSystRupIndex);
            }
        }
        double rake = rupSet.getAveRakeForRup(fltSystRupIndex);
        if (rupMFD == null || rupMFD.size() < 2) {
            double annualRate = rateGain * this.longTermRateOfFltSysRupInERF[fltSystRupIndex];
            if (proxyRups) {
                List<FaultSection> origSects = rupSet.getFaultSectionDataForRupture(fltSystRupIndex);
                List<List<FaultSection>> proxyRupSects = proxySectsModule.getRupProxySects(fltSystRupIndex);
                src = new ProxyRupsFaultRuptureSource(origSects, proxyRupSects, meanMag, annualRate, rake, duration, isPoisson, this.faultGridSpacing, this.aseisReducesArea);
            } else {
                double prob = isPoisson ? 1.0 - Math.exp(-annualRate * duration) : Math.min(1.0, annualRate * duration);
                src = new FaultRuptureSource(meanMag, rupSet.getSurfaceForRupture(fltSystRupIndex, this.faultGridSpacing, this.aseisReducesArea), rake, prob, isPoisson);
            }
        } else {
            DiscretizedFunc rupMFDcorrected = rupMFD;
            if (rateGain != 1.0) {
                rupMFDcorrected = rupMFD.deepClone();
                rupMFDcorrected.scale(rateGain);
            }
            if (proxyRups) {
                List<FaultSection> origSects = rupSet.getFaultSectionDataForRupture(fltSystRupIndex);
                List<List<FaultSection>> proxyRupSects = proxySectsModule.getRupProxySects(fltSystRupIndex);
                src = new ProxyRupsFaultRuptureSource(origSects, proxyRupSects, rupMFDcorrected, rake, duration, isPoisson, this.faultGridSpacing, this.aseisReducesArea);
            } else {
                src = new FaultRuptureSource(rupMFDcorrected, rupSet.getSurfaceForRupture(fltSystRupIndex, this.faultGridSpacing, this.aseisReducesArea), rake, duration, isPoisson);
            }
        }
        if (src instanceof FaultRuptureSource) {
            ((FaultRuptureSource)src).setName(this.getFaultSysSourceName(fltSystRupIndex));
        } else if (src instanceof ProxyRupsFaultRuptureSource) {
            ((ProxyRupsFaultRuptureSource)src).setName("Proxy " + this.getFaultSysSourceName(fltSystRupIndex));
        }
        RupSetTectonicRegimes tectonics = rupSet.getModule(RupSetTectonicRegimes.class);
        if (tectonics != null && (regime = tectonics.get(fltSystRupIndex)) != null) {
            src.setTectonicRegionType(regime);
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProbEqkSource getOtherSource(int iSource) {
        Preconditions.checkNotNull((Object)this.faultSysSolution, (Object)"Fault system solution is null");
        GridSourceProvider gridSources = this.faultSysSolution.getGridSourceProvider();
        if (gridSources == null) {
            return null;
        }
        if (this.cacheGridSources) {
            ProbEqkSource cached;
            if (this.gridSourceCache == null) {
                BaseFaultSystemSolutionERF baseFaultSystemSolutionERF = this;
                synchronized (baseFaultSystemSolutionERF) {
                    if (this.gridSourceCache == null) {
                        this.gridSourceCache = new ProbEqkSource[this.numOtherSources];
                    }
                }
            }
            if ((cached = this.gridSourceCache[iSource]) == null) {
                this.gridSourceCache[iSource] = cached = gridSources.getSource(iSource, this.timeSpan.getDuration(), this.getGridSourceAftershockFilter(), this.bgSettings);
            }
            return cached;
        }
        return gridSources.getSource(iSource, this.timeSpan.getDuration(), this.getGridSourceAftershockFilter(), this.bgSettings);
    }

    public void setGriddedSeismicitySettings(GriddedSeismicitySettings settings) {
        this.bgSettingsParam.setValue(settings);
    }

    public GriddedSeismicitySettings getGriddedSeismicitySettings() {
        return this.bgSettings;
    }

    public void setCacheGridSources(boolean cacheGridSources) {
        this.cacheGridSources = cacheGridSources;
        if (!cacheGridSources) {
            this.gridSourceCache = null;
        }
    }

    public void clearCachedGridSources() {
        this.gridSourceCache = null;
    }

    protected boolean initOtherSources() {
        if (this.bgIncludeChanged && this.bgInclude == IncludeBackgroundOption.EXCLUDE) {
            return true;
        }
        if (this.bgRupSettingsChanged || this.bgIncludeChanged) {
            int prevOther = this.numOtherSources;
            System.out.println("faultSysSolution: " + String.valueOf(this.faultSysSolution));
            GridSourceProvider gridSources = this.faultSysSolution.getGridSourceProvider();
            if (gridSources == null) {
                this.numOtherSources = 0;
                return prevOther > 0;
            }
            this.numOtherSources = gridSources.getNumSources();
            return true;
        }
        return false;
    }

    @Override
    public void timeSpanChange(EventObject event) {
        this.timeSpanChangeFlag = true;
    }

    @Override
    protected void setAllNthRupRelatedArrays() {
        this.totNumRups = 0;
        this.totNumRupsFromFaultSystem = 0;
        this.nthRupIndicesForSource = new ArrayList();
        int numSources = this.getNumSources();
        ArrayList<Integer> tempSrcIndexForNthRup = new ArrayList<Integer>(numSources);
        ArrayList<Integer> tempRupIndexForNthRup = new ArrayList<Integer>(numSources);
        ArrayList<Integer> tempFltSysRupIndexForNthRup = new ArrayList<Integer>(numSources);
        int n = 0;
        for (int s = 0; s < numSources; ++s) {
            int numRups = this.getSource(s).getNumRuptures();
            this.totNumRups += numRups;
            if (s < this.numNonZeroFaultSystemSources) {
                this.totNumRupsFromFaultSystem += numRups;
            }
            int[] nthRupsForSrc = new int[numRups];
            for (int r = 0; r < numRups; ++r) {
                tempSrcIndexForNthRup.add(s);
                tempRupIndexForNthRup.add(r);
                if (s < this.numNonZeroFaultSystemSources) {
                    tempFltSysRupIndexForNthRup.add(this.fltSysRupIndexForSource[s]);
                }
                nthRupsForSrc[r] = n++;
            }
            this.nthRupIndicesForSource.add(nthRupsForSrc);
        }
        this.srcIndexForNthRup = new int[tempSrcIndexForNthRup.size()];
        this.rupIndexForNthRup = new int[tempRupIndexForNthRup.size()];
        this.fltSysRupIndexForNthRup = new int[tempFltSysRupIndexForNthRup.size()];
        for (n = 0; n < this.totNumRups; ++n) {
            this.srcIndexForNthRup[n] = (Integer)tempSrcIndexForNthRup.get(n);
            this.rupIndexForNthRup[n] = (Integer)tempRupIndexForNthRup.get(n);
            if (n >= tempFltSysRupIndexForNthRup.size()) continue;
            this.fltSysRupIndexForNthRup[n] = (Integer)tempFltSysRupIndexForNthRup.get(n);
        }
    }

    public int getFltSysRupIndexForNthRup(int nthRup) {
        return this.fltSysRupIndexForNthRup[nthRup];
    }

    public int getSrcIndexForFltSysRup(int fltSysRupIndex) {
        return this.srcIndexForFltSysRup[fltSysRupIndex];
    }

    public int getTotNumRupsFromFaultSystem() {
        return this.totNumRupsFromFaultSystem;
    }

    public GridSourceProvider getGridSourceProvider() {
        return this.faultSysSolution.getGridSourceProvider();
    }

    @Override
    public UnaryOperator<List<DisaggregationSourceRuptureInfo>> getDisaggSourceConsolidator() {
        if (this.disaggSourceConsolidator == null) {
            this.disaggSourceConsolidator = new SolutionDisaggConsolidator(this);
        }
        return this.disaggSourceConsolidator;
    }
}

