/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import com.google.common.primitives.Doubles;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryPredicate;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeCurveAverager;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeHazardCompare;
import org.opensha.sha.earthquake.faultSysSolution.hazard.mpj.MPJ_LogicTreeHazardCalc;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;

public class FaultAndGriddedSeparateTreeHazardCombiner {
    private static final DecimalFormat twoDigits = new DecimalFormat("0.00");
    private static final DecimalFormat pDF = new DecimalFormat("0.00%");

    public static void main(String[] args) throws IOException {
        GriddedRegion gridReg;
        File gridRegFile;
        String resultFileName;
        CommandLine cmd = FaultSysTools.parseOptions(FaultAndGriddedSeparateTreeHazardCombiner.createOptions(), args, LogicTreeHazardCompare.class);
        args = cmd.getArgs();
        if (args.length < 7 || args.length > 8) {
            System.err.println("USAGE: <results_fault.zip> <results_fault_hazard_dir> <results_gridded.zip> <results_gridded_hazard_dir> <results_output_combined.zip> <results_output_hazard_combined.zip> <grid-region.geojson> [<periods>]");
            System.exit(1);
        }
        int cnt = 0;
        File faultSLTFile = new File(args[cnt++]);
        SolutionLogicTree faultSLT = SolutionLogicTree.load(faultSLTFile);
        File faultHazardDir = new File(args[cnt++]);
        SolutionLogicTree griddedSLT = SolutionLogicTree.load(new File(args[cnt++]));
        File griddedHazardDir = new File(args[cnt++]);
        File resultsOutFile = (resultFileName = args[cnt++]).trim().toLowerCase().equals("null") ? null : new File(resultFileName);
        File hazardOutFile = new File(args[cnt++]);
        if ((gridRegFile = new File(args[cnt++])).getName().endsWith(".zip")) {
            java.util.zip.ZipFile zip = new java.util.zip.ZipFile(gridRegFile);
            ZipEntry gridRegEntry = zip.getEntry("gridded_region.geojson");
            Preconditions.checkNotNull((Object)gridRegEntry);
            BufferedInputStream is = new BufferedInputStream(zip.getInputStream(gridRegEntry));
            Feature gridRegFeature = Feature.read(new InputStreamReader(is));
            gridReg = GriddedRegion.fromFeature(gridRegFeature);
            zip.close();
        } else {
            Feature gridRegFeature = Feature.read(gridRegFile);
            gridReg = GriddedRegion.fromFeature(gridRegFeature);
        }
        double gridSpacing = gridReg.getSpacing();
        double[] periods = MPJ_LogicTreeHazardCalc.PERIODS_DEFAULT;
        SolHazardMapCalc.ReturnPeriods[] rps = SolHazardMapCalc.MAP_RPS;
        if (cnt < args.length) {
            String periodsStr;
            ArrayList<Double> periodsList = new ArrayList<Double>();
            if ((periodsStr = args[cnt++]).contains(",")) {
                String[] split;
                for (String str : split = periodsStr.split(",")) {
                    periodsList.add(Double.parseDouble(str));
                }
            } else {
                periodsList.add(Double.parseDouble(periodsStr));
            }
            periods = Doubles.toArray(periodsList);
        }
        LogicTree<?> faultTree = faultSLT.getLogicTree();
        LogicTree<?> gridTree = griddedSLT.getLogicTree();
        String faultHazardDirName = "hazard_" + (float)gridSpacing + "deg_grid_seis_" + IncludeBackgroundOption.EXCLUDE.name();
        String gridHazardDirName = "hazard_" + (float)gridSpacing + "deg_grid_seis_" + IncludeBackgroundOption.ONLY.name();
        ArrayList<DiscretizedFunc[][]> gridSeisCurves = new ArrayList<DiscretizedFunc[][]>();
        for (LogicTreeBranch<?> gridBranch : gridTree) {
            System.out.println("Pre-loading curves for gridded seismicity branch " + String.valueOf(gridBranch));
            File branchResultsDir = gridBranch.getBranchDirectory(griddedHazardDir, true);
            File branchHazardDir = new File(branchResultsDir, gridHazardDirName);
            Preconditions.checkState((boolean)branchHazardDir.exists(), (String)"%s doesn't exist", (Object)branchHazardDir.getAbsolutePath());
            gridSeisCurves.add(FaultAndGriddedSeparateTreeHazardCombiner.loadCurves(branchHazardDir, periods, gridReg));
        }
        DiscretizedFunc[][] meanGridSeisCurves = null;
        final ArrayList<LogicTreeLevel<LogicTreeLevel>> combinedLevels = new ArrayList<LogicTreeLevel<LogicTreeLevel>>();
        combinedLevels.addAll((Collection<LogicTreeLevel<LogicTreeLevel>>)faultTree.getLevels());
        if (cmd.hasOption("average-gridded")) {
            int p;
            System.out.println("Averaging gridded seismicity curves");
            LogicTreeCurveAverager[] meanCurves = new LogicTreeCurveAverager[periods.length];
            for (p = 0; p < periods.length; ++p) {
                meanCurves[p] = new LogicTreeCurveAverager(gridTree, gridReg.getNodeList());
            }
            for (int g = 0; g < gridTree.size(); ++g) {
                LogicTreeBranch<?> gridBranch = gridTree.getBranch(g);
                DiscretizedFunc[][] gridCurves = (DiscretizedFunc[][])gridSeisCurves.get(g);
                double weight = gridTree.getBranchWeight(g);
                for (int p2 = 0; p2 < periods.length; ++p2) {
                    meanCurves[p2].processBranchCurves(gridBranch, weight, gridCurves[p2]);
                }
            }
            meanGridSeisCurves = new DiscretizedFunc[periods.length][];
            for (p = 0; p < periods.length; ++p) {
                meanGridSeisCurves[p] = meanCurves[p].getNormalizedCurves().get("mean");
            }
            gridTree = null;
        } else {
            for (LogicTreeLevel gridLevel : gridTree.getLevels()) {
                boolean duplicate = false;
                for (LogicTreeLevel faultLevel : faultTree.getLevels()) {
                    if (!faultLevel.getType().equals(gridLevel.getType())) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                combinedLevels.add(gridLevel);
            }
        }
        final ArrayList combinedBranches = new ArrayList();
        File tmpOut = new File(hazardOutFile.getAbsolutePath() + ".tmp");
        final ZipOutputStream hazardOutZip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmpOut)));
        CompletableFuture<Void> writeFuture = null;
        final WriteCounter writeCounter = new WriteCounter();
        LogicTreeCurveAverager[] meanCurves = new LogicTreeCurveAverager[periods.length];
        HashSet<LogicTreeNode> variableNodes = new HashSet<LogicTreeNode>();
        HashMap nodeLevels = new HashMap();
        LogicTreeCurveAverager.populateVariableNodes(faultTree, variableNodes, nodeLevels);
        if (gridTree != null) {
            LogicTreeCurveAverager.populateVariableNodes(gridTree, variableNodes, nodeLevels);
        }
        for (int p = 0; p < periods.length; ++p) {
            meanCurves[p] = new LogicTreeCurveAverager(gridReg.getNodeList(), variableNodes, nodeLevels);
        }
        ExecutorService exec = Executors.newFixedThreadPool(FaultSysTools.defaultNumThreads());
        Stopwatch watch = Stopwatch.createStarted();
        Stopwatch combineWatch = Stopwatch.createUnstarted();
        Stopwatch mapStringWatch = Stopwatch.createUnstarted();
        Stopwatch blockingIOWatch = Stopwatch.createUnstarted();
        Stopwatch blockingAvgWatch = Stopwatch.createUnstarted();
        CompletableFuture<DiscretizedFunc[][]> nextFaultLoadFuture = null;
        for (int f = 0; f < faultTree.size(); ++f) {
            LogicTreeBranch<?> faultBranch = faultTree.getBranch(f);
            System.out.println("Processing fault branch " + f + ": " + String.valueOf(faultBranch));
            if (nextFaultLoadFuture == null) {
                nextFaultLoadFuture = FaultAndGriddedSeparateTreeHazardCombiner.curveLoadFuture(faultHazardDir, faultHazardDirName, faultBranch, periods);
            }
            DiscretizedFunc[][] faultCurves = (DiscretizedFunc[][])nextFaultLoadFuture.join();
            if (f < faultTree.size() - 1) {
                nextFaultLoadFuture = FaultAndGriddedSeparateTreeHazardCombiner.curveLoadFuture(faultHazardDir, faultHazardDirName, faultTree.getBranch(f + 1), periods);
            }
            double faultWeight = faultTree.getBranchWeight(faultBranch);
            ArrayList<CompletableFuture<Void>> perAvgFutures = new ArrayList<CompletableFuture<Void>>();
            int numGrid = meanGridSeisCurves != null ? 1 : gridTree.size();
            for (int g = 0; g < numGrid; ++g) {
                int writable;
                DiscretizedFunc[][] gridCurves;
                double gridWeight;
                combineWatch.start();
                final LogicTreeBranch<LogicTreeNode> combinedBranch = new LogicTreeBranch<LogicTreeNode>(combinedLevels);
                for (LogicTreeNode node : faultBranch) {
                    combinedBranch.setValue(node);
                }
                if (meanGridSeisCurves == null) {
                    LogicTreeBranch<?> gridBranch = gridTree.getBranch(g);
                    for (LogicTreeNode node : gridBranch) {
                        combinedBranch.setValue(node);
                    }
                    gridWeight = gridTree.getBranchWeight(gridBranch);
                    gridCurves = (DiscretizedFunc[][])gridSeisCurves.get(g);
                } else {
                    gridWeight = 1.0;
                    gridCurves = meanGridSeisCurves;
                }
                final double combWeight = faultWeight * gridWeight;
                String combPrefix = combinedBranch.getBranchZipPath();
                combinedBranch.setOrigBranchWeight(faultWeight);
                HashMap<CallSite, GriddedGeoDataSet> writeMap = new HashMap<CallSite, GriddedGeoDataSet>(gridReg.getNodeCount() * periods.length);
                for (int p = 0; p < periods.length; ++p) {
                    Preconditions.checkState((faultCurves[p].length == gridCurves[p].length ? 1 : 0) != 0);
                    Preconditions.checkState((faultCurves[p].length == gridReg.getNodeCount() ? 1 : 0) != 0);
                    Object xVals = new double[faultCurves[p][0].size()];
                    for (int i = 0; i < ((Object)xVals).length; ++i) {
                        xVals[i] = faultCurves[p][0].getX(i);
                    }
                    ArrayList<Future<GridLocResult>> futures = new ArrayList<Future<GridLocResult>>();
                    for (int i = 0; i < faultCurves[p].length; ++i) {
                        futures.add(exec.submit(new ProcessCallable(i, (double[])xVals, faultCurves[p][i], gridCurves[p][i], rps)));
                    }
                    final DiscretizedFunc[] combCurves = new DiscretizedFunc[gridCurves[p].length];
                    GriddedGeoDataSet[] xyzs = new GriddedGeoDataSet[rps.length];
                    for (int r = 0; r < rps.length; ++r) {
                        xyzs[r] = new GriddedGeoDataSet(gridReg, false);
                    }
                    try {
                        for (Future future : futures) {
                            GridLocResult result = (GridLocResult)future.get();
                            combCurves[result.gridIndex] = result.combCurve;
                            for (int r = 0; r < rps.length; ++r) {
                                xyzs[r].set(result.gridIndex, result.mapVals[r]);
                            }
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    for (int r = 0; r < rps.length; ++r) {
                        String mapFileName = MPJ_LogicTreeHazardCalc.mapPrefix(periods[p], rps[r]) + ".txt";
                        String entryName = combPrefix + "/" + mapFileName;
                        Preconditions.checkState((writeMap.put((CallSite)((Object)entryName), xyzs[r]) == null ? 1 : 0) != 0, (String)"Duplicate entry? %s", (Object)entryName);
                    }
                    final LogicTreeCurveAverager averager = meanCurves[p];
                    perAvgFutures.add(CompletableFuture.runAsync(new Runnable(){

                        @Override
                        public void run() {
                            averager.processBranchCurves(combinedBranch, combWeight, combCurves);
                        }
                    }));
                }
                combineWatch.stop();
                mapStringWatch.start();
                HashMap<String, Future<byte[]>> mapStringByteFutures = new HashMap<String, Future<byte[]>>(writeMap.size());
                for (String entryName : writeMap.keySet()) {
                    final GriddedGeoDataSet xyz = (GriddedGeoDataSet)writeMap.get(entryName);
                    mapStringByteFutures.put(entryName, exec.submit(new Callable<byte[]>(){

                        @Override
                        public byte[] call() throws Exception {
                            int size = Integer.max(1000, xyz.size() * 12);
                            StringWriter stringWriter = new StringWriter(size);
                            ArbDiscrGeoDataSet.writeXYZWriter(xyz, stringWriter);
                            stringWriter.flush();
                            return stringWriter.toString().getBytes();
                        }
                    }));
                }
                final HashMap<String, byte[]> mapStringBytes = new HashMap<String, byte[]>(writeMap.size());
                try {
                    for (String entryName : writeMap.keySet()) {
                        mapStringBytes.put(entryName, (byte[])((Future)mapStringByteFutures.get(entryName)).get());
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                mapStringWatch.stop();
                if (writeFuture != null) {
                    blockingIOWatch.start();
                    writeFuture.join();
                    blockingIOWatch.stop();
                    double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                    System.out.println("\tDone writing branch " + combinedBranches.size() + " (" + (float)((double)combinedBranches.size() / secs) + " /s)");
                }
                Preconditions.checkState(((writable = writeCounter.getWritable()) == 0 ? 1 : 0) != 0, (String)"Have %s writable maps after join? written=%s", (int)writable, (int)writeCounter.getWritten());
                int expected = periods.length * rps.length;
                Preconditions.checkState((writeMap.size() == expected ? 1 : 0) != 0, (String)"Expected $s writeable maps, have %s", (int)expected, (int)writeMap.size());
                writeCounter.incrementWritable(expected);
                System.out.println("Writing combined branch " + combinedBranches.size() + ": " + String.valueOf(combinedBranch));
                System.out.println("\tCombined weight: " + (float)faultWeight + " x " + (float)gridWeight + " = " + (float)combWeight);
                System.out.println("\tWriting " + writeCounter.getWritable() + " new maps, " + writeCounter.getWritten() + " written so far");
                combinedBranches.add(combinedBranch);
                writeFuture = CompletableFuture.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (String entryName : mapStringBytes.keySet()) {
                                byte[] mapBytes = (byte[])mapStringBytes.get(entryName);
                                hazardOutZip.putNextEntry(new ZipEntry(entryName));
                                hazardOutZip.write(mapBytes);
                                hazardOutZip.closeEntry();
                                writeCounter.incrementWritten();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                });
            }
            System.out.println("Waiting on " + perAvgFutures.size() + " averaging futures...");
            blockingAvgWatch.start();
            for (CompletableFuture future : perAvgFutures) {
                future.join();
            }
            blockingAvgWatch.stop();
            System.out.println("DONE fault branch " + f + "/" + faultTree.size());
            System.out.println("\tTotal time combining:\t" + FaultAndGriddedSeparateTreeHazardCombiner.blockingTimePrint(combineWatch, watch));
            System.out.println("\tTotal on map file rep:\t" + FaultAndGriddedSeparateTreeHazardCombiner.blockingTimePrint(mapStringWatch, watch));
            System.out.println("\tTotal blocking I/O:\t" + FaultAndGriddedSeparateTreeHazardCombiner.blockingTimePrint(blockingIOWatch, watch));
            System.out.println("\tTotal blocking Averaging:\t" + FaultAndGriddedSeparateTreeHazardCombiner.blockingTimePrint(blockingAvgWatch, watch));
            double totSecs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            double secsEach = totSecs / (double)(f + 1);
            double secsLeft = secsEach * (double)(faultTree.size() - (f + 1));
            double minsLeft = secsLeft / 60.0;
            double hoursLeft = minsLeft / 60.0;
            if (minsLeft > 90.0) {
                System.out.println("\tEstimated time left: " + twoDigits.format(hoursLeft) + " hours");
                continue;
            }
            if (secsLeft > 90.0) {
                System.out.println("\tEstimated time left: " + twoDigits.format(minsLeft) + " mins");
                continue;
            }
            System.out.println("\tEstimated time left: " + twoDigits.format(secsLeft) + " secs");
        }
        exec.shutdown();
        if (writeFuture != null) {
            writeFuture.join();
        }
        watch.stop();
        double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        System.out.println("Wrote for " + combinedBranches.size() + " branches (" + (float)((double)combinedBranches.size() / secs) + " /s)");
        System.out.println("Wrote " + writeCounter.getWritten() + " maps in total");
        MPJ_LogicTreeHazardCalc.writeMeanCurvesAndMaps(hazardOutZip, meanCurves, gridReg, periods, rps);
        hazardOutZip.putNextEntry(new ZipEntry("gridded_region.geojson"));
        Feature gridFeature = gridReg.toFeature();
        Feature.write(gridFeature, new OutputStreamWriter(hazardOutZip));
        hazardOutZip.closeEntry();
        hazardOutZip.close();
        Files.move((File)tmpOut, (File)hazardOutFile);
        if (resultsOutFile != null) {
            tmpOut = new File(resultsOutFile.getAbsolutePath() + ".tmp");
            final ZipArchiveOutputStream zout = new ZipArchiveOutputStream(tmpOut);
            ZipFile zip = new ZipFile(faultSLTFile);
            zip.copyRawEntries(zout, new ZipArchiveEntryPredicate(){

                public boolean test(ZipArchiveEntry zipArchiveEntry) {
                    if (zipArchiveEntry.getName().endsWith("logic_tree.json")) {
                        try {
                            LogicTree tree = LogicTree.fromExisting(combinedLevels, combinedBranches);
                            System.out.println("Updaing logic tree archive with " + tree.size() + " branches: " + zipArchiveEntry.getName());
                            zout.putArchiveEntry(new ZipArchiveEntry(zipArchiveEntry.getName()));
                            BufferedOutputStream bStream = new BufferedOutputStream((OutputStream)zout);
                            tree.writeToStream(bStream);
                            bStream.flush();
                            zout.flush();
                            zout.closeArchiveEntry();
                        }
                        catch (IOException e) {
                            throw ExceptionUtils.asRuntimeException(e);
                        }
                        return false;
                    }
                    return true;
                }
            });
            zip.close();
            zout.close();
            Files.move((File)tmpOut, (File)resultsOutFile);
        }
    }

    public static Options createOptions() {
        Options ops = new Options();
        ops.addOption("ag", "average-gridded", false, "Flag to only use average gridded seismicity.");
        return ops;
    }

    private static String blockingTimePrint(Stopwatch blockingWatch, Stopwatch totalWatch) {
        double blockSecs = (double)blockingWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        double blockMins = blockSecs / 60.0;
        String timeStr = blockMins > 1.0 ? twoDigits.format(blockMins) + " m" : twoDigits.format(blockSecs) + " s";
        double totSecs = (double)totalWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        return timeStr + " (" + pDF.format(blockSecs / totSecs) + ")";
    }

    private static CompletableFuture<DiscretizedFunc[][]> curveLoadFuture(File faultHazardDir, String faultHazardDirName, LogicTreeBranch<?> faultBranch, final double[] periods) {
        File branchResultsDir = faultBranch.getBranchDirectory(faultHazardDir, true);
        final File branchHazardDir = new File(branchResultsDir, faultHazardDirName);
        Preconditions.checkState((boolean)branchHazardDir.exists(), (String)"%s doesn't exist", (Object)branchHazardDir.getAbsolutePath());
        return CompletableFuture.supplyAsync(new Supplier<DiscretizedFunc[][]>(){

            @Override
            public DiscretizedFunc[][] get() {
                try {
                    return FaultAndGriddedSeparateTreeHazardCombiner.loadCurves(branchHazardDir, periods, null);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        });
    }

    private static DiscretizedFunc[][] loadCurves(File hazardDir, double[] periods, GriddedRegion region) throws IOException {
        DiscretizedFunc[][] curves = new DiscretizedFunc[periods.length][];
        for (int p = 0; p < periods.length; ++p) {
            String fileName = SolHazardMapCalc.getCSV_FileName("curves", periods[p]);
            File csvFile = new File(hazardDir, fileName);
            if (!csvFile.exists()) {
                csvFile = new File(hazardDir, fileName + ".gz");
            }
            Preconditions.checkState((boolean)csvFile.exists(), (String)"Curves CSV file not found: %s", (Object)csvFile.getAbsolutePath());
            CSVFile<String> csv = CSVFile.readFile(csvFile, true);
            curves[p] = SolHazardMapCalc.loadCurvesCSV(csv, region);
        }
        return curves;
    }

    private static class WriteCounter {
        private int writable = 0;
        private int written = 0;

        private WriteCounter() {
        }

        public synchronized void incrementWritable(int num) {
            this.writable += num;
        }

        public synchronized void incrementWritable() {
            ++this.writable;
        }

        public synchronized void incrementWritten() {
            ++this.written;
            --this.writable;
        }

        public synchronized int getWritable() {
            return this.writable;
        }

        public synchronized int getWritten() {
            return this.written;
        }
    }

    private static class ProcessCallable
    implements Callable<GridLocResult> {
        private int gridIndex;
        private double[] xVals;
        private DiscretizedFunc faultCurve;
        private DiscretizedFunc gridCurve;
        private SolHazardMapCalc.ReturnPeriods[] rps;

        public ProcessCallable(int gridIndex, double[] xVals, DiscretizedFunc faultCurve, DiscretizedFunc gridCurve, SolHazardMapCalc.ReturnPeriods[] rps) {
            this.gridIndex = gridIndex;
            this.xVals = xVals;
            this.faultCurve = faultCurve;
            this.gridCurve = gridCurve;
            this.rps = rps;
        }

        @Override
        public GridLocResult call() throws Exception {
            Preconditions.checkState((this.faultCurve.size() == this.xVals.length ? 1 : 0) != 0);
            Preconditions.checkState((this.gridCurve.size() == this.xVals.length ? 1 : 0) != 0);
            double[] yVals = new double[this.xVals.length];
            for (int j = 0; j < this.faultCurve.size(); ++j) {
                double x = this.faultCurve.getX(j);
                Preconditions.checkState(((float)x == (float)this.gridCurve.getX(j) ? 1 : 0) != 0);
                double y1 = this.faultCurve.getY(j);
                double y2 = this.gridCurve.getY(j);
                double y = y1 == 0.0 ? y2 : (y2 == 0.0 ? y1 : 1.0 - (1.0 - y1) * (1.0 - y2));
                yVals[j] = y;
            }
            LightFixedXFunc combCurve = new LightFixedXFunc(this.xVals, yVals);
            double[] mapVals = new double[this.rps.length];
            for (int r = 0; r < this.rps.length; ++r) {
                double curveLevel = this.rps[r].oneYearProb;
                double val = curveLevel > combCurve.getMaxY() ? 0.0 : (curveLevel < combCurve.getMinY() ? combCurve.getMaxX() : combCurve.getFirstInterpolatedX_inLogXLogYDomain(curveLevel));
                mapVals[r] = val;
            }
            return new GridLocResult(this.gridIndex, combCurve, mapVals);
        }
    }

    private static class GridLocResult {
        private final int gridIndex;
        private final DiscretizedFunc combCurve;
        private final double[] mapVals;

        public GridLocResult(int gridIndex, DiscretizedFunc combCurve, double[] mapVals) {
            this.gridIndex = gridIndex;
            this.combCurve = combCurve;
            this.mapVals = mapVals;
        }
    }
}

