/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;

public class LogicTreeCurveAverager {
    private LocationList gridLocs;
    private Map<String, DiscretizedFunc[]> curvesMap;
    private Map<String, Double> weightSumsMap;
    private HashSet<LogicTreeNode> variableNodes;
    private HashMap<LogicTreeNode, LogicTreeLevel<?>> nodeLevels;
    public static final String MEAN_PREFIX = "mean";

    public LogicTreeCurveAverager(LogicTree<?> tree, LocationList gridLocs) {
        this.gridLocs = gridLocs;
        this.curvesMap = new HashMap<String, DiscretizedFunc[]>();
        this.weightSumsMap = new HashMap<String, Double>();
        if (tree != null) {
            this.variableNodes = new HashSet();
            this.nodeLevels = new HashMap();
            LogicTreeCurveAverager.populateVariableNodes(tree, this.variableNodes, this.nodeLevels);
        }
    }

    public LogicTreeCurveAverager(LocationList gridLocs, HashSet<LogicTreeNode> variableNodes, HashMap<LogicTreeNode, LogicTreeLevel<?>> nodeLevels) {
        this.gridLocs = gridLocs;
        this.curvesMap = new HashMap<String, DiscretizedFunc[]>();
        this.weightSumsMap = new HashMap<String, Double>();
        this.variableNodes = variableNodes;
        this.nodeLevels = nodeLevels;
    }

    public static void populateVariableNodes(LogicTree<?> tree, HashSet<LogicTreeNode> variableNodes, HashMap<LogicTreeNode, LogicTreeLevel<?>> nodeLevels) {
        LogicTreeCurveAverager.populateVariableNodes(tree, variableNodes, nodeLevels, null, null);
    }

    public static void populateVariableNodes(LogicTree<?> tree, HashSet<LogicTreeNode> variableNodes, HashMap<LogicTreeNode, LogicTreeLevel<?>> nodeLevels, Map<LogicTreeLevel<?>, LogicTreeLevel<?>> levelRemappings, Map<LogicTreeNode, LogicTreeNode> nodeRemappings) {
        int numLevels = tree.getLevels().size();
        for (int l = 0; l < numLevels; ++l) {
            HashSet levelNodes = new HashSet();
            for (LogicTreeBranch<?> branch : tree) {
                Object node = branch.getValue(l);
                if (nodeRemappings != null && nodeRemappings.containsKey(node)) {
                    node = nodeRemappings.get(node);
                }
                levelNodes.add(node);
            }
            LogicTreeLevel<?> level = (LogicTreeLevel<?>)tree.getLevels().get(l);
            if (LogicTreeCurveAverager.shouldSkipLevel(level, levelNodes.size())) continue;
            if (levelRemappings != null && levelRemappings.containsKey(level)) {
                level = levelRemappings.get(level);
            }
            for (Object node : levelNodes) {
                nodeLevels.put((LogicTreeNode)node, level);
            }
            variableNodes.addAll(levelNodes);
        }
    }

    public static boolean shouldSkipLevel(LogicTreeLevel<?> level, int nodeCount) {
        if (nodeCount <= 1) {
            return false;
        }
        return level instanceof LogicTreeLevel.RandomlySampledLevel && nodeCount > 6 || nodeCount > 30;
    }

    public synchronized void processBranchCurves(LogicTreeBranch<?> branch, double weight, DiscretizedFunc[] curves) {
        Preconditions.checkState((curves.length == this.gridLocs.size() ? 1 : 0) != 0);
        List<String> keys = this.getMeanCurveKeys(branch);
        double[] xVals = new double[curves[0].size()];
        for (int i = 0; i < xVals.length; ++i) {
            xVals[i] = curves[0].getX(i);
        }
        for (String key : keys) {
            int i;
            DiscretizedFunc[] meanCurves = this.curvesMap.get(key);
            if (meanCurves == null) {
                meanCurves = new DiscretizedFunc[curves.length];
                for (i = 0; i < curves.length; ++i) {
                    meanCurves[i] = new LightFixedXFunc(xVals, new double[xVals.length]);
                }
                this.curvesMap.put(key, meanCurves);
                this.weightSumsMap.put(key, weight);
            } else {
                Preconditions.checkState((meanCurves.length == curves.length ? 1 : 0) != 0);
                this.weightSumsMap.put(key, this.weightSumsMap.get(key) + weight);
            }
            for (i = 0; i < curves.length; ++i) {
                DiscretizedFunc curve = curves[i];
                DiscretizedFunc meanCurve = meanCurves[i];
                Preconditions.checkState((curve.size() == meanCurve.size() ? 1 : 0) != 0);
                for (int j = 0; j < curve.size(); ++j) {
                    meanCurve.set(j, meanCurve.getY(j) + weight * curve.getY(j));
                }
            }
        }
    }

    public void rawCacheToDir(File outputDir, double period) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(this.curvesMap.keySet());
        Collections.sort(keys);
        CSVFile<String> weightsCSV = new CSVFile<String>(true);
        weightsCSV.addLine("Key", "Weight Sum");
        for (String key : keys) {
            String fileName = SolHazardMapCalc.getCSV_FileName(key + "_curves", period);
            DiscretizedFunc[] curves = this.curvesMap.get(key);
            double weight = this.weightSumsMap.get(key);
            CSVFile<String> curvesCSV = SolHazardMapCalc.buildCurvesCSV(curves, this.gridLocs);
            curvesCSV.writeToFile(new File(outputDir, fileName));
            weightsCSV.addLine(key, "" + weight);
        }
        weightsCSV.writeToFile(new File(outputDir, SolHazardMapCalc.getCSV_FileName("weights", period)));
    }

    public static LogicTreeCurveAverager readRawCacheDir(final File cacheDir, double period, ExecutorService exec) throws IOException {
        File csvFile = new File(cacheDir, SolHazardMapCalc.getCSV_FileName("weights", period));
        for (int i = 0; !csvFile.exists() && i < 5; ++i) {
            System.err.println("WARNING, csv doesn't exist, will sleep 1 second: " + csvFile.getAbsolutePath());
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        CSVFile<String> weightsCSV = CSVFile.readFile(csvFile, true);
        final LogicTreeCurveAverager ret = new LogicTreeCurveAverager(null, null);
        HashMap<String, Future<DiscretizedFunc[]>> loadFutures = new HashMap<String, Future<DiscretizedFunc[]>>();
        for (int row = 1; row < weightsCSV.getNumRows(); ++row) {
            String key = weightsCSV.get(row, 0);
            double weight = weightsCSV.getDouble(row, 1);
            ret.weightSumsMap.put(key, weight);
            final String fileName = SolHazardMapCalc.getCSV_FileName(key + "_curves", period);
            Callable<DiscretizedFunc[]> loadCall = new Callable<DiscretizedFunc[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public DiscretizedFunc[] call() throws Exception {
                    CSVFile<String> curvesCSV = CSVFile.readFile(new File(cacheDir, fileName), true);
                    DiscretizedFunc[] curves = SolHazardMapCalc.loadCurvesCSV(curvesCSV, null);
                    LogicTreeCurveAverager logicTreeCurveAverager = ret;
                    synchronized (logicTreeCurveAverager) {
                        if (ret.gridLocs == null) {
                            ret.gridLocs = new LocationList();
                            for (int i = 0; i < curves.length; ++i) {
                                Preconditions.checkState((curvesCSV.getInt(i + 1, 0) == i ? 1 : 0) != 0);
                                double lat = curvesCSV.getDouble(i + 1, 1);
                                double lon = curvesCSV.getDouble(i + 1, 2);
                                ret.gridLocs.add(new Location(lat, lon));
                            }
                        } else {
                            Preconditions.checkState((ret.gridLocs.size() == curves.length ? 1 : 0) != 0);
                        }
                    }
                    return curves;
                }
            };
            loadFutures.put(key, exec.submit(loadCall));
        }
        for (String key : loadFutures.keySet()) {
            try {
                ret.curvesMap.put(key, (DiscretizedFunc[])((Future)loadFutures.get(key)).get());
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        return ret;
    }

    public void addFrom(LogicTreeCurveAverager other) {
        if (this.gridLocs == null && other.gridLocs != null) {
            this.gridLocs = other.gridLocs;
        }
        double[] xVals = null;
        for (String key : other.curvesMap.keySet()) {
            int i;
            double weight = other.weightSumsMap.get(key);
            DiscretizedFunc[] curves = other.curvesMap.get(key);
            DiscretizedFunc[] meanCurves = this.curvesMap.get(key);
            if (meanCurves == null) {
                meanCurves = new DiscretizedFunc[curves.length];
                if (xVals == null) {
                    xVals = new double[curves[0].size()];
                    for (i = 0; i < xVals.length; ++i) {
                        xVals[i] = curves[0].getX(i);
                    }
                }
                for (i = 0; i < curves.length; ++i) {
                    meanCurves[i] = new LightFixedXFunc(xVals, new double[xVals.length]);
                }
                this.curvesMap.put(key, meanCurves);
                this.weightSumsMap.put(key, weight);
            } else {
                Preconditions.checkState((meanCurves.length == curves.length ? 1 : 0) != 0);
                this.weightSumsMap.put(key, this.weightSumsMap.get(key) + weight);
            }
            for (i = 0; i < curves.length; ++i) {
                DiscretizedFunc curve = curves[i];
                DiscretizedFunc meanCurve = meanCurves[i];
                Preconditions.checkState((curve.size() == meanCurve.size() ? 1 : 0) != 0);
                for (int j = 0; j < curve.size(); ++j) {
                    meanCurve.set(j, meanCurve.getY(j) + curve.getY(j));
                }
            }
        }
    }

    private DiscretizedFunc[] getNormalized(DiscretizedFunc[] curves, double weight) {
        if ((float)weight != 1.0f) {
            double scale = 1.0 / weight;
            DiscretizedFunc[] normCurves = new DiscretizedFunc[curves.length];
            for (int i = 0; i < curves.length; ++i) {
                normCurves[i] = curves[i].deepClone();
                normCurves[i].scale(scale);
            }
            return normCurves;
        }
        return curves;
    }

    public Map<String, DiscretizedFunc[]> getNormalizedCurves() {
        HashMap<String, DiscretizedFunc[]> ret = new HashMap<String, DiscretizedFunc[]>();
        for (String key : this.curvesMap.keySet()) {
            ret.put(key, this.getNormalized(this.curvesMap.get(key), this.weightSumsMap.get(key)));
        }
        return ret;
    }

    public static String choicePrefix(LogicTreeLevel<?> level, LogicTreeNode node) {
        return level.getFilePrefix() + "_" + node.getFilePrefix();
    }

    public static String choiceWithoutPrefix(LogicTreeLevel<?> level, LogicTreeNode node) {
        return level.getFilePrefix() + "_without_" + node.getFilePrefix();
    }

    private List<String> getMeanCurveKeys(LogicTreeBranch<?> branch) {
        ArrayList<String> meanCurveKeys = new ArrayList<String>();
        meanCurveKeys.add(MEAN_PREFIX);
        for (int i = 0; i < branch.size(); ++i) {
            Object obj = branch.getValue(i);
            if (obj == null || !this.nodeLevels.containsKey(obj)) continue;
            meanCurveKeys.add(LogicTreeCurveAverager.choicePrefix(branch.getLevel(i), obj));
        }
        if (this.variableNodes != null) {
            for (LogicTreeNode logicTreeNode : this.variableNodes) {
                if (branch.hasValue(logicTreeNode)) continue;
                meanCurveKeys.add(LogicTreeCurveAverager.choiceWithoutPrefix(this.nodeLevels.get(logicTreeNode), logicTreeNode));
            }
        }
        return meanCurveKeys;
    }
}

