/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.CSVWriter;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeHazardCompare;
import org.opensha.sha.earthquake.faultSysSolution.hazard.SiteLogicTreeHazardPageGen;
import org.opensha.sha.earthquake.faultSysSolution.hazard.mpj.MPJ_SiteLogicTreeHazardCurveCalc;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;
import org.opensha.sha.imr.attenRelImpl.nshmp.NSHMP_Config;

public class LogicTreeSimplifiedMapCurveWriter {
    private static final int MAX_SITES_IN_MEMORY_DEFAULT = 1000;
    private static final int MAX_ASYNC_READS = 10;
    static final double[] FRACTILES = new double[]{0.025, 0.16, 0.84, 0.975};
    static final String[] PERCENTILE_HEADERS;
    private static final DecimalFormat timeDF;

    public static Options createOptions() {
        Options ops = new Options();
        ops.addOption(null, "max-read-threads", true, "Maximum read threads (>=1, more use more memory). Default is 10");
        ops.addOption(null, "max-sites-in-memory", true, "Maximum number of sites to keep in memory at once; lower values require more passes through the data. Default is 1000");
        ops.addOption(null, "max-zip-threads", true, "Maximum parallel zip threads (>=1, more use more memory). Default is min(8, cpus-4).");
        ops.addOption(null, "nshmp-imls", false, "Flag to store data at NSHMP-lib IMLs (period-dependent)");
        return ops;
    }

    public static void main(String[] args) {
        try {
            LogicTreeSimplifiedMapCurveWriter.run(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void run(String[] args) throws IOException {
        int bundleSize;
        File summaryOutputFile;
        File fullOutputFile;
        CommandLine cmd = FaultSysTools.parseOptions(LogicTreeSimplifiedMapCurveWriter.createOptions(), args, LogicTreeSimplifiedMapCurveWriter.class);
        args = cmd.getArgs();
        if (args.length < 5 || args.length > 6) {
            System.err.println("USAGE: LogicTreeSimplifiedMapCurveWriter <results-dir> <logic-tree-file.json> <gridded-region.geojson> <hazard-dir-name> [<full-output-dir>] <summary-output-dir>");
            System.exit(1);
        }
        File resultsDir = new File(args[0]);
        Preconditions.checkState((boolean)resultsDir.exists());
        File logicTreeFile = new File(args[1]);
        Preconditions.checkState((boolean)logicTreeFile.exists());
        File gridRegFile = new File(args[2]);
        Preconditions.checkState((boolean)gridRegFile.exists());
        String hazardDirName = args[3];
        if (args.length == 5) {
            fullOutputFile = null;
            summaryOutputFile = new File(args[4]);
        } else {
            fullOutputFile = new File(args[4]);
            summaryOutputFile = new File(args[5]);
        }
        final boolean nshmpIMLs = cmd.hasOption("nshmp-imls");
        LogicTree<LogicTreeNode> tree = LogicTree.read(logicTreeFile);
        final int treeSize = tree.size();
        final ArrayList<Double> branchWeights = new ArrayList<Double>(treeSize);
        double sumWeights = 0.0;
        for (int i = 0; i < treeSize; ++i) {
            double weight = tree.getBranchWeight(i);
            branchWeights.add(weight);
            sumWeights += weight;
        }
        if (!Precision.equals((double)sumWeights, (double)1.0, (double)1.0E-5)) {
            double scalar = 1.0 / sumWeights;
            for (int i = 0; i < treeSize; ++i) {
                branchWeights.set(i, (Double)branchWeights.get(i) * scalar);
            }
        }
        final GriddedRegion gridReg = LogicTreeSimplifiedMapCurveWriter.loadGridReg(gridRegFile);
        System.out.println("Initializing output writers");
        ArchiveOutput.ApacheZipFileOutput tmpFullOutput = null;
        if (fullOutputFile != null) {
            int threads = FaultSysTools.defaultNumThreads();
            int maxThreads = Integer.min(8, threads - 4);
            if (cmd.hasOption("max-zip-threads")) {
                maxThreads = Integer.parseInt(cmd.getOptionValue("max-zip-threads"));
                Preconditions.checkState((maxThreads >= 1 ? 1 : 0) != 0, (Object)"Must have at least 1 zip thread");
            }
            tmpFullOutput = threads < 8 || maxThreads == 1 ? new ArchiveOutput.AsynchronousZipFileOutput(fullOutputFile) : new ArchiveOutput.ParallelZipFileOutput(fullOutputFile, maxThreads, true);
        }
        final ArchiveOutput.AsynchronousZipFileOutput fullOutput = tmpFullOutput;
        ArchiveOutput.AsynchronousZipFileOutput summaryOutput = new ArchiveOutput.AsynchronousZipFileOutput(summaryOutputFile);
        System.out.println("Writing site and logic tree JSON and CSVs");
        ArchiveOutput[] outputs = new ArchiveOutput[]{summaryOutput, fullOutput};
        CSVFile<String> sitesCSV = new CSVFile<String>(true);
        sitesCSV.addLine("Grid Index", "Latitude", "Longitude");
        for (int i = 0; i < gridReg.getNodeCount(); ++i) {
            ArchiveOutput[] loc = gridReg.getLocation(i);
            sitesCSV.addLine("" + i, "" + (float)loc.lat, "" + (float)loc.lon);
        }
        CSVFile<String> logicTreeCSV = LogicTreeSimplifiedMapCurveWriter.buildLogicTreeCSV(tree, branchWeights);
        for (ArchiveOutput output : outputs) {
            if (output == null) continue;
            output.putNextEntry("gridded_region.geojson");
            OutputStreamWriter writer = new OutputStreamWriter(output.getOutputStream());
            Feature.write(gridReg.toFeature(), writer);
            ((Writer)writer).flush();
            output.closeEntry();
            output.putNextEntry("grid_locations.csv");
            sitesCSV.writeToStream(output.getOutputStream());
            output.closeEntry();
            tree.writeToArchive(output, "");
            output.putNextEntry("logic_tree.csv");
            logicTreeCSV.writeToStream(output.getOutputStream());
            output.closeEntry();
        }
        sitesCSV = null;
        logicTreeCSV = null;
        File resultsDirZip = new File(resultsDir.getParentFile(), resultsDir.getName() + ".zip");
        ArchiveInput.FileBacked resultsDirInput = resultsDirZip.exists() ? new ArchiveInput.ZipFileInput(resultsDirZip) : new ArchiveInput.DirectoryInput(resultsDir.toPath());
        System.out.println("Detecting calculation periods from " + resultsDirInput.getName());
        double[] periods = LogicTreeHazardCompare.detectHazardPeriods(new SolHazardMapCalc.ReturnPeriods[]{SolHazardMapCalc.ReturnPeriods.TWO_IN_50}, resultsDirInput);
        resultsDirInput.close();
        int maxSitesInMemory = 1000;
        if (cmd.hasOption("max-sites-in-memory")) {
            maxSitesInMemory = Integer.parseInt(cmd.getOptionValue("max-sites-in-memory"));
        }
        Preconditions.checkState((maxSitesInMemory > 1 ? 1 : 0) != 0, (Object)"Max sites in memory must be positive");
        ArrayList<int[]> siteLoadBatches = new ArrayList<int[]>();
        int curSiteIndex = 0;
        for (int numSitesLeft = gridReg.getNodeCount(); numSitesLeft > 0; numSitesLeft -= bundleSize) {
            bundleSize = Integer.min(numSitesLeft, maxSitesInMemory);
            int[] bundle = new int[bundleSize];
            for (int i = 0; i < bundleSize; ++i) {
                bundle[i] = curSiteIndex++;
            }
            siteLoadBatches.add(bundle);
        }
        int branchMod = treeSize >= 100000 ? 5000 : (treeSize >= 50000 ? 2500 : (treeSize >= 20000 ? 1000 : (treeSize >= 10000 ? 500 : (treeSize >= 5000 ? 250 : (treeSize >= 1000 ? 50 : 10)))));
        int maxBundleSize = ((int[])siteLoadBatches.get(0)).length;
        int siteMod = maxBundleSize >= 10000 ? 500 : (maxBundleSize >= 5000 ? 250 : (maxBundleSize >= 1000 ? 50 : (maxBundleSize >= 500 ? 25 : (maxBundleSize >= 100 ? 5 : 1))));
        if (siteLoadBatches.size() > 1) {
            System.out.println("Have to read data " + siteLoadBatches.size() + " times to keep data from at most " + maxSitesInMemory + " sites in memory at once");
        }
        int maxReadThreads = 10;
        if (cmd.hasOption("max-read-threads")) {
            maxReadThreads = Integer.parseInt(cmd.getOptionValue("max-read-threads"));
            Preconditions.checkState((maxReadThreads >= 1 ? 1 : 0) != 0, (Object)"Must have at least 1 read thread");
        }
        Stopwatch overallWatch = Stopwatch.createStarted();
        for (int p = 0; p < periods.length; ++p) {
            String perUnits;
            Object perLabel;
            System.out.println("Processing files for period " + p + "/" + periods.length + " (" + (float)periods[p] + ")");
            if (periods[p] == -1.0) {
                perLabel = "PGV";
                perUnits = "cm/s";
            } else if (periods[p] == 0.0) {
                perLabel = "PGA";
                perUnits = "g";
            } else {
                perLabel = (float)periods[p] + "s SA";
                perUnits = "g";
            }
            final double[] nshmpXVals = nshmpIMLs ? NSHMP_Config.imlsFor(periods[p]) : null;
            for (int b = 0; b < siteLoadBatches.size(); ++b) {
                DiscretizedFunc[][] branch;
                System.out.println("\tProcessing site batch " + b + "/" + siteLoadBatches.size() + ", period " + p + "/" + periods.length);
                final int[] siteIndexes = (int[])siteLoadBatches.get(b);
                System.out.println("\t\tLoading data for " + siteIndexes.length + " sites");
                DiscretizedFunc[][] siteCurves = new DiscretizedFunc[siteIndexes.length][treeSize];
                ArrayDeque<CompletableFuture<Void>> curveLoadFutures = new ArrayDeque<CompletableFuture<Void>>(maxReadThreads);
                Stopwatch watch = Stopwatch.createStarted();
                for (int i = 0; i < treeSize; ++i) {
                    if (curveLoadFutures.size() == maxReadThreads) {
                        ((CompletableFuture)curveLoadFutures.removeFirst()).join();
                    }
                    if (i % branchMod == 0) {
                        System.out.println("\t\tProcessing branch " + i + "/" + treeSize);
                    }
                    branch = tree.getBranch(i);
                    File resultsSubDir = branch.getBranchDirectory(resultsDir, false);
                    Preconditions.checkState((boolean)resultsSubDir.exists(), (String)"Results sub-dir doesn't exist: %s", (Object)resultsSubDir.getAbsolutePath());
                    File hazardDir = new File(resultsSubDir, hazardDirName);
                    Preconditions.checkState((boolean)hazardDir.exists(), (String)"Hazard dir doesn't exist: %s", (Object)hazardDir.getAbsolutePath());
                    File curvesFile = new File(hazardDir, SolHazardMapCalc.getCSV_FileName("curves", periods[p]));
                    if (!curvesFile.exists()) {
                        curvesFile = new File(curvesFile.getAbsolutePath() + ".gz");
                    }
                    Preconditions.checkState((boolean)curvesFile.exists(), (String)"Curve files doesn't exist: %s", (Object)curvesFile.getAbsolutePath());
                    final File file = curvesFile;
                    int branchIndex = i;
                    int firstXValWarn = b == 0 && i == 0 ? 1 : 0;
                    curveLoadFutures.addLast(CompletableFuture.runAsync(new Runnable(){
                        final /* synthetic */ boolean val$firstXValWarn;
                        final /* synthetic */ DiscretizedFunc[][] val$siteCurves;
                        final /* synthetic */ int val$branchIndex;
                        {
                            this.val$firstXValWarn = bl2;
                            this.val$siteCurves = discretizedFuncArray;
                            this.val$branchIndex = n;
                        }

                        @Override
                        public void run() {
                            CSVFile<String> csv;
                            try {
                                csv = CSVFile.readFile(file, true);
                            }
                            catch (IOException e) {
                                throw ExceptionUtils.asRuntimeException((Throwable)e);
                            }
                            DiscretizedFunc[] branchCurves = SolHazardMapCalc.loadCurvesCSV(csv, gridReg);
                            for (int s = 0; s < siteIndexes.length; ++s) {
                                DiscretizedFunc curve = branchCurves[siteIndexes[s]];
                                if (nshmpIMLs) {
                                    double[] interpYVals = new double[nshmpXVals.length];
                                    double curveMinX = curve.getMinX();
                                    double curveMaxX = curve.getMaxX();
                                    for (int j = 0; j < nshmpXVals.length; ++j) {
                                        double x = nshmpXVals[j];
                                        if (x < curveMinX) {
                                            if (this.val$firstXValWarn) {
                                                System.err.println("WARNING: Input curve minX=" + (float)curveMinX + " > nshmpMinX=" + (float)x + ", extrapolating using y from input minX");
                                            }
                                            interpYVals[j] = curve.getY(0);
                                            continue;
                                        }
                                        if (x > curveMaxX) {
                                            if (this.val$firstXValWarn) {
                                                System.err.println("WARNING: Input curve maxX=" + (float)curveMaxX + " < nshmpMaxX=" + (float)x + ", extrapolating using y=0");
                                            }
                                            interpYVals[j] = 0.0;
                                            continue;
                                        }
                                        interpYVals[j] = curve.getInterpolatedY_inLogXDomain(x);
                                    }
                                    curve = new LightFixedXFunc(nshmpXVals, interpYVals);
                                }
                                this.val$siteCurves[s][this.val$branchIndex] = curve;
                            }
                        }
                    }));
                }
                while (!curveLoadFutures.isEmpty()) {
                    ((CompletableFuture)curveLoadFutures.removeFirst()).join();
                }
                watch.stop();
                System.out.println("\tTook " + LogicTreeSimplifiedMapCurveWriter.timeStr(watch));
                DiscretizedFunc xVals = null;
                branch = siteCurves;
                int resultsSubDir = branch.length;
                for (int hazardDir = 0; hazardDir < resultsSubDir; ++hazardDir) {
                    DiscretizedFunc[] curves;
                    for (DiscretizedFunc curve : curves = branch[hazardDir]) {
                        if (curve == null) continue;
                        xVals = curve;
                        break;
                    }
                    if (xVals != null) break;
                }
                Preconditions.checkNotNull(xVals, (Object)"No non-null curves found!");
                final DiscretizedFunc finalXVals = xVals;
                System.out.println("\tWriting data for site batch " + b + "/" + siteLoadBatches.size() + ", period " + p + "/" + periods.length);
                watch.reset();
                watch.start();
                CompletableFuture<Void> fullWriteFuture = null;
                CompletableFuture<Void> summaryWriteFuture = null;
                for (int s = 0; s < siteIndexes.length; ++s) {
                    if (s % siteMod == 0) {
                        System.out.println("\t\tWriting data for site " + s + "/" + siteIndexes.length);
                    }
                    int n = siteIndexes[s];
                    final DiscretizedFunc[] curves = siteCurves[s];
                    final String sitePrefix = MPJ_SiteLogicTreeHazardCurveCalc.getSitePeriodPrefix("grid_" + n, periods[p]);
                    if (fullOutput != null) {
                        if (fullWriteFuture != null) {
                            fullWriteFuture.join();
                        }
                        fullWriteFuture = CompletableFuture.runAsync(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    int i;
                                    fullOutput.putNextEntry(sitePrefix + ".csv");
                                    CSVWriter writer = new CSVWriter(fullOutput.getOutputStream(), true);
                                    ArrayList<String> header = new ArrayList<String>(2 + finalXVals.size());
                                    header.add("Branch Index");
                                    header.add("Branch Weight");
                                    for (i = 0; i < finalXVals.size(); ++i) {
                                        header.add("" + (float)finalXVals.getX(i));
                                    }
                                    writer.write(header);
                                    for (i = 0; i < treeSize; ++i) {
                                        int j;
                                        ArrayList<String> line = new ArrayList<String>(header.size());
                                        line.add("" + i);
                                        line.add("" + ((Double)branchWeights.get(i)).floatValue());
                                        DiscretizedFunc curve = curves[i];
                                        if (curve == null) {
                                            for (j = 0; j < finalXVals.size(); ++j) {
                                                line.add("0.0");
                                            }
                                        } else {
                                            Preconditions.checkState((curve.size() == finalXVals.size() ? 1 : 0) != 0);
                                            for (j = 0; j < curve.size(); ++j) {
                                                line.add("" + (float)curve.getY(j));
                                            }
                                        }
                                        writer.write(line);
                                    }
                                    writer.flush();
                                    fullOutput.closeEntry();
                                }
                                catch (IOException e) {
                                    throw ExceptionUtils.asRuntimeException((Throwable)e);
                                }
                            }
                        });
                    }
                    if (summaryWriteFuture != null) {
                        summaryWriteFuture.join();
                    }
                    summaryWriteFuture = CompletableFuture.runAsync(new Runnable(){
                        final /* synthetic */ String val$perLabel;
                        final /* synthetic */ String val$perUnits;
                        final /* synthetic */ ArchiveOutput val$summaryOutput;
                        final /* synthetic */ String val$sitePrefix;
                        {
                            this.val$perLabel = string;
                            this.val$perUnits = string2;
                            this.val$summaryOutput = archiveOutput;
                            this.val$sitePrefix = string3;
                        }

                        @Override
                        public void run() {
                            SiteLogicTreeHazardPageGen.ValueDistribution[] curveDists = new SiteLogicTreeHazardPageGen.ValueDistribution[finalXVals.size()];
                            for (int x = 0; x < finalXVals.size(); ++x) {
                                ArrayList<Double> vals = new ArrayList<Double>(treeSize);
                                for (int i = 0; i < treeSize; ++i) {
                                    DiscretizedFunc curve = curves[i];
                                    if (curve == null) {
                                        vals.add(0.0);
                                        continue;
                                    }
                                    vals.add(curve.getY(x));
                                }
                                curveDists[x] = new SiteLogicTreeHazardPageGen.ValueDistribution(vals, branchWeights);
                            }
                            CSVFile<String> csv = LogicTreeSimplifiedMapCurveWriter.buildCurveDistCSV(curveDists, this.val$perLabel + " (" + this.val$perUnits + ")", finalXVals);
                            try {
                                this.val$summaryOutput.putNextEntry(this.val$sitePrefix + ".csv");
                                csv.writeToStream(this.val$summaryOutput.getOutputStream());
                                this.val$summaryOutput.closeEntry();
                            }
                            catch (IOException e) {
                                throw ExceptionUtils.asRuntimeException((Throwable)e);
                            }
                        }
                    });
                }
                if (fullWriteFuture != null) {
                    fullWriteFuture.join();
                }
                if (summaryWriteFuture != null) {
                    summaryWriteFuture.join();
                }
                System.out.println("\tDONE writing data for site batch " + b + "/" + siteLoadBatches.size() + ", period " + p + "/" + periods.length);
                watch.stop();
                System.out.println("\tTook " + LogicTreeSimplifiedMapCurveWriter.timeStr(watch));
            }
        }
        if (fullOutput != null) {
            fullOutput.close();
        }
        summaryOutput.close();
        System.out.println("DONE");
        overallWatch.stop();
        System.out.println("Took " + LogicTreeSimplifiedMapCurveWriter.timeStr(overallWatch));
        System.exit(0);
    }

    static CSVFile<String> buildCurveDistCSV(SiteLogicTreeHazardPageGen.ValueDistribution[] dists, String periodHeader, DiscretizedFunc xVals) {
        Preconditions.checkState((xVals.size() == dists.length ? 1 : 0) != 0);
        CSVFile<String> csv = new CSVFile<String>(true);
        ArrayList<String> header = new ArrayList<String>(5 + PERCENTILE_HEADERS.length);
        header.add(periodHeader);
        header.add("Mean");
        header.add("Median");
        header.add("Min");
        for (String pHeader : PERCENTILE_HEADERS) {
            header.add(pHeader);
        }
        header.add("Max");
        csv.addLine((List<String>)header);
        for (int i = 0; i < xVals.size(); ++i) {
            SiteLogicTreeHazardPageGen.ValueDistribution dist = dists[i];
            ArrayList<CallSite> line = new ArrayList<CallSite>(header.size());
            line.add((CallSite)((Object)("" + (float)xVals.getX(i))));
            line.add((CallSite)((Object)("" + dist.mean)));
            line.add((CallSite)((Object)("" + dist.getInterpolatedFractile(0.5))));
            line.add((CallSite)((Object)("" + dist.min)));
            for (double fractile : FRACTILES) {
                line.add((CallSite)((Object)("" + dist.getInterpolatedFractile(fractile))));
            }
            line.add((CallSite)((Object)("" + dist.max)));
            csv.addLine((List<String>)line);
        }
        return csv;
    }

    static CSVFile<String> buildLogicTreeCSV(LogicTree<?> tree, List<Double> branchWeights) {
        CSVFile<String> logicTreeCSV = new CSVFile<String>(true);
        ArrayList<String> branchHeader = new ArrayList<String>();
        branchHeader.add("Branch Index");
        branchHeader.add("Branch Weight");
        for (LogicTreeLevel level : tree.getLevels()) {
            branchHeader.add(level.getShortName());
        }
        logicTreeCSV.addLine((List<String>)branchHeader);
        int treeSize = tree.size();
        for (int i = 0; i < treeSize; ++i) {
            ArrayList<Object> line = new ArrayList<Object>(branchHeader.size());
            line.add("" + i);
            line.add(String.valueOf(branchWeights.get(i)));
            LogicTreeBranch<?> branch = tree.getBranch(i);
            for (LogicTreeNode node : branch) {
                line.add(node.getShortName());
            }
            logicTreeCSV.addLine((List<String>)line);
        }
        return logicTreeCSV;
    }

    private static GriddedRegion loadGridReg(File regFile) throws IOException {
        Preconditions.checkState((boolean)regFile.exists(), (String)"Supplied region file doesn't exist: %s", (Object)regFile.getAbsolutePath());
        if (regFile.getName().toLowerCase().endsWith(".zip")) {
            ZipFile zip = new ZipFile(regFile);
            ZipEntry regEntry = zip.getEntry("gridded_region.geojson");
            System.out.println("Reading gridded region from zip file: " + regEntry.getName());
            BufferedReader bRead = new BufferedReader(new InputStreamReader(zip.getInputStream(regEntry)));
            GriddedRegion region = GriddedRegion.fromFeature(Feature.read(bRead));
            zip.close();
            return region;
        }
        Feature feature = Feature.read(regFile);
        return GriddedRegion.fromFeature(feature);
    }

    private static String timeStr(Stopwatch watch) {
        double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        if (secs > 60.0) {
            double mins = secs / 60.0;
            if (mins > 60.0) {
                return timeDF.format(mins / 60.0) + "h";
            }
            return timeDF.format(mins) + "m";
        }
        return timeDF.format(secs) + "s";
    }

    static {
        String[] headers = new String[FRACTILES.length];
        DecimalFormat df = new DecimalFormat("0.#");
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = "p" + df.format(FRACTILES[i] * 100.0);
        }
        PERCENTILE_HEADERS = headers;
        timeDF = new DecimalFormat("0.0");
    }
}

