/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard.mpj;

import com.google.common.base.Preconditions;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.calc.params.filters.SourceFilterManager;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.DistCachedERFWrapper;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysHazardCalcSettings;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenRelSupplier;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.nshmp.NSHMP_GMM_Wrapper;
import org.opensha.sha.imr.logicTree.ScalarIMR_ParamsLogicTreeNode;
import org.opensha.sha.imr.logicTree.ScalarIMRsLogicTreeNode;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.erf.FaultSystemSolutionERF;

public abstract class AbstractSitewiseThreadedLogicTreeCalc {
    private ExecutorService exec;
    private int numSites;
    private SolutionLogicTree solTree;
    private LogicTree<?> tree;
    private boolean hasGMMLevels;
    private Map<TectonicRegionType, AttenRelSupplier> gmmRefs;
    private double[] periods;
    private IncludeBackgroundOption gridSeisOp;
    private GriddedSeismicitySettings griddedSettings;
    private boolean cacheGridSources = true;
    private boolean doGmmInputCache = false;
    private SourceFilterManager sourceFilters;
    private DiscretizedFunc[] xVals;
    private DiscretizedFunc[] logXVals;
    private LogicTreeBranch<?> prevBranch;
    private int prevBranchIndex = -1;
    private FaultSystemSolutionERF prevERF;
    private int[] prevSiteIndexes;
    private int gmmCacheBranchIndex = -1;
    private NSHMP_GMM_Wrapper[] gmmSiteCaches;

    public AbstractSitewiseThreadedLogicTreeCalc(ExecutorService exec, int numSites, SolutionLogicTree solTree, AttenRelSupplier gmmRef, double[] periods, IncludeBackgroundOption gridSeisOp, GriddedSeismicitySettings griddedSettings, SourceFilterManager sourceFilters) {
        this(exec, numSites, solTree, FaultSysHazardCalcSettings.wrapInTRTMap(gmmRef), periods, gridSeisOp, griddedSettings, sourceFilters);
    }

    public AbstractSitewiseThreadedLogicTreeCalc(ExecutorService exec, int numSites, SolutionLogicTree solTree, Map<TectonicRegionType, AttenRelSupplier> gmmRefs, double[] periods, IncludeBackgroundOption gridSeisOp, GriddedSeismicitySettings griddedSettings, SourceFilterManager sourceFilters) {
        this.exec = exec;
        this.numSites = numSites;
        this.solTree = solTree;
        this.gmmRefs = gmmRefs;
        this.periods = periods;
        this.gridSeisOp = gridSeisOp;
        this.griddedSettings = griddedSettings;
        this.sourceFilters = sourceFilters;
        this.tree = solTree.getLogicTree();
        for (LogicTreeLevel level : this.tree.getLevels()) {
            if (!AbstractSitewiseThreadedLogicTreeCalc.isGMMLevel(level) || level.getNodes().size() <= 1) continue;
            this.hasGMMLevels = true;
            break;
        }
        this.xVals = new DiscretizedFunc[periods.length];
        this.logXVals = new DiscretizedFunc[periods.length];
        IMT_Info imtInfo = new IMT_Info();
        for (int p = 0; p < periods.length; ++p) {
            this.xVals[p] = periods[p] == -1.0 ? imtInfo.getDefaultHazardCurve("PGV") : (periods[p] == 0.0 ? imtInfo.getDefaultHazardCurve("PGA") : imtInfo.getDefaultHazardCurve("SA"));
            this.logXVals[p] = new ArbitrarilyDiscretizedFunc();
            for (Point2D pt : this.xVals[p]) {
                this.logXVals[p].set(Math.log(pt.getX()), 0.0);
            }
        }
        this.debug("hasGMMLevels=" + this.hasGMMLevels);
    }

    public void setCacheGridSources(boolean cacheGridSources) {
        this.cacheGridSources = cacheGridSources;
    }

    public void setDoGmmInputCache(boolean doGmmInputCache) {
        this.doGmmInputCache = doGmmInputCache;
    }

    private static boolean isGMMLevel(LogicTreeLevel<?> level) {
        return ScalarIMRsLogicTreeNode.class.isAssignableFrom(level.getType()) || ScalarIMR_ParamsLogicTreeNode.class.isAssignableFrom(level.getType());
    }

    public abstract Site siteForIndex(int var1, Map<TectonicRegionType, ScalarIMR> var2);

    public abstract void debug(String var1);

    public DiscretizedFunc[] getXVals() {
        return this.xVals;
    }

    public DiscretizedFunc[] getLogXVals() {
        return this.logXVals;
    }

    public DiscretizedFunc[][] calcForBranch(int branchIndex) throws IOException {
        int[] siteIndexes = new int[this.numSites];
        for (int s = 0; s < this.numSites; ++s) {
            siteIndexes[s] = s;
        }
        return this.calcForBranch(branchIndex, siteIndexes);
    }

    public DiscretizedFunc[][] calcForBranch(int branchIndex, int[] siteIndexes) throws IOException {
        LogicTreeBranch<?> branch = this.tree.getBranch(branchIndex);
        FaultSystemSolutionERF erf = null;
        if (this.hasGMMLevels && this.prevBranch != null) {
            boolean onlyGmmDifferent = true;
            for (int l = 0; l < branch.size(); ++l) {
                if (branch.getValue(l).equals(this.prevBranch.getValue(l)) || AbstractSitewiseThreadedLogicTreeCalc.isGMMLevel(branch.getLevel(l))) continue;
                onlyGmmDifferent = false;
                this.debug("More than GMM different between " + branchIndex + " and " + this.prevBranchIndex + ": '" + String.valueOf(branch.getValue(l)) + "' != '" + String.valueOf(this.prevBranch.getValue(l)) + "'");
                break;
            }
            if (onlyGmmDifferent) {
                this.debug("Re-using ERF from branch " + this.prevBranchIndex + " for branch " + branchIndex);
                erf = this.prevERF;
            } else {
                this.prevSiteIndexes = null;
                this.gmmSiteCaches = null;
            }
        }
        if (erf == null) {
            this.debug("Building ERF for branch " + branchIndex);
            this.prevSiteIndexes = null;
            this.gmmSiteCaches = null;
            FaultSystemSolution sol = this.solTree.forBranch(branch);
            erf = new FaultSystemSolutionERF(sol);
            if (this.gridSeisOp == IncludeBackgroundOption.INCLUDE || this.gridSeisOp == IncludeBackgroundOption.ONLY) {
                Preconditions.checkNotNull((Object)sol.getGridSourceProvider(), (String)"Grid source provider is null, but gridded seis option is %s", (Object)((Object)this.gridSeisOp));
            }
            erf.setParameter("Background Seismicity", (Object)this.gridSeisOp);
            erf.getTimeSpan().setDuration(1.0);
            erf.setGriddedSeismicitySettings(this.griddedSettings);
            erf.setCacheGridSources(this.cacheGridSources);
            erf.updateForecast();
        }
        Map<TectonicRegionType, AttenRelSupplier> gmmSuppliers = FaultSysHazardCalcSettings.getGMM_Suppliers(branch, this.gmmRefs, true);
        boolean doGmmInputCache = false;
        if (this.hasGMMLevels && this.doGmmInputCache) {
            for (Supplier supplier : gmmSuppliers.values()) {
                ScalarIMR gmm = (ScalarIMR)supplier.get();
                if (gmm instanceof NSHMP_GMM_Wrapper) {
                    doGmmInputCache = true;
                    continue;
                }
                doGmmInputCache = false;
                break;
            }
        }
        ArrayDeque<DistCachedERFWrapper> erfDeque = new ArrayDeque<DistCachedERFWrapper>();
        if (doGmmInputCache) {
            if (this.prevSiteIndexes == null || this.gmmSiteCaches != null && !Arrays.equals(siteIndexes, this.prevSiteIndexes)) {
                this.prevSiteIndexes = null;
                this.gmmSiteCaches = null;
            }
            if (this.gmmSiteCaches == null) {
                this.debug("Pre-caching GMM inputs for branch " + branchIndex);
                ArrayList<Future<NSHMP_GMM_Wrapper>> arrayList = new ArrayList<Future<NSHMP_GMM_Wrapper>>(siteIndexes.length);
                for (Object siteIndex : (ScalarIMR)siteIndexes) {
                    arrayList.add(this.exec.submit(new SitePrecacheCall(erf, (int)siteIndex, erfDeque)));
                }
                this.debug("DONE pre-caching GMM inputs for branch " + branchIndex);
                this.gmmSiteCaches = new NSHMP_GMM_Wrapper[siteIndexes.length];
                for (int s = 0; s < siteIndexes.length; ++s) {
                    try {
                        this.gmmSiteCaches[s] = (NSHMP_GMM_Wrapper)((Future)arrayList.get(s)).get();
                        continue;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
                this.gmmCacheBranchIndex = branchIndex;
            } else {
                this.debug("Re-using GMM inputs from branch " + this.gmmCacheBranchIndex + " for branch " + branchIndex);
            }
        }
        this.debug("Calculaing " + siteIndexes.length + " sites for branch " + branchIndex);
        ArrayList<Future<DiscretizedFunc[]>> arrayList = new ArrayList<Future<DiscretizedFunc[]>>(siteIndexes.length);
        for (int s = 0; s < siteIndexes.length; ++s) {
            int siteIndex = siteIndexes[s];
            SiteCalcCall call = new SiteCalcCall(erf, siteIndex, gmmSuppliers, erfDeque);
            if (doGmmInputCache) {
                call.cacheSupplier = this.gmmSiteCaches[s];
            }
            arrayList.add(this.exec.submit(call));
        }
        this.debug("DONE calculaing " + siteIndexes.length + " sites for branch " + branchIndex);
        DiscretizedFunc[][] curves = new DiscretizedFunc[siteIndexes.length][];
        for (int s = 0; s < siteIndexes.length; ++s) {
            try {
                curves[s] = (DiscretizedFunc[])((Future)arrayList.get(s)).get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        this.prevERF = erf;
        this.prevBranch = branch;
        this.prevBranchIndex = branchIndex;
        this.prevSiteIndexes = siteIndexes;
        return curves;
    }

    private synchronized DistCachedERFWrapper checkOutERF(FaultSystemSolutionERF fssERF, Deque<DistCachedERFWrapper> deque) {
        if (!deque.isEmpty()) {
            return deque.pop();
        }
        return new DistCachedERFWrapper(fssERF);
    }

    private synchronized void checkInERF(DistCachedERFWrapper erf, Deque<DistCachedERFWrapper> deque) {
        deque.push(erf);
    }

    private class SitePrecacheCall
    implements Callable<NSHMP_GMM_Wrapper> {
        private FaultSystemSolutionERF fssERF;
        private int siteIndex;
        private Deque<DistCachedERFWrapper> erfDeque;

        private SitePrecacheCall(FaultSystemSolutionERF fssERF, int siteIndex, Deque<DistCachedERFWrapper> erfDeque) {
            this.fssERF = fssERF;
            this.siteIndex = siteIndex;
            this.erfDeque = erfDeque;
        }

        @Override
        public NSHMP_GMM_Wrapper call() throws Exception {
            DistCachedERFWrapper erf = AbstractSitewiseThreadedLogicTreeCalc.this.checkOutERF(this.fssERF, this.erfDeque);
            NSHMP_GMM_Wrapper.InputCacheGen cache = new NSHMP_GMM_Wrapper.InputCacheGen();
            List<SourceFilter> filters = AbstractSitewiseThreadedLogicTreeCalc.this.sourceFilters.getEnabledFilters();
            EnumMap<TectonicRegionType, ScalarIMR> gmmMap = new EnumMap<TectonicRegionType, ScalarIMR>(TectonicRegionType.class);
            gmmMap.put(TectonicRegionType.ACTIVE_SHALLOW, cache);
            Site site = AbstractSitewiseThreadedLogicTreeCalc.this.siteForIndex(this.siteIndex, gmmMap);
            ((NSHMP_GMM_Wrapper)cache).setSite(site);
            for (ProbEqkSource source : erf) {
                if (HazardCurveCalculator.canSkipSource(filters, source, site)) continue;
                for (ProbEqkRupture rup : source) {
                    cache.setEqkRupture(rup);
                }
            }
            AbstractSitewiseThreadedLogicTreeCalc.this.checkInERF(erf, this.erfDeque);
            return cache;
        }
    }

    private class SiteCalcCall
    implements Callable<DiscretizedFunc[]> {
        private FaultSystemSolutionERF fssERF;
        private int siteIndex;
        private Map<TectonicRegionType, ? extends Supplier<ScalarIMR>> gmmSuppliers;
        private Deque<DistCachedERFWrapper> erfDeque;
        private NSHMP_GMM_Wrapper cacheSupplier;

        private SiteCalcCall(FaultSystemSolutionERF fssERF, int siteIndex, Map<TectonicRegionType, ? extends Supplier<ScalarIMR>> gmmSuppliers, Deque<DistCachedERFWrapper> erfDeque) {
            this.fssERF = fssERF;
            this.siteIndex = siteIndex;
            this.gmmSuppliers = gmmSuppliers;
            this.erfDeque = erfDeque;
        }

        @Override
        public DiscretizedFunc[] call() throws Exception {
            Map<TectonicRegionType, ScalarIMR> gmms = FaultSysHazardCalcSettings.getGmmInstances(this.gmmSuppliers);
            Site site = AbstractSitewiseThreadedLogicTreeCalc.this.siteForIndex(this.siteIndex, gmms);
            AbstractERF erf = null;
            for (ScalarIMR gmm : gmms.values()) {
                if (this.cacheSupplier != null && gmm instanceof NSHMP_GMM_Wrapper) {
                    gmm.setSite(site);
                    NSHMP_GMM_Wrapper nshmpGmm = (NSHMP_GMM_Wrapper)gmm;
                    nshmpGmm.setCacheInputsPerRupture(true);
                    nshmpGmm.copyPerRuptureCacheFrom(this.cacheSupplier);
                    if (erf != null) continue;
                    erf = this.fssERF;
                    continue;
                }
                erf = AbstractSitewiseThreadedLogicTreeCalc.this.checkOutERF(this.fssERF, this.erfDeque);
            }
            DiscretizedFunc[] curves = new DiscretizedFunc[AbstractSitewiseThreadedLogicTreeCalc.this.periods.length];
            HazardCurveCalculator calc = new HazardCurveCalculator(AbstractSitewiseThreadedLogicTreeCalc.this.sourceFilters);
            for (int p = 0; p < AbstractSitewiseThreadedLogicTreeCalc.this.periods.length; ++p) {
                FaultSysHazardCalcSettings.setIMforPeriod(gmms, AbstractSitewiseThreadedLogicTreeCalc.this.periods[p]);
                DiscretizedFunc logHazCurve = AbstractSitewiseThreadedLogicTreeCalc.this.logXVals[p].deepClone();
                calc.getHazardCurve(logHazCurve, site, gmms, (ERF)erf);
                double sumY = logHazCurve.calcSumOfY_Vals();
                if (!Double.isFinite(sumY) || sumY <= 0.0) {
                    System.err.println("Hazard curve is non-finite or zero. sumY=" + sumY);
                    System.err.println("\tSite: " + site.getName() + ", " + String.valueOf(site.getLocation()));
                    System.err.println("\tLog Curve:\n" + String.valueOf(logHazCurve));
                }
                Preconditions.checkState((boolean)Double.isFinite(sumY), (Object)"Non-finite hazard curve");
                curves[p] = AbstractSitewiseThreadedLogicTreeCalc.this.xVals[p].deepClone();
                Preconditions.checkState((curves[p].size() == logHazCurve.size() ? 1 : 0) != 0);
                for (int i = 0; i < logHazCurve.size(); ++i) {
                    curves[p].set(i, logHazCurve.getY(i));
                }
            }
            if (erf instanceof DistCachedERFWrapper) {
                AbstractSitewiseThreadedLogicTreeCalc.this.checkInERF((DistCachedERFWrapper)erf, this.erfDeque);
            }
            return curves;
        }
    }
}

