/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.JsonAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opensha.commons.data.IntegerSampler;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.JSON_TypeAdapterBackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionInputGenerator;
import org.opensha.sha.earthquake.faultSysSolution.inversion.Inversions;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ColumnOrganizedAnnealingData;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ReweightEvenFitSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SerialSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ThreadedSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompoundCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.EnergyCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.IterationCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.IterationsPerVariableCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.MisfitStdDevCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.TimeCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.CoolingScheduleType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.GenerationFunctionType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.NonnegativityConstraintType;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitStats;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;

public class InversionConfiguration
implements SubModule<ModuleContainer<?>>,
JSON_TypeAdapterBackedModule<InversionConfiguration> {
    private transient ModuleContainer<?> parent;
    private static final GenerationFunctionType PERTURB_DEFAULT = GenerationFunctionType.VARIABLE_EXPONENTIAL_SCALE;
    private static final NonnegativityConstraintType NON_NEG_DEFAULT = NonnegativityConstraintType.TRY_ZERO_RATES_OFTEN;
    private static final CoolingScheduleType COOL_DEFAULT = CoolingScheduleType.FAST_SA;
    private static final CompletionCriteria SUB_COMPLETION_DEFAULT = TimeCompletionCriteria.getInSeconds(1L);
    private List<InversionConstraint> constraints;
    private double[] waterLevel;
    private double[] initial;
    private double[] variablePertubationBasis;
    @JsonAdapter(value=IntegerSampler.Adapter.class)
    private IntegerSampler sampler;
    private GenerationFunctionType perturb = PERTURB_DEFAULT;
    private NonnegativityConstraintType nonneg = NON_NEG_DEFAULT;
    private CoolingScheduleType cool = COOL_DEFAULT;
    private CompletionCriteria completion;
    private InversionMisfitStats.Quantity reweightTargetQuantity = null;
    private int threads = 1;
    private CompletionCriteria subCompletion;
    private Integer avgThreads;
    private CompletionCriteria avgCompletion;

    public static Builder builder(List<InversionConstraint> constraints, CompletionCriteria completion) {
        return new Builder(constraints, completion);
    }

    public static Builder builder(InversionConfiguration config) {
        return new Builder(config);
    }

    public static Builder builder(List<InversionConstraint> constraints, CommandLine cmd) {
        return new Builder(constraints, cmd);
    }

    private static CompletionCriteria parseCompletionArg(String value) {
        if ((value = value.trim().toLowerCase()).endsWith("h")) {
            return TimeCompletionCriteria.getInHours(Long.parseLong(value.substring(0, value.length() - 1)));
        }
        if (value.endsWith("m")) {
            return TimeCompletionCriteria.getInMinutes(Long.parseLong(value.substring(0, value.length() - 1)));
        }
        if (value.endsWith("s")) {
            return TimeCompletionCriteria.getInSeconds(Long.parseLong(value.substring(0, value.length() - 1)));
        }
        if (value.endsWith("e")) {
            return new EnergyCompletionCriteria(Double.parseDouble(value.substring(0, value.length() - 1)));
        }
        if (value.endsWith("ip")) {
            return new IterationsPerVariableCompletionCriteria(Double.parseDouble(value.substring(0, value.length() - 2)));
        }
        if (value.endsWith("i")) {
            value = value.substring(0, value.length() - 1);
        }
        return new IterationCompletionCriteria(Long.parseLong(value));
    }

    public static Options createSAOptions() {
        Options ops = new Options();
        ops.addOption(FaultSysTools.threadsOption());
        String complText = "If either no suffix or 'i' is appended, then it is assumed to be an iteration count. Specify times in hours, minutes, or seconds by appending 'h', 'm', or 's' respecively. Specify total energy by appending 'e'. Fractions are not allowed.";
        Option completionOption = new Option("c", "completion", true, "Total inversion completion criteria. " + complText);
        completionOption.setRequired(false);
        ops.addOption(completionOption);
        Option completionSDOption = new Option("csd", "completion-sd", true, "Total inversion completion criteria where misfits for each constraint must have no more than the given standard deviation. This can apply to only a given constraint weighting type if you supply the --completion-sd-type <type> argument.");
        completionSDOption.setRequired(false);
        ops.addOption(completionSDOption);
        Option completionSDTypeOption = new Option("csd", "completion-sd-type", true, "Constraint wieghting type for the --completion-sd option. Default is all constraints, options are: " + FaultSysTools.enumOptions(ConstraintWeightingType.class));
        completionSDTypeOption.setRequired(false);
        ops.addOption(completionSDTypeOption);
        Option avgOption = new Option("at", "avg-threads", true, "Enables a top layer of threads that average results of worker threads at fixed intervals. Supply the number of averaging threads, which must be < threads. Default is no averaging, if enabled you must also supply --avg-completion <value>.");
        avgOption.setRequired(false);
        ops.addOption(avgOption);
        Option avgCompletionOption = new Option("ac", "avg-completion", true, "Interval between across-thread averaging. " + complText);
        avgCompletionOption.setRequired(false);
        ops.addOption(avgCompletionOption);
        Option subCompletionOption = new Option("sc", "sub-completion", true, "Interval between across-thread synchronization. " + complText + " Default: 1s");
        subCompletionOption.setRequired(false);
        ops.addOption(subCompletionOption);
        Option perturbOption = new Option("pt", "perturb", true, "Perturbation function. One of " + FaultSysTools.enumOptions(GenerationFunctionType.class) + ". Default: " + PERTURB_DEFAULT.name());
        perturbOption.setRequired(false);
        ops.addOption(perturbOption);
        Option nonNegOption = new Option("nn", "non-negativity", true, "Non-negativity constraint. One of " + FaultSysTools.enumOptions(NonnegativityConstraintType.class) + ". Default: " + NON_NEG_DEFAULT.name());
        nonNegOption.setRequired(false);
        ops.addOption(nonNegOption);
        Option coolOption = new Option("cool", "cooling-schedule", true, "Cooling schedule. One of " + FaultSysTools.enumOptions(CoolingScheduleType.class) + ". Default: " + COOL_DEFAULT.name());
        coolOption.setRequired(false);
        ops.addOption(coolOption);
        Option reweightQuantity = new Option("rwq", "reweight-quantity", true, "Enables dynamic constraint reweighting, targeting the given quantity. Note that this only applies to uncertainty-weighted constraints. If you simply want enable re-weighting using the default quantity (" + ReweightEvenFitSimulatedAnnealing.QUANTITY_DEFAULT.name() + "), use --reweight instead.");
        reweightQuantity.setRequired(false);
        ops.addOption(reweightQuantity);
        Option reweight = new Option("rw", "reweight", false, "Enables dynamic constraint reweighting, targeting " + ReweightEvenFitSimulatedAnnealing.QUANTITY_DEFAULT.name() + ". Note that this only applies to uncertainty-weighted constraints. If you want to target a different quantity, use --reweight-quantity <quantity> instead.");
        reweight.setRequired(false);
        ops.addOption(reweight);
        return ops;
    }

    private InversionConfiguration() {
    }

    @Override
    public String getName() {
        return "Inversion Configuration";
    }

    public SimulatedAnnealing buildSA(InversionInputGenerator inputs) {
        SimulatedAnnealing sa;
        ColumnOrganizedAnnealingData equalityData = new ColumnOrganizedAnnealingData(inputs.getA(), inputs.getD());
        ColumnOrganizedAnnealingData inequalityData = null;
        if (inputs.getA_ineq() != null) {
            inequalityData = new ColumnOrganizedAnnealingData(inputs.getA_ineq(), inputs.getD_ineq());
        }
        if (this.threads > 1) {
            if (this.avgThreads != null && this.avgThreads > 0) {
                int myThreads;
                int threadsPerAvg = (int)Math.ceil((double)this.threads / (double)this.avgThreads.intValue());
                Preconditions.checkState((threadsPerAvg <= this.threads ? 1 : 0) != 0);
                Preconditions.checkState((threadsPerAvg > 0 ? 1 : 0) != 0);
                ArrayList<SimulatedAnnealing> tsas = new ArrayList<SimulatedAnnealing>();
                for (int threadsLeft = this.threads; threadsLeft > 0; threadsLeft -= myThreads) {
                    myThreads = Integer.min(threadsLeft, threadsPerAvg);
                    if (myThreads > 1) {
                        tsas.add(new ThreadedSimulatedAnnealing(equalityData, inequalityData, inputs.getInitialSolution(), 0.0, myThreads, this.subCompletion));
                        continue;
                    }
                    tsas.add(new SerialSimulatedAnnealing(equalityData, inequalityData, inputs.getInitialSolution(), 0.0));
                }
                sa = new ThreadedSimulatedAnnealing(tsas, this.avgCompletion, true);
            } else {
                sa = new ThreadedSimulatedAnnealing(equalityData, inequalityData, inputs.getInitialSolution(), 0.0, this.threads, this.subCompletion);
            }
        } else {
            sa = new SerialSimulatedAnnealing(equalityData, inequalityData, inputs.getInitialSolution(), 0.0);
        }
        sa.setConstraintRanges(inputs.getConstraintRowRanges());
        if (this.reweightTargetQuantity != null) {
            if (sa instanceof ThreadedSimulatedAnnealing) {
                sa = new ReweightEvenFitSimulatedAnnealing((ThreadedSimulatedAnnealing)sa, this.reweightTargetQuantity);
            } else {
                sa.setConstraintRanges(null);
                sa = new ReweightEvenFitSimulatedAnnealing(sa, this.subCompletion, this.reweightTargetQuantity);
                sa.setConstraintRanges(inputs.getConstraintRowRanges());
            }
        }
        if (this.perturb.isVariable()) {
            double[] basis = this.variablePertubationBasis;
            if (basis == null) {
                basis = Inversions.getDefaultVariablePerturbationBasis(inputs.getRuptureSet());
            }
            sa.setVariablePerturbationBasis(basis);
        }
        sa.setPerturbationFunc(this.perturb);
        sa.setNonnegativeityConstraintAlgorithm(this.nonneg);
        sa.setCoolingFunc(this.cool);
        if (this.sampler != null) {
            sa.setRuptureSampler(this.sampler);
        }
        return sa;
    }

    public InversionConfiguration copy() {
        InversionConfiguration copy = new InversionConfiguration();
        copy.set(this);
        return copy;
    }

    public ImmutableList<InversionConstraint> getConstraints() {
        return ImmutableList.copyOf(this.constraints);
    }

    public CompletionCriteria getCompletionCriteria() {
        return this.completion;
    }

    public double[] getWaterLevel() {
        return this.waterLevel;
    }

    public double[] getInitialSolution() {
        return this.initial;
    }

    public GenerationFunctionType getPerturbationFunc() {
        return this.perturb;
    }

    public NonnegativityConstraintType getNonnegConstraint() {
        return this.nonneg;
    }

    public CoolingScheduleType getCoolingSchedule() {
        return this.cool;
    }

    public double[] getVariablePertubationBasis() {
        return this.variablePertubationBasis;
    }

    public IntegerSampler getSampler() {
        return this.sampler;
    }

    public int getThreads() {
        return this.threads;
    }

    public CompletionCriteria getSubCompletionCriteria() {
        return this.subCompletion;
    }

    public Integer getAvgThreads() {
        return this.avgThreads;
    }

    public CompletionCriteria getAvgCompletionCriteria() {
        return this.avgCompletion;
    }

    public InversionMisfitStats.Quantity getReweightTargetQuantity() {
        return this.reweightTargetQuantity;
    }

    @Override
    public void setParent(ModuleContainer<?> parent) throws IllegalStateException {
        this.parent = parent;
        FaultSystemRupSet rupSet = null;
        if (parent instanceof FaultSystemRupSet) {
            rupSet = (FaultSystemRupSet)parent;
        } else if (parent instanceof FaultSystemSolution) {
            rupSet = ((FaultSystemSolution)parent).getRupSet();
        }
        if (rupSet != null && this.constraints != null) {
            for (InversionConstraint constraint : this.constraints) {
                constraint.setRuptureSet(rupSet);
            }
        }
    }

    @Override
    public ModuleContainer<?> getParent() {
        return this.parent;
    }

    @Override
    public SubModule<ModuleContainer<?>> copy(ModuleContainer<?> newParent) throws IllegalStateException {
        InversionConfiguration copy = this.copy();
        if (this.parent != null && this.parent != newParent) {
            copy.setParent(newParent);
        }
        return copy;
    }

    @Override
    public String getFileName() {
        return "inversion_config.json";
    }

    @Override
    public Type getType() {
        return InversionConfiguration.class;
    }

    @Override
    public InversionConfiguration get() {
        return this;
    }

    @Override
    public void set(InversionConfiguration source) {
        this.constraints = source.constraints;
        this.waterLevel = source.waterLevel;
        this.initial = source.initial;
        this.perturb = source.perturb;
        this.nonneg = source.nonneg;
        this.cool = source.cool;
        this.completion = source.completion;
        this.variablePertubationBasis = source.variablePertubationBasis;
        this.sampler = source.sampler;
        this.threads = source.threads;
        this.subCompletion = source.subCompletion;
        this.avgThreads = source.avgThreads;
        this.avgCompletion = source.avgCompletion;
        this.reweightTargetQuantity = source.reweightTargetQuantity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.initial);
        result = 31 * result + Arrays.hashCode(this.variablePertubationBasis);
        result = 31 * result + Arrays.hashCode(this.waterLevel);
        result = 31 * result + Objects.hash(new Object[]{InversionConfiguration.complStr(this.avgCompletion), this.avgThreads, InversionConfiguration.complStr(this.completion), InversionConfiguration.constrStr(this.constraints), this.cool, this.nonneg, this.perturb, this.sampler, InversionConfiguration.complStr(this.subCompletion), this.threads});
        return result;
    }

    private static String complStr(CompletionCriteria crit) {
        if (crit == null) {
            return null;
        }
        return crit.getClass().getName() + " " + crit.toString();
    }

    private static List<String> constrStr(List<InversionConstraint> constraints) {
        if (constraints == null || constraints.isEmpty()) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>(constraints.size());
        for (InversionConstraint constr : constraints) {
            ret.add(constr.getClass().getName() + " " + constr.getName() + " " + (float)constr.getWeight());
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InversionConfiguration other = (InversionConfiguration)obj;
        return Objects.equals(InversionConfiguration.complStr(this.avgCompletion), InversionConfiguration.complStr(other.avgCompletion)) && Objects.equals(this.avgThreads, other.avgThreads) && Objects.equals(InversionConfiguration.complStr(this.completion), InversionConfiguration.complStr(other.completion)) && Objects.equals(InversionConfiguration.constrStr(this.constraints), InversionConfiguration.constrStr(other.constraints)) && this.cool == other.cool && Arrays.equals(this.initial, other.initial) && this.nonneg == other.nonneg && this.perturb == other.perturb && Objects.equals(this.sampler, other.sampler) && Objects.equals(InversionConfiguration.complStr(this.subCompletion), InversionConfiguration.complStr(other.subCompletion)) && this.threads == other.threads && Arrays.equals(this.variablePertubationBasis, other.variablePertubationBasis) && Arrays.equals(this.waterLevel, other.waterLevel);
    }

    @Override
    public void registerTypeAdapters(GsonBuilder builder) {
        builder.serializeSpecialFloatingPointValues();
    }

    public static void writeJSON(InversionConfiguration config, File jsonFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(jsonFile));
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeSpecialFloatingPointValues().create();
        gson.toJson((Object)config, InversionConfiguration.class, (Appendable)writer);
        writer.flush();
        writer.close();
    }

    public static InversionConfiguration readJSON(File jsonFile, FaultSystemRupSet rupSet) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeSpecialFloatingPointValues().registerTypeAdapter(InversionConstraint.class, (Object)new InversionConstraint.Adapter(rupSet)).create();
        InversionConfiguration config = (InversionConfiguration)gson.fromJson((Reader)reader, InversionConfiguration.class);
        return config;
    }

    public static class Builder {
        private InversionConfiguration config;

        private Builder(InversionConfiguration config) {
            this.config = config.copy();
        }

        private Builder(List<InversionConstraint> constraints, CompletionCriteria completion) {
            this.config = new InversionConfiguration();
            this.config.constraints = ImmutableList.copyOf(constraints);
            this.config.completion = completion;
        }

        private Builder(List<InversionConstraint> constraints, CommandLine cmd) {
            this.config = new InversionConfiguration();
            this.config.constraints = ImmutableList.copyOf(constraints);
            if (!cmd.hasOption("threads")) {
                this.config.threads = FaultSysTools.defaultNumThreads();
            }
            this.forCommandLine(cmd);
        }

        public Builder forCommandLine(CommandLine cmd) {
            if (cmd == null) {
                return this;
            }
            if (cmd.hasOption("threads")) {
                this.config.threads = FaultSysTools.getNumThreads(cmd);
            }
            if (cmd.hasOption("completion")) {
                this.config.completion = InversionConfiguration.parseCompletionArg(cmd.getOptionValue("completion"));
            }
            if (cmd.hasOption("completion-sd")) {
                if (this.config.completion != null && !cmd.hasOption("completion")) {
                    this.config.completion = null;
                }
                double sd = Double.parseDouble(cmd.getOptionValue("completion-sd"));
                ConstraintWeightingType type = null;
                if (cmd.hasOption("completion-sd-type")) {
                    type = ConstraintWeightingType.valueOf(cmd.getOptionValue("completion-sd-type"));
                }
                MisfitStdDevCompletionCriteria completion = new MisfitStdDevCompletionCriteria(type, sd);
                this.config.completion = this.config.completion == null ? completion : new CompoundCompletionCriteria(List.of(this.config.completion, completion));
            }
            if (cmd.hasOption("avg-threads")) {
                this.config.avgThreads = Integer.parseInt(cmd.getOptionValue("avg-threads"));
            }
            if (this.config.avgThreads != null && this.config.avgThreads > 0) {
                if (cmd.hasOption("avg-completion")) {
                    this.config.avgCompletion = InversionConfiguration.parseCompletionArg(cmd.getOptionValue("avg-completion"));
                } else {
                    Preconditions.checkArgument((this.config.avgCompletion != null ? 1 : 0) != 0, (Object)"Averaging enabled but --avg-completion <value> not specified");
                }
            }
            if (cmd.hasOption("sub-completion")) {
                this.config.subCompletion = InversionConfiguration.parseCompletionArg(cmd.getOptionValue("sub-completion"));
            }
            if (cmd.hasOption("perturb")) {
                this.config.perturb = GenerationFunctionType.valueOf(cmd.getOptionValue("perturb"));
            }
            if (cmd.hasOption("non-negativity")) {
                this.config.nonneg = NonnegativityConstraintType.valueOf(cmd.getOptionValue("non-negativity"));
            }
            if (cmd.hasOption("cooling-schedule")) {
                this.config.cool = CoolingScheduleType.valueOf(cmd.getOptionValue("cooling-schedule"));
            }
            if (cmd.hasOption("reweight-quantity")) {
                this.config.reweightTargetQuantity = InversionMisfitStats.Quantity.valueOf(cmd.getOptionValue("reweight-quantity"));
            } else if (cmd.hasOption("reweight")) {
                this.config.reweightTargetQuantity = ReweightEvenFitSimulatedAnnealing.QUANTITY_DEFAULT;
            }
            return this;
        }

        public Builder waterLevel(double[] waterLevel) {
            this.config.waterLevel = waterLevel;
            return this;
        }

        public Builder initialSolution(double[] initial) {
            this.config.initial = initial;
            return this;
        }

        public Builder perturbation(GenerationFunctionType perturb) {
            this.config.perturb = perturb;
            return this;
        }

        public Builder variablePertubationBasis(double[] variablePertubationBasis) {
            this.config.variablePertubationBasis = variablePertubationBasis;
            return this;
        }

        public Builder nonNegativity(NonnegativityConstraintType nonneg) {
            this.config.nonneg = nonneg;
            return this;
        }

        public Builder cooling(CoolingScheduleType cool) {
            this.config.cool = cool;
            return this;
        }

        public Builder sampler(double[] samplerBasis) {
            if (samplerBasis == null) {
                this.config.sampler = null;
                return this;
            }
            return this.sampler(new IntegerPDF_FunctionSampler(samplerBasis));
        }

        public Builder clearSampler() {
            this.config.sampler = null;
            return this;
        }

        public Builder sampler(IntegerSampler sampler) {
            this.config.sampler = sampler;
            return this;
        }

        public Builder threads(int threads) {
            this.config.threads = threads;
            if (this.config.subCompletion == null) {
                this.config.subCompletion = SUB_COMPLETION_DEFAULT;
            }
            return this;
        }

        public Builder normalizeConstraintWeightsByRowCount() {
            return this.normalizeConstraintWeightsByRowCount(null);
        }

        public Builder normalizeConstraintWeightsByRowCount(ConstraintWeightingType weightingType) {
            for (InversionConstraint constraint : this.config.getConstraints()) {
                if (weightingType != null && constraint.getWeightingType() != weightingType) continue;
                int rows = constraint.getNumRows();
                constraint.setWeight(constraint.getWeight() / (double)rows);
            }
            return this;
        }

        public Builder subCompletion(CompletionCriteria subCompletion) {
            this.config.subCompletion = subCompletion;
            return this;
        }

        public Builder completion(CompletionCriteria completion) {
            this.config.completion = completion;
            return this;
        }

        public Builder avgThreads(int avgThreads, CompletionCriteria avgCompletion) {
            this.config.avgThreads = avgThreads;
            this.config.avgCompletion = avgCompletion;
            return this;
        }

        public Builder noAvg() {
            this.config.avgThreads = null;
            this.config.avgCompletion = null;
            return this;
        }

        public Builder reweight() {
            return this.reweight(ReweightEvenFitSimulatedAnnealing.QUANTITY_DEFAULT);
        }

        public Builder reweight(InversionMisfitStats.Quantity reweightTargetQuantity) {
            this.config.reweightTargetQuantity = reweightTargetQuantity;
            return this;
        }

        public Builder except(Class<? extends InversionConstraint> type) {
            return this.except(type, true);
        }

        public Builder except(Class<? extends InversionConstraint> type, boolean failIfNotFound) {
            ArrayList<InversionConstraint> constraints = new ArrayList<InversionConstraint>(this.config.constraints);
            int i = constraints.size();
            while (--i >= 0) {
                if (!type.isAssignableFrom(((InversionConstraint)constraints.get(i)).getClass())) continue;
                constraints.remove(i);
            }
            Preconditions.checkState((!constraints.isEmpty() ? 1 : 0) != 0, (Object)"No constraints left!");
            Preconditions.checkState((!failIfNotFound || constraints.size() < this.config.constraints.size() ? 1 : 0) != 0, (Object)"No constraints removed!");
            this.config.constraints = constraints;
            return this;
        }

        public Builder add(InversionConstraint constraint) {
            ArrayList<InversionConstraint> constraints = new ArrayList<InversionConstraint>(this.config.constraints);
            constraints.add(constraint);
            this.config.constraints = constraints;
            return this;
        }

        public InversionConfiguration build() {
            Preconditions.checkNotNull((Object)this.config.completion, (Object)"No completion criteria specified");
            Preconditions.checkNotNull(this.config.constraints, (Object)"No comstraints supplied");
            Preconditions.checkState((!this.config.constraints.isEmpty() ? 1 : 0) != 0, (Object)"No comstraints supplied");
            Preconditions.checkState((this.config.threads >= 1 ? 1 : 0) != 0, (String)"Threads must be positive, supplied: %s", (int)this.config.threads);
            if (this.config.subCompletion == null && (this.config.threads > 1 || this.config.reweightTargetQuantity != null)) {
                this.config.subCompletion = SUB_COMPLETION_DEFAULT;
            }
            if (this.config.avgThreads != null) {
                Preconditions.checkState((this.config.avgThreads >= 1 ? 1 : 0) != 0, (String)"Averaging threads (if enabled) must be >=1: %s", (Object)this.config.avgThreads);
                Preconditions.checkState((this.config.avgThreads <= this.config.threads ? 1 : 0) != 0, (String)"The number of averaging threads (%s) must be less than the number of total threads (%s)", (Object)this.config.avgThreads, (int)this.config.threads);
                Preconditions.checkNotNull((Object)this.config.avgCompletion, (Object)"Averaging enabled but average completion criteria not specified");
            }
            return this.config.copy();
        }
    }
}

