/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion;

import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.tdouble.AbstractLongDoubleMap;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.CSVWriter;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import scratch.UCERF3.utils.MatrixIO;

public class InversionInputGenerator {
    protected FaultSystemRupSet rupSet;
    protected int numRuptures;
    protected List<InversionConstraint> constraints;
    protected double[] initialSolution;
    protected double[] waterLevelRates;
    protected DoubleMatrix2D A;
    protected double[] d;
    protected DoubleMatrix2D A_ineq;
    protected double[] d_ineq;
    protected List<ConstraintRange> constraintRowRanges;
    private static final DecimalFormat oneDigit = new DecimalFormat("0.0");

    public InversionInputGenerator(FaultSystemRupSet rupSet, List<InversionConstraint> constraints) {
        this(rupSet, constraints, null, null);
    }

    public InversionInputGenerator(FaultSystemRupSet rupSet, InversionConfiguration config) {
        this(rupSet, (List<InversionConstraint>)config.getConstraints(), config.getInitialSolution(), config.getWaterLevel());
    }

    public InversionInputGenerator(FaultSystemRupSet rupSet, List<InversionConstraint> constraints, double[] initialSolution, double[] waterLevelRates) {
        this.rupSet = rupSet;
        this.numRuptures = rupSet.getNumRuptures();
        this.constraints = constraints;
        this.initialSolution = initialSolution;
        this.waterLevelRates = waterLevelRates;
    }

    public void generateInputs() {
        this.generateInputs(null, false);
    }

    public void generateInputs(boolean verbose) {
        this.generateInputs(null, verbose);
    }

    public static List<ConstraintRange> buildConstraintRanges(List<InversionConstraint> constraints, boolean verbose) {
        int numRows = 0;
        int numIneqRows = 0;
        ArrayList<ConstraintRange> constraintRowRanges = new ArrayList<ConstraintRange>();
        for (InversionConstraint constraint : constraints) {
            ConstraintRange range;
            constraint.setQuickGetSets(!verbose);
            if (constraint.isInequality()) {
                range = InversionInputGenerator.calcRowRange(numIneqRows, constraint, verbose);
                numIneqRows = range.endRow;
            } else {
                range = InversionInputGenerator.calcRowRange(numRows, constraint, verbose);
                numRows = range.endRow;
            }
            constraintRowRanges.add(range);
        }
        return constraintRowRanges;
    }

    public void generateInputs(Class<? extends DoubleMatrix2D> clazz, boolean verbose) {
        if (verbose) {
            System.out.println("Generating inversion inputs with " + this.numRuptures + " ruptures and " + this.constraints.size() + " constraints");
        }
        if (this.initialSolution == null) {
            if (verbose) {
                System.out.println("Building empty initial solution (all zeroes)");
            }
            this.initialSolution = new double[this.numRuptures];
        } else {
            Preconditions.checkState((this.initialSolution.length == this.numRuptures ? 1 : 0) != 0, (String)"Initial solution is wrong size: %s != %s", (int)this.initialSolution.length, (int)this.numRuptures);
        }
        if (this.waterLevelRates != null) {
            Preconditions.checkState((this.waterLevelRates.length == this.numRuptures ? 1 : 0) != 0, (String)"Water level rates are wrong size: %s != %s", (int)this.waterLevelRates.length, (int)this.numRuptures);
        }
        if (verbose) {
            System.out.println("Calculating constraint row counts");
        }
        Stopwatch watch = verbose ? Stopwatch.createStarted() : null;
        Stopwatch watchTotal = verbose ? Stopwatch.createStarted() : null;
        this.constraintRowRanges = InversionInputGenerator.buildConstraintRanges(this.constraints, verbose);
        int numRows = 0;
        int numIneqRows = 0;
        for (ConstraintRange range : this.constraintRowRanges) {
            if (range.inequality) {
                numIneqRows = range.endRow;
                continue;
            }
            numRows = range.endRow;
        }
        if (verbose) {
            watch.stop();
            System.out.println("Took " + InversionInputGenerator.getTimeStr(watch) + " to get row counts");
        }
        if (numRows > 0) {
            if (verbose) {
                System.out.println("Building A matrix with " + numRows + " rows and " + this.numRuptures + " columns");
            }
            this.A = InversionInputGenerator.buildMatrix(clazz, numRows, this.numRuptures);
            this.d = new double[numRows];
        }
        if (numIneqRows > 0) {
            if (verbose) {
                System.out.println("Building A inequality matrix with " + numIneqRows + " rows and " + this.numRuptures + " columns");
            }
            this.A_ineq = InversionInputGenerator.buildMatrix(clazz, numIneqRows, this.numRuptures);
            this.d_ineq = new double[numIneqRows];
        }
        if (verbose) {
            System.out.println("Encoding matrices");
        }
        watch = verbose ? Stopwatch.createStarted() : null;
        int numNonZero = 0;
        for (int i = 0; i < this.constraints.size(); ++i) {
            double[] myD;
            DoubleMatrix2D myA;
            InversionConstraint constraint = this.constraints.get(i);
            ConstraintRange rowRange = this.constraintRowRanges.get(i);
            if (constraint.isInequality()) {
                myA = this.A_ineq;
                myD = this.d_ineq;
            } else {
                myA = this.A;
                myD = this.d;
            }
            if (verbose) {
                System.out.println("\tEncoding " + constraint.getName() + ", ineq=" + constraint.isInequality());
            }
            Stopwatch subWatch = verbose ? Stopwatch.createStarted() : null;
            long myNonZero = constraint.encode(myA, myD, rowRange.startRow);
            if (verbose) {
                long maxNum = (long)(rowRange.endRow - rowRange.startRow) * (long)this.numRuptures;
                double density = 100.0 * (double)myNonZero / (double)maxNum;
                System.out.println("\t\tDONE, took " + InversionInputGenerator.getTimeStr(subWatch) + " to encode " + myNonZero + " values (density: " + oneDigit.format(density) + " %)");
                subWatch.stop();
            }
            numNonZero = (int)((long)numNonZero + myNonZero);
        }
        if (verbose) {
            long maxNum = (long)(numRows + numIneqRows) * (long)this.numRuptures;
            double density = 100.0 * (double)numNonZero / (double)maxNum;
            System.out.println("DONE encoding, took " + InversionInputGenerator.getTimeStr(watch) + " to encode " + numNonZero + " values (density: " + oneDigit.format(density) + " %)");
            watch.stop();
        }
        if (this.waterLevelRates != null) {
            Object object = watch = verbose ? Stopwatch.createStarted() : null;
            if (numRows > 0) {
                if (verbose) {
                    System.out.println("Applying minimum rupture rates to A matrix");
                }
                this.A.forEachNonZero((IntIntDoubleFunction)new AdjustDataForMinRates(this.d, this.waterLevelRates));
            }
            if (numIneqRows > 0) {
                if (verbose) {
                    System.out.println("Applying minimum rupture rates to A_ineq matrix");
                }
                this.A_ineq.forEachNonZero((IntIntDoubleFunction)new AdjustDataForMinRates(this.d_ineq, this.waterLevelRates));
            }
            this.initialSolution = Arrays.copyOf(this.initialSolution, this.numRuptures);
            for (int i = 0; i < this.numRuptures; ++i) {
                double adjustedVal = this.initialSolution[i] - this.waterLevelRates[i];
                if (adjustedVal < 0.0) {
                    adjustedVal = 0.0;
                }
                this.initialSolution[i] = adjustedVal;
            }
            if (verbose) {
                System.out.println("Took " + InversionInputGenerator.getTimeStr(watch) + " to apply minimum rates");
                watch.stop();
            }
        }
        if (verbose) {
            System.out.println("Took " + InversionInputGenerator.getTimeStr(watchTotal) + " to generate inputs");
            watchTotal.stop();
        }
    }

    static ConstraintRange calcRowRange(int startIndex, InversionConstraint constraint, boolean verbose) {
        Stopwatch watch = verbose ? Stopwatch.createStarted() : null;
        ConstraintRange range = constraint.getRange(startIndex);
        if (verbose) {
            System.out.println("\t" + String.valueOf(range) + " (took " + InversionInputGenerator.getTimeStr(watch) + ")");
            watch.stop();
        }
        return range;
    }

    protected static String getTimeStr(Stopwatch watch) {
        long millis = watch.elapsed(TimeUnit.MILLISECONDS);
        if (millis < 1000L) {
            return millis + " ms";
        }
        double secs = (double)millis / 1000.0;
        if (secs < 60.0) {
            return oneDigit.format(secs) + " s";
        }
        double mins = secs / 60.0;
        return oneDigit.format(mins) + " m";
    }

    protected static DoubleMatrix2D buildMatrix(Class<? extends DoubleMatrix2D> clazz, int rows, int cols) {
        if (clazz == null || clazz.equals(SparseDoubleMatrix2D.class)) {
            return new SparseDoubleMatrix2D(rows, cols);
        }
        if (clazz.equals(SparseRCDoubleMatrix2D.class)) {
            return new SparseRCDoubleMatrix2D(rows, cols);
        }
        if (clazz.equals(SparseCCDoubleMatrix2D.class)) {
            return new SparseCCDoubleMatrix2D(rows, cols);
        }
        throw new IllegalArgumentException("Unknown matrix type: " + String.valueOf(clazz));
    }

    public void columnCompress() {
        this.A = InversionInputGenerator.getColumnCompressed(this.A);
        if (this.A_ineq != null) {
            this.A_ineq = InversionInputGenerator.getColumnCompressed(this.A_ineq);
        }
    }

    private static SparseCCDoubleMatrix2D getColumnCompressed(DoubleMatrix2D mat) {
        if (mat instanceof SparseCCDoubleMatrix2D) {
            return (SparseCCDoubleMatrix2D)mat;
        }
        if (mat instanceof SparseRCDoubleMatrix2D) {
            return ((SparseRCDoubleMatrix2D)mat).getColumnCompressed();
        }
        if (mat instanceof SparseDoubleMatrix2D) {
            return ((SparseDoubleMatrix2D)mat).getColumnCompressed(true);
        }
        throw new RuntimeException("Can't column compress matrix: " + String.valueOf(mat));
    }

    public double[] adjustSolutionForWaterLevel(double[] solution) {
        return InversionInputGenerator.adjustSolutionForWaterLevel(solution, this.waterLevelRates);
    }

    public static double[] adjustSolutionForWaterLevel(double[] solution, double[] waterLevelRates) {
        solution = Arrays.copyOf(solution, solution.length);
        if (waterLevelRates != null) {
            Preconditions.checkState((waterLevelRates.length == solution.length ? 1 : 0) != 0, (Object)"minimum rates size mismatch!");
            for (int i = 0; i < solution.length; ++i) {
                solution[i] = solution[i] + waterLevelRates[i];
            }
        }
        return solution;
    }

    private static void writeDoubleArrayCSV(double[] array, OutputStream out, String indexHeader, String dataHeader) throws IOException {
        CSVWriter csv = new CSVWriter(out, true);
        csv.write(List.of(indexHeader, dataHeader));
        for (int i = 0; i < array.length; ++i) {
            csv.write(List.of("" + i, "" + array[i]));
        }
        csv.flush();
    }

    private static void writeSparseCSV(DoubleMatrix2D mat, OutputStream out) throws IOException {
        CSVWriter csv = new CSVWriter(out, true);
        csv.write(List.of("Row Index", "Column Index", "Value"));
        if (mat instanceof SparseDoubleMatrix2D) {
            AbstractLongDoubleMap map = ((SparseDoubleMatrix2D)mat).elements();
            int nnz = mat.cardinality();
            long[] keys = map.keys().elements();
            double[] values = map.values().elements();
            int columns = mat.columns();
            for (int i = 0; i < nnz; ++i) {
                int row = (int)(keys[i] / (long)columns);
                int column = (int)(keys[i] % (long)columns);
                csv.write(List.of("" + row, "" + column, "" + values[i]));
            }
        } else {
            IntArrayList rowList = new IntArrayList();
            IntArrayList colList = new IntArrayList();
            DoubleArrayList valList = new DoubleArrayList();
            mat.getNonZeros(rowList, colList, valList);
            Preconditions.checkState((rowList.size() > 0 ? 1 : 0) != 0, (Object)"rowList is empty!");
            Preconditions.checkState((rowList.size() == colList.size() && colList.size() == valList.size() ? 1 : 0) != 0, (Object)"array sizes incorrect!");
            for (int i = 0; i < valList.size(); ++i) {
                int row = rowList.get(i);
                int col = colList.get(i);
                double val = valList.get(i);
                csv.write(List.of("" + row, "" + col, "" + val));
            }
        }
        csv.flush();
    }

    public void writeArchive(File file, boolean binary) throws IOException {
        this.writeArchive(file, null, binary);
    }

    public void writeArchive(File file, double[] solution, boolean binary) throws IOException {
        this.writeArchive(ArchiveOutput.getDefaultOutput(file), solution, binary);
    }

    public void writeArchive(ArchiveOutput out, boolean binary) throws IOException {
        this.writeArchive(out, null, binary);
    }

    public void writeArchive(ArchiveOutput out, double[] solution, boolean binary) throws IOException {
        if (binary) {
            out.putNextEntry("d.bin");
            MatrixIO.doubleArrayToStream(this.d, out.getOutputStream());
        } else {
            out.putNextEntry("d.csv");
            InversionInputGenerator.writeDoubleArrayCSV(this.d, out.getOutputStream(), "Constraint Index", "Constraint Target");
        }
        out.closeEntry();
        if (binary) {
            out.putNextEntry("a.bin");
            MatrixIO.saveSparse(this.A, out.getOutputStream());
        } else {
            out.putNextEntry("a.csv");
            InversionInputGenerator.writeSparseCSV(this.A, out.getOutputStream());
        }
        out.closeEntry();
        if (this.initialSolution != null && StatUtils.max((double[])this.initialSolution) > 0.0) {
            if (binary) {
                out.putNextEntry("initial.bin");
                MatrixIO.doubleArrayToStream(this.initialSolution, out.getOutputStream());
            } else {
                out.putNextEntry("initial.csv");
                InversionInputGenerator.writeDoubleArrayCSV(this.initialSolution, out.getOutputStream(), "Rupture Index", "Initial Value");
            }
            out.closeEntry();
        }
        if (solution != null) {
            if (binary) {
                out.putNextEntry("solution.bin");
                MatrixIO.doubleArrayToStream(solution, out.getOutputStream());
            } else {
                out.putNextEntry("solution.csv");
                InversionInputGenerator.writeDoubleArrayCSV(solution, out.getOutputStream(), "Rupture Index", "Solution Value (Annual Rate)");
            }
            out.closeEntry();
        }
        if (this.d_ineq != null) {
            if (binary) {
                out.putNextEntry("d_ineq.bin");
                MatrixIO.doubleArrayToStream(this.d_ineq, out.getOutputStream());
            } else {
                out.putNextEntry("d_ineq.csv");
                InversionInputGenerator.writeDoubleArrayCSV(this.d_ineq, out.getOutputStream(), "Constraint Index", "Constraint Target");
            }
            out.closeEntry();
        }
        if (this.A_ineq != null) {
            if (binary) {
                out.putNextEntry("a_ineq.bin");
                MatrixIO.saveSparse(this.A_ineq, out.getOutputStream());
            } else {
                out.putNextEntry("a_ineq.csv");
                InversionInputGenerator.writeSparseCSV(this.A_ineq, out.getOutputStream());
            }
            out.closeEntry();
        }
        if (this.waterLevelRates != null) {
            if (binary) {
                out.putNextEntry("waterLevelRates.bin");
                MatrixIO.doubleArrayToStream(this.waterLevelRates, out.getOutputStream());
            } else {
                out.putNextEntry("waterLevelRates.csv");
                InversionInputGenerator.writeDoubleArrayCSV(this.waterLevelRates, out.getOutputStream(), "Rupture Index", "Water-level Value");
            }
            out.closeEntry();
        }
        CSVFile<String> rangeCSV = new CSVFile<String>(true);
        rangeCSV.addLine("Name", "Short Name", "Inequality?", "Start Row (inclusive)", "End Row (exclusive)");
        for (ConstraintRange range : this.constraintRowRanges) {
            rangeCSV.addLine(range.name, range.shortName, "" + range.inequality, "" + range.startRow, "" + range.endRow);
        }
        CSV_BackedModule.writeToArchive(rangeCSV, out, "", "constraintRanges.csv");
        out.close();
    }

    public DoubleMatrix2D getA() {
        return this.A;
    }

    public DoubleMatrix2D getA_ineq() {
        return this.A_ineq;
    }

    public double[] getD() {
        return this.d;
    }

    public double[] getD_ineq() {
        return this.d_ineq;
    }

    public double[] getInitialSolution() {
        return this.initialSolution;
    }

    public double[] getWaterLevelRates() {
        return this.waterLevelRates;
    }

    public boolean hasInitialSolution() {
        if (this.initialSolution == null) {
            return false;
        }
        boolean nonZero = false;
        for (double val : this.initialSolution) {
            if (!(val > 0.0)) continue;
            nonZero = true;
            break;
        }
        return nonZero;
    }

    public List<ConstraintRange> getConstraintRowRanges() {
        return this.constraintRowRanges;
    }

    public List<InversionConstraint> getConstraints() {
        return this.constraints;
    }

    public FaultSystemRupSet getRuptureSet() {
        return this.rupSet;
    }

    private static class AdjustDataForMinRates
    implements IntIntDoubleFunction {
        private double[] d;
        private double[] waterLevelRates;

        public AdjustDataForMinRates(double[] d, double[] waterLevelRates) {
            this.d = d;
            this.waterLevelRates = waterLevelRates;
        }

        public double apply(int row, int col, double val) {
            int n = row;
            this.d[n] = this.d[n] - val * this.waterLevelRates[col];
            return val;
        }
    }
}

