/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import org.opensha.commons.data.ShortNamed;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;

@JsonAdapter(value=Adapter.class)
public abstract class InversionConstraint
implements ShortNamed {
    private transient boolean quickGetsSets = true;
    private transient String name;
    private transient String shortName;
    protected transient double weight;
    protected transient boolean inequality;
    protected transient ConstraintWeightingType weightingType;

    protected InversionConstraint(String name, String shortName, double weight, boolean inequality) {
        this(name, shortName, weight, inequality, ConstraintWeightingType.UNNORMALIZED);
    }

    protected InversionConstraint(String name, String shortName, double weight, boolean inequality, ConstraintWeightingType weightingType) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
        this.inequality = inequality;
        this.weightingType = weightingType;
    }

    public abstract int getNumRows();

    public ConstraintRange getRange(int startIndex) {
        return new ConstraintRange(this.name, this.shortName, startIndex, startIndex + this.getNumRows(), this.inequality, this.weight, this.weightingType);
    }

    public final boolean isInequality() {
        return this.inequality;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public final double getWeight() {
        return this.weight;
    }

    public final ConstraintWeightingType getWeightingType() {
        return this.weightingType;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getShortName() {
        return this.shortName;
    }

    public abstract long encode(DoubleMatrix2D var1, double[] var2, int var3);

    protected void setA(DoubleMatrix2D A, int row, int col, double val) {
        Preconditions.checkState((boolean)Double.isFinite(val), (String)"Setting non-finite value in A matrix at [%s, %s]: %s", (Object)row, (Object)col, (Object)val);
        if (this.quickGetsSets) {
            A.setQuick(row, col, val);
        } else {
            A.set(row, col, val);
        }
    }

    protected double getA(DoubleMatrix2D A, int row, int col) {
        if (this.quickGetsSets) {
            return A.getQuick(row, col);
        }
        return A.get(row, col);
    }

    protected boolean addA(DoubleMatrix2D A, int row, int col, double val) {
        double prevVal = this.getA(A, row, col);
        if (this.quickGetsSets) {
            A.setQuick(row, col, val + prevVal);
        } else {
            A.set(row, col, val + prevVal);
        }
        return prevVal != 0.0;
    }

    public void setQuickGetSets(boolean quickGetsSets) {
        this.quickGetsSets = quickGetsSets;
    }

    public void setRuptureSet(FaultSystemRupSet rupSet) {
    }

    public static void writeConstraintsJSON(File jsonFile, List<InversionConstraint> constraints) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(jsonFile));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        TypeToken token = TypeToken.getParameterized(List.class, (Type[])new Type[]{InversionConstraint.class});
        gson.toJson(constraints, token.getType(), (Appendable)writer);
        writer.flush();
        writer.close();
    }

    public static List<InversionConstraint> loadConstraintsJSON(File jsonFile, FaultSystemRupSet rupSet) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        Gson gson = new GsonBuilder().registerTypeAdapter(InversionConstraint.class, (Object)new Adapter(rupSet)).create();
        TypeToken token = TypeToken.getParameterized(List.class, (Type[])new Type[]{InversionConstraint.class});
        return (List)gson.fromJson((Reader)reader, token.getType());
    }

    public static class Adapter
    extends TypeAdapter<InversionConstraint> {
        private Gson gson;
        private FaultSystemRupSet rupSet;

        public Adapter() {
            this(null);
        }

        public Adapter(FaultSystemRupSet rupSet) {
            this.rupSet = rupSet;
            this.gson = new GsonBuilder().registerTypeHierarchyAdapter(FaultSystemRupSet.class, (Object)new RupSetInterceptorAdaptor()).serializeSpecialFloatingPointValues().create();
        }

        public void write(JsonWriter out, InversionConstraint value) throws IOException {
            out.beginObject();
            out.name("type").value(value.getClass().getName());
            out.name("name").value(value.getName());
            out.name("shortName").value(value.getShortName());
            out.name("inequality").value(value.isInequality());
            out.name("weight").value(value.getWeight());
            if (value.weightingType != null) {
                out.name("weightingType").value(value.weightingType.name());
            }
            out.name("data");
            this.gson.toJson((Object)value, value.getClass(), out);
            out.endObject();
        }

        public InversionConstraint read(JsonReader in) throws IOException {
            Class<?> type = null;
            String name = null;
            String shortName = null;
            Boolean inequality = null;
            Double weight = null;
            ConstraintWeightingType weightingType = null;
            InversionConstraint constraint = null;
            in.beginObject();
            block20: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "type": {
                        String className = in.nextString();
                        try {
                            type = Class.forName(className);
                        }
                        catch (Exception e) {
                            System.err.println("WARNING: Could not locate constraint class, will use stub instead: " + className);
                        }
                        continue block20;
                    }
                    case "name": {
                        name = in.nextString();
                        continue block20;
                    }
                    case "shortName": {
                        shortName = in.nextString();
                        continue block20;
                    }
                    case "inequality": {
                        inequality = in.nextBoolean();
                        continue block20;
                    }
                    case "weight": {
                        weight = in.nextDouble();
                        continue block20;
                    }
                    case "weightingType": {
                        weightingType = ConstraintWeightingType.valueOf(in.nextString());
                        continue block20;
                    }
                    case "data": {
                        if (type == null) {
                            in.skipValue();
                            continue block20;
                        }
                        constraint = (InversionConstraint)this.gson.fromJson(in, type);
                        if (this.rupSet == null) continue block20;
                        constraint.setRuptureSet(this.rupSet);
                        continue block20;
                    }
                }
                in.skipValue();
            }
            Preconditions.checkNotNull(weight, (Object)"Weight not supplied in constraint JSON");
            Preconditions.checkNotNull(inequality, (Object)"Inequality boolean not supplied in constraint JSON");
            if (constraint == null) {
                constraint = new ConstraintStub(name, shortName, weight, inequality, weightingType);
            } else {
                constraint.weight = weight;
                constraint.inequality = inequality;
                constraint.name = name;
                constraint.shortName = shortName;
                if (weightingType != null) {
                    constraint.weightingType = weightingType;
                }
            }
            in.endObject();
            return constraint;
        }
    }

    private static class ConstraintStub
    extends InversionConstraint {
        protected ConstraintStub(String name, String shortName, double weight, boolean inequality, ConstraintWeightingType weightingType) {
            super(name, shortName, weight, inequality, weightingType);
        }

        @Override
        public int getNumRows() {
            throw new UnsupportedOperationException("Cannot call getNumRows() on a constraint stub (after deserialization failed, see earlier message)");
        }

        @Override
        public long encode(DoubleMatrix2D A, double[] d, int startRow) {
            throw new UnsupportedOperationException("Cannot call encode(...) on a constraint stub (after deserialization failed, see earlier message)");
        }
    }

    private static class RupSetInterceptorAdaptor
    extends TypeAdapter<FaultSystemRupSet> {
        private RupSetInterceptorAdaptor() {
        }

        public void write(JsonWriter out, FaultSystemRupSet value) throws IOException {
            throw new IllegalStateException("Attempting to serialize a FaultSystemRupSet, which should never happen. Constraint should declare the rupture set to be transient and override the setRuptureSet(...) method to get the rupture set.");
        }

        public FaultSystemRupSet read(JsonReader in) throws IOException {
            throw new IllegalStateException("Attempting to deserialize a FaultSystemRupSet, which should never happen. Constraint should declare the rupture set to be transient and override the setRuptureSet(...) method to get the rupture set.");
        }
    }
}

