/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.data.uncertainty.UncertainIncrMagFreqDist;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class MFDInversionConstraint
extends InversionConstraint {
    private transient FaultSystemRupSet rupSet;
    private List<? extends IncrementalMagFreqDist> mfds;
    private HashSet<Integer> excludeRupIndexes;
    public static final boolean MFD_FRACT_IN_REGION_TRACE_ONLY = false;

    public MFDInversionConstraint(FaultSystemRupSet rupSet, double weight, boolean inequality, List<? extends IncrementalMagFreqDist> mfds) {
        this(rupSet, weight, inequality, ConstraintWeightingType.NORMALIZED, mfds);
    }

    public MFDInversionConstraint(FaultSystemRupSet rupSet, double weight, boolean inequality, ConstraintWeightingType weightingType, List<? extends IncrementalMagFreqDist> mfds) {
        this(rupSet, weight, inequality, weightingType, mfds, null);
    }

    public MFDInversionConstraint(FaultSystemRupSet rupSet, double weight, boolean inequality, ConstraintWeightingType weightingType, List<? extends IncrementalMagFreqDist> mfds, HashSet<Integer> excludeRupIndexes) {
        super(weightingType.applyNamePrefix("MFD " + (inequality ? "Inequality" : "Equality")), weightingType.applyShortNamePrefix("MFD" + (inequality ? "Inequality" : "Equality")), weight, inequality, weightingType);
        this.rupSet = rupSet;
        this.mfds = mfds;
        if (weightingType == ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY) {
            for (IncrementalMagFreqDist incrementalMagFreqDist : mfds) {
                Preconditions.checkArgument((boolean)(incrementalMagFreqDist instanceof UncertainIncrMagFreqDist), (Object)"Uncertain MFD instances (with standard deviations) must be supplied for uncertainty weighting");
            }
        }
        this.excludeRupIndexes = excludeRupIndexes;
    }

    public List<? extends IncrementalMagFreqDist> getMFDs() {
        return this.mfds;
    }

    public HashSet<Integer> getExcludeRupIndexes() {
        return this.excludeRupIndexes;
    }

    static int getNumRows(List<? extends IncrementalMagFreqDist> mfds, FaultSystemRupSet rupSet) {
        int totalNumMagFreqConstraints = 0;
        for (IncrementalMagFreqDist incrementalMagFreqDist : mfds) {
            totalNumMagFreqConstraints += incrementalMagFreqDist.getClosestXIndex(rupSet.getMaxMag()) - incrementalMagFreqDist.getClosestXIndex(rupSet.getMinMag()) + 1;
        }
        return totalNumMagFreqConstraints;
    }

    @Override
    public int getNumRows() {
        return MFDInversionConstraint.getNumRows(this.mfds, this.rupSet);
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        int numRuptures = this.rupSet.getNumRuptures();
        for (int i = 0; i < this.mfds.size(); ++i) {
            IncrementalMagFreqDist mfd = this.mfds.get(i);
            Region region = mfd.getRegion();
            double[] fractRupsInside = this.rupSet.getFractRupsInsideRegion(region, false);
            int minMagIndex = mfd.getClosestXIndex(this.rupSet.getMinMag());
            int maxMagIndex = mfd.getClosestXIndex(this.rupSet.getMaxMag());
            double[] targets = new double[mfd.size()];
            double[] scales = new double[targets.length];
            for (int j = 0; j < targets.length; ++j) {
                double rate = mfd.getY(j);
                if (rate == 0.0) {
                    targets[j] = 0.0;
                    scales[j] = 0.0;
                    continue;
                }
                double stdDev = mfd instanceof UncertainIncrMagFreqDist ? ((UncertainIncrMagFreqDist)mfd).getStdDev(j) : 0.0;
                scales[j] = this.weightingType.getA_Scalar(rate, stdDev);
                targets[j] = this.weightingType.getD(rate, stdDev);
            }
            for (int rup = 0; rup < numRuptures; ++rup) {
                double mag = this.rupSet.getMagForRup(rup);
                double fractRupInside = fractRupsInside[rup];
                if (!(fractRupInside > 0.0) || !(mag > mfd.getMinX() - mfd.getDelta() / 2.0) || !(mag < mfd.getMaxX() + mfd.getDelta() / 2.0) || this.excludeRupIndexes != null && this.excludeRupIndexes.contains(rup)) continue;
                int magIndex = mfd.getClosestXIndex(mag);
                Preconditions.checkState((magIndex >= minMagIndex && magIndex <= maxMagIndex ? 1 : 0) != 0);
                int rowIndex = startRow + magIndex - minMagIndex;
                if (targets[magIndex] == 0.0) {
                    this.setA(A, rowIndex, rup, 0.0);
                    continue;
                }
                this.setA(A, rowIndex, rup, this.weight * fractRupInside * scales[magIndex]);
                ++numNonZeroElements;
            }
            for (int magIndex = minMagIndex; magIndex <= maxMagIndex; ++magIndex) {
                int rowIndex = startRow + magIndex - minMagIndex;
                d[rowIndex] = this.weight * targets[magIndex];
            }
            startRow += maxMagIndex - minMagIndex + 1;
        }
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }
}

