/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.UCERF3InversionInputGenerator;

@JsonAdapter(value=Adapter.class)
public abstract class PaleoProbabilityModel {
    private transient Map<Integer, Double> traceLengthCache = Maps.newConcurrentMap();

    public double getProbPaleoVisible(FaultSystemRupSet rupSet, int rupIndex, int sectIndex) {
        return this.getProbPaleoVisible(rupSet.getMagForRup(rupIndex), rupSet.getFaultSectionDataForRupture(rupIndex), sectIndex);
    }

    public abstract double getProbPaleoVisible(double var1, List<? extends FaultSection> var3, int var4);

    public abstract double getProbPaleoVisible(double var1, double var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double getDistAlongRup(List<? extends FaultSection> rupSections, int sectIndex) {
        if (this.traceLengthCache == null) {
            PaleoProbabilityModel paleoProbabilityModel = this;
            synchronized (paleoProbabilityModel) {
                if (this.traceLengthCache == null) {
                    this.traceLengthCache = Maps.newConcurrentMap();
                }
            }
        }
        return UCERF3InversionInputGenerator.getDistanceAlongRupture(rupSections, sectIndex, this.traceLengthCache);
    }

    public static class Adapter
    extends TypeAdapter<PaleoProbabilityModel> {
        Gson gson = new Gson();

        public void write(JsonWriter out, PaleoProbabilityModel value) throws IOException {
            out.beginObject();
            out.name("type").value(value.getClass().getName());
            out.name("data");
            this.gson.toJson((Object)value, value.getClass(), out);
            out.endObject();
        }

        public PaleoProbabilityModel read(JsonReader in) throws IOException {
            Class<?> type = null;
            in.beginObject();
            Preconditions.checkState((boolean)in.nextName().equals("type"), (Object)"JSON 'type' object must be first");
            try {
                type = Class.forName(in.nextString());
            }
            catch (ClassNotFoundException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            Preconditions.checkState((boolean)in.nextName().equals("data"), (Object)"JSON 'data' object must be second");
            PaleoProbabilityModel model = (PaleoProbabilityModel)this.gson.fromJson(in, type);
            in.endObject();
            return model;
        }
    }
}

