/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;

public class PaleoRateInversionConstraint
extends InversionConstraint {
    public static final String NAME = "Paleoseismic Event Rate";
    public static final String SHORT_NAME = "PaleoRate";
    private transient FaultSystemRupSet rupSet;
    private List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoRateConstraints;
    private PaleoProbabilityModel paleoProbModel;

    public PaleoRateInversionConstraint(FaultSystemRupSet rupSet, double weight, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoRateConstraints, PaleoProbabilityModel paleoProbModel) {
        this(rupSet, weight, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY, paleoRateConstraints, paleoProbModel);
    }

    public PaleoRateInversionConstraint(FaultSystemRupSet rupSet, double weight, ConstraintWeightingType weightingType, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoRateConstraints, PaleoProbabilityModel paleoProbModel) {
        super(NAME, SHORT_NAME, weight, false, weightingType);
        this.rupSet = rupSet;
        this.paleoRateConstraints = paleoRateConstraints;
        this.paleoProbModel = paleoProbModel;
        this.weightingType = weightingType;
    }

    @Override
    public int getNumRows() {
        return this.paleoRateConstraints.size();
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        for (int i = 0; i < this.paleoRateConstraints.size(); ++i) {
            UncertainDataConstraint.SectMappedUncertainDataConstraint constraint = this.paleoRateConstraints.get(i);
            int row = startRow + i;
            d[row] = this.weight * this.weightingType.getD(constraint.bestEstimate, constraint.getPreferredStdDev());
            double scalar = this.weightingType.getA_Scalar(constraint.bestEstimate, constraint.getPreferredStdDev());
            List<Integer> rupsForSect = this.rupSet.getRupturesForSection(constraint.sectionIndex);
            for (int rupIndex = 0; rupIndex < rupsForSect.size(); ++rupIndex) {
                int rup = rupsForSect.get(rupIndex);
                double probPaleoVisible = this.paleoProbModel.getProbPaleoVisible(this.rupSet, rup, constraint.sectionIndex);
                this.setA(A, row, rup, this.weight * probPaleoVisible * scalar);
                ++numNonZeroElements;
            }
        }
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }
}

