/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.faultSurface.FaultSection;

public class PaleoVisibleEventRateSmoothnessInversionConstraint
extends InversionConstraint {
    public static final String NAME = "Paleo-Visible Event Rate Smoothness";
    public static final String SHORT_NAME = "PaleoRateSmooth";
    private transient FaultSystemRupSet rupSet;
    private PaleoProbabilityModel paleoProbabilityModel;

    public PaleoVisibleEventRateSmoothnessInversionConstraint(FaultSystemRupSet rupSet, double weight, PaleoProbabilityModel paleoProbabilityModel) {
        super(NAME, SHORT_NAME, weight, false);
        this.rupSet = rupSet;
        this.paleoProbabilityModel = paleoProbabilityModel;
    }

    @Override
    public int getNumRows() {
        HashSet<Integer> parentIDs = new HashSet<Integer>();
        for (FaultSection faultSection : this.rupSet.getFaultSectionDataList()) {
            int parentID = faultSection.getParentSectionId();
            parentIDs.add(parentID);
        }
        int numParentSections = parentIDs.size();
        return this.rupSet.getNumSections() - numParentSections;
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        int parentID;
        long numNonZeroElements = 0L;
        HashSet<Integer> prevParents = new HashSet<Integer>();
        ArrayList<Integer> parentIDs = new ArrayList<Integer>();
        for (FaultSection iterator : this.rupSet.getFaultSectionDataList()) {
            parentID = iterator.getParentSectionId();
            if (prevParents.contains(parentID)) continue;
            parentIDs.add(parentID);
            prevParents.add(parentID);
        }
        int rowIndex = startRow;
        Iterator iterator = parentIDs.iterator();
        while (iterator.hasNext()) {
            parentID = (Integer)iterator.next();
            ArrayList<Integer> sectsForParent = new ArrayList<Integer>();
            for (FaultSection faultSection : this.rupSet.getFaultSectionDataList()) {
                int sectParentID = faultSection.getParentSectionId();
                if (sectParentID != parentID) continue;
                sectsForParent.add(faultSection.getSectionId());
            }
            for (int j = 0; j < sectsForParent.size() - 1; ++j) {
                double probPaleoVisible;
                int n = (Integer)sectsForParent.get(j);
                int sect2 = (Integer)sectsForParent.get(j + 1);
                List<Integer> sect1Rups = this.rupSet.getRupturesForSection(n);
                List<Integer> sect2Rups = this.rupSet.getRupturesForSection(sect2);
                for (int rup : sect1Rups) {
                    probPaleoVisible = this.paleoProbabilityModel.getProbPaleoVisible(this.rupSet, rup, n);
                    if (!(probPaleoVisible > 0.0)) continue;
                    this.setA(A, rowIndex, rup, probPaleoVisible * this.weight);
                    ++numNonZeroElements;
                }
                for (int rup : sect2Rups) {
                    probPaleoVisible = this.paleoProbabilityModel.getProbPaleoVisible(this.rupSet, rup, sect2);
                    if (!(probPaleoVisible > 0.0)) continue;
                    double prevVal = this.getA(A, rowIndex, rup);
                    double newVal = prevVal - probPaleoVisible * this.weight;
                    if (newVal == 0.0) {
                        --numNonZeroElements;
                    } else if (prevVal == 0.0) {
                        ++numNonZeroElements;
                    }
                    this.setA(A, rowIndex, rup, newVal);
                }
                d[rowIndex] = 0.0;
                ++rowIndex;
            }
        }
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }
}

