/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.faultSurface.FaultSection;

public class RupRateSmoothingInversionConstraint
extends InversionConstraint {
    public static final String NAME = "Rup Rate Smoothing";
    public static final String SHORT_NAME = "RupRateSmooth";
    private List<IDPairing> smoothingConstraintRupPairings;

    public RupRateSmoothingInversionConstraint(double weight, FaultSystemRupSet rupSet) {
        this(weight, RupRateSmoothingInversionConstraint.getRupSmoothingPairings(rupSet));
    }

    public RupRateSmoothingInversionConstraint(double weight, List<IDPairing> smoothingConstraintRupPairings) {
        super(NAME, SHORT_NAME, weight, false);
        this.smoothingConstraintRupPairings = smoothingConstraintRupPairings;
    }

    @Override
    public int getNumRows() {
        return this.smoothingConstraintRupPairings.size();
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        for (int i = 0; i < this.smoothingConstraintRupPairings.size(); ++i) {
            int rowIndex = startRow + i;
            IDPairing rupPairings = this.smoothingConstraintRupPairings.get(i);
            this.setA(A, rowIndex, rupPairings.getID1(), this.weight);
            this.setA(A, rowIndex, rupPairings.getID2(), -this.weight);
            d[rowIndex] = 0.0;
            numNonZeroElements += 2L;
        }
        return numNonZeroElements;
    }

    public static List<IDPairing> getRupSmoothingPairings(FaultSystemRupSet rupSet) {
        ArrayList<IDPairing> pairings = new ArrayList<IDPairing>();
        int numRuptures = rupSet.getNumRuptures();
        ArrayList<HashSet<Integer>> rupHashList = new ArrayList<HashSet<Integer>>();
        ArrayList rupParentsHashList = new ArrayList();
        HashMap parentsToRupsMap = new HashMap();
        for (int r = 0; r < numRuptures; ++r) {
            rupHashList.add(new HashSet<Integer>(rupSet.getSectionsIndicesForRup(r)));
            HashSet<Integer> parentIDs = new HashSet<Integer>();
            for (FaultSection sect : rupSet.getFaultSectionDataForRupture(r)) {
                parentIDs.add(sect.getParentSectionId());
            }
            rupParentsHashList.add(parentIDs);
            ArrayList<Integer> rupsForParents = (ArrayList<Integer>)parentsToRupsMap.get(parentIDs);
            if (rupsForParents == null) {
                rupsForParents = new ArrayList<Integer>();
                parentsToRupsMap.put(parentIDs, rupsForParents);
            }
            rupsForParents.add(r);
        }
        for (int rup1 = 0; rup1 < numRuptures; ++rup1) {
            List<Integer> sects = rupSet.getSectionsIndicesForRup(rup1);
            HashSet rup1Parents = (HashSet)rupParentsHashList.get(rup1);
            block3: for (Integer rup2 : (List)parentsToRupsMap.get(rup1Parents)) {
                if (rup2 <= rup1) continue;
                HashSet sects2 = (HashSet)rupHashList.get(rup2);
                if (sects.size() != sects2.size()) continue;
                int numSectsDifferent = 0;
                for (int i = 0; i < sects.size(); ++i) {
                    if (!sects2.contains(sects.get(i))) {
                        ++numSectsDifferent;
                    }
                    if (numSectsDifferent > 1) continue block3;
                }
                pairings.add(new IDPairing(rup1, rup2));
            }
        }
        return pairings;
    }
}

