/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.base.Preconditions;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;

public class SectionTotalRateConstraint
extends InversionConstraint {
    private transient FaultSystemRupSet rupSet;
    private double[] sectRates;
    private double[] sectRateStdDevs;
    private boolean nucleation;

    public SectionTotalRateConstraint(FaultSystemRupSet rupSet, double weight, double[] sectRates, boolean nucleation) {
        this(rupSet, weight, ConstraintWeightingType.NORMALIZED, sectRates, null, nucleation);
    }

    public SectionTotalRateConstraint(FaultSystemRupSet rupSet, double weight, ConstraintWeightingType weightType, double[] sectRates, double[] sectRateStdDevs, boolean nucleation) {
        super(weightType.applyNamePrefix("Subsection Total " + (nucleation ? "Nucleation" : "Participation") + " Rates"), weightType.applyShortNamePrefix("SubSect" + (nucleation ? "Nucl" : "Part") + "Rates"), weight, false, weightType);
        this.rupSet = rupSet;
        this.nucleation = nucleation;
        this.setSectRates(sectRates, sectRateStdDevs);
    }

    public void setSectRates(double[] sectRates) {
        this.setSectRates(sectRates, null);
    }

    public void setSectRates(double[] sectRates, double[] sectRateStdDevs) {
        Preconditions.checkState((this.rupSet.getNumSections() == sectRates.length ? 1 : 0) != 0, (Object)"section rates array isn't the right length");
        this.sectRates = sectRates;
        if (this.getWeightingType() == ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY) {
            Preconditions.checkState((sectRateStdDevs != null ? 1 : 0) != 0, (Object)"Must supply standard deviations to weight by uncertainty");
            Preconditions.checkState((sectRateStdDevs.length == sectRates.length ? 1 : 0) != 0, (Object)"Standard deviations array isn't the right length");
            this.sectRateStdDevs = sectRateStdDevs;
        }
    }

    public double[] getSectRates() {
        return this.sectRates;
    }

    public double[] getSectRateStdDevs() {
        return this.sectRateStdDevs;
    }

    public boolean isNucleation() {
        return this.nucleation;
    }

    @Override
    public int getNumRows() {
        return this.sectRates.length;
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZero = 0L;
        for (int s = 0; s < this.sectRates.length; ++s) {
            if (Double.isNaN(this.sectRates[s])) continue;
            double stdDev = 0.0;
            if (!(this.sectRateStdDevs == null || (stdDev = this.sectRateStdDevs[s]) != 0.0 && Double.isFinite(stdDev))) {
                Preconditions.checkState((this.sectRates[s] == 0.0 ? 1 : 0) != 0, (String)"Zero standard deviations are only supported when the target rate is zero: sectRates[%s]=%s, sectRateStdDevs[%s]=%s", (Object)s, (Object)this.sectRates[s], (Object)s, (Object)this.sectRateStdDevs[s]);
                continue;
            }
            double scale = this.weightingType.getA_Scalar(this.sectRates[s], stdDev);
            double target = this.weightingType.getD(this.sectRates[s], stdDev);
            int row = startRow + s;
            d[row] = target * this.weight;
            double sectArea = this.rupSet.getAreaForSection(s);
            for (int rup : this.rupSet.getRupturesForSection(s)) {
                double val = scale * this.weight;
                if (this.nucleation) {
                    double rupArea = this.rupSet.getAreaForRup(rup);
                    val *= sectArea / rupArea;
                }
                this.setA(A, row, rup, val);
                ++numNonZero;
            }
        }
        return numNonZero;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        Preconditions.checkState((rupSet.getNumSections() == this.sectRates.length ? 1 : 0) != 0);
        this.rupSet = rupSet;
    }
}

