/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.List;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;

public class SlipRateInversionConstraint
extends InversionConstraint {
    private transient FaultSystemRupSet rupSet;
    private transient AveSlipModule aveSlipModule;
    private transient SlipAlongRuptureModel slipAlongModule;
    private transient SectSlipRates targetSlipRates;
    public static final double DEFAULT_FRACT_STD_DEV = 0.5;

    public SlipRateInversionConstraint(double weight, ConstraintWeightingType weightingType, FaultSystemRupSet rupSet) {
        this(weight, weightingType, rupSet, rupSet.requireModule(AveSlipModule.class), rupSet.requireModule(SlipAlongRuptureModel.class), rupSet.requireModule(SectSlipRates.class));
    }

    public SlipRateInversionConstraint(double weight, ConstraintWeightingType weightingType, FaultSystemRupSet rupSet, AveSlipModule aveSlipModule, SlipAlongRuptureModel slipAlongModule, SectSlipRates targetSlipRates) {
        super(weightingType.applyNamePrefix("Slip Rate"), weightingType.applyShortNamePrefix("SlipRate"), weight, false, weightingType);
        this.weightingType = weightingType;
        this.setRuptureSet(rupSet);
        this.aveSlipModule = aveSlipModule;
        this.slipAlongModule = slipAlongModule;
        this.targetSlipRates = targetSlipRates;
    }

    @Override
    public int getNumRows() {
        return this.rupSet.getNumSections();
    }

    public static double[] getSlipRateStdDevs(SectSlipRates targetSlipRates, double defaultFractStdDev) {
        int numDefaults = 0;
        int numInferred = 0;
        FaultSystemRupSet rupSet = targetSlipRates.getParent();
        int numSections = rupSet.getNumSections();
        double[] stdDevs = new double[numSections];
        for (int s = 0; s < numSections; ++s) {
            double stdDev = targetSlipRates.getSlipRateStdDev(s);
            if (stdDev == 0.0 || Double.isNaN(stdDev)) {
                FaultSection sect = rupSet.getFaultSectionData(s);
                FeatureProperties props = sect instanceof GeoJSONFaultSection ? ((GeoJSONFaultSection)sect).getProperties() : null;
                double meanRate = targetSlipRates.getSlipRate(s);
                if (props != null && props.containsKey("HighRate") && props.containsKey("LowRate")) {
                    double high = props.getDouble("HighRate", Double.NaN);
                    double low = props.getDouble("LowRate", Double.NaN);
                    stdDev = UncertaintyBoundType.TWO_SIGMA.estimateStdDev(low, high);
                    ++numInferred;
                } else {
                    stdDev = meanRate * defaultFractStdDev;
                    ++numDefaults;
                }
            }
            stdDevs[s] = stdDev;
        }
        if (numDefaults > 0 || numInferred > 0) {
            System.err.println("WARNING: " + (numDefaults + numInferred) + "/" + numSections + " sections were missing slip rate standard deviations, and uncertainty weighting is selected.");
            if (numDefaults > 0) {
                System.err.println("\tUsed default fractional standard deviation for " + numDefaults + " values: std = " + (float)defaultFractStdDev + " x slip_rate");
            }
            if (numInferred > 0) {
                System.err.println("\tInferred standard deviation for " + numDefaults + " values from upper and lower bounds, assuming +/- 2 sigma: std = (upper-lower)/4");
            }
        }
        return stdDevs;
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        int row;
        long numNonZeroElements = 0L;
        int numRuptures = this.rupSet.getNumRuptures();
        int numSections = this.rupSet.getNumSections();
        double[] weights = new double[numSections];
        for (int s = 0; s < numSections; ++s) {
            weights[s] = this.weight;
        }
        if (this.weightingType == ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY) {
            double[] stdDevs = SlipRateInversionConstraint.getSlipRateStdDevs(this.targetSlipRates, 0.5);
            for (int s = 0; s < numSections; ++s) {
                if (stdDevs[s] == 0.0) continue;
                int n = s;
                weights[n] = weights[n] / stdDevs[s];
            }
        }
        for (int rup = 0; rup < numRuptures; ++rup) {
            double[] slips = this.slipAlongModule.calcSlipOnSectionsForRup(this.rupSet, this.aveSlipModule, rup);
            List<Integer> sects = this.rupSet.getSectionsIndicesForRup(rup);
            for (int i = 0; i < slips.length; ++i) {
                double target;
                int sectIndex = sects.get(i);
                row = startRow + sectIndex;
                int col = rup;
                double val = slips[i];
                if (this.weightingType == ConstraintWeightingType.NORMALIZED && (target = this.targetSlipRates.getSlipRate(sectIndex)) != 0.0) {
                    if (target < 1.0E-4 || Double.isNaN(target)) {
                        target = 1.0E-4;
                    }
                    val = slips[i] / target;
                }
                this.setA(A, row, col, val * weights[sectIndex]);
                ++numNonZeroElements;
            }
        }
        for (int sectIndex = 0; sectIndex < numSections; ++sectIndex) {
            double target;
            double val = target = this.targetSlipRates.getSlipRate(sectIndex);
            if (this.weightingType == ConstraintWeightingType.NORMALIZED) {
                val = target == 0.0 ? 0.0 : (target < 1.0E-4 || Double.isNaN(target) ? this.targetSlipRates.getSlipRate(sectIndex) / 1.0E-4 : 1.0);
            }
            row = startRow + sectIndex;
            d[row] = val * weights[sectIndex];
            if (!Double.isNaN(d[sectIndex]) && !(d[sectIndex] < 0.0)) continue;
            throw new IllegalStateException("d[" + sectIndex + "]=" + d[sectIndex] + " is NaN or 0!  target=" + target);
        }
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
        this.aveSlipModule = rupSet.requireModule(AveSlipModule.class);
        this.slipAlongModule = rupSet.requireModule(SlipAlongRuptureModel.class);
        this.targetSlipRates = rupSet.requireModule(SectSlipRates.class);
    }
}

