/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import com.google.common.base.Preconditions;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.Uncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.Location;

public class UncertainDataConstraint
implements Named {
    public final String name;
    public final double bestEstimate;
    public final Uncertainty[] uncertainties;

    public UncertainDataConstraint(String name, double bestEstimate, Uncertainty ... uncertainties) {
        this.name = name;
        this.bestEstimate = bestEstimate;
        Preconditions.checkArgument((uncertainties.length > 0 ? 1 : 0) != 0, (Object)"Must supply at least 1 uncertainty");
        this.uncertainties = uncertainties;
    }

    public boolean hasUncertaintyBounds(UncertaintyBoundType type) {
        return this.getUncertaintyBounds(type) != null;
    }

    public BoundedUncertainty getUncertaintyBounds(UncertaintyBoundType type) {
        for (Uncertainty u : this.uncertainties) {
            if (!(u instanceof BoundedUncertainty) || ((BoundedUncertainty)u).type != type) continue;
            return (BoundedUncertainty)u;
        }
        return null;
    }

    public BoundedUncertainty estimateUncertaintyBounds(UncertaintyBoundType type) {
        BoundedUncertainty uncertainty = this.getUncertaintyBounds(type);
        if (uncertainty == null) {
            uncertainty = type.estimate(this.bestEstimate, this.getPreferredStdDev());
        }
        return uncertainty;
    }

    public double getPreferredStdDev() {
        return this.uncertainties[0].stdDev;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "[" + this.name + ", \u03bc=" + (float)this.bestEstimate + ", \u03c3=" + this.getPreferredStdDev() + "]";
    }

    public static class SectMappedUncertainDataConstraint
    extends UncertainDataConstraint {
        public final int sectionIndex;
        public final String sectionName;
        public final Location dataLocation;

        public SectMappedUncertainDataConstraint(String name, int sectionIndex, String sectionName, Location dataLocation, double bestEstimate, Uncertainty ... uncertainties) {
            super(name, bestEstimate, uncertainties);
            this.sectionIndex = sectionIndex;
            this.sectionName = sectionName;
            this.dataLocation = dataLocation;
        }

        public SectMappedUncertainDataConstraint forRemappedSectionIndex(int newSectIndex) {
            return new SectMappedUncertainDataConstraint(this.name, newSectIndex, this.sectionName, this.dataLocation, this.bestEstimate, this.uncertainties);
        }
    }
}

